; NOISES.ASM
;
; by Tim Stryker
;
; Copyright (c) 1989 Galacticomm, Inc.
;
; This source is for use by Galacticomm "FLASH" Protocol Licensees ONLY.
; Any use of the contents of this file, or any functional derivative or
; part or portion thereof, outside of the provisions of the Galacticomm
; "FLASH" Protocol Developers' License Agreement is strictly prohibited.
 
        include model.mac
 
; This package includes the following C-callable utilities:
;
; ininoi();                     initialize for sound effects
;
; setnoi(rouadr);               set noise-maker routine
; int (*rouadr)();                   addr of C routine returning period
;                                    (gets called appx 145.6 Hz)
;
; finnoi();                     finish up and close down sound effects
;
 
        if lcode
ARGOFF  equ     6
        else
ARGOFF  equ     4
        endif
 
                                ; motherboard hardware control info
TIMER   equ     40H             ;   8253 counter/timer port address
OCW2    equ     20H             ;   8259 port addr for writing EOI info
NSEOI   equ     20H             ;   8259 non-specific EOI command code
 
        dseg
 
        public  _fstick,_fstick2,_bckctr,_forctr
 
_fstick dw      0               ; fast-ticker (appx 145.6 Hz)
_fstick2 dw     0               ; another one
_bckctr dw      0               ; "background" noise counter
_forctr dw      0               ; "foreground" noise counter
 
rouadr  label  word
rouadd  dd     nada             ; vector to be invoked at 145.6 Hz
addend  dw      ?               ; addend for rti selection
cycler  dw      ?               ; cyclic counter for rti selection
doctor  db      ?               ; flag indicating we "doctored" the RTI period
docler  db      ?               ; cyclic counter for doctoring purposes
 
        endds
 
        pseg    noises
 
oldrdw  label   dword           ; old real-time interrupt vector for feed-thru
oldrti  dw      0,0
 
        proc_def    ininoi      ; initialize sound stuff
        push    bp
        mov     bp,sp
        push    si
        push    di
 
; this section attempts to determine the current timer-0 latch contents
; so that it can be run under DoubleDOS with The Major BBS running in
; the other partition (with a pair of serial ports or something hooked
; back-to-back to effect Sysop-to-BBS communications).  The first "in"
; instruction is supposed to latch the current counter contents so that
; the second "in" instruction will get the high-order counter contents
; corresponding to the same moment in time.  On at least one machine I
; have worked with, this does not appear to happen, so I have removed
; this code for the time being.  If operation under DoubleDOS becomes
; of prime importance, feel free to experiment here with alternatives...
; the interrupt-level code is fully prepared to deal with the idea of
; interrupts coming in faster than 145.6 Hz, as well as slower.
;
;                                         ; how fast are timer irpts now?
;         mov     cx,5                    ; view over 5 cycles of timer
;         xor     ax,ax
;         mov     di,ax
;         mov     dx,ax
;
; w4jump: mov     si,ax
;         in      al,TIMER
;         xchg    al,ah
;         in      al,TIMER
;         xchg    al,ah
;         cmp     ax,si                   ; higher than last time?
;         jbe     w4jump                  ; no
;         cmp     ax,di                   ; higher than overall maximum?
;         jbe     doloop                  ; no
;         mov     di,ax                   ; yes, set new overall maximum
; doloop: loop    w4jump
;         add     di,0FFH                 ; round up to nearest likely value
;         and     di,0FF00H               ; this is now value in timer latch
;         jnz     storaw                  ; if nonzero, assume < 2000H
;                                         ;    (GSBL is always <= 1000H)
 
        out     TIMER,al                ; set timer 0 latch to 2000H
        mov     al,20H                  ;   (8 * normal speed)
        out     TIMER,al                ;   (appx. 145.6 Hz)
        mov     di,2000H                ; pretend that's what we read
        mov     dl,1                    ; set "doctored" flag
 
storaw: mov     addend,di               ; remember for interrupt pass-off
        mov     doctor,dl               ; nonzero if doctored
 
        mov     al,0B6H                 ; sel ch#2, r/w LSB-MSB, mode 3, binary
        out     TIMER+3,al
        mov     al,2                    ; make inaudibly-high pitch
        out     TIMER+2,al
        xor     al,al
        out     TIMER+2,al
 
        cli
        in      al,61H                  ; turn on speaker
        or      al,3
        out     61H,al
        sti
 
        push    ds                      ; read and record old rti vector
        xor     ax,ax
        mov     ds,ax
        assume  ds:nothing
        mov     bx,8*4
        cli
        mov     cx,[bx]
        mov     dx,[bx+2]
        mov     cs:oldrti,cx
        mov     cs:oldrti+2,dx
        mov     word ptr [bx],offset rtirpt  ; set new rti vector
        mov     [bx+2],cs
        sti
        pop     ds                      ; switch back to dgroup
        assume  ds:dgroup
 
        pop     di
        pop     si
        pop     bp
        ret
        end_proc
 
        proc_def    setnoi      ; set new period-calculator routine address
        push    bp
        mov     bp,sp
 
        pushf
        cli
        mov     ax,[bp+ARGOFF]          ; set passed rouadr parameter
        mov     rouadr,ax
        mov     ax,[bp+ARGOFF+2]
        mov     rouadr+2,ax
        popf
 
        pop     bp
        ret
        end_proc
 
nada    proc    far             ; initial default period calculator routine
        xor     ax,ax
        ret
nada    endp
 
rtirpt  proc    far             ; MASTER REAL-TIME INTERRUPT VECTOR DEST
 
        push    ax                      ; save regs
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        push    ds
        push    es
        mov     ax,dgroup               ; establish addressability
        mov     ds,ax
 
irpdch: mov     ax,addend               ; time for one of ours?
        add     cycler,ax
        test    cycler,0E000H
        jz      irprtr                  ; not yet
        and     cycler,01FFFH           ; yeppo
 
        inc     _fstick                  ; increment various handy counters
        inc     _fstick2
        inc     _bckctr
        inc     _forctr
 
        call    [rouadd]                ; get curr sound period
        cmp     ax,2                    ; if less than 2, make it 2
        ja      perok
        mov     ax,2
perok:  out     TIMER+2,al              ; output low order byte of period
        mov     al,ah
        out     TIMER+2,al              ; output high-order byte of period
 
irprtr: test    doctor,0FFH             ; did we doctor the RTI ourselves?
        jz      regrtr                  ; no, just hitchhiking
        add     docler,20H              ; yes, every eighth time do regular
        jc      regrtr
 
        mov     al,NSEOI                ; 7/8 of time finish it up ourselves
        out     OCW2,al
        pop     es
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        iret
 
regrtr: pop     es                      ; don't EOI yet, just pop regs
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        jmp     cs:[oldrdw]             ; give that regular rti guy a chance
 
rtirpt  endp
 
        proc_def finnoi         ; put everything back
 
        mov     cx,cs:oldrti            ; anything need to be put back?
        mov     dx,cs:oldrti+2
        mov     ax,cx
        or      ax,dx
        jz      nnoret                  ; no
 
        mov     al,2                    ; yes, make inaudibly-high pitch
        out     TIMER+2,al
        xor     al,al
        out     TIMER+2,al
        cli
        in      al,61H                  ; turn off speaker
        and     al,0FFH-3
        out     61H,al
        sti
 
        xor     ax,ax                   ; address zero page
        push    ds
        mov     ds,ax
        assume  ds:nothing
        mov     bx,8*4                  ; restore old rti vector
        cli
        mov     [bx],cx
        mov     [bx+2],dx
 
        pop     ds                      ; switch back to dgroup
        assume  ds:dgroup
 
        test    doctor,0FFH             ; did doctor before?
        jz      nnosti                  ; no, leave alone
        out     TIMER,al                ; set timer 0 latch back to normal
        out     TIMER,al
nnosti: sti
 
nnoret: ret
 
        end_proc
 
        endps
 
        end
 
