; JSTICK.ASM
;
; by Les Bird
;
; Copyright (c) 1991 Galacticomm, Inc.
;
; This source is for use by Galacticomm "FLASH" Protocol Licensees ONLY.
; Any use of the contents of this file, or any functional derivative or
; part or portion thereof, outside of the provisions of the Galacticomm
; "FLASH" Protocol Developers' License Agreement is strictly prohibited.
;
; ***********************************************************************
; *     void jstick()   - this 'C' callable routine reads the position  *
; *                       of joystick #1 attached to a game-port (0x201)*
; *                       and returns the X position in variable _joyx  *
; *                       and the Y position in variable _joyy and the  *
; *                       button status in variable _joyb               *
; *                                                                     *
; *     _joyb   - xxxx.0000                                             *
; *                 ||                                                  *
; *                 |`-- 0 if joystick #1, button #1 pressed            *
; *                 `--- 0 if joystick #1, button #2 pressed            *
; *                                                                     *
; *     'C' example:                                                    *
; *                                                                     *
; *     extern                                                          *
; *     int joyb,joyx,joyy;                                             *
; *                                                                     *
; *     void                                                            *
; *     main(void)                                                      *
; *     {                                                               *
; *          jstick();                                                  *
; *          printf("Joystick X position = %d",joyx);                   *
; *          printf("Joystick Y position = %d",joyy);                   *
; *          printf("Joystick button stat= %d",joyb);                   *
; *     }                                                               *
; *                                                                     *
; ***********************************************************************
;
        include model.mac
;
JOYPORT equ     201H            ; game-port I/O address
;
        dseg
;
        public  _joyb,_joyx,_joyy
_joyb   db      0               ; joystick button status
_joyx   dw      0               ; joystick X position
_joyy   dw      0               ; joystick Y position
joydn   db      ?               ; internal compare value
joycr   dw      ?               ; internal counter
;
        endds
;
        pseg    jstick
;
        proc_def jstick
;
        push    bp
        mov     bp,sp
        push    ax
        push    bx
        push    cx
        push    dx
        mov     bx,0
        mov     cx,200h
        mov     joycr,cx
        xor     cx,cx
        mov     dx,JOYPORT
        in      al,dx
        mov     _joyb,al
        and     al,0fh
        mov     joydn,al
        out     dx,al
jloop:  in      al,dx
        push    ax
        and     al,0fh
        cmp     al,joydn
        pop     ax
        jz      jretrn
        dec     joycr
        jz      jretrn
        push    ax
        and     al,1
        pop     ax
        jz      jupdy
        inc     bx
jupdy:  and     al,2
        jz      jloop
        inc     cx
        jmp     jloop
jretrn: mov     _joyx,bx
        mov     _joyy,cx
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        mov     sp,bp
        pop     bp
        ret
;
        end_proc
;
        endps
;
        end
