        page ,132
 
; FLUTIL.ASM
;
; by Tim Stryker
;
; Copyright (C) 1989 Galacticomm, Inc.
;
; This source is for use by Galacticomm "FLASH" Protocol Licensees ONLY.
; Any use of the contents of this file, or any functional derivative or
; part or portion thereof, outside of the provisions of the Galacticomm
; "FLASH" Protocol Developers' License Agreement is strictly prohibited.
 
        include model.mac
 
; This package includes the following C-callable utilities:
;
;   calcrc(crc,byt)     c-callable CRC calculator
;                               crc=starting 16-bit CRC value
;                               byt=8-bit new value to be integrated in
;
;   odd(byt)            c-callable odd-parity maker
;                               byt=input 7-bit value
;
;   stivec              set irpt vector
;                               dx:ax (input) = new vector contents
;                               bx (input)    = irpt number
;
;   rdivec              read irpt vector
;                               bx (input)     = irpt number
;                               dx:ax (output) = vector contents
;
;   formim              form interrupt mask
;                               cl (input) = irpt number
;                               bl (output) = irpt mask
 
        if lcode
ARGOFF  equ     6
        else
ARGOFF  equ     4
        endif
 
        pseg    flutil
 
        public  stivec,rdivec,formim
 
        proc_def    calcrc
        push    bp
        mov     bp,sp
 
        mov     ax,[bp+ARGOFF]          ; crc^=(byt<<8);
        xor     ah,[bp+ARGOFF+2]
 
        mov     cx,8                    ; for (j=0 ; j < 8 ; j++) {
ccloop: or      ah,ah                   ;      if (crc&0x8000) {
        jns     ccplus
        shl     ax,1                    ;           crc=(crc<<1)^0x1021;
        xor     ax,1021H                ;      }
        jmp short cclbot                ;      else {
ccplus: shl     ax,1                    ;           crc=crc<<1;
                                        ;      }
cclbot: loop    ccloop                  ; }
 
        pop     bp
        ret                             ; return(crc);
        end_proc
 
        proc_def    odd
        push    bp
        mov     bp,sp
 
        mov     ax,[bp+ARGOFF]          ; make parity odd if not already
        or      al,al
        jpo     oddret
        xor     al,80H
 
oddret: pop     bp
        ret
        end_proc
 
stivec  proc    near
 
        push    ds                      ; get access to low RAM
        push    ax
        mov     ax,0
        mov     ds,ax
        pop     ax
        shl     bx,1                    ; multiply vec # by 4 to get addr
        shl     bx,1
        pushf
        cli
        mov     [bx],ax                 ; write offset part of vector
        mov     [bx+2],dx               ; write segment part
        popf
        pop     ds
 
        ret
stivec  endp
 
rdivec  proc    near
 
        push    ds                      ; get access to low RAM
        mov     ax,0
        mov     ds,ax
        shl     bx,1                    ; multiply vec # by 4 to get addr
        shl     bx,1
        mov     ax,[bx]                 ; read offset part of vector
        mov     dx,[bx+2]               ; read segment part
        pop     ds                      ; return result in dx:ax
 
        ret
rdivec  endp
 
formim  proc    near
 
        mov     bl,1                    ; shift 1 left by wndirp bits
        or      cl,cl
        jz      noshft
        shl     bl,cl
 
noshft: ret                             ; return it in bl
formim  endp
 
        ENDPS
        end
 
