/***************************************************************************
 *                                                                         *
 *   FLASH.H                                                               *
 *                                                                         *
 *   Copyright (C) 1988-1991 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS remote-program interface, designed for use      *
 *   as an adjunct to the teleconference.                                  *
 *                                                                         *
 *                                            - T. Stryker 5/26/89         *
 *                                                                         *
 ***************************************************************************/
#define CHPERP  10            /* maximum channels per pool                 */
#define SHPERP   6            /* maximum "shareware" channels per pool     */
#define PDSIZE 512            /* pool data history size                    */
#define PDMASK (PDSIZE-1)     /* pool data wraparound mask                 */
#define NPOOLS  10            /* maximum number of pools                   */
#define TPERSC  18            /* ticks of the master flash clock, per sec  */
#define GNSIZE  20            /* game name size maximum (including the \0) */
#define GVSIZE   6            /* game version size max (including the \0)  */

extern
struct pool {
     unsigned tlcchn;
     char gamnam[GNSIZE];
     char gamver[GVSIZE];
     int nchans;
     struct fapyr *faps[CHPERP];
     int nxtbyt;
     char pdata[PDSIZE];
} *pools,*piptr,*pbptr;

extern
struct fapyr {
     int chno;
     int nxxbyt;
     int bytoff;
     int cancnt;
     struct pool *poolpt;
     int oneten;
     long serno;
     int fflags;
} *fapyrs,*fiptr,*fbptr;

                              /* fapyr.flags bit values                    */
#define FLASHY 01             /*   in flash communications mode            */
#define XMTING 02             /*   transmitting a packet                   */
#define NAKLST 04             /*   received a NAK last character           */

#define STPFLA 230            /* stop-flash-mode injected status code      */

#undef  TPCSIZ
#define TPCSIZ 41             /* max size of teleconf channel topic        */
#define TMSSIZ 60             /* max size of enter/exit messages for users */

extern
struct tlc {                  /* teleconference per-user volatile data     */
     int flags;               /*   telecon user "flag" bits                */
     int paged;               /*   intervals-since-last-paged counter      */
     int swchan;              /*   # of times switched chans in interval   */
     int blinkc;              /*   intervals-since-paged-Sysop counter     */
     unsigned channel;        /*   teleconference channel number in use    */
     char topic[TPCSIZ];      /*   channel topic as set by moderator       */
     int inpcnt;              /*   input message counter for freeloaders   */
     int reqcha;              /*   intervals-since-last-chat-request ctr.  */
     int chatch;              /*   channel of other user being chatted with*/
     int retstt;              /*   return state number when XTOOTH         */
     int retsub;              /*   return sub-state number when XTOOTH     */
     long forgets[8];         /*   "forget" flags by modem number          */
     long invites[8];         /*   "invite" flags by modem number          */
     unsigned prvchn;         /*   user's private channel number           */
     int defchn;              /*   default channel 1=Main 2=Private        */
     int action;              /*   users action state 2=Off 1=On           */
     int pagsts;              /*   default page status 1=On 2=Off 3=Ok     */
     int pagint;              /*   user set page interval                  */
     int chaint;              /*   user set chat interval                  */
     char theme[TPCSIZ];      /*   current topic when user is in private   */
     int pflags;              /*   flags saved to disk when updated        */
} *tlclst,                    /* one to a customer (dynamic array)         */
  *tlcptr,*tptr;              /* handy pointers for speed                  */

                              /* definition of telecon user bit "flags"    */
#define NOPAGE 1              /*   user page-flag set to "off"             */
#define JUSTEX 2              /*   user "just exited" during current intvl */
#define OKPAGE 4              /*   user doesn't mind being paged to death  */
#define CCHVLD 8              /*   chat-channel value is valid             */
#define ACTION 16             /*   action is on                            */
#define EDITED 32             /*   users account has been edited           */
#define INVALL 64             /*   user has invited everyone to channel    */
#define XTOOTH 128            /*   exit to other than main menu            */
#define NOTALK 256            /*   user has been squelched by a sysop      */
#define TYPING 512            /*   user is now typing (for chat colors)    */

extern
struct tlc2 {                 /* secondary teleconf per-user volatile data */
     char entmsg[TMSSIZ];     /*   entrance message if not default         */
     char extmsg[TMSSIZ];     /*   exit message if not default             */
} *tl2lst,                    /* one to a customer (dynamic array)         */
  *tl2ptr,*t2ptr;             /* handy pointers for speed                  */

                              /* sub-state codes                           */
#define TLKING  1             /*   regular conferencing                    */
#define CHTING  2             /*   chatting with another user              */
#define LNKING  3             /*   linking to another system               */
#define LINKED  4             /*   linked to another system                */
#define GOING   5             /*   orphan outdial channel going down       */
#define FLHING  6             /*   in flash protocol mode                  */
#define EDTING  10            /*   base substate for editing               */

extern
FILE *tlcmb;                  /* teleconf named-message file block pointer */
