{
 ============================================================================
                         GECHO Serial Key Generator
                   Copyright (c) 1995 Hackers Technology
                            All Rights reserved.

  You are free to use and modified this program without any modifications
  into OBJ (object) code.  The author has no responsibilities about misused
  of this program, use it with your own risk.
 ============================================================================
}
Program GECHO_KEYMAKER;
Uses CRT;

{
 ----------------------------------------------------------------------------
  This program using GECODE.OBJ to create GECHO Serial Key. The OBJ file has
  three routines, are:

    * GE_ECHO Function
      Syntax : GE_ECHO(UserName : String; Var KeyCodeArray) : LongInt;
      Purpose: Create GEcho Serial Number and Serial Key.
      Param  : - UserName for GEcho Registering name.
               - KeyCodeArray for Serial Key, and should be pointed to an
                 array that at least 4 bytes long.
      Return : Serial Number in unsigned long integer type.

    * GE_UTIL Function
      Syntax : GE_UTIL(UserName : String) : LongInt;
      Purpose: Create GEUtil Serial Number.
      Param  : UserName for GEUtil Registering name.
      Return : Serial Number in unsigned long type.

    * LONG2STR Procedure
      Syntax : LONG2STR(Num : LongInt; VAR NumStr : STRING);
      Purpose: Convert an unsigned long to a Turbo Pascal string type.
               Solve the Pascal limitation which does not capability
               to generate an unsigned long integer type.
      Param  : - Num to specified an unsigned long to be converted.
               - Unsigned long converting result returned on NumStr.
      Return : None
 ----------------------------------------------------------------------------
}


{ !!!!!!! ALWAYS INTERFACING TO OBJECT ROUTINES WITH FAR CALL TYPE !!!!!!!! }

{$L GECODE.OBJ}
{$F+}
Function  GE_ECHO(UserName : STRING; Var KeyCode) : LongInt; External;
Function  GE_UTIL(UserName : STRING) : LongInt; External;
Procedure LONG2STR(Num : LongInt; Var NumStr : String); External;
{$F-}

CONST
  PName         : String[20] = 'GEcho Keymaker Lite ';
  PVersion      : String[12] = 'Version 1.0';
  POwner        : String[38] = 'Copyright () 1995 Hackers Technology.';
  PLegal        : String[22] = '  All rights reserved.';

  IDHeader1     : String[14] = 'Registered to ';
  IDHeader2     : String[14] = 'GEcho Key   ';
  IDHeader3     : String[14] = 'MBUTIL Key  ';

  CreateTxt     : String[26] = 'Create Serial txt file... ';
  CreateBin     : String[26] = 'Create Serial Key file... ';
  ResDone       : String[05] = 'Done.';
  ResFail       : String[05] = 'Fail!';

  KeyFile       : String[10] = 'KEYFILE.GE';
  KeyText       : String[09] = 'GECHO.KEY';


VAR
  TxtFile       : Text;
  BinFile       : File;
  uName         : String;
  GESerial      : String;
  MBSerial      : String;
  LineStr       : String;
  KeyBuffer     : Array[1..10] Of Byte;
  Result        : LongInt;
  Temp          : Word;


BEGIN
  ClrScr;
  FillChar(LineStr, SizeOf(LineStr), 196);  LineStr[0] := #78;
  WriteLn(PName, PVersion);
  WriteLn(POwner, PLegal);
  WriteLn(LineStr);

  Write('Enter your name (max. 50 chars) : '); ReadLn(uName);
  WriteLn;

  Result := GE_Echo(uName, KeyBuffer);
  Long2Str(Result, GESerial);

  Result := GE_Util(uName);
  Long2Str(Result, MBSerial);

  WriteLn(IDHeader1, uName);
  WriteLn(IDHeader2, GESerial);
  WriteLn(IDHeader3, MBSerial);
  WriteLn(LineStr);

  {$I-}
  Write(CreateTxt);
  Assign(TxtFile, KeyText);
  ReWrite(TxtFile);
  IF IOResult = 0 THEN
  BEGIN
    WriteLn(TxtFile, PName+PVersion);
    WriteLn(TxtFile, POwner+PLegal);
    WriteLn(TxtFile, LineStr);
    WriteLn(TxtFile, IDHeader1+uName);
    WriteLn(TxtFile, IDHeader2+GESerial);
    WriteLn(TxtFile, IDHeader3+MBSerial);
    WriteLn(TxtFile, LineStr);
    Close(TxtFile);
    WriteLn(ResDone);
  END
  ELSE WriteLn(ResFail+#7);

  Write(CreateBin);
  Assign(BinFile, KeyFile);
  ReWrite(BinFile, 1);
  IF IOResult = 0 THEN
  BEGIN
    BlockWrite(BinFile, KeyBuffer, 4, Temp);
    Close(BinFile);
    WriteLn(ResDone);
  END
  ELSE WriteLn(ResFail+#7);
  WriteLn;
END.
