
;----------------------------|
;     DATA SEGMENT BEGINS    |
;----------------------------|


DataSegment                     segment

CredLen         DW      003Eh          ;3Dh=62d                         
Credits         DB      "Yankees and Rednecks Registration Number Generator "
                DB      ", by [-NH-]"
SysPrLen        DW      0021h           ;21h=33d
SysOpPrompt     DB      "Enter SysOps name -------------> "
SysInpLen       DB      050h            ;50h=80d
SysInput        DB      80 DUP (00h)
SysTotal        DW      0000h
MulVal          DW      0000h
BBSPrLen        DW      0021h           ;21h=33d
BBSPrompt       DB      "Enter BBS's name --------------> "
BBSInpLen       DB      050h            ;50h=80d
BBSInput        DB      80 DUP (00h)
BBSTotal        DW      0000h
CodeLength      DW      0000h
RegASC          DW      10 DUP (00h)
RegPrLen        DW      021h            ;21h=33d
RegPrompt       DB      "Your Registration Number is --->"

DataSegment                     ends

;----------------------------|
;      DATA SEGMENT ENDS     |
;----------------------------|

ASSUME CS:CodeSegment
ASSUME DS:DataSegment


;----------------------------|
;    STACK SEGMENT BEGINS    |
;----------------------------|

TheStack        segment         stack
Space           DB    512   DUP   (00h)
TheStack        ends



;----------------------------|
;     STACK SEGMENT ENDS     |
;----------------------------|




;----------------------------|
;     CODE SEGMENT BEGINS    |
;----------------------------|


CodeSegment                     segment
Start:
                mov ax, DataSegment     ;Initialize es and ds to DataSegment
                mov ds, ax
                mov es, ax
                call TitlePrompt
                call ProSysOp           ;Get Sysop's name w/ buffered input
                call BBSPr
                call ProBBS
                call ProCode
                call ExitDos

TitlePrompt     proc
                call ClrScrn            ;Clear screen w/ bios service
                call WrtCrd             ;Print title using bios service
                call WrtSysPr           ;Print Sysop's name prompt
                call SysCursor
                ret
TitlePrompt     endp

BBSPr           proc
                call WrtBBSPr
                call BBSCursor
                ret
BBSPr           endp


ProSysOp        proc
                call SysOpInput
                call AddSysOp           ;Total Sysop's name
                call MulSysOp           ;multiply it etc...
                ret
ProSysOp        endp

ProBBS          proc
                call InputBBS
                call AddBBS
                call MulBBS
                ret
ProBBS          endp

ProCode         proc
                xor cx, cx              ;Kludge
                call Bin2ASC
                call WrtCdPr
                call CodeCursor
                call WrtCode
                ret
ProCode         endp


ClrScrn         proc
                mov ax, 0600h           ;ah=Scroll window up;al=0=entire win.
                sub bh, bh              ;bx=Clear attributes
                mov cx, 0000h           ;cx=row, column of upper window coor.
                mov dx, 01850h          ;cx=row, column of lower window coor.
                int 010h
                ret                     
ClrScrn         endp



WrtCrd          proc
                mov ah, 013h            ;ah=Write string,ah=alt.attributes
                mov al, 00h             ;clear al
                mov bx, 000Eh           ;bh=page number;bl=character attrib.
                mov dx, 0100h           ;dh=row;dl=column
                mov cx, CredLen         ;String length
                lea bp, Credits         ;String at ES:BP
                int 010h                ;BIOS VIDEO service
                ret
WrtCrd          endp

WrtSysPr        proc
                mov ah, 013h            ;ah=Write string,ah=alt.attributes
                mov al, 00h             ;clear al
                mov bx, 0007h           ;bh=page number
                mov dx, 0300h           ;dh=row;dl=column
                mov cx, SysPrLen        ;String length
                lea bp, SysOpPrompt     ;String at ES:BP
                int 010h                ;BIOS VIDEO service
                ret
WrtSysPr        endp

SysCursor       proc
                mov ah, 02h             ;Set cursor
                sub bh, bh              ;bh=page number
                mov dx, 00322h          ;to column 29, row 3 
                int 010h
                ret
SysCursor       endp



SysOpInput      proc
                mov ah, 0Ah             ;Buffered keyboard input
                lea dx, SysInpLen       ;1st byte in buffer=max input length
                int 21h                 ;returns:2nd byte =input length
                ret                     ;3rd and following=inputted string
SysOpInput      endp

AddSysOp        proc
                lea si, SysInput
                mov cl, Byte Ptr [si]   ;String length at 1st byte in buffer
                sub ch, ch              
                inc cx
                mov MulVal, cx          ;Save string length+1 for later
                dec cx                  ;Reset string length
                inc si                  ;Set pointer to first character
AddChar:        lodsb                   ;load byte at ds:si into al
                sub ah, ah              ;Trunctuate MSB
                add ax, SysTotal        ;Add character to total
                mov SysTotal, ax        ;Update new total
                loop AddChar
                ret
AddSysOp        endp

MulSysOp        proc
                sub dx, dx              ;clear dx
                mov ax, SysTotal        
                mul MulVal              ;Multiply string total by string len.
                mov cx, 0004h           ;Divide by four
                idiv cx
                mov SysTotal, ax        ;LSW goes back to total
                ret
MulSysOp        endp

WrtBBSPr        proc
                mov ah, 013h            ;ah=Write string,ah=alt.attributes
                mov al, 00h             ;clear al
                mov bx, 0007h           ;bh=page number
                mov dx, 0400h           ;dh=row;dl=column
                mov cx, BBSPrLen        ;String length
                lea bp, BBSPrompt       ;String at ES:BP
                int 010h                ;BIOS VIDEO service
                ret
WrtBBSPr        endp

BBSCursor       proc
                mov ah, 02h             ;Set cursor
                sub bh, bh              ;bh=page number
                mov dx, 00422h          ;to column 29, row 4 
                int 010h
                ret
BBSCursor       endp


InputBBS        proc
                mov ah, 0Ah             ;Buffered keyboard input
                lea dx, SysInpLen       ;1st byte in buffer=max input length
                int 21h                 ;returns:2nd byte =input length
                ret
InputBBS        endp

AddBBS          proc
                lea si, SysInput
                mov cl, Byte Ptr [si]   ;String length at 1st byte in buffer
                sub ch, ch              
                inc si                  ;Set pointer to first character
AddByte:        lodsb                   ;load byte at ds:si into al
                sub ah, ah              ;Trunctuate MSB
                add ax, BBSTotal        ;Add character to total
                mov BBSTotal, ax        ;Update new total
                loop AddByte
                ret
AddBBS          endp

MulBBS          proc
                mov ax, MulVal
                mov dx, 0000h
                dec ax
                mov cx, 0004
                xor bx, bx
                call Shift
                mov cx, ax
                mov bx, dx
                mov ax, BBSTotal
                call Shift
                mov cx, 03h
                xor bx, bx
                Call ShiftDiv
                mov BBSTotal, ax
                mov ax, SysTotal
                add ax, BBSTotal
                mov dx, 0Dh
                mul dx
                cwd
                xor ax, dx
                sub ax, dx
                cwd

                ret
MulBBS          endp

.386

Shift           proc
                shl eax, 010h
                shrd eax, edx, 010h
                shl ecx, 010h
                shrd ecx, ebx, 010h
                imul ecx
                shld edx, eax, 010h
                ret
Shift           endp

ShiftDiv        proc
                shl eax, 010h
                shrd eax, edx, 010h
                shl ecx, 010h
                shrd ecx, ebx, 010h
                cdq
                idiv ecx
                mov ecx, edx
                shld edx, eax, 010h
                shld ebx, ecx, 010h
                ret
ShiftDiv        endp


Bin2ASC         proc                
                inc cx
                mov CodeLength, cx      
                mov bx, 0Ah             ;Divide DX:AX by 10d
                div bx
                add dx, 030h            ;Convert remainder to ASCII
                push dx                 ;Save to stack
                sub dx, dx              ;clear remainder
                or ax, ax               ;
                jz Unstack
                lea si, RegASC
                jmp Bin2ASC

Unstack:        pop dx                  ;Move ascii number in REVERSE order
                mov [si], dl ;to buffer
                inc si
                loop Unstack
                ret
Bin2ASC         endp


WrtCdPr         proc
                mov ah, 013h            ;ah=Write string,ah=alt.attributes
                mov al, 00h             ;clear al
                mov bx, 0001h           ;bh=page number;bl=character attrib.
                mov dx, 0500h           ;dh=row;dl=column
                mov cx, RegPrLen
                lea bp, RegPrompt       ;String at ES:BP
                int 010h                ;BIOS VIDEO service
                ret
WrtCdPr         endp

CodeCursor      proc
                mov ah, 02h             ;Set cursor
                sub bh, bh              ;bh=page number
                mov dx, 0622h           ;to column 29, row 3 
                int 010h
                ret
CodeCursor      endp

WrtCode         proc
                mov ah, 013h            ;ah=Write string,ah=alt.attributes
                mov al, 00h             ;clear al
                mov bx, 000Fh           ;bh=page number;bl=character attrib.
                mov dx, 0522h           ;dh=row;dl=column
                mov cx, CodeLength
                lea bp, RegASC          ;String at ES:BP
                int 010h                ;BIOS VIDEO service
                ret
WrtCode         endp



ExitDos         proc
                mov ax, 04C00h          ;Exit dos w/ error code 0
                int 21h
ExitDos         endp

CodeSegment                     ends
                END Start


                             

;----------------------------|
;      CODE SEGMENT ENDS     |
;----------------------------|













































