unit nanostr;

interface

uses dos,crt;

function qualify(s:string):string;
function hms2sec(t:string):longint;
function int2str(inint:longint):string;
function i2s(inint:longint):string;
function str2int(s:string):longint;
function upcasestr(lstring:string):string;
function qualifydate(date:string):boolean;
function str2keys(var s:string):longint;
function addslash(idir:string):string;
function stripslash(idir:string):string;
function isnum(c:char):boolean;
function isnums(s:string):boolean;
function hex2long(s:string):longint;
function hexb(n:byte):string;
function hexw(n:word):string;
function hexl(n:longint):string;

implementation

function qualify(s:string):string;
var s2:string;
    i,j:word;
    c:char;
begin
  i:=1; j:=1; s2:='';
  if s[0]=#0 then begin qualify:=''; exit; end;
  repeat
    c:=s[i];
    if
      ((c>=#32) and (c<=#126))
    or
      (c>#127)
    then
      begin
        s2[j]:=c;
        inc(j);
      end;
    inc(i);
  until (chr(i)>s[0]) or (s[0]=#0);
  s2[0]:=chr(j-1);
  if s2[1]=#32 then repeat delete(s2,1,1) until (s2[1]<>#32) or (s2[0]=#0);
  if s2[length(s2)]=#32 then repeat delete(s2,length(s2),1) until (s2[length(s2)]<>#32) or (s2[0]=#0);
  qualify:=s2;
end;

function hms2sec(t:string):longint;
var h1,m1,s1:string[2];
    h2,m2,s2:longint;
begin
  h2:=0; m2:=0; s2:=0;
  t:=qualify(t);
  h1:=copy(t,1,2); h2:=str2int(h1);
  m1:=copy(t,4,2); m2:=str2int(m1);
  if ord(t[0])>6 then begin s1:=copy(t,7,2); s2:=str2int(s1); end;
  hms2sec:=(h2*3600)+(m2*60)+(s2);
end;

function int2str(inint:longint):string;
var tmp:string[11];
begin
  tmp:='0';
  str(inint,tmp);
  int2str:=tmp
end;

function i2s(inint:longint):string;
var tmp:string[11];
begin
  tmp:='0';
  str(inint,tmp);
  i2s:=tmp
end;

function str2int(s:string):longint;
var param:longint;
    ercode:integer;
begin
  val(qualify(s),param,ercode);
  str2int:=param;
end;

function upcasestr(lstring:string):string;
var i:byte;
begin
  for i:=1 to length(lstring) do
  lstring[i]:=upcase(lstring[i]);
  upcasestr:=lstring;
end;

function qualifydate(date:string):boolean;
var tmpb:boolean;
    ts:string[20];
    yy,mm,dd:word;
begin
  tmpb:=true;
  if date[0]<>#8 then tmpb:=false;
  if (date[3]<>'/') and (date[3]<>'-') then tmpb:=false;
  if (date[6]<>'/') and (date[6]<>'-') then tmpb:=false;
  yy:=str2int(copy(date,1,2));
  mm:=str2int(copy(date,4,2)); if (mm>12) or (mm<1) then tmpb:=false;
  dd:=str2int(copy(date,7,2));
  case mm of
    9,4,6,11: if dd>30 then tmpb:=false;
    1,3,5,7,8,10,12: if dd>31 then tmpb:=false;
    2: if
         ((yy mod 4)=0)
       then
         begin
           if
             (dd>29)
           then
             tmpb:=false;
         end
       else
        if
          (dd>28)
        then
          tmpb:=false;
  end;
  if mm<1 then tmpb:=false;
  qualifydate:=tmpb;
end;

function str2keys(var s:string):longint;
const flagnums:string[32]='0123456789ABCDEFGHIJKLMNOPQRSTUV';
var index,w,y:longint;
    c:char;
begin
  if s='' then begin str2keys:=0; exit; end;
  w:=0;
  for index:=1 to length(s) do
    begin
      c:=upcase(s[index]);
      case c of
        '0':W:=W or $00000001;
        '1':W:=W or $00000002;
        '2':W:=W or $00000004;
        '3':W:=W or $00000008;
        '4':W:=W or $00000010;
        '5':W:=W or $00000020;
        '6':W:=W or $00000040;
        '7':W:=W or $00000080;
        '8':W:=W or $00000100;
        '9':W:=W or $00000200;
        'A':W:=W or $00000400;
        'B':W:=W or $00000800;
        'C':W:=W or $00001000;
        'D':W:=W or $00002000;
        'E':W:=W or $00004000;
        'F':W:=W or $00008000;
        'G':W:=W or $00010000;
        'H':W:=W or $00020000;
        'I':W:=W or $00040000;
        'J':W:=W or $00080000;
        'K':W:=W or $00100000;
        'L':W:=W or $00200000;
        'M':W:=W or $00400000;
        'N':W:=W or $00800000;
        'O':W:=W or $01000000;
        'P':W:=W or $02000000;
        'Q':W:=W or $04000000;
        'R':W:=W or $08000000;
        'S':W:=W or $10000000;
        'T':W:=W or $20000000;
        'U':W:=W or $40000000;
        'V':W:=W or $80000000;
      end;
    end;
  str2keys:=w;
end;

function addslash(idir:string):string;
begin
  if (idir[length(idir)]<>'\') then idir:=idir+'\';
  addslash:=idir;
end;

function stripslash(idir:string):string;
begin
  if (idir[length(idir)]='\') then idir[0]:=chr(ord(idir[0])-1);
  stripslash:=idir;
end;

function isnum(c:char):boolean;
begin
  isnum:=(c in ['0'..'9']);
end;

function isnums(s:string):boolean;
var t:longint;
begin
  s:=qualify(s);
  t:=str2int(s);
  isnums:=true;
  if (t=0) and not(s[1]='0') then isnums:=false;
end;

function hex2long(s:string):longint;
const dig:string[16]='0123456789ABCDEF';
var t,u:longint;
    mult:longint;
    c:char;
    l:byte absolute s;
    v:byte;
begin
  s:=upcasestr(s);
  mult:=1; u:=0;
  hex2long:=-1;
  if l>8 then exit;
  hex2long:=0;
  if s='' then exit;
  repeat
    c:=s[l];
    v:=pos(c,dig);
    if (v=0) then begin hex2long:=-1; exit; end;
    t:=longint(v-1)*mult;
    u:=longint(u+t);
    dec(l);
    mult:=mult shl 4;
  until l=0;
  hex2long:=u;
end;

Function HexByte(Number: Byte): String;
  Var
    HChar: Char;
    LChar: Char;

  Begin
  LChar := Chr((Number And $F) + 48);
  If LChar > '9' Then
    LChar := Chr(Ord(LChar) + 7);
  HChar := Chr((Number shr 4) + 48);
  If HChar > '9' Then
    HChar := Chr(Ord(HChar) + 7);
  HexByte := HChar + LChar;
  End;


Function HexStr(Number: Word): String;
  Begin
  HexStr := HexByte(Number Shr 8) + HexByte(Number And $FF);
  End;


Function HexLong(Number: LongInt): String;
  Type
    WordRec = Record
      Lo: Word;
      Hi: Word;
    End;

  Begin
  HexLong := HexStr(WordRec(Number).Hi) + HexStr(WordRec(Number).Lo);
  End;

function hexb(n:byte):string;
begin hexb:=hexbyte(n); end;

function hexw(n:word):string;
begin hexw:=hexstr(n); end;

function hexl(n:longint):string;
begin hexl:=hexlong(n); end;

begin
end.

