
unit iconfig;
{$O+,F+}
{$N+,E+}
interface

uses dos,crt,bbskv,bbskern,rgoods,protcomm,sys_msg;

procedure buildconfig;
procedure parse;
function hex2long(s:string):longint;

var linein:string[127];
    restofline:string;
    parses:array[1..8] of string[80];

implementation

{$I RN-STRUC.PAS}

const cfgname='RANCHO.CFG';

var
    ps:pathstr; ds:dirstr; ns:namestr; es:extstr;

    taskstr: string[2];
    workfile:text;
    fnam:string[80];
    arg,arg2,arg3:string[32];
    v1,v2,v3,v4,v5,v6,v7,v8,v9:integer;
    v0:word;
    comd:char;
    linenum,index2:integer;
    addressindex:integer;


procedure nothing;
begin
end;

function hex2long(s:string):longint;
const dig:string[16]='0123456789ABCDEF';
var t,u:longint;
    mult:longint;
    c:char;
    l:byte absolute s;
    v:byte;
begin
  s:=upcasestr(s);
  mult:=1; u:=0;
  hex2long:=-1;
  if l>8 then exit;
  hex2long:=0;
  if s='' then exit;
  repeat
    c:=s[l];
    v:=pos(c,dig);
    if (v=0) then begin hex2long:=-1; exit; end;
    t:=longint(v-1)*mult;
    u:=longint(u+t);
    dec(l);
    mult:=mult shl 4;
  until l=0;
  hex2long:=u;
end;

procedure parse;
var index:integer;
begin
  fillchar(parses,sizeof(PARSES),chr(0));
  while (copy(linein,one,one)=' ') do delete (linein,one,one); {This gets rid of leading spaces}
  index2:=one;
  repeat
    begin
      index:=one; {reset the counter}
      while ((copy(linein,index,one)<>' ') and (index <= length(linein))) do index:=index+one; {Seek out space}
      parses[index2]:=copy(linein,one,(index-one)); {When it finds space the length of the first string is index-1}
      delete(linein,one,index); {Get rid of that part of the input string; it's now in parse1}
      while (copy(linein,one,one)=' ') do delete (linein,one,one); {This gets rid of leading spaces}
      if index2=1 then restofline:=linein;
      inc(index2);
    end
  until((index2>16) or (length(linein)<1));
end; {Procedure Parse}

procedure processline;
var cml,cmle,cmle2:string;
    index:integer;
    zone,net,node,point:word;
    m1,m2,m3:longint; argu:string; argu2:String;
begin
  for index:=1 to 16 do parses[index]:=upcasestr(parses[index]);
  cml:=upcasestr(parses[1]); arg:=parses[2]; argu:=upcasestr(parses[2]);
  argu2:=upcasestr(parses[3]);
  v2:=str2int(arg);
  if cml='ANSI' then
    begin
      cmle:=upcasestr(arg);
      if (cmle='DOORINFO') or (cmle='DORINFO') then config.ansimode:=0;
      if (cmle='ASK') then config.ansimode:=1;
      if (cmle='AUTO') or (cmle='DETECT') then config.ansimode:=2;
    end;
  if
    (cml='PORT')
  then
    begin
      m1:=str2int(arg);
      m2:=hex2long(parses[3]);
      m3:=str2int(parses[4]);
      protcomm.porttable[m1-1].base:=m2;
      protcomm.porttable[m1-1].irq :=m3;
    end;
  if cml='NOFOSSIL' then config.nofossil:=true;
  if config.nofossil then begin usefossil:=false; canusefossil:=false; end;
  if cml='SPECIALTOY' then config.specialtoy:=v2;
  if cml='SPECIALDEFENSE' then config.specialdefense:=v2;
  if cml='ESCAPE' then config.escape:=v2;
  if cml='PLAYS' then config.maxplays:=v2;
  if cml='MOVES' then config.maxmoves:=v2;
  if cml='AVTERM' then config.maxschool:=v2;
  if cml='DRINK' then config.maxjoust:=v2;
  if cml='DIFF' then config.maxdiff:=v2;
  if cml='WINLEVEL' then config.winlevel:=v2;
  if cml='TIMEOUT' then config.timeout:=v2;
  if cml='PAY' then config.robotpaypercent:=v2;
  if cml='XP' then config.robotxppercent:=v2;
  if cml='LOCALCOLOUR' then if upcasestr(arg)='NO' then config.localcolour:=false else config.localcolour:=true;
  if cml='DVSLICE' then if upcasestr(arg)='NO' then config.dvblog:=false else config.dvblog:=true;
  if cml='VKRMOVES' then if upcasestr(arg)='NO' then config.vkrmove:=false else config.vkrmove:=true;
  if cml='START' then config.startroom:=v2;
  if cml='LOSERXP' then config.loserxp:=v2;
  if cml='MINUSHP' then config.minushp:=v2;
  if (cml='CLIMBPAY') or (cml='BUMPPAY') then config.bumppay:=v2;
  if cml='ROBOTREROLL' then config.robotreroll:=v2;
  if cml='CORNER' then config.corner:=v2;
  if cml='MAXJACUZZI' then config.maxjacuzzi:=v2;
  if cml='JACUZZILUCK' then config.jacuzziluck:=v2;
  if cml='NOVKR' then config.novkr:=true;
  if cml='VKRKEY' then config.vkrkey:=true;
  if cml='MAXUSER' then config.maxuser:=v2;
  if
    cml='ROBOT'
  then
    begin
      if (argu='GENDER') or (argu='SEX') then
        begin
          if (argu2='FEMALE') then config.robotgender:=0;
          if (argu2='MALE') then config.robotgender:=1;
          if (argu2='BOTH') or (argu2='RANDOM') then config.robotgender:=2;
        end;
      if (argu='PREFERENCE') or (argu='BUTTER') then
        begin
          if (argu2='BI') or (argu2='BISEXUAL') then config.robotpreference:=0;
          if (argu2='RANDOM') or (argu2='ANY') then config.robotpreference:=1;
          if (argu2='STRAIGHT') then config.robotpreference:=2;
          if (argu2='GAY') then config.robotpreference:=3;
        end;
      if (argu='LASTNAME') then
        begin
          if (argu2='ON') then config.robotlastname:=0;
          if (argu2='OFF') then config.robotlastname:=1;
        end;
    end;
  if
    cml='DELETE'
  then
    begin
      if (argu='INACTIVE') then
        begin
          m1:=str2int(argu2); config.nukedays:=m1;
          if (argu2='NEVER') then config.nukedays:=0;
        end;
    end;
end;

procedure buildconfig;
begin
  linenum:=0;
  fillchar(config,sizeof(config),#0);
  usefossil:=true;
  canusefossil:=true;
  config.maxuser:=255;
  config.loserxp:=10;
  config.bumppay:=200;
  config.maxplays:=5;
  config.maxmoves:=60;
  config.maxschool:=2;
  config.maxjoust:=3;
  config.timeout:=4;
  config.winlevel:=100;
  config.robotxppercent:=100;
  config.robotpaypercent:=100;
  config.maxdiff:=5;
  config.localcolour:=true;
  config.startroom:=1;
  config.minushp:=100;
  config.escape:=20;
  config.specialtoy:=400;
  config.specialdefense:=300;
  config.robotreroll:=6;
  config.corner:=30;
  config.vkrmove:=false;
  config.jacuzziluck:=35;
  config.maxjacuzzi:=4;
  config.dvblog:=false;
  config.novkr:=false;

  if
    (not exist(cfgname))
  then
    begin
      parameter[1]:=cfgname;
      sysmsg(714);
      delay(5000);
      halt;
    end;
  assign(workfile,cfgname);
  reset(workfile);
  repeat
    begin
      readln(workfile,linein);
      inc(linenum);
      parse;
      processline;
    end;
  until eof(workfile);
  close(workfile);
end;

begin
end.
