/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.plugin.StatusDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UpdateDialog
extends JDialog
implements ActionListener {
    static final String MANIFEST = "META-INF/MANIFEST.MF";
    static final String MANIFEST_DIR = "META-INF/";
    static final String REMOTE_URL = "jar:http://j-twat.sourceforge.net/jtwat2.jar!/";
    static final String LOCAL_FILE = "jtwat2.jar";
    static final String TEMP_FILE = "jtwat3.jar";
    static final String REMOTE_NONJAR_URL = "jar:http://j-twat.sourceforge.net/nonjar.jar!/";
    static final String VERSION_URL = "http://j-twat.sourceforge.net/version";
    static final String LOCAL_VERSION = "version";
    static final String CHANGES_URL = "http://j-twat.sourceforge.net/changes";
    JTextArea changes;
    JButton yes;
    JButton no;
    boolean result = false;
    float version;
    float currentVersion;

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.show();
        new UpdateDialog(frame).show();
        System.exit(0);
    }

    public UpdateDialog(Frame frame) {
        super(frame);
        this.setTitle("Update Available");
        this.result = this.checkVersion();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(new JLabel("Changes since version " + this.version + ":"));
        this.changes = new JTextArea(10, 30);
        this.getContentPane().add(new JScrollPane(this.changes));
        this.getContentPane().add(new JLabel("Do you wish to upgrade to version " + this.currentVersion + "?"));
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.yes = new JButton("Yes");
        jPanel.add(this.yes);
        this.yes.addActionListener(this);
        this.no = new JButton("No");
        jPanel.add(this.no);
        this.no.addActionListener(this);
        this.getContentPane().add(jPanel);
        this.setModal(true);
        this.getChanges();
        this.pack();
    }

    public boolean getResult() {
        return this.result;
    }

    public void show() {
        if (this.result) {
            super.show();
        }
    }

    void getChanges() {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            URL uRL = new URL(CHANGES_URL);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openConnection().getInputStream());
            byte[] byArray = new byte[512];
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "~", false);
            StringBuffer stringBuffer2 = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                float f = Float.parseFloat(stringTokenizer.nextToken());
                String string = stringTokenizer.nextToken();
                if (!(f > this.version)) continue;
                stringBuffer2.append(f);
                stringBuffer2.append(":\n");
                stringBuffer2.append(string);
                stringBuffer2.append("\n------------------------------------------------------------------\n");
            }
            this.changes.setText(stringBuffer2.toString());
            return;
        }
        catch (Exception exception) {
            System.out.println("ERROR ACCESSING CHANGE LOG");
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.yes) {
            this.getFiles();
        }
        this.dispose();
    }

    boolean checkVersion() {
        DataInputStream dataInputStream;
        this.version = 0.0f;
        this.currentVersion = 0.0f;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(LOCAL_VERSION));
            this.version = Float.parseFloat(dataInputStream.readLine());
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error opening version file!!!");
            exception.printStackTrace();
        }
        try {
            URL uRL = new URL(VERSION_URL);
            dataInputStream = new DataInputStream(uRL.openStream());
            this.currentVersion = Float.parseFloat(dataInputStream.readLine());
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error Connecting to Version Control!!!");
            exception.printStackTrace();
        }
        return this.version < this.currentVersion;
    }

    void getFiles() {
        JarFile jarFile;
        JarFile jarFile2;
        JarFile jarFile3;
        StatusDialog statusDialog = new StatusDialog(this);
        statusDialog.setText("Connecting...");
        statusDialog.show();
        try {
            jarFile3 = ((JarURLConnection)new URL(REMOTE_URL).openConnection()).getJarFile();
            jarFile2 = ((JarURLConnection)new URL(REMOTE_NONJAR_URL).openConnection()).getJarFile();
            jarFile = new JarFile(LOCAL_FILE);
        }
        catch (IOException iOException) {
            System.out.println("Error connecting!");
            System.out.println(iOException);
            iOException.printStackTrace();
            return;
        }
        statusDialog.setText("Connecting...connected.");
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ZipEntry zipEntry;
            JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(TEMP_FILE));
            Enumeration<JarEntry> enumeration = jarFile3.entries();
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (zipEntry.getSize() == -1L) continue;
                object4 = jarFile.getEntry(zipEntry.getName());
                if (object4 == null || ((ZipEntry)object4).getTime() < zipEntry.getTime()) {
                    object3 = (JarURLConnection)new URL(REMOTE_URL + zipEntry.getName()).openConnection();
                    object2 = new BufferedInputStream(((URLConnection)object3).getInputStream());
                    statusDialog.setText("Downloading " + zipEntry.getName());
                } else {
                    object2 = new BufferedInputStream(jarFile.getInputStream((ZipEntry)object4));
                }
                object = new ZipEntry(zipEntry.getName());
                ((ZipEntry)object).setTime(zipEntry.getTime());
                ((ZipEntry)object).setSize(zipEntry.getSize());
                jarOutputStream.putNextEntry((ZipEntry)object);
                UpdateDialog.readAndWrite((InputStream)object2, jarOutputStream, statusDialog, zipEntry.getSize());
                ((BufferedInputStream)object2).close();
            }
            jarOutputStream.close();
            jarFile.close();
            object4 = new File(LOCAL_FILE);
            object2 = new File(TEMP_FILE);
            ((File)object4).delete();
            ((File)object2).renameTo((File)object4);
            enumeration = jarFile2.entries();
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (zipEntry.getSize() == -1L || ((File)(object = new File(zipEntry.getName()))).exists() && ((File)object).lastModified() >= zipEntry.getTime()) continue;
                if (!(((File)object).getParent() == null || (((File)(object3 = new File(((File)object).getParent()))).exists() || ((File)object3).mkdirs()) && ((File)object3).isDirectory())) {
                    System.out.println("COULD NOT MAKE DIRECTORY");
                }
                object3 = new FileOutputStream((File)object);
                JarURLConnection jarURLConnection = (JarURLConnection)new URL(REMOTE_NONJAR_URL + zipEntry.getName()).openConnection();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(jarURLConnection.getInputStream());
                statusDialog.setText("Downloading " + zipEntry.getName());
                ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
                zipEntry2.setTime(zipEntry.getTime());
                zipEntry2.setSize(zipEntry.getSize());
                UpdateDialog.readAndWrite(bufferedInputStream, (OutputStream)object3, statusDialog, zipEntry.getSize());
                bufferedInputStream.close();
            }
            System.out.println("writing version");
            object = new PrintStream(new FileOutputStream(LOCAL_VERSION));
            ((PrintStream)object).println(Float.toString(this.currentVersion));
            ((PrintStream)object).close();
        }
        catch (IOException iOException) {
            System.out.println("Error downloading files!!!");
            System.out.println(iOException);
        }
        statusDialog.dispose();
    }

    static void readAndWrite(InputStream inputStream, OutputStream outputStream, StatusDialog statusDialog, long l) throws IOException {
        int n;
        byte[] byArray = new byte[512];
        long l2 = 0L;
        long l3 = l;
        statusDialog.setProgress(0);
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            statusDialog.setProgress((int)((l2 += (long)n) / l3));
            outputStream.write(byArray, 0, n);
        }
    }
}

