/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import TWHelp.DatabaseUpdateScript;
import TWHelp.TWClient;
import TWHelp.TWHelper;
import TWHelp.TWScript;
import TWHelp.TWSession;
import TWHelp.TWStorageModule;
import de.mud.jta.FilterPlugin;
import de.mud.jta.Main;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.SocketRequest;
import de.mud.jta.plugin.AnalysisDialog;
import de.mud.jta.plugin.ChatDialog;
import de.mud.jta.plugin.ChatFrame;
import de.mud.jta.plugin.ConnectionDialog;
import de.mud.jta.plugin.FeatureRequestDialog;
import de.mud.jta.plugin.MacroDialog;
import de.mud.jta.plugin.MessageBox;
import de.mud.jta.plugin.OptionsDialog;
import de.mud.jta.plugin.ScriptDialog;
import de.mud.jta.plugin.StorageModuleSelectDialog;
import de.mud.jta.plugin.SubmitBugDialog;
import de.mud.jta.plugin.TW$1;
import de.mud.jta.plugin.TW$2;
import de.mud.jta.plugin.TWStatus;
import de.mud.jta.plugin.ViewLogDialog;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class TW
extends Plugin
implements FilterPlugin,
VisualPlugin,
ActionListener,
TWClient {
    static String version = "J-TWAT VERSION " + Main.version + " Beta";
    String[] scripts = new String[]{"TWHelp.BustPlanets", "TWHelp.BuyRefurbScript", "TWHelp.BuyPClassScript", "TWHelp.ColonizeScript", "TWHelp.EprobeExplore", "TWHelp.ExploreShipScript", "TWHelp.MegaJettisonScript", "TWHelp.SimpleMoveScript", "TWHelp.PlanetColonistTransferScript", "TWHelp.PlanetProductTransferScript", "TWHelp.PlanetSellProductScript", "TWHelp.PlanetWarpInScript", "TWHelp.PhotonEnterScript", "TWHelp.PhotonWatchScript", "TWHelp.PhotonPlanetScript", "TWHelp.PortBuyDownScript", "TWHelp.PortPairTradeScript", "TWHelp.SDTScript", "TWHelp.ShipCaptureScript", "TWHelp.SSTScript", "TWHelp.SSTScript2", "TWHelp.SSMScript", "TWHelp.ZTM"};
    String[] analysis = new String[]{"TWHelp.PortPairAnalysis", "TWHelp.EvilPairAnalysis", "TWHelp.BustAnalysis", "TWHelp.SSSAnalysis", "TWHelp.DeadEndAnalysis", "TWHelp.BubbleAnalysis", "TWHelp.NearestFighterAnalysis", "TWHelp.SectorAnalysis"};
    String[] storage = new String[]{"TWHelp.JTWATFileStorageModule", "TWHelp.CIMFileStorageModule", "TWHelp.HTTPGetStorageModule"};
    public TWHelper helper;
    PipedOutputStream toHelper;
    PipedInputStream toHelperEndStream;
    Applet theapplet;
    Frame theFrame;
    boolean isAppletValue;
    ChatDialog chatd = null;
    ChatFrame chatf = null;
    AnalysisDialog anald = null;
    StorageModuleSelectDialog storaged = null;
    ConnectionDialog connectiond = null;
    MacroDialog macrod = null;
    ViewLogDialog logd = null;
    Panel panel;
    Choice scriptList;
    Hashtable scriptClasses;
    Button run;
    Button stop;
    Button updateDB;
    Button chatb;
    Button analdb;
    Button macrob;
    Button graphb;
    boolean onlineStatus;
    TWStorageModule lastSave = null;
    Menu pluginMenu;
    MenuItem connect;
    MenuItem disconnect;
    MenuItem loadDB;
    MenuItem saveDB;
    MenuItem saveAsDB;
    MenuItem resetHelper;
    MenuItem option;
    MenuItem export;
    MenuItem importb;
    Menu toolMenu;
    MenuItem viewChat;
    MenuItem viewAnalysis;
    MenuItem viewMacro;
    MenuItem updateDBMenu;
    Menu debugMenu;
    MenuItem submitBug;
    MenuItem submitFeature;
    MenuItem viewLog;
    Menu scriptMenu;
    FilterPlugin source;
    String longString = new String("");
    int NORMAL = 0;
    int ESCAPE = 1;
    int ESCAPE2 = 2;
    int ESCAPE_STRING = 3;
    int ansiState = this.NORMAL;
    boolean useDlg = true;

    public boolean isApplet() {
        return this.isAppletValue;
    }

    public TW(PluginBus pluginBus, String string) {
        super(pluginBus, string);
        int n;
        TW tW = this;
        this.onlineStatus = false;
        System.out.println(version);
        this.isAppletValue = false;
        try {
            if (Main.frame != null) {
                this.theFrame = Main.frame;
            }
        }
        catch (Exception exception) {
            System.err.println("de.mud.jta.Main class not found -- assuming this is an applet");
        }
        pluginBus.registerPluginListener(new TW$1(this, tW));
        pluginBus.registerPluginListener(new TW$2(this));
        this.chatf = new ChatFrame("Chat", this);
        if (this.theFrame != null) {
            this.chatd = new ChatDialog(this.theFrame, "Chat", this);
            this.anald = new AnalysisDialog(this.theFrame);
            this.storaged = new StorageModuleSelectDialog(this.theFrame, "Save Information");
            this.connectiond = new ConnectionDialog(this.theFrame);
            this.macrod = new MacroDialog(this.theFrame, this);
            this.logd = new ViewLogDialog(this.theFrame);
            int n2 = 0;
            while (n2 < this.analysis.length) {
                this.anald.addAnalysis(this.analysis[n2]);
                ++n2;
            }
            n = 0;
            while (n < this.storage.length) {
                this.storaged.addStorageModule(this.storage[n]);
                ++n;
            }
        }
        this.panel = new Panel(new FlowLayout(0));
        this.scriptList = new Choice();
        this.scriptClasses = new Hashtable();
        Hashtable<String, MenuItem> hashtable = new Hashtable<String, MenuItem>();
        n = 0;
        while (n < this.scripts.length) {
            String string2 = TWSession.getCurrentSession().addScript(this.scripts[n]);
            if (string2 != null) {
                MenuItem menuItem;
                this.scriptList.addItem(string2);
                this.scriptClasses.put(string2, this.scripts[n]);
                String string3 = TWSession.getCurrentSession().getScriptCategory(this.scripts[n]);
                if (string3 != null) {
                    menuItem = (Menu)hashtable.get(string3);
                    if (menuItem == null) {
                        menuItem = new Menu(string3, true);
                        this.getScriptMenu().add(menuItem);
                        hashtable.put(string3, menuItem);
                    }
                    MenuItem menuItem2 = new MenuItem(string2);
                    menuItem2.addActionListener(this);
                    ((Menu)menuItem).add(menuItem2);
                } else {
                    menuItem = new MenuItem(string2);
                    menuItem.addActionListener(this);
                    this.getScriptMenu().add(menuItem);
                }
            }
            ++n;
        }
        this.panel.add(this.scriptList);
        this.run = new Button("RUN");
        this.run.addActionListener(this);
        this.panel.add(this.run);
        this.stop = new Button("STOP");
        this.stop.addActionListener(this);
        this.panel.add(this.stop);
        this.stop.setEnabled(false);
        this.updateDB = new Button("Update DB");
        this.updateDB.addActionListener(this);
        this.panel.add(this.updateDB);
        this.chatb = new Button("Show Chat");
        this.chatb.addActionListener(this);
        this.panel.add(this.chatb);
        this.analdb = new Button("Show Analysis");
        this.analdb.addActionListener(this);
        this.panel.add(this.analdb);
        this.macrob = new Button("Show Macro");
        this.macrob.addActionListener(this);
        this.panel.add(this.macrob);
        this.graphb = new Button("Show Map");
        this.graphb.addActionListener(this);
        this.panel.add(this.graphb);
        try {
            this.toHelper = new PipedOutputStream();
            this.toHelperEndStream = new PipedInputStream(this.toHelper);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TWSession.getCurrentSession().setClient(this);
        this.helper = TWSession.getCurrentSession().getHelper();
        TWSession.getCurrentSession().init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block43: {
            if (actionEvent.getSource() == this.stop) {
                this.helper.stopScript();
                return;
            }
            if (actionEvent.getSource() == this.run) {
                try {
                    TWScript tWScript = TWSession.getCurrentSession().getNewScript((String)this.scriptClasses.get(this.scriptList.getSelectedItem()));
                    this.helper.prepareScript(tWScript);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            if (actionEvent.getSource() == this.updateDB || actionEvent.getSource() == this.updateDBMenu) {
                this.helper.prepareScript(new DatabaseUpdateScript());
                return;
            }
            if (actionEvent.getSource() == this.chatb || actionEvent.getSource() == this.viewChat) {
                this.flipChat();
                return;
            }
            if (actionEvent.getSource() == this.analdb || actionEvent.getSource() == this.viewAnalysis) {
                this.flipAnalysis();
                return;
            }
            if (actionEvent.getSource() == this.macrob || actionEvent.getSource() == this.viewMacro) {
                this.flipMacro();
                return;
            }
            if (actionEvent.getSource() == this.graphb) {
                TWSession.getCurrentSession().getMap().flipWindow();
                return;
            }
            if (actionEvent.getSource() == this.loadDB) {
                try {
                    TWStorageModule tWStorageModule = TWSession.getCurrentSession().getNewStorageModule("TWHelp.JTWATFileStorageModule");
                    if (tWStorageModule.read()) {
                        this.lastSave = tWStorageModule;
                        this.saveDB.setEnabled(true);
                        return;
                    }
                    break block43;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            if (actionEvent.getSource() == this.saveDB) {
                if (this.lastSave != null) {
                    this.lastSave.write(true);
                    return;
                }
            } else {
                if (actionEvent.getSource() == this.saveAsDB) {
                    try {
                        TWStorageModule tWStorageModule = TWSession.getCurrentSession().getNewStorageModule("TWHelp.JTWATFileStorageModule");
                        if (tWStorageModule.write(false)) {
                            this.lastSave = tWStorageModule;
                            this.saveDB.setEnabled(true);
                            return;
                        }
                        break block43;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
                if (actionEvent.getSource() == this.importb) {
                    this.storaged.setTitle("Import Game");
                    this.storaged.show();
                    if (this.storaged.getSelection() != null) {
                        try {
                            TWSession.getCurrentSession().getNewStorageModule(this.storaged.getSelection()).read();
                            return;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return;
                        }
                    }
                } else if (actionEvent.getSource() == this.export) {
                    this.storaged.setTitle("Export Game");
                    this.storaged.show();
                    if (this.storaged.getSelection() != null) {
                        try {
                            TWSession.getCurrentSession().getNewStorageModule(this.storaged.getSelection()).write();
                            return;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return;
                        }
                    }
                } else {
                    if (actionEvent.getSource() == this.resetHelper) {
                        this.helper = null;
                        TWSession.getCurrentSession().resetSession();
                        TWSession.getCurrentSession().init();
                        this.helper = TWSession.getCurrentSession().getHelper();
                        this.anald.reset();
                        this.analdb.setLabel("Show Analysis");
                        this.chatd.reset();
                        this.chatf.reset();
                        this.chatb.setLabel("Show Chat");
                        this.macrod.reset();
                        this.macrob.setLabel("Show Macro");
                        return;
                    }
                    if (actionEvent.getSource() == this.connect) {
                        this.connectiond.show();
                        if (this.connectiond.getAddress() != null) {
                            this.bus.broadcast(new SocketRequest(this.connectiond.getAddress().getAddress(), this.connectiond.getAddress().getPort()));
                            return;
                        }
                    } else {
                        if (actionEvent.getSource() == this.disconnect) {
                            this.bus.broadcast(new SocketRequest());
                            return;
                        }
                        if (actionEvent.getSource() == this.option) {
                            new OptionsDialog(this.theFrame).show();
                            return;
                        }
                        if (actionEvent.getSource() == this.submitBug) {
                            new SubmitBugDialog(this.theFrame).show();
                            return;
                        }
                        if (actionEvent.getSource() == this.submitFeature) {
                            new FeatureRequestDialog(this.theFrame).show();
                            return;
                        }
                        if (actionEvent.getSource() == this.viewLog) {
                            if (this.logd.isShowing()) {
                                this.logd.hide();
                                return;
                            }
                            this.logd.show();
                            return;
                        }
                        if (actionEvent.getSource() instanceof MenuItem && this.scriptClasses.get(((MenuItem)actionEvent.getSource()).getLabel()) != null) {
                            try {
                                TWScript tWScript = TWSession.getCurrentSession().getNewScript((String)this.scriptClasses.get(((MenuItem)actionEvent.getSource()).getLabel()));
                                this.helper.prepareScript(tWScript);
                                return;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                return;
                            }
                        }
                        System.out.println(actionEvent.getSource());
                    }
                }
            }
        }
    }

    public Component getPluginVisual() {
        return this.panel;
    }

    public Menu getPluginMenu() {
        if (this.pluginMenu != null) {
            return this.pluginMenu;
        }
        this.pluginMenu = new Menu("File");
        this.connect = new MenuItem("Connect...");
        this.connect.addActionListener(this);
        this.pluginMenu.add(this.connect);
        this.disconnect = new MenuItem("Disconnect");
        this.disconnect.addActionListener(this);
        this.pluginMenu.add(this.disconnect);
        this.resetHelper = new MenuItem("Reset Helper");
        this.resetHelper.addActionListener(this);
        this.pluginMenu.add(this.resetHelper);
        this.pluginMenu.add(new MenuItem("-"));
        this.loadDB = new MenuItem("Open Game...");
        this.loadDB.addActionListener(this);
        this.pluginMenu.add(this.loadDB);
        this.saveDB = new MenuItem("Save Game");
        this.saveDB.addActionListener(this);
        this.saveDB.setEnabled(false);
        this.pluginMenu.add(this.saveDB);
        this.saveAsDB = new MenuItem("Save Game As...");
        this.saveAsDB.addActionListener(this);
        this.pluginMenu.add(this.saveAsDB);
        this.pluginMenu.add(new MenuItem("-"));
        this.importb = new MenuItem("Import...");
        this.pluginMenu.add(this.importb);
        this.importb.addActionListener(this);
        this.export = new MenuItem("Export...");
        this.pluginMenu.add(this.export);
        this.export.addActionListener(this);
        this.pluginMenu.add(new MenuItem("-"));
        this.option = new MenuItem("Game Options...");
        this.option.addActionListener(this);
        this.pluginMenu.add(this.option);
        return this.pluginMenu;
    }

    public Menu getToolMenu() {
        if (this.toolMenu != null) {
            return this.toolMenu;
        }
        this.toolMenu = new Menu("Tools");
        this.viewChat = new MenuItem("View Chat");
        this.viewChat.addActionListener(this);
        this.toolMenu.add(this.viewChat);
        this.viewAnalysis = new MenuItem("View Analysis");
        this.viewAnalysis.addActionListener(this);
        this.toolMenu.add(this.viewAnalysis);
        this.viewMacro = new MenuItem("View Macro");
        this.viewMacro.addActionListener(this);
        this.toolMenu.add(this.viewMacro);
        this.toolMenu.add(new MenuItem("-"));
        this.updateDBMenu = new MenuItem("Update DataBase");
        this.updateDBMenu.addActionListener(this);
        this.toolMenu.add(this.updateDBMenu);
        return this.toolMenu;
    }

    public Menu getDebugMenu() {
        if (this.debugMenu != null) {
            return this.debugMenu;
        }
        this.debugMenu = new Menu("Debug");
        this.viewLog = new MenuItem("View Error Log");
        this.viewLog.addActionListener(this);
        this.debugMenu.add(this.viewLog);
        this.debugMenu.add(new MenuItem("-"));
        this.submitBug = new MenuItem("Submit a Bug");
        this.submitBug.addActionListener(this);
        this.debugMenu.add(this.submitBug);
        this.submitFeature = new MenuItem("Submit a Feature Request");
        this.submitFeature.addActionListener(this);
        this.debugMenu.add(this.submitFeature);
        return this.debugMenu;
    }

    public Menu getScriptMenu() {
        if (this.scriptMenu == null) {
            this.scriptMenu = new Menu("Scripts");
        }
        return this.scriptMenu;
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public int read(byte[] byArray) {
        int n = -1;
        try {
            n = this.source.read(byArray);
            if (n > -1) {
                byte[] byArray2 = new byte[byArray.length];
                int n2 = this.stripAnsi(byArray, byArray2, n);
                this.toHelper.write(byArray2, 0, n2);
                this.toHelper.flush();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return n;
    }

    public int stripAnsi(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = (char)byArray[n3];
            switch (this.ansiState) {
                case 0: {
                    if (c != '\u001b' && c != '\u0000') {
                        byArray2[n2] = byArray[n3];
                        ++n2;
                        break;
                    }
                    if (c != '\u001b') break;
                    this.ansiState = this.ESCAPE;
                    break;
                }
                case 1: {
                    if (c == '[' || Character.isDigit(c)) {
                        this.ansiState = this.ESCAPE2;
                        break;
                    }
                    if (c != '\"') break;
                    this.ansiState = this.ESCAPE_STRING;
                    break;
                }
                case 2: {
                    if (Character.isLetter(c)) {
                        this.ansiState = this.NORMAL;
                        break;
                    }
                    if (c == '[' || Character.isDigit(c)) {
                        this.ansiState = this.ESCAPE2;
                        break;
                    }
                    this.ansiState = this.ESCAPE;
                    break;
                }
                case 3: {
                    if (c != '\"') break;
                    this.ansiState = this.ESCAPE;
                }
            }
            ++n3;
        }
        return n2;
    }

    public synchronized void write(String string) {
        this.write(string.getBytes());
    }

    public synchronized void write(byte[] byArray) {
        if (this.macrod.isRecording()) {
            this.macrod.addCharacter(new String(byArray));
        }
        try {
            this.source.write(byArray);
            return;
        }
        catch (IOException iOException) {
            System.out.println("IOEXCEPTION");
            return;
        }
    }

    public synchronized void WriteMessage(String string) {
        this.write(string);
    }

    public void writeChat(String string) {
        if (this.chatd == null) {
            this.chatd = new ChatDialog(this.theFrame, "Chat", this);
        }
        this.chatd.addMessage(string);
        if (this.chatf == null) {
            this.chatf = new ChatFrame("Chat", this);
        }
        this.chatf.addMessage(string);
    }

    public void scriptStarted() {
        this.run.setEnabled(false);
        this.stop.setEnabled(true);
    }

    public void scriptStopped() {
        this.run.setEnabled(true);
        this.stop.setEnabled(false);
    }

    public boolean prepareScript(Component component, String string) {
        boolean bl = true;
        if (component != null) {
            bl = new ScriptDialog(this.theFrame, component, string).doDialog();
        }
        return bl;
    }

    public void updateStatus() {
        TWStatus tWStatus = TWStatus.getTWStatus();
        if (this.theapplet != null) {
            this.theapplet.showStatus(version);
        }
        if (tWStatus != null) {
            tWStatus.updateStatus(this.helper.info.ti.toString());
        }
    }

    public void updatePlayerList(Vector vector) {
        if (this.chatd == null) {
            this.chatd = new ChatDialog(this.theFrame, "Chat", this);
        }
        if (this.chatf == null) {
            this.chatf = new ChatFrame("Chat", this);
        }
        this.chatd.setPlayerList(vector);
        this.chatf.setPlayerList(vector);
    }

    public void flipAnalysis() {
        if (this.anald.isShowing()) {
            this.anald.hide();
            this.analdb.setLabel("Show Analysis");
            return;
        }
        this.anald.show();
        this.analdb.setLabel("Hide Analysis");
    }

    public void flipMacro() {
        if (this.macrod.isShowing()) {
            this.macrod.hide();
            this.macrob.setLabel("Show Macro");
            return;
        }
        this.macrod.show();
        this.macrob.setLabel("Hide Macro");
    }

    public void flipChat() {
        Window window;
        if (this.chatd == null) {
            this.chatd = new ChatDialog(this.theFrame, "Chat", this);
        }
        if (this.chatf == null) {
            this.chatf = new ChatFrame("Chat", this);
        }
        if ((window = this.useDlg ? this.chatd : this.chatf).isShowing()) {
            window.hide();
            this.chatb.setLabel("Show Chat");
            return;
        }
        window.show();
        this.chatb.setLabel("Hide Chat");
    }

    public void swapChats() {
        if (this.chatd == null) {
            this.chatd = new ChatDialog(this.theFrame, "Chat", this);
        }
        if (this.chatf == null) {
            this.chatf = new ChatFrame("Chat", this);
        }
        if (this.chatd.isShowing()) {
            this.chatd.hide();
            this.chatf.show();
            this.useDlg = false;
            return;
        }
        this.chatd.show();
        this.chatf.hide();
        this.useDlg = true;
    }

    public boolean writeStaticInfo(String string, String string2) {
        return false;
    }

    public String readStaticInfo(String string) {
        return "";
    }

    public Frame getFrame() {
        return this.theFrame;
    }

    public InputStream getInputStream() {
        return this.toHelperEndStream;
    }

    public boolean isOnline() {
        return this.onlineStatus;
    }

    public int showMessageBox(String string, int n) {
        MessageBox messageBox = new MessageBox(this.theFrame, string, n);
        messageBox.show();
        return messageBox.getResult();
    }

    public boolean doSaveOnExit() {
        int n = this.showMessageBox("Do you wish to save your game?", 14);
        boolean bl = false;
        if (n == 4) {
            if (this.lastSave != null) {
                System.out.println("just saving");
                this.lastSave.write(true);
            } else {
                try {
                    TWSession.getCurrentSession().getNewStorageModule("TWHelp.JTWATFileStorageModule").write();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            bl = true;
        } else if (n == 8) {
            bl = true;
        } else if (n == 2) {
            bl = false;
        }
        return bl;
    }
}

