/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.Main;
import de.mud.jta.plugin.AddAddressDialog;
import de.mud.jta.plugin.ServerAddress;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

class ConnectionDialog
extends Dialog
implements ActionListener,
ItemListener {
    TextField address;
    TextField port;
    Button ok;
    Button cancel;
    Button addb;
    Button removeb;
    List addresses;
    Vector addressesData = new Vector();
    ServerAddress result = null;
    boolean dirty = false;

    public ConnectionDialog(Frame frame) {
        super(frame, "Connect...", true);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new FlowLayout(0));
        panel.add(new Label("Address: "));
        this.address = new TextField("", 20);
        panel.add(this.address);
        panel.add(new Label("   Port: "));
        this.port = new TextField("", 6);
        panel.add(this.port);
        this.add((Component)panel, "North");
        Panel panel2 = new Panel(new BorderLayout());
        Panel panel3 = new Panel(new FlowLayout(1));
        this.addb = new Button("Add...");
        this.addb.addActionListener(this);
        panel3.add(this.addb);
        this.removeb = new Button("Remove");
        this.removeb.addActionListener(this);
        panel3.add(this.removeb);
        panel2.add((Component)panel3, "North");
        this.addresses = new List();
        this.addresses.addItemListener(this);
        panel2.add((Component)this.addresses, "Center");
        this.add((Component)panel2, "Center");
        Panel panel4 = new Panel(new FlowLayout(1));
        this.ok = new Button("Connect");
        panel4.add(this.ok);
        this.ok.addActionListener(this);
        this.cancel = new Button("Cancel");
        this.cancel.addActionListener(this);
        panel4.add(this.cancel);
        this.add((Component)panel4, "South");
        this.readAddressBook();
        this.pack();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ServerAddress serverAddress = (ServerAddress)this.addressesData.elementAt(this.addresses.getSelectedIndex());
        this.address.setText(serverAddress.getAddress());
        this.port.setText(Integer.toString(serverAddress.getPort()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addb) {
            this.dirty = true;
            AddAddressDialog addAddressDialog = new AddAddressDialog(this);
            addAddressDialog.show();
            if (addAddressDialog.getAddress() != null) {
                this.addressesData.addElement(addAddressDialog.getAddress());
                this.addresses.add(addAddressDialog.getAddress().getDescription());
                return;
            }
        } else if (actionEvent.getSource() == this.removeb) {
            this.dirty = true;
            if (this.addresses.getSelectedIndex() > -1) {
                this.addressesData.removeElementAt(this.addresses.getSelectedIndex());
                this.addresses.remove(this.addresses.getSelectedIndex());
                return;
            }
        } else {
            if (actionEvent.getSource() == this.ok) {
                if (this.dirty) {
                    this.writeAddressBook();
                }
                this.result = new ServerAddress("", this.address.getText(), this.port.getText());
                this.dispose();
                return;
            }
            if (actionEvent.getSource() == this.cancel) {
                if (this.dirty) {
                    this.writeAddressBook();
                }
                this.result = null;
                this.dispose();
            }
        }
    }

    ServerAddress getAddress() {
        return this.result;
    }

    void writeAddressBook() {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(".jtwataddresses"));
            int n = 0;
            while (n < this.addressesData.size()) {
                printStream.println(((ServerAddress)this.addressesData.elementAt(n)).toString());
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("Could not write addresses to disk.");
            exception.printStackTrace();
            return;
        }
    }

    void readAddressBook() {
        try {
            String string;
            BufferedReader bufferedReader = Main.addressBookURL != null ? new BufferedReader(new InputStreamReader(new URL(Main.addressBookURL).openStream())) : new BufferedReader(new InputStreamReader(new FileInputStream(".jtwataddresses")));
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                this.addressesData.addElement(new ServerAddress(string2, string3, string4));
                this.addresses.add(string2);
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("Could not read addresses from disk.");
            exception.printStackTrace();
            return;
        }
    }
}

