/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import TWHelp.TWAnalysis;
import TWHelp.TWSession;
import de.mud.jta.plugin.AnalysisDialog$1;
import de.mud.jta.plugin.ScriptDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;

class AnalysisDialog
extends Dialog
implements ActionListener,
ItemListener {
    Component result;
    Panel analysisButtons;
    Button newAnalysis;
    Button refresh;
    Frame parent;
    Choice aList;
    List dummyList;
    Hashtable analysisClasses;

    public AnalysisDialog(Frame frame) {
        super(frame, "Analysis");
        this.parent = frame;
        this.analysisClasses = new Hashtable();
        this.setLayout(new BorderLayout());
        this.analysisButtons = new Panel(new FlowLayout(0));
        this.aList = new Choice();
        this.aList.addItemListener(this);
        this.analysisButtons.add(this.aList);
        this.newAnalysis = new Button("New Analysis...");
        this.newAnalysis.addActionListener(this);
        this.analysisButtons.add(this.newAnalysis);
        this.refresh = new Button("Refresh");
        this.refresh.addActionListener(this);
        this.analysisButtons.add(this.refresh);
        AnalysisDialog analysisDialog = this;
        analysisDialog.add((Component)analysisDialog.analysisButtons, "North");
        this.dummyList = new List();
        this.result = this.dummyList;
        this.dummyList.addItem("No results yet.  Run new analysis");
        AnalysisDialog analysisDialog2 = this;
        analysisDialog2.add(analysisDialog2.result, "Center");
        ((Component)this).setSize(500, 200);
        this.addWindowListener(new AnalysisDialog$1(this));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.newAnalysis) {
            String string = (String)this.analysisClasses.get(this.aList.getSelectedItem());
            TWAnalysis tWAnalysis = TWSession.getCurrentSession().getNewAnalysis(string);
            Component component = tWAnalysis.getDialog();
            ScriptDialog scriptDialog = null;
            if (component != null) {
                scriptDialog = new ScriptDialog(this.parent, component, tWAnalysis.getHelpString());
            }
            if (component == null || scriptDialog.doDialog()) {
                tWAnalysis.executeAnalysis();
                this.hide();
                this.show();
                return;
            }
        } else if (actionEvent.getSource() == this.refresh) {
            String string = (String)this.analysisClasses.get(this.aList.getSelectedItem());
            TWAnalysis tWAnalysis = TWSession.getCurrentSession().getCurrentAnalysis(string);
            if (tWAnalysis != null) {
                tWAnalysis.executeAnalysis();
            }
            this.hide();
            this.show();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.hide();
        this.show();
    }

    public void show() {
        String string = (String)this.analysisClasses.get(this.aList.getSelectedItem());
        TWAnalysis tWAnalysis = TWSession.getCurrentSession().getCurrentAnalysis(string);
        if (tWAnalysis == null && TWSession.getCurrentSession().isSingular(string)) {
            tWAnalysis = TWSession.getCurrentSession().getNewAnalysis(string);
            tWAnalysis.executeAnalysis();
        }
        AnalysisDialog analysisDialog = this;
        analysisDialog.remove(analysisDialog.result);
        this.result = tWAnalysis != null ? tWAnalysis.getResultDisplay() : this.dummyList;
        this.newAnalysis.setEnabled(!TWSession.getCurrentSession().isSingular(string));
        AnalysisDialog analysisDialog2 = this;
        analysisDialog2.add(analysisDialog2.result, "Center");
        this.pack();
        super.show();
    }

    public void addAnalysis(String string) {
        String string2 = TWSession.getCurrentSession().addAnalysis(string);
        if (string2 != null) {
            this.aList.add(string2);
            this.analysisClasses.put(string2, string);
        }
    }

    public void reset() {
        AnalysisDialog analysisDialog = this;
        analysisDialog.remove(analysisDialog.result);
        this.dummyList = new List();
        this.result = this.dummyList;
        AnalysisDialog analysisDialog2 = this;
        analysisDialog2.add(analysisDialog2.result, "Center");
        this.hide();
    }
}

