/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.Port;
import TWHelp.Sector;
import TWHelp.Ship;
import TWHelp.ShipType;
import TWHelp.TWInfo;
import TWHelp.TWSession;
import TWHelp.Yylex;
import java.util.StringTokenizer;
import java.util.Vector;

public class YylexHelper {
    static Yylex yylex;
    static TWInfo info;
    public static int traderMode;
    static Vector tempTrader;
    static boolean emptyShip;
    static int comval;
    static int comprod;

    public static void setYylex(Yylex yylex) {
        YylexHelper.yylex = yylex;
        TWSession.getCurrentSession();
        info = TWSession.getInfo();
    }

    public static void handleCommerceReport() {
        Sector sector = info.getCS();
        if (sector.port == null) {
            sector.port = new Port(sector);
            info.addPort(sector.port);
        }
        if (comval == 0) {
            sector.port.state[YylexHelper.comprod][YylexHelper.comval] = yylex.readNumber();
        } else if (comval == 1) {
            sector.port.state[YylexHelper.comprod][YylexHelper.comval] = yylex.readNumber();
            sector.port.state[YylexHelper.comprod][2] = (int)((double)sector.port.state[comprod][0] / ((double)sector.port.state[comprod][1] / 100.0));
        } else {
            YylexHelper.info.ti.setHoldContents(comprod, yylex.readNumber());
        }
        if (++comval > 2) {
            comval = 0;
            ++comprod;
        }
        if (comprod > 2) {
            comprod = 0;
            comval = 0;
            yylex.yybegin(0);
        }
    }

    public static void handleStealingReport() {
        int n = yylex.readNumber();
        Port port = YylexHelper.info.getCS().port;
        if (comval == 0) {
            port.state[YylexHelper.comprod][0] = n;
        } else if (comval == 1) {
            port.state[YylexHelper.comprod][3] = n;
        } else {
            YylexHelper.info.ti.setHoldContents(comprod, n);
        }
        if (++comval > 2) {
            comval = 0;
            ++comprod;
        }
        if (comprod > 2) {
            comprod = 0;
            comval = 0;
            yylex.yybegin(0);
        }
    }

    public static void resetPlayersPresent() {
        info.clearPlayersPresent();
        info.clearShipsPresent();
        info.clearFedsPresent();
        info.clearAliensPresent();
    }

    static void setMode(String string) {
        if (string.substring(8, 9).indexOf(":") != -1) {
            String string2 = string.substring(0, 8);
            string2.trim();
            Vector vector = (Vector)info.getAliens();
            if (string2.indexOf("Traders") != -1) {
                traderMode = 0;
                return;
            }
            if (string2.indexOf("Federals") != -1) {
                traderMode = 2;
                return;
            }
            if (string2.indexOf("Ferrengi") != -1) {
                traderMode = 1;
                return;
            }
            if (string2.indexOf("Aliens") != -1) {
                traderMode = 1;
                return;
            }
            int n = 0;
            while (n < vector.size()) {
                if (((String)vector.elementAt(n)).indexOf(string2) != -1) {
                    traderMode = 1;
                    return;
                }
                ++n;
            }
        }
    }

    static void addTraderPresent(Vector vector) {
        switch (traderMode) {
            case 0: {
                info.addPlayerPresent(vector);
                return;
            }
            case 1: {
                info.addAlienPresent(vector);
                return;
            }
            case 2: {
                info.addFedPresent(vector);
                return;
            }
        }
        info.addAlienPresent(vector);
    }

    public static void handleDisplayTraders(String string) {
        YylexHelper.setMode(string);
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < Yylex.ranks.size()) {
            if (string.indexOf((String)Yylex.ranks.elementAt(n2)) != -1) {
                bl = true;
                n = string.indexOf((String)Yylex.ranks.elementAt(n2)) + ((String)Yylex.ranks.elementAt(n2)).length();
            }
            ++n2;
        }
        if (bl) {
            int n3;
            emptyShip = false;
            int n4 = string.indexOf(", w/");
            String string2 = string.substring(n + 1, n4);
            boolean bl2 = false;
            int n5 = 0;
            String string3 = string2;
            if (string3.substring(string3.length() - 1).equals("]")) {
                int n6 = 0;
                n3 = 0;
                while (string2.indexOf("[", n3) != -1) {
                    n6 = string2.indexOf("[", n3);
                    n3 = string2.indexOf("[", n3) + 1;
                }
                int n7 = string2.length() - 1;
                n5 = Integer.parseInt(string2.substring(n6 + 1, n7));
                String string4 = string2.substring(0, n6 - 1);
                String string5 = string2.substring(n7 + 1);
                string2 = string4 + string5;
                bl2 = true;
            }
            int[] cfr_ignored_0 = new int[2];
            n3 = string.indexOf(" ftrs");
            n3 = Yylex.readNumber(string.substring(n4 + 5, n3), 0)[1];
            tempTrader = new Vector();
            tempTrader.add(string2);
            tempTrader.add(new Integer(n3));
            tempTrader.add("dummy spot");
            if (bl2) {
                tempTrader.add(new Integer(n5));
                return;
            }
        } else if (string.indexOf("[Owned by]") != -1) {
            int n8;
            emptyShip = true;
            int n9 = string.indexOf("[Owned by]");
            String string6 = string.substring(10, n9 - 1);
            String string7 = string.substring(n9 + 11);
            n = string7.indexOf(", w/");
            String string8 = string7.substring(0, n);
            int n10 = 0;
            boolean bl3 = false;
            String string9 = string8;
            if (string9.substring(string9.length() - 1).equals("]")) {
                int n11 = 0;
                n8 = 0;
                while (string8.indexOf("[", n8) != -1) {
                    n11 = string8.indexOf("[", n8);
                    n8 = string8.indexOf("[", n8) + 1;
                }
                int n12 = string8.length() - 1;
                n10 = Integer.parseInt(string8.substring(n11 + 1, n12));
                String string10 = string8.substring(0, n11 - 1);
                String string11 = string8.substring(n12 + 1);
                string8 = string10 + string11;
                bl3 = true;
            }
            int[] cfr_ignored_1 = new int[2];
            n8 = string7.indexOf(" ftrs");
            n8 = Yylex.readNumber(string7.substring(n + 5, n8), 0)[1];
            tempTrader = new Vector();
            tempTrader.add(string8);
            tempTrader.add(new Integer(n8));
            tempTrader.add("dummy spot");
            tempTrader.add(string6);
            if (bl3) {
                tempTrader.add(new Integer(n10));
            }
        }
    }

    public static void handleTraderShipType(String string) {
        Vector vector = (Vector)info.getAllShipTypes();
        int n = 0;
        while (n < vector.size()) {
            ShipType shipType = (ShipType)vector.elementAt(n);
            if (string.indexOf(shipType.className) != -1) {
                tempTrader.remove(2);
                tempTrader.add(2, shipType);
                if (!emptyShip) {
                    YylexHelper.addTraderPresent(tempTrader);
                } else {
                    info.addShipPresent(tempTrader);
                }
            }
            ++n;
        }
    }

    public static void densityScanB(int n) {
        if (info.getSector(YylexHelper.info.ti.getTempSectorValue()) != null) {
            info.getSector(YylexHelper.info.ti.getTempSectorValue()).setDensityScan(n);
            return;
        }
        Sector sector = new Sector(YylexHelper.info.ti.getTempSectorValue());
        info.addSector(sector);
    }

    public static void portdef(String string) {
        Sector sector = info.getCS();
        if (string.indexOf("<=-DANGER-=>") > -1) {
            if (sector.port != null) {
                info.removePort(sector.number);
                sector.port = null;
                return;
            }
        } else {
            int n = string.lastIndexOf(44);
            sector.port.name = string.substring(0, n);
            int[] nArray = Yylex.readNumber(string.substring(n + 1), 0);
            YylexHelper.info.getCS().port.setType(nArray[1]);
        }
    }

    public static void shipNameState(String string, String string2) {
        ShipType shipType;
        String string3 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        String string4 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + " " + stringTokenizer.nextToken();
        }
        int n = info.getShipTypeNumber(string4);
        if (n != -1 && (shipType = info.getShipType(n)) != null) {
            shipType.catalog = string2;
            info.upDateShip(shipType);
        }
    }

    public static void ShipScan(int[] nArray, String string) {
        Ship ship = new Ship();
        new Ship().number = nArray[1];
        nArray = Yylex.readNumber(string, nArray[0]);
        ship.sector = info.getSector(nArray[1]);
        if (ship.sector == null) {
            ship.sector = new Sector(nArray[1]);
            info.addSector(ship.sector);
        }
        int n = nArray[0] + 1;
        int n2 = n + 15;
        ship.name = string.substring(n, n2);
        ship.corporate = string.indexOf("Corp", n2) > -1;
        nArray = Yylex.readNumber(string, n2);
        ship.fighters = nArray[1];
        if (string.charAt(nArray[0]) == 'T') {
            ship.fighters *= 1000;
        }
        nArray = Yylex.readNumber(string, nArray[0]);
        ship.shields = nArray[1];
        if (string.charAt(nArray[0]) == 'T') {
            ship.shields *= 1000;
        }
        nArray = Yylex.readNumber(string, nArray[0]);
        ship.hops = nArray[1];
        String string2 = string.substring(55);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        while (stringTokenizer.hasMoreTokens()) {
            string3 = string3 + " " + stringTokenizer.nextToken();
        }
        ship.shiptype = info.getShipTypeNumber(string3);
        info.addShip(ship);
    }

    static {
        traderMode = 0;
        comval = 0;
        comprod = 0;
    }
}

