/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.Sector;
import TWHelp.TWEventListener;
import TWHelp.TWHelper;
import TWHelp.TWObject;
import TWHelp.TWSession;
import TWHelp.Yylex;
import TWHelp.Yytoken;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TraderInfo
extends TWObject
implements TWEventListener {
    public static int FUEL = 0;
    public static int ORGANICS = 1;
    public static int EQUIPMENT = 2;
    public static int COLONISTS = 3;
    public static int EMPTY = 4;
    public static int DENSITY = 1;
    public static int HOLO = 2;
    public static final String CLEAR_BUST = "CLEAR_BUST";
    public static final String REQUEST_BUST = "REQUEST_BUST";
    private TWHelper f1;
    public String name = new String();
    private int f2 = 0;
    public int rank = 0;
    private int f3 = 0;
    private int f4 = 0;
    private int f5 = 0;
    private int f6 = 0;
    private int f7 = 0;
    private int f8 = 0;
    private int f9 = 0;
    private int[] f10 = new int[5];
    private int f11 = 0;
    private int f12 = 0;
    private boolean f13 = false;
    private int f14 = 0;
    private int f15 = -1;
    private boolean f16 = false;
    Hashtable deployedFtrs = new Hashtable();
    private int f17 = 0;
    public int shiptype = -1;
    private int f18 = -1;
    public Hashtable busts = new Hashtable();

    TraderInfo() {
    }

    public void init() {
        this.f1 = TWSession.getCurrentSession().getHelper();
        this.f1.addTWEventListener(this);
    }

    public static boolean isSingular() {
        return true;
    }

    public static String getName() {
        return "";
    }

    public synchronized Object getPersistantInfo() {
        Vector<Serializable> vector = new Vector<Serializable>();
        vector.addElement(this.busts);
        vector.addElement(new Integer(this.getLastSteal()));
        return vector;
    }

    public synchronized void setPersistantInfo(Object object) {
        Vector vector = (Vector)object;
        this.busts = (Hashtable)vector.elementAt(0);
        this.setLastSteal((Integer)vector.elementAt(1));
    }

    public void setExperience(int n) {
        this.f2 = n;
        this.updateStatus();
    }

    public int getExperience() {
        return this.f2;
    }

    public void setAlignment(int n) {
        this.f3 = n;
        this.updateStatus();
    }

    public int getAlignment() {
        return this.f3;
    }

    public void setCredits(int n) {
        this.f4 = n;
        this.updateStatus();
    }

    public int getCredits() {
        return this.f4;
    }

    public void setTurns(int n) {
        this.f5 = n;
        this.updateStatus();
    }

    public int getTurns() {
        return this.f5;
    }

    public void setHolds(int n) {
        this.f6 = n;
        this.updateStatus();
    }

    public int getHolds() {
        return this.f6;
    }

    public void setScanners(int n) {
        this.f7 = n;
    }

    public int getScanners() {
        return this.f7;
    }

    public void setPhotons(int n) {
        this.f8 = n;
    }

    public int getPhotons() {
        return this.f8;
    }

    public void setCurrentShip(int n) {
        this.f9 = n;
    }

    public int getCurrentShip() {
        return this.f9;
    }

    public void setHoldContents(int n, int n2) {
        this.f10[n] = n2;
        if (n != EMPTY) {
            this.f10[TraderInfo.EMPTY] = this.f6 - (this.f10[FUEL] + this.f10[ORGANICS] + this.f10[EQUIPMENT] + this.f10[COLONISTS]);
        }
        this.updateStatus();
    }

    public int getHoldContents(int n) {
        return this.f10[n];
    }

    public void clearHolds() {
        this.f10[TraderInfo.FUEL] = 0;
        this.f10[TraderInfo.ORGANICS] = 0;
        this.f10[TraderInfo.EQUIPMENT] = 0;
        this.f10[TraderInfo.COLONISTS] = 0;
        this.f10[TraderInfo.EMPTY] = this.f6;
    }

    public void setFighters(int n) {
        this.f11 = n;
        this.updateStatus();
    }

    public int getFighters() {
        return this.f11;
    }

    public void setShields(int n) {
        this.f12 = n;
        this.updateStatus();
    }

    public int getShields() {
        return this.f12;
    }

    public void setOnCorp(boolean bl) {
        this.f13 = bl;
        this.updateStatus();
    }

    public boolean getOnCorp() {
        return this.f13;
    }

    public void setCorpNum(int n) {
        this.f14 = n;
    }

    public int getCorpNum() {
        return this.f14;
    }

    public void setShieldsScan(int n) {
        this.f15 = n;
    }

    public int getShieldsScan() {
        return this.f15;
    }

    public void setHasPlanetScanners(boolean bl) {
        this.f16 = bl;
        this.updateStatus();
    }

    public boolean getHasPlanetScanners() {
        return this.f16;
    }

    public void deleteDeployedFtrs() {
        this.deployedFtrs = new Hashtable();
    }

    public Object getAllDeployedFtrs() {
        return this.deployedFtrs.clone();
    }

    public void addDeployedFtr(int n) {
        this.deployedFtrs.put(new Integer(n), new Integer(n));
    }

    public boolean isDeployedFtr(int n) {
        return (Integer)this.deployedFtrs.get(new Integer(n)) != null;
    }

    public void setTempSectorValue(int n) {
        this.f17 = n;
    }

    public int getTempSectorValue() {
        return this.f17;
    }

    public int getShipType() {
        return this.shiptype;
    }

    public void setShipType(int n) {
        this.shiptype = n;
    }

    public void updateStatus() {
        this.f1.updateStatus();
    }

    public boolean isLastSteal(Sector sector) {
        if (sector == null) {
            return false;
        }
        return this.f18 == sector.number;
    }

    public int getLastSteal() {
        return this.f18;
    }

    public void setLastSteal(int n) {
        this.f18 = n;
    }

    public boolean isBusted(Sector sector) {
        if (sector == null) {
            return false;
        }
        return this.isBusted(sector.number);
    }

    public boolean isBusted(int n) {
        return this.busts.containsKey(new Integer(n));
    }

    public void addBust(int n) {
        this.addBust(n, true);
    }

    public void addBust(int n, boolean bl) {
        this.busts.put(new Integer(n), this.f1.info.getTime());
        if (bl) {
            this.f1.writeStaticInfo();
        }
    }

    public void addBust(int n, Date date, boolean bl) {
        this.busts.put(new Integer(n), date);
        if (bl) {
            this.f1.writeStaticInfo();
        }
    }

    public void clearBust(int n) {
        Integer n2 = new Integer(n);
        if (this.busts.get(n2) != null) {
            this.busts.remove(n2);
        }
    }

    public void clearBust(int n, Date date) {
        Integer n2 = new Integer(n);
        Date date2 = (Date)this.busts.get(n2);
        if (date2 != null && date2.before(date)) {
            this.busts.remove(n2);
        }
    }

    public void importBusts(String string) {
        this.busts.clear();
        if (string != null && string.length() > 0) {
            if (string.charAt(0) != 'T') {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",\n\r", false);
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = (String)stringTokenizer.nextElement();
                    this.addBust(new Integer(string2), false);
                }
                return;
            }
            string = string.substring(1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|,\n\r", false);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                String string4 = (String)stringTokenizer.nextElement();
                this.addBust(new Integer(string3), new Date(new Long(string4)), false);
            }
        }
    }

    public String exportBusts() {
        StringBuffer stringBuffer = new StringBuffer("T");
        Enumeration enumeration = this.busts.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            stringBuffer.append(n.toString() + "|" + new Long(((Date)this.busts.get(n)).getTime()).toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
        }
        return new String(stringBuffer);
    }

    public void processStatus(String string) {
        this.f13 = false;
        this.f7 = 0;
        this.f8 = 0;
        this.f16 = false;
        int[] nArray = Yylex.readNumber(string, 0);
        this.f5 = nArray[1];
        nArray = Yylex.readNumber(string, nArray[0]);
        this.f4 = nArray[1];
        nArray = Yylex.readNumber(string, nArray[0]);
        this.f11 = nArray[1];
        nArray = Yylex.readNumber(string, nArray[0]);
        this.f12 = nArray[1];
        nArray = Yylex.readNumber(string, nArray[0]);
        this.f6 = nArray[1];
        nArray = Yylex.readNumber(string, nArray[0]);
        this.f10[0] = nArray[1];
        nArray = Yylex.readNumber(string, nArray[0]);
        this.f10[1] = nArray[1];
        nArray = Yylex.readNumber(string, nArray[0]);
        this.f10[2] = nArray[1];
        nArray = Yylex.readNumber(string, nArray[0]);
        this.f10[3] = nArray[1];
        this.f10[TraderInfo.EMPTY] = this.f6 - (this.f10[FUEL] + this.f10[ORGANICS] + this.f10[EQUIPMENT] + this.f10[COLONISTS]);
        if (string.indexOf("Phot") > -1) {
            String string2 = string;
            nArray = Yylex.readNumber(string2, string2.indexOf("Phot"));
            this.f8 = nArray[1];
        } else {
            this.f8 = 0;
        }
        if (string.indexOf("PlScn Yes") != -1) {
            this.f16 = true;
        }
        if (string.indexOf("LRS Holo") != -1) {
            this.f7 = 2;
        } else if (string.indexOf("LRS Dens") != -1) {
            this.f7 = 1;
        }
        String string3 = string;
        nArray = Yylex.readNumber(string3, string3.indexOf("Aln"));
        this.f3 = nArray[1];
        nArray = Yylex.readNumber(string, nArray[0]);
        this.f2 = nArray[1];
        if (string.indexOf("Corp") != -1) {
            this.f13 = true;
            String string4 = string;
            nArray = Yylex.readNumber(string4, string4.indexOf("Corp"));
            this.f14 = nArray[1];
        }
        String string5 = string;
        nArray = Yylex.readNumber(string5, string5.indexOf("Ship"));
        this.f9 = nArray[1];
        this.f1.updateStatus();
    }

    public String toString() {
        String string = " Exp: " + Integer.toString(this.f2) + " Align: " + Integer.toString(this.f3);
        string = string + " Turns: " + Integer.toString(this.f5) + " Credits: " + Integer.toString(this.f4) + " Fighters: " + Integer.toString(this.f11) + " Shields: " + Integer.toString(this.f12);
        string = string + "\nHolds: " + Integer.toString(this.f6) + " - Fuel: " + this.f10[FUEL] + " 0rganics: " + this.f10[ORGANICS] + " Equipment: " + this.f10[EQUIPMENT] + " Colonists: " + this.f10[COLONISTS] + " Empty: " + this.f10[EMPTY];
        if (this.getLastSteal() != -1) {
            string = string + "\nLast Steal: ";
            TraderInfo traderInfo = this;
            string = traderInfo.isLastSteal(traderInfo.f1.info.getCS()) ? string + " (LAST STEAL HERE)" : string + Integer.toString(this.getLastSteal());
        }
        TraderInfo traderInfo = this;
        if (traderInfo.isBusted(traderInfo.f1.info.getCS())) {
            string = string + " (BUSTED HERE)";
        }
        return string;
    }

    public void handleTWEvent(Yytoken yytoken) {
        if (yytoken.id == Yytoken.RADIO_COMMAND) {
            String string = (String)yytoken.args.elementAt(0);
            if (string.equals(CLEAR_BUST)) {
                String string2 = (String)yytoken.args.elementAt(1);
                int n = string2.indexOf("|");
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                int n2 = Integer.parseInt(string3);
                Date date = new Date(Long.parseLong(string4));
                this.clearBust(n2, date);
                return;
            }
            if (string.equals(REQUEST_BUST)) {
                this.shareBusts();
            }
        }
    }

    public void shareBusts() {
        Enumeration enumeration = this.busts.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            long l = ((Date)this.busts.get(n)).getTime();
            String string = n.toString() + "|" + Long.toString(l);
            this.f1.sendRadioCommand(CLEAR_BUST, string);
        }
    }

    public void shareBust(int n, long l) {
        String string = Integer.toString(n) + "|" + Long.toString(l);
        this.f1.sendRadioCommand(CLEAR_BUST, string);
    }

    public void shareBustsMemo() {
        Enumeration enumeration = this.busts.keys();
        this.f1.writeResponse("TT");
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            long l = ((Date)this.busts.get(n)).getTime();
            String string = n.toString() + "|" + Long.toString(l);
            this.f1.writeResponse("J-TWAT COMMAND :: " + CLEAR_BUST + " :: " + string + "\n");
        }
        this.f1.writeResponse("\n");
    }

    public void requestBusts() {
        this.f1.sendRadioCommand(REQUEST_BUST, "");
    }
}

