/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.TWAnalysis;
import TWHelp.TWClient;
import TWHelp.TWHelper;
import TWHelp.TWInfo;
import TWHelp.TWMacro;
import TWHelp.TWMap;
import TWHelp.TWObject;
import TWHelp.TWOptionManager;
import TWHelp.TWScript;
import TWHelp.TWStorageModule;
import TWHelp.TraderInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TWSession {
    private static TWSession f1;
    TWClient client;
    TWHelper helper;
    static TWInfo info;
    TraderInfo ti;
    TWMacro macros;
    TWOptionManager options;
    TWMap map;
    Hashtable scripts;
    Hashtable scriptArguments;
    Hashtable analysis;
    Hashtable modules;
    Hashtable allObjects = new Hashtable();
    Hashtable currentObjects;
    Hashtable persistantObjects;

    public static TWSession getCurrentSession() {
        if (f1 == null) {
            f1 = new TWSession();
        }
        return f1;
    }

    public Object getPersistantInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<Hashtable> vector = new Vector<Hashtable>();
        Enumeration enumeration = this.allObjects.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (!this.isSingular(string) || this.getCurrentObject(string) == null || (object = this.getCurrentObject(string).getPersistantInfo()) == null) continue;
            hashtable.put(string, object);
        }
        vector.addElement(hashtable);
        vector.addElement(this.scriptArguments);
        return vector;
    }

    public Object getPersistantInfoNoSectors() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<Hashtable> vector = new Vector<Hashtable>();
        Enumeration enumeration = this.allObjects.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (!this.isSingular(string) || this.getCurrentObject(string) == null || string.equals("TWHelp.TWInfo") || (object = this.getCurrentObject(string).getPersistantInfo()) == null) continue;
            hashtable.put(string, object);
        }
        vector.addElement(hashtable);
        vector.addElement(this.scriptArguments);
        return vector;
    }

    public void setPersistantInfo(Object object) {
        Vector vector = (Vector)object;
        Hashtable hashtable = (Hashtable)vector.elementAt(0);
        this.scriptArguments = (Hashtable)vector.elementAt(1);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.isSingular(string) || this.getCurrentObject(string) == null) continue;
            this.persistantObjects.put(string, hashtable.get(string));
            this.getCurrentObject(string).setPersistantInfo(this.persistantObjects.get(string));
        }
    }

    protected TWSession() {
        try {
            this.allObjects.put("TWHelp.TWHelper", Class.forName("TWHelp.TWHelper"));
            this.allObjects.put("TWHelp.TWInfo", Class.forName("TWHelp.TWInfo"));
            this.allObjects.put("TWHelp.TraderInfo", Class.forName("TWHelp.TraderInfo"));
            this.allObjects.put("TWHelp.TWMacro", Class.forName("TWHelp.TWMacro"));
            this.allObjects.put("TWHelp.TWOptionManager", Class.forName("TWHelp.TWOptionManager"));
            this.allObjects.put("TWHelp.TWMap", Class.forName("TWHelp.TWMap"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Core classes not found.  We're done...");
            System.exit(1);
        }
        this.resetSession();
    }

    public void init() {
        this.helper.init();
        info.init();
        this.ti.init();
        new Thread(this.helper).start();
    }

    public void resetSession() {
        if (this.helper != null) {
            this.helper.shutdown();
        }
        this.scriptArguments = new Hashtable();
        this.currentObjects = new Hashtable();
        this.persistantObjects = new Hashtable();
        this.helper = (TWHelper)this.getNewObject("TWHelp.TWHelper");
        info = (TWInfo)this.getNewObject("TWHelp.TWInfo");
        this.ti = (TraderInfo)this.getNewObject("TWHelp.TraderInfo");
        this.macros = (TWMacro)this.getNewObject("TWHelp.TWMacro");
        this.options = (TWOptionManager)this.getNewObject("TWHelp.TWOptionManager");
        this.map = (TWMap)this.getNewObject("TWHelp.TWMap");
    }

    public void setClient(TWClient tWClient) {
        this.client = tWClient;
    }

    public TWClient getClient() {
        return this.client;
    }

    public TWHelper getHelper() {
        return this.helper;
    }

    public static TWInfo getInfo() {
        return info;
    }

    public TraderInfo getTraderInfo() {
        return this.ti;
    }

    public TWMacro getMacroManager() {
        return this.macros;
    }

    public TWOptionManager getOptionManager() {
        return this.options;
    }

    public TWMap getMap() {
        return this.map;
    }

    public String addObject(String string) {
        String string2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            this.allObjects.put(string, clazz);
            string2 = (String)clazz.getMethod("getName", null).invoke(null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public String addScript(String string) {
        String string2 = this.addObject(string);
        if (string2 != null) {
            this.getNewScript(string).setDefaultArguments();
        }
        return string2;
    }

    public String addAnalysis(String string) {
        return this.addObject(string);
    }

    public String addModule(String string) {
        return this.addObject(string);
    }

    public boolean isSingular(String string) {
        boolean bl = false;
        try {
            bl = (Boolean)((Class)this.allObjects.get(string)).getMethod("isSingular", null).invoke(null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public TWObject getNewObject(String string) {
        TWObject tWObject;
        try {
            Class clazz = (Class)this.allObjects.get(string);
            boolean bl = (Boolean)clazz.getMethod("isSingular", null).invoke(null, null);
            if (!(bl && (tWObject = this.getCurrentObject(string)) != null || (tWObject = (TWObject)clazz.newInstance()) == null)) {
                Object v;
                this.currentObjects.put(string, tWObject);
                if (bl && (v = this.persistantObjects.get(string)) != null) {
                    tWObject.setPersistantInfo(v);
                }
            }
        }
        catch (Exception exception) {
            tWObject = null;
            exception.printStackTrace();
        }
        return tWObject;
    }

    public TWObject getCurrentObject(String string) {
        return (TWObject)this.currentObjects.get(string);
    }

    public TWScript getNewScript(String string) {
        TWScript tWScript = (TWScript)this.getNewObject(string);
        if (tWScript != null) {
            Hashtable hashtable = (Hashtable)this.scriptArguments.get(string);
            if (hashtable == null) {
                hashtable = new Hashtable();
                this.scriptArguments.put(string, hashtable);
            }
            tWScript.setAllArguments(hashtable);
        }
        return tWScript;
    }

    public TWAnalysis getNewAnalysis(String string) {
        return (TWAnalysis)this.getNewObject(string);
    }

    public TWStorageModule getNewStorageModule(String string) {
        return (TWStorageModule)this.getNewObject(string);
    }

    public TWScript getCurrentScript(String string) {
        return (TWScript)this.getCurrentObject(string);
    }

    public TWAnalysis getCurrentAnalysis(String string) {
        return (TWAnalysis)this.getCurrentObject(string);
    }

    public TWStorageModule getCurrentStorageModule(String string) {
        return (TWStorageModule)this.getCurrentObject(string);
    }

    public String getScriptCategory(String string) {
        String string2 = null;
        Class clazz = (Class)this.allObjects.get(string);
        if (clazz != null) {
            try {
                string2 = (String)clazz.getMethod("getCategory", null).invoke(null, null);
            }
            catch (Exception exception) {
                System.out.println("Error getting script category.");
                System.out.println(exception);
            }
        }
        return string2;
    }
}

