/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.TWInfo;
import TWHelp.TWObject;
import TWHelp.TWOption;
import TWHelp.TWSession;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TWOptionManager
extends TWObject {
    Hashtable options = new Hashtable();

    public static boolean isSingular() {
        return true;
    }

    public static String getName() {
        return "TWOptionManager";
    }

    public Object getPersistantInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Enumeration enumeration = this.getAllOptions();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, this.getOptionValue(string));
        }
        return hashtable;
    }

    public void setPersistantInfo(Object object) {
        Hashtable hashtable = (Hashtable)object;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setOptionValue(string, hashtable.get(string));
        }
    }

    public TWOptionManager() {
        TWInfo tWInfo = TWSession.getInfo();
        try {
            TWInfo tWInfo2 = tWInfo;
            this.addOption(new TWOption("STARDOCK", "Stardock Location", "The sector number where stardock is located", TWOption.SINGLE, null, "", tWInfo2, tWInfo2.getClass().getField("stardock"), TWOption.INTVAL));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        this.addOption(new TWOption("STEAL_FACTOR", "Stealing Factor", "Exp. divided by this = # of holds to steal", TWOption.SINGLE, null, "30"));
        this.addOption(new TWOption("ROB_FACTOR", "Robbing Factor", "Exp. multiplied by this = # of credits to steal", TWOption.SINGLE, null, "7"));
        String[] stringArray = new String[]{"Proceed", "Go around", "Stop", "Prompt"};
        this.addOption(new TWOption("SECTOR_HANDLING", "Adverse Sector Handling", "How to behave when an adverse sector (mines, figs, etc) is encountered in a script", TWOption.CHOICE, stringArray, "Go around"));
        this.addOption(new TWOption("FRIENDLIES", "Friendly List", "The players on this list will not be attacked during offensive scripts", TWOption.LIST, null, new Vector()));
        this.addOption(new TWOption("REFURB", "Refurb Ship Type", "Type of ship the auto refurb scripts will search for when attacking", TWOption.SINGLE, null, "Merchant Freighter"));
        this.addOption(new TWOption("KEEPALIVE", "Keep Alive Option", "Send a '#' whenever timeout warnings occur", TWOption.BOOLEAN, null, new Boolean(true)));
        this.addOption(new TWOption("TRADE_FACTOR", "Trading Percentage", "This percentage is used to calculate the starting haggle price.  Closer to 100% means a safer haggle.", TWOption.SINGLE, null, "0.94"));
        try {
            TWInfo tWInfo3 = tWInfo;
            this.addOption(new TWOption("TURN_MINIMUM", "Turn Checker", "Scripts will not run if turns go below this value. (Set to 0 to turn this feature off)", TWOption.SINGLE, null, "50", tWInfo3, tWInfo3.getClass().getField("turnlimit"), TWOption.INTVAL));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        this.setAllDefault();
    }

    public void addOption(TWOption tWOption) {
        this.options.put(tWOption.key, tWOption);
    }

    public Object getOptionValue(String string) {
        Object object = null;
        TWOption tWOption = (TWOption)this.options.get(string);
        if (tWOption != null) {
            object = tWOption.getValue();
        }
        return object;
    }

    public void setOptionValue(String string, Object object) {
        TWOption tWOption = (TWOption)this.options.get(string);
        if (tWOption != null) {
            tWOption.setValue(object);
        }
    }

    public TWOption getOption(String string) {
        return (TWOption)this.options.get(string);
    }

    public void setDefaultValue(String string) {
        TWOption tWOption = (TWOption)this.options.get(string);
        if (tWOption != null) {
            TWOption tWOption2 = tWOption;
            tWOption2.setValue(tWOption2.getDefaultValue());
        }
    }

    public void setAllDefault() {
        Enumeration enumeration = this.options.keys();
        while (enumeration.hasMoreElements()) {
            this.setDefaultValue((String)enumeration.nextElement());
        }
    }

    public Enumeration getAllOptions() {
        return this.options.keys();
    }
}

