/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import EDU.auburn.VGJ.VGJ;
import EDU.auburn.VGJ.graph.TWGraph;
import EDU.auburn.VGJ.gui.GraphWindow;
import TWHelp.NewBubble;
import TWHelp.Sector;
import TWHelp.TWObject;
import TWHelp.TWSession;
import java.awt.Frame;

public class TWMap
extends TWObject {
    GraphWindow gw;
    TWGraph graph;

    public static boolean isSingular() {
        return true;
    }

    public static String getName() {
        return "";
    }

    void init() {
        TWSession.getCurrentSession();
        this.gw = VGJ.buildWindow(TWSession.getInfo());
        this.graph = (TWGraph)this.gw.getGraph();
    }

    public void showWindow() {
        if (this.gw == null) {
            this.init();
        }
        this.gw.show();
        this.gw.TWUpdate();
        this.update();
    }

    public void hideWindow() {
        if (this.gw == null) {
            this.init();
        }
        this.gw.hide();
    }

    public void flipWindow() {
        if (this.gw == null) {
            this.init();
        }
        if (this.gw.isShowing()) {
            this.hideWindow();
            return;
        }
        this.showWindow();
    }

    public Frame getWindow() {
        if (this.gw == null) {
            this.init();
        }
        return this.gw;
    }

    public void update() {
        if (this.graph == null) {
            this.init();
        }
        if (this.gw.isShowing()) {
            this.graph.updateNodes();
            this.gw.TWUpdate();
        }
    }

    public void mapSector(Sector sector, int n) {
        if (this.graph == null) {
            this.init();
        }
        this.graph.rebuildGraph(sector, n);
        this.gw.TWUpdate();
    }

    public void mapBubble(NewBubble newBubble) {
        if (this.graph == null) {
            this.init();
        }
        this.graph.rebuildGraphFromBubble(newBubble.door, newBubble.sectors);
        this.gw.TWUpdate();
    }

    public void mapCurrentSector(int n) {
        TWSession.getCurrentSession();
        Sector sector = TWSession.getInfo().getCS();
        if (sector != null) {
            this.mapSector(sector, n);
        }
    }
}

