/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.Sector;
import TWHelp.SectorLookupDialog;
import TWHelp.TWAnalysis;
import TWHelp.TWSession;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Enumeration;
import java.util.Vector;

public class SectorAnalysis
extends TWAnalysis
implements ActionListener,
ItemListener,
TextListener {
    protected static TWAnalysis theInstance = null;
    Sector theSector = null;
    Vector result;
    List sectorNumber;
    TextArea sectorData;
    TextArea sectorNote;
    Button getSector;
    Button mapSector;

    public static String getName() {
        return "Sector Journal";
    }

    public static boolean isSingular() {
        return true;
    }

    public static TWAnalysis getInstance() {
        if (theInstance == null) {
            theInstance = new SectorAnalysis();
        }
        return theInstance;
    }

    protected SectorAnalysis() {
    }

    public Vector getResult() {
        return this.result;
    }

    public void setResult(Vector vector) {
        this.result = vector;
    }

    public void executeAnalysis() {
        Enumeration enumeration = this.info.getAllSectors();
        Vector<Sector> vector = new Vector<Sector>();
        while (enumeration.hasMoreElements()) {
            vector.add((Sector)enumeration.nextElement());
        }
        this.setResult(vector);
    }

    public Component getResultDisplay() {
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        this.sectorData = new TextArea();
        this.sectorData.setEditable(false);
        this.sectorNote = new TextArea();
        this.sectorNote.addTextListener(this);
        panel2.add((Component)this.sectorData, "Center");
        panel2.add((Component)this.sectorNote, "South");
        panel.add((Component)panel2, "Center");
        this.sectorNumber = new List();
        this.sectorNumber.addItemListener(this);
        this.m1();
        panel.add((Component)this.sectorNumber, "West");
        Panel panel3 = new Panel(new FlowLayout(0));
        this.getSector = new Button("Lookup Sector");
        this.getSector.addActionListener(this);
        panel3.add(this.getSector);
        this.mapSector = new Button("Map this Sector");
        this.mapSector.addActionListener(this);
        panel3.add(this.mapSector);
        panel.add((Component)panel3, "South");
        return panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getSector) {
            int n = new SectorLookupDialog(this.helper.getFrame()).doDialog();
            if (n != -1) {
                this.m2(n);
                return;
            }
        } else if (actionEvent.getSource() == this.mapSector && this.theSector != null) {
            TWSession.getCurrentSession().getMap().mapSector(this.theSector, 4);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.sectorNumber) {
            String string = this.sectorNumber.getSelectedItem();
            Integer n = new Integer(string);
            this.m2(n);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.theSector != null) {
            this.theSector.setNote(this.sectorNote.getText());
        }
    }

    private void m1() {
        if (this.sectorNumber != null) {
            this.sectorNumber.removeAll();
            Enumeration enumeration = this.getResult().elements();
            while (enumeration.hasMoreElements()) {
                Sector sector = (Sector)enumeration.nextElement();
                this.sectorNumber.addItem(new Integer(sector.number).toString());
            }
        }
    }

    private void m2(int n) {
        Sector sector = this.info.getSector(n);
        if (sector != null) {
            this.theSector = sector;
        }
        this.sectorData.setText("");
        String string = "Sector  : " + this.theSector.number + this.theSector.getArea();
        string = this.theSector.getVisited() ? string + " (Explored)\n" : string + " (Unexplored)\n";
        if (this.theSector.port != null) {
            string = string + " Ports   : ";
            if (this.theSector.port.name != null && this.theSector.port.name.length() > 0) {
                string = string + this.theSector.port.name + " ";
            }
            string = string + "(" + this.theSector.port.getTypeString() + ")\n";
        }
        string = string + "Warps to Sector(s) : ";
        Vector vector = this.theSector.getWarps(this.info);
        int n2 = 0;
        while (n2 < vector.size()) {
            Sector sector2 = (Sector)vector.elementAt(n2);
            string = sector2.getVisited() ? string + Integer.toString(sector2.number) : string + "(" + Integer.toString(sector2.number) + ")";
            if (n2 < vector.size() - 1) {
                string = string + " - ";
            }
            ++n2;
        }
        string = string + "\n";
        this.sectorData.setText(string);
        this.sectorNote.setText(this.theSector.getNote());
    }
}

