/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.Port;
import TWHelp.TWInfo;
import TWHelp.TWSession;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Sector
implements Serializable {
    public static int FIG_TYPE_NONE = 0;
    public static int FIG_TYPE_OFFENSE = 1;
    public static int FIG_TYPE_DEFENSE = 2;
    public static int FIG_TYPE_TOLL = 3;
    public int number;
    boolean visited = false;
    String note = new String();
    public Port port = null;
    String beacon = null;
    Vector warps;
    int navhaz = 0;
    public int warpTrace = -1;
    public boolean inBubble = false;
    public boolean bubbleChecked = false;
    boolean complete = false;
    String area = new String();
    private Vector f1;
    private int f2 = 0;
    private boolean f3 = false;
    private int f4;
    private boolean f5 = false;
    private int f6 = 0;
    private int f7 = FIG_TYPE_NONE;
    private String f8 = "";
    private boolean f9 = false;
    int densityScan = 0;
    String deadendNote = "";

    public boolean checkTrace(int n) {
        TWSession.getCurrentSession();
        TWInfo tWInfo = TWSession.getInfo();
        boolean bl = false;
        if (n == 1) {
            return true;
        }
        Sector sector = this;
        if (this.warpTrace != -1) {
            while (!bl && sector.warpTrace != 1) {
                if (sector.warpTrace == n) {
                    bl = true;
                }
                sector = tWInfo.getSector(sector.warpTrace);
            }
        }
        return bl;
    }

    public Sector() {
        this.warps = new Vector();
    }

    public Sector(int n) {
        this.number = n;
        this.warps = new Vector();
    }

    public void addWarp(Sector sector) {
        this.addWarp(sector.number);
    }

    public void addWarp(int n) {
        block2: {
            Enumeration enumeration = this.warps.elements();
            while (enumeration.hasMoreElements()) {
                if ((Integer)enumeration.nextElement() != n) {
                    continue;
                }
                break block2;
            }
            this.warps.addElement(new Integer(n));
        }
    }

    public boolean equals(Sector sector) {
        return this.number == sector.number;
    }

    public void setVisited(boolean bl) {
        this.visited = bl;
    }

    public boolean getVisited() {
        return this.visited;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
    }

    public boolean getComplete() {
        return this.complete;
    }

    public void setArea(String string) {
        this.area = string;
    }

    public String getArea() {
        return this.area;
    }

    public String toString() {
        String string = "s~" + Integer.toString(this.number) + "~";
        string = string + "v~" + this.visited + "~";
        string = string + "w~" + Integer.toString(this.warps.size()) + "~";
        int n = 0;
        while (n < this.warps.size()) {
            string = string + (Integer)this.warps.elementAt(n) + "~";
            ++n;
        }
        if (this.area != null && this.area.length() > 0) {
            string = string + "a~" + this.area + "~";
        }
        if (this.beacon != null) {
            string = string + "b~" + this.beacon + "~";
        }
        if (this.navhaz > 0) {
            string = string + "n~" + Integer.toString(this.navhaz) + "~";
        }
        if (this.f4 > 0) {
            string = string + "pc~" + Integer.toString(this.f4) + "~";
        }
        if (this.f6 > 0) {
            string = string + "f~" + Integer.toString(this.f6) + "~" + Integer.toString(this.f7) + "~";
        }
        if (this.getNote() != null && this.getNote().length() > 0) {
            string = string + "sn~" + this.getNote() + "~";
        }
        return string + "c~" + new Boolean(this.getComplete()).toString() + "~";
    }

    public static Sector fromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "~", false);
        if (!stringTokenizer.nextToken().equals("s")) {
            return null;
        }
        Sector sector = new Sector(Integer.parseInt(stringTokenizer.nextToken()));
        if (!stringTokenizer.nextToken().equals("v")) {
            return null;
        }
        if (stringTokenizer.nextToken().equalsIgnoreCase("true")) {
            sector.setVisited(true);
        } else {
            sector.setVisited(false);
        }
        if (!stringTokenizer.nextToken().equals("w")) {
            return null;
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = 0;
        while (n2 < n) {
            sector.addWarp(Integer.parseInt(stringTokenizer.nextToken()));
            ++n2;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return sector;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("a")) {
            sector.area = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            } else {
                return sector;
            }
        }
        if (string2.equals("b")) {
            sector.beacon = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            } else {
                return sector;
            }
        }
        if (string2.equals("n")) {
            sector.setNavHaz(Integer.parseInt(stringTokenizer.nextToken()));
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            } else {
                return sector;
            }
        }
        if (string2.equals("pc")) {
            sector.setPlanetCount(Integer.parseInt(stringTokenizer.nextToken()));
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            } else {
                return sector;
            }
        }
        if (string2.equals("f")) {
            sector.setNumFighters(Integer.parseInt(stringTokenizer.nextToken()));
            sector.setFighterType(Integer.parseInt(stringTokenizer.nextToken()));
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            } else {
                return sector;
            }
        }
        if (string2.equals("sn")) {
            sector.setNote(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            } else {
                return sector;
            }
        }
        if (string2.equals("c")) {
            Boolean.valueOf(stringTokenizer.nextToken()).booleanValue();
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            } else {
                return sector;
            }
        }
        return sector;
    }

    public void setNavHaz(int n) {
        this.navhaz = n;
    }

    public int getNavHaz() {
        return this.navhaz;
    }

    public void setFirstPlanetNum(int n) {
        this.f1 = new Vector();
        this.f1.add(new Integer(n));
    }

    public void addPlanetNum(int n) {
        this.f1.add(new Integer(n));
    }

    public int getPlanetNum(int n) {
        return (Integer)this.f1.elementAt(n - 1);
    }

    public int getPlanetNumSize() {
        return this.f1.size();
    }

    public void setHasPlanet(boolean bl) {
        this.f3 = bl;
    }

    public boolean getHasPlanet() {
        return this.f3;
    }

    public void setPlanetCount(int n) {
        this.f4 = n;
    }

    public int getPlanetCount() {
        return this.f4;
    }

    public void setHasAnom(boolean bl) {
        this.f5 = bl;
    }

    public boolean getHasAnom() {
        return this.f5;
    }

    public int getNumFighters() {
        return this.f6;
    }

    public void setNumFighters(int n) {
        this.f6 = n;
    }

    public int getFighterType() {
        return this.f7;
    }

    public void setFighterType(int n) {
        this.f7 = n;
    }

    public void setFighterOwner(String string) {
        this.f9 = string.equals("yours") || string.equals("belong to your Corp");
        this.f8 = string;
    }

    public String getFighterOwner() {
        return this.f8;
    }

    public boolean getFighterFriendly() {
        return this.f9;
    }

    public void setDensityScan(int n) {
        this.densityScan = n;
    }

    public int getDensityScan() {
        return this.densityScan;
    }

    public boolean getSafeDensity() {
        if ((this.densityScan == 0 || this.densityScan == 100) && this.navhaz == 0) {
            return true;
        }
        return this.number > 0 && this.number < 11;
    }

    public Vector getWarps() {
        TWSession.getCurrentSession();
        return this.getWarps(TWSession.getInfo(), true);
    }

    public Vector getWarps(boolean bl) {
        TWSession.getCurrentSession();
        return this.getWarps(TWSession.getInfo(), bl);
    }

    public Vector getWarps(TWInfo tWInfo) {
        return this.getWarps(tWInfo, true);
    }

    public Vector getWarps(TWInfo tWInfo, boolean bl) {
        Vector<Sector> vector = new Vector<Sector>();
        int n = 0;
        while (n < this.warps.size()) {
            Sector sector = tWInfo.getSector((Integer)this.warps.elementAt(n));
            if (bl || !Sector.isOneWayWarp(this, sector)) {
                vector.addElement(sector);
            }
            ++n;
        }
        return vector;
    }

    public void setNote(String string) {
        this.note = string + "\n";
    }

    public void clearNote() {
        this.note = "";
    }

    public void appendNote(String string) {
        this.note = this.note + "\n" + string;
    }

    public String getNote() {
        return new String(this.note);
    }

    public void setDeadendNote(String string) {
        this.deadendNote = string;
    }

    public void appendDeadendNote(String string) {
        this.deadendNote = this.deadendNote + "\n" + string;
    }

    public String getDeadendNote() {
        return new String(this.deadendNote);
    }

    public static boolean isOneWayWarp(Sector sector, Sector sector2) {
        Vector vector = sector2.getWarps();
        boolean bl = true;
        int n = 0;
        while (n < vector.size() && bl) {
            bl = !((Sector)vector.elementAt(n)).equals(sector);
            ++n;
        }
        return bl;
    }

    public boolean isDeadEnd() {
        Vector vector = this.getWarps();
        int n = 0;
        while (n < vector.size()) {
            Sector sector = (Sector)vector.elementAt(n);
            if (Sector.isOneWayWarp(this, sector) && (sector.getVisited() || sector.getComplete())) {
                vector.removeElementAt(n);
                --n;
            }
            ++n;
        }
        return (this.getVisited() || this.getComplete()) && vector.size() == 1;
    }
}

