/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.Sector;
import TWHelp.Ship;
import TWHelp.TWScript;
import TWHelp.TraderInfo;
import TWHelp.Yytoken;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class SSTScript2
extends TWScript
implements ActionListener,
ItemListener {
    Vector ships;
    Vector passwords;
    boolean refurb;
    boolean useRefurbSector;
    int refurbSector;
    boolean useSpecificPort;
    int specificPort;
    boolean useWaitShip;
    int waitShip;
    int waitShipHops;
    int lastShip = 0;
    TextField stf;
    TextField ptf;
    TextField sttf;
    TextField rstf;
    TextField sptf;
    TextField wstf;
    TextField wshtf;
    List shipList;
    Button add;
    Button remove;
    Panel mainp;
    Checkbox refurbcb;
    Checkbox nrscb;
    Checkbox rscb;
    Checkbox nspcb;
    Checkbox spcb;
    Checkbox wscb;

    public static String getName() {
        return "Multiple Ship SST";
    }

    public static String getCategory() {
        return "Evil";
    }

    public String getHelpString() {
        return "For this script you supply a list of ships (and their passwords) using the add and remove button.  When you hit execute, the script will transport you to each ship, sell the equipment in that ship, and then steal it back.  If you check \"AutoRefurb\", you will blow up merchant frieghter in your sector, thereby regaining the holds you have lost.  If you wish to store all your refurbs in a specific sector, select \"Refurb in sector...\" and provide the sector number you wish to refurb at.  Similarly, selecting \"Use specific port\" to buy equipment will cause you to travel to a specific sector to purchase equipment, while nearest sector will choose the closest convienient xxB port to go to.  If you select \"Use wait ship\" then when all the ports have been busted you will x-port back to the specified ship and wait for a teammate to clear the bust.  This script works with J-TWAT's bust clearing capability, so that when you bust the bust is shared on your subspace radio, and anyone recieving it will clear the port from their current bust list.  Therefore, it is possible to set up 3 ports and have two corpmates trade all their turns as long as there are plenty of refurbs to blow up.";
    }

    public SSTScript2(Vector vector, Vector vector2) {
        this.ships = vector;
        this.passwords = vector2;
    }

    public SSTScript2() {
        this.ships = new Vector();
        this.passwords = new Vector();
    }

    public void setDefaultArguments() {
        System.out.println("SST2.0 DEF ARGS GOT CALLED");
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.setArgument("ships", vector);
        this.setArgument("passwords", vector2);
        this.setArgument("refurb", new Boolean(true));
        this.setArgument("useRefurbSector", new Boolean(false));
        this.setArgument("useSpecificPort", new Boolean(false));
        this.setArgument("useWaitShip", new Boolean(false));
        this.setArgument("waitShipHops", "7");
    }

    public void executeScript(Yytoken yytoken) {
        if (this.ships.size() < 2 || yytoken.id != Yytoken.MAIN_PROMPT) {
            System.out.println("Must specify at least two ships");
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        int n = this.getIntOption("STEAL_FACTOR");
        TWScript tWScript = TWScript.generateTradeScript(new int[]{0, 0, -1});
        TWScript tWScript2 = TWScript.generateStealScript(2, this.info.ti.getExperience() / n + 1);
        if (this.useWaitShip && this.waitShip == this.info.ti.getCurrentShip()) {
            this.m1();
        }
        while (!this.checkStopped()) {
            Sector sector;
            boolean bl = false;
            if (this.info.getCS().port != null) {
                this.helper.doUpdate(true);
                this.getNextToken();
                this.getNextToken();
                System.out.println(this.info.ti.getHoldContents(TraderInfo.EQUIPMENT));
                if (this.info.ti.getHoldContents(TraderInfo.EQUIPMENT) > 0) {
                    if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT) {
                        this.setExitStatus(TWScript.FAILURE);
                        return;
                    }
                } else {
                    this.writeResponse("P");
                    this.getNextToken();
                    this.writeResponse("R");
                    this.getNextToken();
                    this.writeResponse("S");
                    this.getNextToken();
                    this.writeResponse("Q");
                    this.getNextToken();
                    if (this.info.getCS().port.getProductOnDock(2) < this.info.ti.getHoldContents(TraderInfo.EMPTY) - 5) {
                        System.out.println("NOT ENOUGH");
                        if (this.useSpecificPort) {
                            sector = this.info.getCS();
                            SSTScript2 sSTScript2 = this;
                            sSTScript2.callScript(TWScript.generateMoveScript(sSTScript2.specificPort));
                            this.callScript(tWScript);
                            this.callScript(TWScript.generateMoveScript(sector.number));
                        } else if (!this.useSpecificPort) {
                            this.callScript(TWScript.generateRefuelScript(2));
                        }
                        if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT) {
                            this.setExitStatus(TWScript.FAILURE);
                            return;
                        }
                    }
                }
                if (this.checkStopped()) break;
                if (this.callScript((TWScript)tWScript2).id != Yytoken.MAIN_PROMPT) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                if (tWScript2.getExitStatus() == TWScript.SUCCESS) {
                    bl = true;
                }
            }
            if (!bl && this.refurb) {
                sector = this.info.getCS();
                if (this.useRefurbSector) {
                    SSTScript2 sSTScript2 = this;
                    sSTScript2.callScript(TWScript.generateMoveScript(sSTScript2.refurbSector));
                }
                this.callScript(TWScript.generateRefurbScript());
                if (this.useRefurbSector) {
                    this.callScript(TWScript.generateMoveScript(sector.number));
                }
            }
            tWScript2 = TWScript.generateStealScript(2, this.info.ti.getExperience() / n + 1);
            this.m1();
        }
    }

    private void m1() {
        int n;
        int n2 = -1;
        String string = "";
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        Ship ship = null;
        if (this.useWaitShip && this.info.ti.getCurrentShip() == this.waitShip) {
            bl = true;
            n = this.waitShipHops;
        } else {
            n = 7;
            this.lastShip = this.info.ti.getCurrentShip();
        }
        while (n2 == -1 && !this.checkStopped()) {
            this.writeResponse("X");
            if (this.getNextToken().id != Yytoken.TRANSPORT_WHICH_SHIP) {
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
            Vector vector = this.info.getAllShips();
            int n5 = 0;
            while (n5 < vector.size() && n2 == -1) {
                Ship ship2 = (Ship)vector.elementAt(n5);
                Integer n6 = new Integer(ship2.number);
                if (this.ships.contains(n6) && !this.info.ti.isBusted(ship2.sector) && !this.info.ti.isLastSteal(ship2.sector) && ship2.hops <= n) {
                    if (ship2.number > this.lastShip) {
                        n2 = ship2.number;
                        string = (String)this.passwords.elementAt(this.ships.indexOf(n6));
                    } else if (ship == null) {
                        ship = ship2;
                    }
                }
                if (this.useWaitShip && ship2.number == this.waitShip) {
                    n4 = ship2.hops;
                }
                ++n5;
            }
            if (n2 == -1 && ship != null) {
                n2 = ship.number;
                string = "";
            }
            if (n2 > -1) {
                this.writeResponse(Integer.toString(n2) + "\n");
                Yytoken yytoken = this.getNextToken();
                if (yytoken.id == Yytoken.TRANSPORT_PASSWORD) {
                    this.writeResponse(string + "\n");
                    yytoken = this.getNextToken();
                }
                if (yytoken.id != Yytoken.TRANSPORT_SUCCESS) {
                    n2 = -1;
                    this.writeResponse("Q");
                    this.getNextToken();
                    try {
                        Thread.currentThread();
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                this.getNextToken();
                this.writeResponse("Q");
                this.getNextToken();
                if (this.info.getCS().port != null) continue;
                this.writeResponse("\n");
                this.getNextToken();
                continue;
            }
            this.writeResponse("Q");
            this.getNextToken();
            if (this.useWaitShip && !bl && ++n3 > 3 && n4 <= n) {
                SSTScript2 sSTScript2 = this;
                if (sSTScript2.callScript((TWScript)TWScript.generateTransportScript((int)sSTScript2.waitShip, (String)"")).id != Yytoken.MAIN_PROMPT) {
                    System.out.println("Error transporting to wait ship");
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                this.helper.doUpdate(true);
                this.getNextToken();
                this.getNextToken();
                n = this.waitShipHops;
                bl = true;
            }
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public Component getDialog() {
        this.mainp = new Panel(new BorderLayout());
        this.shipList = new List();
        this.ships = (Vector)this.getArgument("ships");
        this.passwords = (Vector)this.getArgument("passwords");
        int n = 0;
        while (n < this.ships.size()) {
            this.shipList.add(((Integer)this.ships.elementAt(n)).toString() + " " + (String)this.passwords.elementAt(n));
            ++n;
        }
        this.mainp.add((Component)this.shipList, "Center");
        Panel panel = new Panel(new GridLayout(10, 1));
        Panel panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Ship : "));
        this.stf = new TextField("", 4);
        panel2.add(this.stf);
        panel2.add(new Label("Password: "));
        this.ptf = new TextField("", 12);
        panel2.add(this.ptf);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        this.add = new Button("Add Ship");
        this.add.addActionListener(this);
        panel2.add(this.add);
        this.remove = new Button("Remove Selected Item");
        this.remove.addActionListener(this);
        panel2.add(this.remove);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        this.refurbcb = new Checkbox("Auto-Refurb on a Bust", (Boolean)this.getArgument("refurb"));
        this.refurbcb.addItemListener(this);
        panel2.add(this.refurbcb);
        panel.add(panel2);
        panel.add(new Label("     Refub Sector:"));
        this.useRefurbSector = (Boolean)this.getArgument("useRefurbSector");
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("     "));
        this.nrscb = new Checkbox("Refurb in the current sector.", !this.useRefurbSector, checkboxGroup);
        panel2.add(this.nrscb);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("     "));
        this.rscb = new Checkbox("Refurb in sector ", this.useRefurbSector, checkboxGroup);
        panel2.add(this.rscb);
        this.rstf = new TextField(Integer.toString(this.info.getCS().number), 5);
        panel2.add(this.rstf);
        panel.add(panel2);
        panel.add(new Label("     Equipment Port:"));
        this.useSpecificPort = (Boolean)this.getArgument("useSpecificPort");
        CheckboxGroup checkboxGroup2 = new CheckboxGroup();
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("     "));
        this.nspcb = new Checkbox("Buy equipment at the nearest port.", !this.useSpecificPort, checkboxGroup2);
        panel2.add(this.nspcb);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("     "));
        this.spcb = new Checkbox("Buy equipment in sector ", this.useSpecificPort, checkboxGroup2);
        panel2.add(this.spcb);
        this.sptf = new TextField(Integer.toString(this.info.getCS().number), 5);
        panel2.add(this.sptf);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        this.wscb = new Checkbox("Use wait ship #", (Boolean)this.getArgument("useWaitShip"));
        panel2.add(this.wscb);
        this.wstf = new TextField(Integer.toString(this.info.ti.getCurrentShip()), 4);
        panel2.add(this.wstf);
        panel2.add(new Label(", xport hops "));
        this.wshtf = new TextField((String)this.getArgument("waitShipHops"), 2);
        panel2.add(this.wshtf);
        panel.add(panel2);
        this.mainp.add((Component)panel, "South");
        return this.mainp;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() == this.add) {
            if (!this.stf.getText().equals("")) {
                this.ships.addElement(new Integer(this.stf.getText()));
                this.passwords.addElement(this.ptf.getText());
                this.shipList.add(this.stf.getText() + " " + this.ptf.getText());
                return;
            }
        } else if (actionEvent.getSource() == this.remove && (n = this.shipList.getSelectedIndex()) > -1) {
            this.shipList.remove(n);
            this.ships.removeElementAt(n);
            this.passwords.removeElementAt(n);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.refurb = this.refurbcb.getState();
        this.rscb.setEnabled(this.refurb);
        this.nspcb.setEnabled(this.refurb);
        this.spcb.setEnabled(this.refurb);
        this.rstf.setEnabled(this.refurb);
        this.sptf.setEnabled(this.refurb);
        this.nrscb.setEnabled(this.refurb);
    }

    public boolean evaluateDialog() {
        this.refurb = this.refurbcb.getState();
        if (this.refurb) {
            this.useRefurbSector = this.rscb.getState();
            if (this.useRefurbSector) {
                SSTScript2 sSTScript2 = this;
                sSTScript2.refurbSector = sSTScript2.processInteger(sSTScript2.rstf.getText(), "refurb sector");
                if (sSTScript2.refurbSector == -1) {
                    return false;
                }
            }
            this.useSpecificPort = this.spcb.getState();
            if (this.useSpecificPort) {
                SSTScript2 sSTScript2 = this;
                sSTScript2.specificPort = sSTScript2.processInteger(sSTScript2.sptf.getText(), "specific port");
                if (sSTScript2.specificPort == -1) {
                    return false;
                }
            }
        }
        this.useWaitShip = this.wscb.getState();
        if (this.useWaitShip) {
            SSTScript2 sSTScript2 = this;
            sSTScript2.waitShip = sSTScript2.processInteger(sSTScript2.wstf.getText(), "wait ship");
            if (sSTScript2.waitShip == -1) {
                return false;
            }
            SSTScript2 sSTScript22 = this;
            sSTScript22.waitShipHops = sSTScript22.processInteger(sSTScript22.wshtf.getText(), "wait ship hops");
            if (sSTScript22.waitShipHops == -1) {
                return false;
            }
        }
        this.setArgument("ships", this.ships);
        this.setArgument("passwords", this.passwords);
        this.setArgument("refurb", new Boolean(this.refurb));
        this.setArgument("useRefurbSector", new Boolean(this.useRefurbSector));
        this.setArgument("useSpecificPort", new Boolean(this.useSpecificPort));
        this.setArgument("useWaitShip", new Boolean(this.useWaitShip));
        this.setArgument("waitShipHops", this.wshtf.getText());
        return true;
    }
}

