/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.AutoMegaJettisonScript;
import TWHelp.Port;
import TWHelp.Sector;
import TWHelp.TWAnalysis;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SSSAnalysis
extends TWAnalysis
implements ActionListener {
    Vector analysisResult;
    int[] minamount;
    Button autoMJButton;
    TextField ftf;
    TextField otf;
    TextField etf;
    Panel mainp;

    public static String getName() {
        return "SSS Ports";
    }

    public SSSAnalysis() {
        this.minamount = new int[3];
    }

    public SSSAnalysis(int[] nArray) {
        this.minamount = nArray;
    }

    public Vector calculateSSS() {
        Vector<Sector> vector = new Vector<Sector>();
        Enumeration enumeration = this.info.getAllPorts();
        while (enumeration.hasMoreElements()) {
            Port port = (Port)enumeration.nextElement();
            if (port.type != 7 || port.getProductAmount(0) <= this.minamount[0] || port.getProductAmount(1) <= this.minamount[1] || port.getProductAmount(2) <= this.minamount[2]) continue;
            vector.addElement(port.sector);
        }
        return vector;
    }

    public void executeAnalysis() {
        if (this.evaluateDialog()) {
            this.analysisResult = this.calculateSSS();
        }
    }

    public Component getResultDisplay() {
        Serializable serializable;
        Panel panel = new Panel(new BorderLayout());
        List list = new List();
        int n = 0;
        while (n < this.analysisResult.size()) {
            serializable = (Sector)this.analysisResult.elementAt(n);
            list.add(Integer.toString(((Sector)serializable).number));
            ++n;
        }
        panel.add((Component)list, "Center");
        serializable = new Panel(new FlowLayout(0));
        this.autoMJButton = new Button("Begin AutoMegaJettison");
        this.autoMJButton.addActionListener(this);
        ((Container)serializable).add(this.autoMJButton);
        panel.add((Component)serializable, "South");
        return panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.helper.prepareScript(new AutoMegaJettisonScript(this.getResult()));
    }

    public Vector getResult() {
        return this.analysisResult;
    }

    public Component getDialog() {
        if (this.mainp != null) {
            return this.mainp;
        }
        this.mainp = new Panel(new GridLayout(4, 1));
        this.mainp.add(new Label("Minimum amount of product at port:"));
        Panel panel = new Panel(new FlowLayout(0));
        panel.add(new Label("Fuel: "));
        this.ftf = new TextField("500", 3);
        panel.add(this.ftf);
        this.mainp.add(panel);
        panel = new Panel(new FlowLayout(0));
        panel.add(new Label("Organics: "));
        this.otf = new TextField("350", 3);
        panel.add(this.otf);
        this.mainp.add(panel);
        panel = new Panel(new FlowLayout(0));
        panel.add(new Label("Equipment: "));
        this.etf = new TextField("200", 3);
        panel.add(this.etf);
        this.mainp.add(panel);
        this.mainp.setSize(300, 225);
        return this.mainp;
    }

    public boolean evaluateDialog() {
        this.minamount[0] = this.ftf.getText().equals("") ? 500 : Integer.parseInt(this.ftf.getText());
        this.minamount[1] = this.otf.getText().equals("") ? 350 : Integer.parseInt(this.otf.getText());
        this.minamount[2] = this.etf.getText().equals("") ? 200 : Integer.parseInt(this.etf.getText());
        return true;
    }
}

