/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.LeaveFightersScript;
import TWHelp.MoveScript;
import TWHelp.Sector;
import TWHelp.TWScript;
import TWHelp.Yytoken;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Hashtable;

public class PortPairTradeScript
extends TWScript {
    int sector1;
    int sector2;
    int[] amount;
    int[] percentages;
    boolean haggle;
    TextField sector1tf;
    TextField sector2tf;
    Checkbox fuel;
    Checkbox org;
    Checkbox equip;
    Checkbox percent;
    Checkbox hagglecb;
    TextField afuel;
    TextField aorg;
    TextField aequip;
    TextField pfuel;
    TextField porg;
    TextField pequip;

    public static String getName() {
        return "Port Pair Trade";
    }

    public static String getCategory() {
        return "Trade";
    }

    public PortPairTradeScript(int n, int n2, int[] nArray, int[] nArray2) {
        this(n, n2, nArray, nArray2, true);
    }

    public PortPairTradeScript(int n, int n2, int[] nArray, int[] nArray2, boolean bl) {
        this.sector1 = n;
        this.sector2 = n2;
        this.amount = nArray;
        this.percentages = nArray2;
        this.haggle = bl;
    }

    public PortPairTradeScript() {
        PortPairTradeScript portPairTradeScript = this;
        portPairTradeScript.sector2 = -1;
        portPairTradeScript.sector1 = -1;
        PortPairTradeScript portPairTradeScript2 = this;
        portPairTradeScript2.percentages = null;
        portPairTradeScript2.amount = null;
    }

    public String getHelpString() {
        return "This script trades between two ports.  Enter the first port number, then the second.  Check the products you wish to trade, and the amount you wish to trade for each. (Leave the amount blank if you want to trade as much as possible.)  If you wish to stop trading after a certain amount of product has been reach, type that in the box marked \"% Min\".  (Make sure the \"Use Percentages\" box is checked.  If you wish to gain experience while using this script, check \"Haggle For Best Price\".";
    }

    public void executeScript(Yytoken yytoken) {
        int n;
        if (this.amount == null || this.percentages == null) {
            return;
        }
        if (yytoken.id != Yytoken.MAIN_PROMPT) {
            System.out.println("BAD PROMPT");
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        Sector sector = this.helper.info.getSector(this.sector1);
        Sector sector2 = this.helper.info.getSector(this.sector2);
        if (sector.port == null || sector2.port == null) {
            System.out.println("NULL PORTS");
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        Sector sector3 = null;
        Sector sector4 = null;
        int n2 = 0;
        while (n2 < 3) {
            if (this.amount[n2] != 0) {
                if (sector.port.validOperation(0, n2) == sector2.port.validOperation(0, n2)) {
                    System.out.println("SAME OPERATION -- " + Integer.toString(n2));
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                if (this.helper.info.ti.getHoldContents(n2) > 0) {
                    if (sector.port.validOperation(0, n2)) {
                        sector3 = sector;
                        sector4 = sector2;
                    } else {
                        sector3 = sector2;
                        sector4 = sector;
                    }
                }
            }
            ++n2;
        }
        if (sector3 == null) {
            int n3 = 0;
            while (n3 < 3) {
                if (this.amount[n3] != 0) {
                    if (sector.port.validOperation(1, n3)) {
                        sector3 = sector;
                        sector4 = sector2;
                    } else {
                        sector3 = sector2;
                        sector4 = sector;
                    }
                }
                ++n3;
            }
        }
        if (this.helper.info.getCS() != sector3) {
            TWScript tWScript = TWScript.generateMoveScript(sector3.number, MoveScript.HOLO);
            this.callScript(tWScript);
            if (tWScript.getExitStatus() != TWScript.SUCCESS) {
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
        }
        System.out.println(this.haggle);
        boolean bl = true;
        do {
            if (bl && (Integer)((Hashtable)this.info.ti.getAllDeployedFtrs()).get(new Integer(this.sector1)) == null) {
                this.callScript(TWScript.generateLeaveFightersScript(1, true, LeaveFightersScript.TOLL));
            }
            PortPairTradeScript portPairTradeScript = this;
            TWScript tWScript = TWScript.generateTradeScript((int[])portPairTradeScript.amount.clone(), this.haggle);
            portPairTradeScript.callScript(tWScript);
            n = tWScript.getExitStatus();
            if (n != TWScript.SUCCESS || !this.m1(sector4) || this.checkStopped()) continue;
            if (bl) {
                bl = false;
                TWScript tWScript2 = TWScript.generateMoveScript(sector4.number, MoveScript.HOLO);
                this.callScript(tWScript2);
                if (tWScript2.getExitStatus() != TWScript.SUCCESS) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                if ((Integer)((Hashtable)this.info.ti.getAllDeployedFtrs()).get(new Integer(this.sector2)) == null) {
                    this.callScript(TWScript.generateLeaveFightersScript(1, true, LeaveFightersScript.TOLL));
                }
            } else {
                this.callScript(TWScript.generateMoveScript(sector4.number));
            }
            PortPairTradeScript portPairTradeScript2 = this;
            tWScript = TWScript.generateTradeScript((int[])portPairTradeScript2.amount.clone(), this.haggle);
            portPairTradeScript2.callScript(tWScript);
            n = tWScript.getExitStatus();
            if (n != TWScript.SUCCESS || this.checkStopped()) continue;
            this.callScript(TWScript.generateMoveScript(sector3.number));
        } while (n == TWScript.SUCCESS && this.m1(sector3) && this.m1(sector4) && !this.checkStopped());
        System.out.println("SUCCESS!!!");
    }

    private boolean m1(Sector sector) {
        System.out.println(sector.port.toString());
        return !(this.percentages[0] >= 0 && sector.port.getProductPercentage(0) < this.percentages[0] || this.percentages[1] >= 0 && sector.port.getProductPercentage(1) < this.percentages[1] || this.percentages[2] >= 0 && sector.port.getProductPercentage(2) < this.percentages[2]);
    }

    public Component getDialog() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(9, 1));
        Panel panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Sector 1:"));
        this.sector1tf = new TextField(Integer.toString(this.helper.info.getCS().number), 10);
        panel2.add(this.sector1tf);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Sector 2:"));
        this.sector2tf = new TextField("", 10);
        panel2.add(this.sector2tf);
        panel.add(panel2);
        panel.add(new Label("Items to trade."));
        panel.add(new Label("(Blank amount trades all available)"));
        panel2 = new Panel(new FlowLayout(0));
        this.fuel = new Checkbox("Fuel: ");
        panel2.add(this.fuel);
        panel2.add(new Label("Amount: "));
        this.afuel = new TextField("", 4);
        panel2.add(this.afuel);
        panel2.add(new Label("Min %: "));
        this.pfuel = new TextField("0", 4);
        panel2.add(this.pfuel);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        this.org = new Checkbox("Organics: ");
        panel2.add(this.org);
        panel2.add(new Label("Amount: "));
        this.aorg = new TextField("", 4);
        panel2.add(this.aorg);
        panel2.add(new Label("Min %: "));
        this.porg = new TextField("0", 4);
        panel2.add(this.porg);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        this.equip = new Checkbox("Equipment: ");
        panel2.add(this.equip);
        panel2.add(new Label("Amount: "));
        this.aequip = new TextField("", 4);
        panel2.add(this.aequip);
        panel2.add(new Label("Min %: "));
        this.pequip = new TextField("0", 4);
        panel2.add(this.pequip);
        panel.add(panel2);
        this.percent = new Checkbox("Use percentages");
        this.percent.setState(true);
        panel.add(this.percent);
        panel.setSize(350, 250);
        this.hagglecb = new Checkbox("Haggle for best price and exp");
        this.hagglecb.setState(true);
        panel.add(this.hagglecb);
        panel.setSize(350, 250);
        return panel;
    }

    public boolean evaluateDialog() {
        this.amount = new int[3];
        this.percentages = new int[3];
        PortPairTradeScript portPairTradeScript = this;
        portPairTradeScript.sector1 = portPairTradeScript.processInteger(portPairTradeScript.sector1tf.getText(), "sector 1");
        if (portPairTradeScript.sector1 == -1) {
            return false;
        }
        PortPairTradeScript portPairTradeScript2 = this;
        portPairTradeScript2.sector2 = portPairTradeScript2.processInteger(portPairTradeScript2.sector2tf.getText(), "sector 2");
        if (portPairTradeScript2.sector2 == -1) {
            return false;
        }
        if (this.fuel.getState()) {
            PortPairTradeScript portPairTradeScript3 = this;
            this.amount[0] = portPairTradeScript3.processInteger(portPairTradeScript3.afuel.getText());
            PortPairTradeScript portPairTradeScript4 = this;
            this.percentages[0] = portPairTradeScript4.processInteger(portPairTradeScript4.pfuel.getText(), "percentage ore", 0);
            if (this.percentages[0] == -1) {
                return false;
            }
        } else {
            this.amount[0] = 0;
            this.percentages[0] = -1;
        }
        if (this.org.getState()) {
            PortPairTradeScript portPairTradeScript5 = this;
            this.amount[1] = portPairTradeScript5.processInteger(portPairTradeScript5.aorg.getText());
            PortPairTradeScript portPairTradeScript6 = this;
            this.percentages[1] = portPairTradeScript6.processInteger(portPairTradeScript6.porg.getText(), "percentage organics", 0);
            if (this.percentages[1] == -1) {
                return false;
            }
        } else {
            this.amount[1] = 0;
            this.percentages[1] = -1;
        }
        if (this.equip.getState()) {
            PortPairTradeScript portPairTradeScript7 = this;
            this.amount[2] = portPairTradeScript7.processInteger(portPairTradeScript7.aequip.getText());
            PortPairTradeScript portPairTradeScript8 = this;
            this.percentages[2] = portPairTradeScript8.processInteger(portPairTradeScript8.pequip.getText(), "percentage Equipment", 0);
            if (this.percentages[2] == -1) {
                return false;
            }
        } else {
            this.amount[2] = 0;
            this.percentages[2] = -1;
        }
        if (!this.percent.getState()) {
            this.percentages[2] = 0;
            this.percentages[1] = 0;
            this.percentages[0] = 0;
        }
        this.haggle = this.hagglecb.getState();
        return true;
    }
}

