/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.TWScript;
import TWHelp.Yytoken;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class PortBuyDownScript
extends TWScript {
    int[] amount;
    int[] a;
    int[][] args;
    int loops;
    int planetNum;
    boolean haggle;
    boolean overPay;
    boolean noHaggle;
    Checkbox fuel;
    Checkbox org;
    Checkbox equip;
    Checkbox overPaycb;
    Checkbox hagglecb;
    Checkbox noHagglecb;
    TextField prodamt;
    TextField planNum;

    public static String getName() {
        return "Port Buy Down Script";
    }

    public static String getCategory() {
        return "Planet";
    }

    public String getHelpString() {
        return "Will buy X amount of product from a port and place it onto the desired planet in the current sector. You can haggle for best or worst price. Useful for those games with mega robbing enabled.";
    }

    public PortBuyDownScript() {
        PortBuyDownScript portBuyDownScript = this;
        portBuyDownScript.noHaggle = false;
        portBuyDownScript.overPay = false;
        portBuyDownScript.haggle = false;
    }

    public void executeScript(Yytoken yytoken) {
        if (this.amount != null) {
            if (yytoken.id != Yytoken.MAIN_PROMPT) {
                System.out.println("Main prompt please!");
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
            if (this.info.getCS().port == null) {
                System.out.println("wrong port");
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
            TWScript tWScript = TWScript.generateTradeScript((int[])this.amount.clone(), false);
            int n = 0;
            while (n < this.loops) {
                if (this.noHaggle) {
                    tWScript = TWScript.generateTradeScript((int[])this.amount.clone(), false);
                } else if (this.haggle) {
                    tWScript = TWScript.generateTradeScript((int[])this.amount.clone(), true);
                } else if (this.overPay) {
                    tWScript = TWScript.generateTradeScript(true, (int[])this.amount.clone());
                }
                this.callScript(tWScript);
                if (tWScript.getExitStatus() != TWScript.SUCCESS || this.checkStopped()) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                TWScript tWScript2 = TWScript.generatePlanetActionScript(this.planetNum, this.a, this.args);
                this.callScript(tWScript2);
                if (tWScript2.getExitStatus() != TWScript.SUCCESS || this.checkStopped()) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                ++n;
            }
        }
    }

    public Component getDialog() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(4, 1));
        Panel panel2 = new Panel(new GridLayout(4, 1));
        panel2.add(new Label("What product do you wish to buy"));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.fuel = new Checkbox("Fuel ore", checkboxGroup, false);
        this.org = new Checkbox("Organics", checkboxGroup, false);
        this.equip = new Checkbox("Equipment", checkboxGroup, true);
        panel2.add(this.fuel);
        panel2.add(this.org);
        panel2.add(this.equip);
        panel.add(panel2);
        panel2 = new Panel(new GridLayout(4, 1));
        panel2.add(new Label("How should we haggle?"));
        CheckboxGroup checkboxGroup2 = new CheckboxGroup();
        this.overPaycb = new Checkbox("Haggle for worst price", checkboxGroup2, true);
        this.hagglecb = new Checkbox("Haggle for best price", checkboxGroup2, false);
        this.noHagglecb = new Checkbox("Don't Haggle", checkboxGroup2, false);
        panel2.add(this.overPaycb);
        panel2.add(this.hagglecb);
        panel2.add(this.noHagglecb);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("How much of the product should we buy?"));
        this.prodamt = new TextField("0", 7);
        panel2.add(this.prodamt);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Which planet do you want to leave the product on?"));
        this.planNum = new TextField("0", 7);
        panel2.add(this.planNum);
        panel.add(panel2);
        panel.setSize(300, 350);
        return panel;
    }

    public boolean evaluateDialog() {
        this.amount = new int[3];
        this.amount[2] = 0;
        this.amount[1] = 0;
        this.amount[0] = 0;
        this.a = new int[1];
        this.args = new int[1][3];
        this.args[0][2] = 0;
        this.args[0][1] = 0;
        this.args[0][0] = 0;
        if (this.fuel.getState()) {
            this.amount[0] = -1;
            this.a[0] = 0;
            this.args[0][0] = -1;
        } else if (this.org.getState()) {
            this.amount[1] = -1;
            this.a[0] = 0;
            this.args[0][1] = -1;
        } else if (this.equip.getState()) {
            this.amount[2] = -1;
            this.a[0] = 0;
            this.args[0][2] = -1;
        }
        if (this.overPaycb.getState()) {
            this.overPay = true;
        } else if (this.hagglecb.getState()) {
            this.haggle = true;
        } else if (this.noHagglecb.getState()) {
            this.noHaggle = true;
        }
        PortBuyDownScript portBuyDownScript = this;
        int n = portBuyDownScript.processInteger(portBuyDownScript.prodamt.getText(), "product amount");
        if (n == -1) {
            return false;
        }
        this.loops = n / this.info.ti.getHolds();
        PortBuyDownScript portBuyDownScript2 = this;
        portBuyDownScript2.planetNum = portBuyDownScript2.processInteger(portBuyDownScript2.planNum.getText(), "planet number");
        return portBuyDownScript2.planetNum != -1;
    }
}

