/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.Planet;
import TWHelp.PlanetActionScript;
import TWHelp.Port;
import TWHelp.TWScript;
import TWHelp.TraderInfo;
import TWHelp.Yytoken;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class PlanetSellProductScript
extends TWScript {
    static int ALL = 0;
    static int AMOUNT = 1;
    static int PERCENTAGE = 2;
    int sector1;
    int sector2;
    int planet;
    int group;
    int action;
    int percentage;
    int amount;
    TextField s1tf;
    TextField s2tf;
    TextField ptf;
    Checkbox[] cb;
    Checkbox[] actcb;
    TextField amounttf;
    TextField percenttf;

    public static String getName() {
        return "Planet-to-Port Sell";
    }

    public static String getCategory() {
        return "Planet";
    }

    public String getHelpString() {
        return "Takes a product from a planet and sells it at a port. Input planet # & its sector, the sector of the port, what to sell, and how much. ";
    }

    public PlanetSellProductScript(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.sector1 = n;
        this.sector2 = n2;
        this.planet = n3;
        this.group = n4;
        this.action = n5;
        this.percentage = n6;
        this.amount = n7;
    }

    public PlanetSellProductScript() {
        this.group = 0;
        this.planet = -1;
    }

    public void executeScript(Yytoken yytoken) {
        Port port;
        if (this.planet == -1) {
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        if (yytoken.id != Yytoken.MAIN_PROMPT) {
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        if (this.info.ti.getHoldContents(TraderInfo.EMPTY) + this.info.ti.getHoldContents(this.group) < this.info.ti.getHolds()) {
            System.out.println("Please empty extra cargo before running this script.");
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        int[] nArray = new int[]{PlanetActionScript.TAKE_PRODUCT};
        int[][] nArrayArray = new int[][]{{0, 0, 0}};
        nArrayArray[0][this.group] = -1;
        int[] nArray2 = new int[]{0, 0, 0};
        int[] nArray3 = nArray2;
        nArray2[this.group] = -1;
        TWScript tWScript = TWScript.generatePlanetActionScript(this.planet, nArray, nArrayArray);
        TWScript tWScript2 = TWScript.generateTradeScript(nArray3);
        boolean bl = this.sector1 != this.sector2;
        TWScript tWScript3 = TWScript.generateMoveScript(this.sector1);
        TWScript tWScript4 = TWScript.generateMoveScript(this.sector2);
        if (this.info.getCS().number != this.sector2) {
            this.callScript(tWScript4);
        }
        if ((port = this.info.getCS().port) == null || port.getTransactionType(this.group) != Port.BUY) {
            System.out.println("You can't sell there!");
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        boolean bl2 = true;
        int n = 0;
        Planet planet = null;
        while (!this.checkStopped() && bl2) {
            if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() != TWScript.SUCCESS) {
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
            if (bl && (this.checkStopped() || this.callScript((TWScript)tWScript3).id != Yytoken.MAIN_PROMPT || tWScript3.getExitStatus() != TWScript.SUCCESS)) {
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
            if (this.checkStopped() || this.callScript((TWScript)tWScript2).id != Yytoken.MAIN_PROMPT || tWScript2.getExitStatus() != TWScript.SUCCESS) {
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
            if (bl && (this.checkStopped() || this.callScript((TWScript)tWScript4).id != Yytoken.MAIN_PROMPT || tWScript4.getExitStatus() != TWScript.SUCCESS)) {
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
            if (planet == null) {
                planet = this.info.getPlanet(this.planet);
            }
            n += this.info.ti.getHolds();
            if (planet.getProductAmount(this.group) == 0 || port.getProductAmount(this.group) == 0) {
                if (this.action != ALL) {
                    System.out.println("Can't sell any more.");
                }
                bl2 = false;
                continue;
            }
            if (this.action == AMOUNT && n >= this.amount) {
                bl2 = false;
                continue;
            }
            if (this.action == AMOUNT && this.amount - n < this.info.ti.getHolds()) {
                nArrayArray[0][this.group] = this.amount - n;
                tWScript = TWScript.generatePlanetActionScript(this.planet, nArray, nArrayArray);
                continue;
            }
            if (this.action != PERCENTAGE || port.getProductPercentage(this.group) >= this.percentage) continue;
            bl2 = false;
        }
    }

    public Component getDialog() {
        Panel panel = new Panel(new GridLayout(6, 1));
        Panel panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Port Sector "));
        this.s1tf = new TextField(Integer.toString(this.info.getCS().number), 5);
        panel2.add(this.s1tf);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Planet Sector "));
        this.s2tf = new TextField(Integer.toString(this.info.getCS().number), 5);
        panel2.add(this.s2tf);
        panel2.add(new Label("Planet #"));
        this.ptf = new TextField("", 4);
        panel2.add(this.ptf);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.cb = new Checkbox[3];
        panel2.add(new Label("Product To Sell : "));
        this.cb[0] = new Checkbox("F", true, checkboxGroup);
        panel2.add(this.cb[0]);
        this.cb[1] = new Checkbox("O", false, checkboxGroup);
        panel2.add(this.cb[1]);
        this.cb[2] = new Checkbox("E", false, checkboxGroup);
        panel2.add(this.cb[2]);
        panel.add(panel2);
        CheckboxGroup checkboxGroup2 = new CheckboxGroup();
        this.actcb = new Checkbox[3];
        panel2 = new Panel(new FlowLayout(0));
        this.actcb[0] = new Checkbox("Sell as much as possible", true, checkboxGroup2);
        panel2.add(this.actcb[0]);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        this.actcb[1] = new Checkbox("Sell an amount", false, checkboxGroup2);
        panel2.add(this.actcb[1]);
        this.amounttf = new TextField("0", 7);
        panel2.add(this.amounttf);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        this.actcb[2] = new Checkbox("Sell until this %", false, checkboxGroup2);
        panel2.add(this.actcb[2]);
        this.percenttf = new TextField("0", 2);
        panel2.add(this.percenttf);
        panel.add(panel2);
        panel.setSize(350, 240);
        return panel;
    }

    public boolean evaluateDialog() {
        PlanetSellProductScript planetSellProductScript = this;
        planetSellProductScript.sector1 = planetSellProductScript.processInteger(planetSellProductScript.s1tf.getText(), "sector 1");
        if (planetSellProductScript.sector1 == -1) {
            return false;
        }
        PlanetSellProductScript planetSellProductScript2 = this;
        planetSellProductScript2.sector2 = planetSellProductScript2.processInteger(planetSellProductScript2.s2tf.getText(), "sector 2");
        if (planetSellProductScript2.sector2 == -1) {
            return false;
        }
        PlanetSellProductScript planetSellProductScript3 = this;
        planetSellProductScript3.planet = planetSellProductScript3.processInteger(planetSellProductScript3.ptf.getText(), "planet");
        if (planetSellProductScript3.planet == -1) {
            return false;
        }
        this.group = this.cb[0].getState() ? 0 : (this.cb[1].getState() ? 1 : 2);
        if (this.actcb[0].getState()) {
            this.action = ALL;
        } else if (this.actcb[1].getState()) {
            this.action = AMOUNT;
            PlanetSellProductScript planetSellProductScript4 = this;
            planetSellProductScript4.amount = planetSellProductScript4.processInteger(planetSellProductScript4.amounttf.getText(), "amount");
            if (planetSellProductScript4.amount == -1) {
                return false;
            }
        } else {
            this.action = PERCENTAGE;
            PlanetSellProductScript planetSellProductScript5 = this;
            planetSellProductScript5.percentage = planetSellProductScript5.processInteger(planetSellProductScript5.percenttf.getText(), "percentage");
            if (planetSellProductScript5.percentage == -1) {
                return false;
            }
        }
        return true;
    }
}

