/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.Planet;
import TWHelp.PlanetActionScript;
import TWHelp.TWScript;
import TWHelp.TraderInfo;
import TWHelp.Yytoken;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class PlanetProductTransferScript
extends TWScript {
    int sector1;
    int sector2;
    int planet1;
    int planet2;
    int group;
    int amount;
    TextField s1tf;
    TextField s2tf;
    TextField p1tf;
    TextField p2tf;
    Checkbox[] cb;
    TextField amounttf;

    public static String getName() {
        return "Product Transfer";
    }

    public static String getCategory() {
        return "Planet";
    }

    public String getHelpString() {
        return "No help on this topic.";
    }

    public PlanetProductTransferScript(int n, int n2, int n3, int n4, int n5, int n6) {
        this.sector1 = n;
        this.sector2 = n2;
        this.planet1 = n3;
        this.planet2 = n4;
        this.group = n5;
        this.amount = n6;
    }

    public PlanetProductTransferScript() {
        PlanetProductTransferScript planetProductTransferScript = this;
        planetProductTransferScript.sector2 = -1;
        planetProductTransferScript.sector1 = -1;
    }

    public void executeScript(Yytoken yytoken) {
        if (this.sector1 == -1 || this.sector2 == -1) {
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        if (yytoken.id != Yytoken.MAIN_PROMPT) {
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        if (this.info.ti.getHoldContents(TraderInfo.EMPTY) + this.info.ti.getHoldContents(this.group) < this.info.ti.getHolds()) {
            System.out.println("Please empty extra cargo before running this script.");
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        int[] nArray = new int[]{PlanetActionScript.TAKE_PRODUCT};
        int[][] nArrayArray = new int[][]{{0, 0, 0}};
        nArrayArray[0][this.group] = -1;
        int[] nArray2 = new int[]{PlanetActionScript.LEAVE_PRODUCT};
        int[][] nArrayArray2 = new int[][]{{0, 0, 0}};
        nArrayArray2[0][this.group] = -1;
        TWScript tWScript = TWScript.generatePlanetActionScript(this.planet1, nArray, nArrayArray);
        TWScript tWScript2 = TWScript.generatePlanetActionScript(this.planet2, nArray2, nArrayArray2);
        boolean bl = this.sector1 != this.sector2;
        TWScript tWScript3 = TWScript.generateMoveScript(this.sector2);
        TWScript tWScript4 = TWScript.generateMoveScript(this.sector1);
        if (this.info.getCS().number != this.sector1) {
            this.callScript(tWScript4);
        }
        boolean bl2 = true;
        int n = 0;
        Planet planet = null;
        Planet planet2 = null;
        while (!this.checkStopped() && n < this.amount && bl2) {
            if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() != TWScript.SUCCESS) {
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
            if (bl && (this.checkStopped() || this.callScript((TWScript)tWScript3).id != Yytoken.MAIN_PROMPT || tWScript3.getExitStatus() != TWScript.SUCCESS)) {
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
            if (this.checkStopped() || this.callScript((TWScript)tWScript2).id != Yytoken.MAIN_PROMPT || tWScript2.getExitStatus() != TWScript.SUCCESS) {
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
            if (bl && (this.checkStopped() || this.callScript((TWScript)tWScript4).id != Yytoken.MAIN_PROMPT || tWScript3.getExitStatus() != TWScript.SUCCESS)) {
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
            if (planet2 == null) {
                planet2 = this.info.getPlanet(this.planet1);
            }
            if (planet == null) {
                planet = this.info.getPlanet(this.planet2);
            }
            n += this.info.ti.getHolds();
            if (planet2.getProductAmount(this.group) == 0) {
                System.out.println("Out of Product");
                bl2 = false;
                continue;
            }
            if (this.amount - n >= this.info.ti.getHolds()) continue;
            nArrayArray[0][this.group] = this.amount - n;
            tWScript = TWScript.generatePlanetActionScript(this.planet1, nArray, nArrayArray);
        }
    }

    public Component getDialog() {
        Panel panel = new Panel(new GridLayout(4, 1));
        Panel panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Planet 1: Sector "));
        this.s1tf = new TextField(Integer.toString(this.info.getCS().number), 5);
        panel2.add(this.s1tf);
        panel2.add(new Label("Planet #"));
        this.p1tf = new TextField("", 4);
        panel2.add(this.p1tf);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Planet 2: Sector "));
        this.s2tf = new TextField(Integer.toString(this.info.getCS().number), 5);
        panel2.add(this.s2tf);
        panel2.add(new Label("Planet #"));
        this.p2tf = new TextField("", 4);
        panel2.add(this.p2tf);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.cb = new Checkbox[3];
        panel2.add(new Label("Transfer : "));
        this.cb[0] = new Checkbox("F", true, checkboxGroup);
        panel2.add(this.cb[0]);
        this.cb[1] = new Checkbox("O", false, checkboxGroup);
        panel2.add(this.cb[1]);
        this.cb[2] = new Checkbox("E", false, checkboxGroup);
        panel2.add(this.cb[2]);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Amount to transfer: "));
        this.amounttf = new TextField("0", 7);
        panel2.add(this.amounttf);
        panel.add(panel2);
        panel.setSize(350, 175);
        return panel;
    }

    public boolean evaluateDialog() {
        PlanetProductTransferScript planetProductTransferScript = this;
        planetProductTransferScript.sector1 = planetProductTransferScript.processInteger(planetProductTransferScript.s1tf.getText(), "sector 1");
        if (planetProductTransferScript.sector1 == -1) {
            return false;
        }
        PlanetProductTransferScript planetProductTransferScript2 = this;
        planetProductTransferScript2.planet1 = planetProductTransferScript2.processInteger(planetProductTransferScript2.p1tf.getText(), "planet 1");
        if (planetProductTransferScript2.planet1 == -1) {
            return false;
        }
        PlanetProductTransferScript planetProductTransferScript3 = this;
        planetProductTransferScript3.sector2 = planetProductTransferScript3.processInteger(planetProductTransferScript3.s2tf.getText(), "sector 2");
        if (planetProductTransferScript3.sector2 == -1) {
            return false;
        }
        PlanetProductTransferScript planetProductTransferScript4 = this;
        planetProductTransferScript4.planet2 = planetProductTransferScript4.processInteger(planetProductTransferScript4.p2tf.getText(), "planet 2");
        if (planetProductTransferScript4.planet2 == -1) {
            return false;
        }
        this.group = this.cb[0].getState() ? 0 : (this.cb[1].getState() ? 1 : 2);
        PlanetProductTransferScript planetProductTransferScript5 = this;
        planetProductTransferScript5.amount = planetProductTransferScript5.processInteger(planetProductTransferScript5.amounttf.getText(), "amount to move");
        return planetProductTransferScript5.amount != -1;
    }
}

