/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.Sector;
import TWHelp.Ship;
import TWHelp.TWScript;
import TWHelp.Yytoken;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Vector;

public class PhotonEnterScript
extends TWScript {
    int sector;
    int planetNumber;
    int shipNum;
    boolean land;
    boolean usePlanetNumber;
    boolean secondShip;
    TextField textSector;
    TextField textPlanetNumber;
    Checkbox chkLand;
    Checkbox chkPlanetNumber;
    Checkbox chkPlanetOrder;
    Checkbox chkSecondShip;
    TextField textShipNum;
    Panel mainp;

    public static String getName() {
        return "Photon and Enter Sector";
    }

    public static String getCategory() {
        return "Offensive";
    }

    public String getHelpString() {
        return "This script will photon a sector. It will then enter the sector and do as commanded";
    }

    public PhotonEnterScript() {
        PhotonEnterScript photonEnterScript = this;
        photonEnterScript.secondShip = false;
        photonEnterScript.usePlanetNumber = false;
        photonEnterScript.land = false;
    }

    public void executeScript(Yytoken yytoken) {
        int n;
        if (yytoken.id != Yytoken.MAIN_PROMPT) {
            this.client.showMessageBox("Start at command prompt.", 1);
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        Sector sector = this.info.getCS();
        Vector vector = sector.getWarps();
        boolean bl = false;
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                if (((Sector)vector.elementAt((int)n2)).number == this.sector) {
                    bl = true;
                }
                ++n2;
            }
        }
        if (!bl) {
            this.client.showMessageBox("Sector to fire photon too is not adjacent to the current sector", 1);
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        if (this.info.ti.getPhotons() == 0) {
            this.client.showMessageBox("Need Photons", 1);
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        if (this.info.ti.getScanners() != 2) {
            this.client.showMessageBox("Need HoloScanners", 1);
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        if (this.secondShip) {
            Vector vector2 = this.info.getAllShips();
            n = 0;
            int n3 = 0;
            while (n3 < vector2.size()) {
                Ship ship = (Ship)vector2.elementAt(n3);
                if (ship.number == this.shipNum && ship.sector.number == sector.number) {
                    n = 1;
                }
                ++n3;
            }
            if (n == 0) {
                this.client.showMessageBox("You don't appear to own ship " + this.shipNum + " or not in current sector. Please display your ships to confirm(x from command prompt)", 1);
                this.setExitStatus(TWScript.FAILURE);
                return;
            }
        }
        Sector sector2 = this.info.getSector(this.sector);
        this.writeResponse("sh");
        this.getNextToken();
        if (this.land && ((n = sector2.getPlanetCount()) == 0 || !this.usePlanetNumber && this.planetNumber > n)) {
            this.client.showMessageBox("Not enought planets in target sector for desired attack", 1);
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        this.helper.handlePauses(false);
        this.writeResponse("cpy" + this.sector + "\nq");
        if (this.secondShip) {
            this.writeResponse("x");
            if (sector.number >= 1 && sector.number <= 10 || sector.number == this.info.getSD()) {
                this.writeResponse("\n" + this.shipNum + "\nq");
            } else {
                this.writeResponse(this.shipNum + "\nq");
            }
        }
        this.writeResponse(this.sector + "\n\n");
        if (sector2.getPlanetCount() > 5) {
            this.writeResponse("\n");
        }
        if (this.land) {
            if (this.usePlanetNumber) {
                this.writeResponse("l" + this.planetNumber + "\n\n\n");
            } else {
                this.writeResponse("l");
                if (!this.getNextToken(Yytoken.LAND_PROMPT, 15)) {
                    this.writeResponse("\n\n");
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                this.writeResponse(sector2.getPlanetNum(this.planetNumber) + "\n\n\n");
            }
        }
        this.helper.handlePauses(true);
    }

    public Component getDialog() {
        if (this.mainp != null) {
            return this.mainp;
        }
        this.mainp = new Panel(new GridLayout(14, 1));
        this.mainp.add(new Label("Photon and Move Script"));
        this.mainp.add(new Label("Photon Sector:"));
        this.textSector = new TextField("", 6);
        this.mainp.add(this.textSector);
        this.chkLand = new Checkbox("Should we land on a planet?", true);
        this.mainp.add(this.chkLand);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.chkPlanetNumber = new Checkbox("Land on planet by number", checkboxGroup, true);
        this.chkPlanetOrder = new Checkbox("Land on planet by order", checkboxGroup, false);
        this.mainp.add(this.chkPlanetNumber);
        this.mainp.add(this.chkPlanetOrder);
        this.textPlanetNumber = new TextField("", 6);
        this.mainp.add(new Label("Enter number for above option"));
        this.mainp.add(this.textPlanetNumber);
        this.chkSecondShip = new Checkbox("Fire photon from this ship and transport to another?", false);
        this.mainp.add(this.chkSecondShip);
        this.mainp.add(new Label("Enter number of ship to transport too if applicable"));
        this.textShipNum = new TextField("", 7);
        this.mainp.add(this.textShipNum);
        this.mainp.setSize(300, 250);
        return this.mainp;
    }

    public boolean evaluateDialog() {
        PhotonEnterScript photonEnterScript = this;
        photonEnterScript.sector = photonEnterScript.processInteger(photonEnterScript.textSector.getText(), "photon sector");
        if (photonEnterScript.sector == -1) {
            return false;
        }
        if (this.chkLand.getState()) {
            this.land = true;
            if (this.chkPlanetNumber.getState()) {
                PhotonEnterScript photonEnterScript2 = this;
                photonEnterScript2.planetNumber = photonEnterScript2.processInteger(photonEnterScript2.textPlanetNumber.getText(), "planet number");
                if (photonEnterScript2.planetNumber == -1) {
                    return false;
                }
                this.usePlanetNumber = true;
            } else {
                PhotonEnterScript photonEnterScript3 = this;
                photonEnterScript3.planetNumber = photonEnterScript3.processInteger(photonEnterScript3.textPlanetNumber.getText(), "planet order");
                if (photonEnterScript3.planetNumber == -1) {
                    return false;
                }
                this.usePlanetNumber = false;
            }
        }
        if (this.chkSecondShip.getState()) {
            this.secondShip = true;
            PhotonEnterScript photonEnterScript4 = this;
            photonEnterScript4.shipNum = photonEnterScript4.processInteger(photonEnterScript4.textShipNum.getText(), "Transport Ship");
            if (photonEnterScript4.shipNum == -1) {
                return false;
            }
        }
        return true;
    }
}

