/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.AutoSSMScript;
import TWHelp.AutoSSTScript;
import TWHelp.Port;
import TWHelp.Sector;
import TWHelp.TWAnalysis;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EvilPairAnalysis
extends TWAnalysis
implements ActionListener {
    int hops;
    int minamount;
    Vector analysisResult;
    Button autoTradeButton;
    TextField minamounttf;
    TextField hopstf;
    Button autoSSTButton;
    Button autoSSMButton;

    public static String getName() {
        return "Evil Pairs";
    }

    public EvilPairAnalysis() {
    }

    public EvilPairAnalysis(int n, int n2) {
        this.hops = n2;
        this.minamount = n;
    }

    public Vector calculateEvilPairs() {
        new Hashtable();
        Hashtable<String, Sector[]> hashtable = new Hashtable<String, Sector[]>();
        Hashtable<String, Sector[]> hashtable2 = new Hashtable<String, Sector[]>();
        Vector<Sector[]> vector = new Vector<Sector[]>();
        Enumeration enumeration = this.info.getAllPorts();
        while (enumeration.hasMoreElements()) {
            Port port = (Port)enumeration.nextElement();
            if (this.info.ti.isBusted(port.sector) || port.getTransactionType(2) != 0 || port.getProductAmount(2) <= this.minamount) continue;
            int[] nArray = new int[3];
            int[] nArray2 = nArray;
            nArray2[1] = 2;
            nArray[0] = 2;
            nArray2[2] = 0;
            Vector vector2 = this.info.getNearestPorts(port.sector, this.hops, nArray2);
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                Port port2 = ((Sector)((Object[])vector2.elementAt((int)n2))[1]).port;
                if (!this.info.ti.isBusted(port2.sector) && port.getProductAmount(2) > this.minamount) {
                    String string = port.sector.number < port2.sector.number ? Integer.toString(port.sector.number) + "-" + Integer.toString(port2.sector.number) : Integer.toString(port2.sector.number) + "-" + Integer.toString(port.sector.number);
                    Sector[] sectorArray = (Sector[])hashtable.get(string);
                    if (sectorArray == null) {
                        Sector[] sectorArray2 = new Sector[2];
                        sectorArray = sectorArray2;
                        sectorArray2[0] = port.sector;
                        sectorArray[1] = port2.sector;
                        hashtable.put(string, sectorArray);
                    } else if ((Sector[])hashtable2.get(string) == null) {
                        hashtable2.put(string, sectorArray);
                        vector.addElement(sectorArray);
                    }
                }
                ++n2;
            }
        }
        return vector;
    }

    public void executeAnalysis() {
        if (this.evaluateDialog()) {
            this.analysisResult = this.calculateEvilPairs();
        }
    }

    public Component getDialog() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        Panel panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Minimum amount of equipment:"));
        this.minamounttf = new TextField("1000", 10);
        panel2.add(this.minamounttf);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Hops between ports:"));
        this.hopstf = new TextField("1", 10);
        panel2.add(this.hopstf);
        panel.add(panel2);
        panel.setSize(350, 150);
        return panel;
    }

    public boolean evaluateDialog() {
        this.minamount = !this.minamounttf.getText().equals("") ? Integer.parseInt(this.minamounttf.getText()) : 1000;
        this.hops = !this.hopstf.getText().equals("") ? Integer.parseInt(this.hopstf.getText()) : 1;
        return true;
    }

    public Component getResultDisplay() {
        Object object;
        Panel panel = new Panel(new BorderLayout());
        List list = new List();
        int n = 0;
        while (n < this.analysisResult.size()) {
            object = (Sector[])this.analysisResult.elementAt(n);
            list.add(Integer.toString(object[0].number) + " - " + Integer.toString(object[1].number));
            ++n;
        }
        panel.add((Component)list, "Center");
        object = new Panel(new FlowLayout(0));
        this.autoSSTButton = new Button("Begin AutoSST");
        this.autoSSTButton.addActionListener(this);
        ((Container)object).add(this.autoSSTButton);
        this.autoSSMButton = new Button("Begin AutoSSM");
        this.autoSSMButton.addActionListener(this);
        ((Container)object).add(this.autoSSMButton);
        panel.add((Component)object, "South");
        return panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.autoSSTButton) {
            AutoSSTScript autoSSTScript = new AutoSSTScript(this.getResult());
            autoSSTScript.setDefaultArguments();
            this.helper.prepareScript(autoSSTScript);
            return;
        }
        if (actionEvent.getSource() == this.autoSSMButton) {
            AutoSSMScript autoSSMScript = new AutoSSMScript(this.getResult());
            autoSSMScript.setDefaultArguments();
            this.helper.prepareScript(autoSSMScript);
        }
    }

    public Vector getResult() {
        return this.analysisResult;
    }
}

