/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.Sector;
import TWHelp.TWScript;
import TWHelp.Yytoken;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.NoSuchElementException;
import java.util.Vector;

public class EprobeExplore
extends TWScript {
    int currSec = 0;
    int startSec = 1;
    int probesFired = 0;
    int totalToFire = 1;
    int mode = 0;
    int buyNum = 25;
    boolean unexploredOnly = true;
    Vector searchDE = new Vector();
    TextField textStart;
    TextField textAmount;
    TextField textBuyNum;
    Checkbox explored;
    Checkbox unExplored;
    Panel mainp;

    public static String getName() {
        return "E-Probe Explore";
    }

    public static String getCategory() {
        return "Exploration";
    }

    public String getHelpString() {
        return "For those who like to live a little longer and don't want to ship explore this is your option. This script will fire e-probes from the stardock exploring for you. It will automatically void sectors to attempt to reach eachs destination and the outcome will be stored to view in the analysis window. Depending on the option it will either shoot to sectors sequentially or to unexplored sectors only. ";
    }

    public EprobeExplore() {
        this.mode = 0;
    }

    public EprobeExplore(int n, Vector vector) {
        this.searchDE = vector;
        System.out.println(this.searchDE.size());
        this.mode = n;
        int n2 = this.searchDE.size();
        this.totalToFire = n2 + n2;
        this.unexploredOnly = false;
    }

    public void executeScript(Yytoken yytoken) {
        if (yytoken.id != Yytoken.MAIN_PROMPT) {
            this.client.showMessageBox("Start at command prompt.", 1);
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        EprobeExplore eprobeExplore = this;
        eprobeExplore.currSec = eprobeExplore.getUnExSec(eprobeExplore.startSec);
        while (this.currSec != -1 && this.probesFired < this.totalToFire) {
            block15: {
                int n;
                block16: {
                    block17: {
                        block14: {
                            TWScript tWScript = TWScript.generateEprobeScript(this.currSec);
                            ++this.probesFired;
                            if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT) {
                                this.setExitStatus(TWScript.FAILURE);
                                return;
                            }
                            n = tWScript.getExitStatus();
                            if (this.checkStopped()) break;
                            if (n != TWScript.SUCCESS) break block14;
                            if (this.info.ti.getTempSectorValue() == 0) {
                                EprobeExplore eprobeExplore2 = this;
                                eprobeExplore2.m1(eprobeExplore2.currSec, "Probe failed to reach this sector\n All routes avoided");
                            } else if (this.mode == 1) {
                                this.info.getSector(this.currSec).setDeadendNote("");
                            }
                            EprobeExplore eprobeExplore3 = this;
                            eprobeExplore3.currSec = eprobeExplore3.getUnExSec(eprobeExplore3.currSec + 1);
                            break block15;
                        }
                        if (n != 1101) break block16;
                        if (!this.info.getCS().equals(this.info.getSector(this.info.getSD()))) break block17;
                        this.buyProbes();
                        --this.probesFired;
                        if (!this.checkStopped()) break block15;
                    }
                    return;
                }
                if (n == 1102) {
                    if (this.info.ti.getTempSectorValue() == this.currSec) {
                        EprobeExplore eprobeExplore4 = this;
                        eprobeExplore4.m1(eprobeExplore4.currSec, "Probe Destroyed Here");
                        EprobeExplore eprobeExplore5 = this;
                        eprobeExplore5.currSec = eprobeExplore5.getUnExSec(eprobeExplore5.currSec + 1);
                    } else {
                        EprobeExplore eprobeExplore6 = this;
                        eprobeExplore6.m1(eprobeExplore6.info.ti.getTempSectorValue(), "Probe Destroyed");
                        EprobeExplore eprobeExplore7 = this;
                        eprobeExplore7.voidSec(eprobeExplore7.info.ti.getTempSectorValue());
                    }
                } else if (n == 1103) {
                    EprobeExplore eprobeExplore8 = this;
                    eprobeExplore8.currSec = eprobeExplore8.getUnExSec(eprobeExplore8.currSec + 1);
                } else if (n == TWScript.FAILURE) break;
            }
            if (this.checkStopped()) break;
        }
    }

    public void voidSec(int n) {
        this.helper.handlePauses(false);
        this.writeResponse("cv" + n + "\nq");
        this.getNextToken();
        this.helper.handlePauses(true);
    }

    public void buyProbes() {
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{this.buyNum};
        TWScript tWScript = TWScript.generateHardwareBuyScript(nArray, nArray2);
        if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT) {
            this.setExitStatus(TWScript.FAILURE);
        }
    }

    public int getUnExSec() {
        return this.getUnExSec(1);
    }

    public int getUnExSec(int n) {
        int n2 = -1;
        if (this.mode == 2) {
            if (this.searchDE.size() == 0) {
                return -1;
            }
            boolean bl = true;
            while (bl) {
                Integer n3;
                try {
                    n3 = (Integer)this.searchDE.firstElement();
                    this.searchDE.remove(n3);
                }
                catch (NoSuchElementException noSuchElementException) {
                    return -1;
                }
                if (n3 == null) {
                    return -1;
                }
                Sector sector = this.info.getSector(n3);
                if (this.unexploredOnly) {
                    if (sector.getVisited() || sector.number <= n) continue;
                    return n3;
                }
                return n3;
            }
        } else if (this.mode == 1) {
            if (this.searchDE.size() == 0) {
                return -1;
            }
            boolean bl = true;
            while (bl) {
                Integer n4;
                try {
                    n4 = (Integer)this.searchDE.firstElement();
                    this.searchDE.remove(n4);
                }
                catch (NoSuchElementException noSuchElementException) {
                    return -1;
                }
                if (n4 == null) {
                    return -1;
                }
                Sector sector = this.info.getSector(n4);
                if (sector == null || sector.number <= n) continue;
                return n4;
            }
        } else if (this.unexploredOnly) {
            int n5 = n;
            while (n5 < 20000) {
                Sector sector = this.info.getSector(n5);
                if (sector == null) {
                    return n5;
                }
                if (!sector.getVisited()) {
                    return n5;
                }
                ++n5;
            }
        } else {
            n2 = n;
        }
        return n2;
    }

    private void m1(int n, String string) {
        Sector sector = this.info.getSector(n);
        if (sector != null) {
            sector.appendNote(string);
            return;
        }
        Sector sector2 = new Sector(n);
        sector2.appendNote(string);
        this.info.addSector(sector2);
    }

    public Component getDialog() {
        if (this.mainp != null) {
            return this.mainp;
        }
        this.mainp = new Panel(new GridLayout(11, 1));
        this.mainp.add(new Label("Eprobe Explore"));
        this.mainp.add(new Label("Sector to start firing probes: "));
        this.textStart = new TextField("1", 6);
        this.mainp.add(this.textStart);
        this.mainp.add(new Label("Number of probes to launch: "));
        this.textAmount = new TextField("25", 4);
        this.mainp.add(this.textAmount);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.explored = new Checkbox("Fire to any sector", checkboxGroup, false);
        this.unExplored = new Checkbox("Fire to unexplored sectors only", checkboxGroup, true);
        this.mainp.add(this.explored);
        this.mainp.add(this.unExplored);
        this.mainp.add(new Label("Number of e-probes ship can hold: "));
        this.textBuyNum = new TextField("25", 4);
        this.mainp.add(this.textBuyNum);
        this.mainp.setSize(300, 250);
        return this.mainp;
    }

    public boolean evaluateDialog() {
        EprobeExplore eprobeExplore = this;
        eprobeExplore.startSec = eprobeExplore.processInteger(eprobeExplore.textStart.getText(), "start sector", 1);
        if (eprobeExplore.startSec == -1) {
            return false;
        }
        EprobeExplore eprobeExplore2 = this;
        eprobeExplore2.totalToFire = eprobeExplore2.processInteger(eprobeExplore2.textAmount.getText(), "amount to fire");
        if (eprobeExplore2.totalToFire == -1) {
            return false;
        }
        EprobeExplore eprobeExplore3 = this;
        eprobeExplore3.buyNum = eprobeExplore3.processInteger(eprobeExplore3.textBuyNum.getText(), "eprobes ship can hold");
        if (eprobeExplore3.buyNum == -1) {
            return false;
        }
        this.unexploredOnly = !this.explored.getState();
        return true;
    }
}

