/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.AddBustDialog;
import TWHelp.TWAnalysis;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class BustAnalysis
extends TWAnalysis
implements ActionListener {
    Vector busts;
    Vector dates;
    TextField bustdata;
    Button addb;
    Button removeb;
    Button sendb;
    Button memob;
    Button requestb;
    List resultList;

    public static boolean isSingular() {
        return true;
    }

    public static String getName() {
        return "Bust Analysis";
    }

    BustAnalysis() {
    }

    public void executeAnalysis() {
        this.busts = new Vector();
        this.dates = new Vector();
        Enumeration enumeration = this.info.ti.busts.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.busts.addElement(k);
            this.dates.addElement(this.info.ti.busts.get(k));
        }
    }

    public Component getResultDisplay() {
        Panel panel = new Panel(new BorderLayout());
        this.resultList = new List();
        int n = 0;
        while (n < this.busts.size()) {
            this.resultList.add(((Integer)this.busts.elementAt(n)).toString() + " " + (Date)this.dates.elementAt(n));
            ++n;
        }
        panel.add((Component)this.resultList, "Center");
        Panel panel2 = new Panel(new FlowLayout(0));
        this.addb = new Button("Add..");
        this.addb.addActionListener(this);
        panel2.add(this.addb);
        this.removeb = new Button("Remove");
        this.removeb.addActionListener(this);
        panel2.add(this.removeb);
        this.sendb = new Button("Share (Radio)");
        this.sendb.addActionListener(this);
        panel2.add(this.sendb);
        this.memob = new Button("Share (Corp)");
        this.memob.addActionListener(this);
        panel2.add(this.memob);
        this.requestb = new Button("Request Busts");
        this.requestb.addActionListener(this);
        panel2.add(this.requestb);
        panel.add((Component)panel2, "South");
        return panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addb) {
            AddBustDialog addBustDialog = new AddBustDialog();
            addBustDialog.show();
            if (addBustDialog.getResult() != -1) {
                this.info.ti.addBust(addBustDialog.getResult());
                Integer n = new Integer(addBustDialog.getResult());
                this.busts.addElement(n);
                this.dates.addElement(this.info.ti.busts.get(n));
                this.resultList.add(((Integer)this.busts.elementAt(this.busts.size() - 1)).toString() + " " + (Date)this.dates.elementAt(this.dates.size() - 1));
                return;
            }
        } else {
            if (actionEvent.getSource() == this.removeb) {
                int n = this.resultList.getSelectedIndex();
                this.resultList.remove(n);
                this.info.ti.clearBust((Integer)this.busts.elementAt(n));
                this.busts.removeElementAt(n);
                this.dates.removeElementAt(n);
                return;
            }
            if (actionEvent.getSource() == this.sendb) {
                this.info.ti.shareBusts();
                return;
            }
            if (actionEvent.getSource() == this.memob) {
                this.info.ti.shareBustsMemo();
                return;
            }
            if (actionEvent.getSource() == this.requestb) {
                this.info.ti.requestBusts();
            }
        }
    }
}

