/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.EprobeExplore;
import TWHelp.NewBubble;
import TWHelp.Sector;
import TWHelp.SectorAnalysis;
import TWHelp.TWSession;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BubbleAnalysis
extends SectorAnalysis
implements ActionListener,
ItemListener {
    Sector theSector = null;
    NewBubble theBubble = null;
    int filterLevel = 3;
    Vector result;
    List sectorNumber;
    TextArea sectorData;
    TextArea sectorNote;
    TextField filterLevelTF;
    Button filterData;
    Button mapSector;
    Button eprobeThisBubble;
    Button eprobeAllBubbles;
    Hashtable sectorsListed;

    public static String getName() {
        return "Bubble Analysis";
    }

    public static boolean isSingular() {
        return true;
    }

    public Vector getResult() {
        return this.result;
    }

    public void setResult(Vector vector) {
        this.result = vector;
    }

    public void executeAnalysis() {
        this.executeAnalysis(true);
        System.gc();
    }

    void pushChildren(Sector sector, Vector vector) {
        Vector vector2 = sector.getWarps(false);
        int n = 0;
        while (n < vector2.size()) {
            Sector sector2 = (Sector)vector2.elementAt(n);
            if (sector2.warpTrace == -1) {
                sector2.warpTrace = sector.number;
                vector.insertElementAt(sector2, 0);
            }
            ++n;
        }
    }

    void pushChildrenTrace(Sector sector, Vector vector, Hashtable hashtable) {
        Vector vector2 = sector.getWarps(false);
        boolean bl = true;
        int n = sector.warpTrace;
        Sector sector2 = sector;
        hashtable.put(sector2, sector2);
        int n2 = 0;
        while (n2 < vector2.size() && bl) {
            Sector sector3 = (Sector)vector2.elementAt(n2);
            if (sector3.number != n && !vector.contains(sector3) && hashtable.get(sector3) == null) {
                vector.insertElementAt(sector3, 0);
            }
            ++n2;
        }
    }

    public void executeAnalysis(boolean bl) {
        Vector<NewBubble> vector = new Vector<NewBubble>();
        Sector sector = this.info.getSector(1);
        if (sector != null) {
            Serializable serializable;
            Serializable serializable2;
            Enumeration enumeration = this.info.getAllSectors();
            while (enumeration.hasMoreElements()) {
                serializable2 = (Sector)enumeration.nextElement();
                ((Sector)enumeration.nextElement()).warpTrace = -1;
                ((Sector)serializable2).inBubble = false;
                ((Sector)serializable2).bubbleChecked = false;
            }
            serializable2 = new Vector();
            sector.warpTrace = 1;
            ((Vector)serializable2).addElement(sector);
            while (((Vector)serializable2).size() > 0) {
                serializable = (Sector)((Vector)serializable2).elementAt(0);
                ((Vector)serializable2).removeElementAt(0);
                this.pushChildren((Sector)serializable, (Vector)serializable2);
            }
            System.out.println("BUILT TREE");
            serializable = sector.getWarps(false);
            int n = 0;
            while (n < ((Vector)serializable).size()) {
                Sector sector2 = (Sector)((Vector)serializable).elementAt(n);
                ((Vector)serializable2).addElement(sector2);
                sector2.bubbleChecked = true;
                ++n;
            }
            int n2 = 1;
            sector.bubbleChecked = true;
            new Hashtable();
            while (((Vector)serializable2).size() > 0) {
                Serializable serializable3;
                Sector sector3 = (Sector)((Vector)serializable2).elementAt(0);
                ((Vector)serializable2).removeElementAt(0);
                Vector<Serializable> vector2 = new Vector<Serializable>();
                Vector vector3 = new Vector();
                Hashtable hashtable = new Hashtable();
                this.pushChildrenTrace(sector3, vector3, hashtable);
                boolean bl2 = true;
                int n3 = sector3.number;
                Vector vector4 = sector3.getWarps(false);
                while (bl2 && vector3.size() > 0) {
                    serializable3 = (Sector)vector3.elementAt(0);
                    vector3.removeElementAt(0);
                    if (((Sector)serializable3).checkTrace(n3)) {
                        this.pushChildrenTrace((Sector)serializable3, vector3, hashtable);
                        vector2.addElement(serializable3);
                        continue;
                    }
                    if (vector4.contains(serializable3)) continue;
                    bl2 = false;
                }
                if (bl2) {
                    vector.addElement(new NewBubble(sector3, vector2));
                    int n4 = 0;
                    while (n4 < vector2.size()) {
                        ((Sector)vector2.elementAt((int)n4)).inBubble = true;
                        ++n4;
                    }
                }
                sector3.bubbleChecked = true;
                serializable3 = sector3.getWarps(false);
                int n5 = 0;
                while (n5 < ((Vector)serializable3).size()) {
                    Sector sector4 = (Sector)((Vector)serializable3).elementAt(n5);
                    if (!sector4.inBubble && !sector4.bubbleChecked) {
                        ((Vector)serializable2).addElement(sector4);
                        sector4.bubbleChecked = true;
                    }
                    ++n5;
                }
                ++n2;
            }
            this.setResult(vector);
            return;
        }
        System.out.println("No Nodes");
    }

    public Component getResultDisplay() {
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        this.sectorData = new TextArea();
        this.sectorData.setEditable(false);
        this.sectorNote = new TextArea();
        this.sectorNote.addTextListener(this);
        panel2.add((Component)this.sectorData, "Center");
        panel2.add((Component)this.sectorNote, "South");
        panel.add((Component)panel2, "Center");
        this.sectorNumber = new List();
        this.sectorNumber.addItemListener(this);
        this.m1();
        panel.add((Component)this.sectorNumber, "West");
        Panel panel3 = new Panel(new FlowLayout(0));
        panel3.add(new Label("Show Bubble Sizes Greater Than"));
        this.filterLevelTF = new TextField("3", 3);
        panel3.add(this.filterLevelTF);
        this.filterData = new Button("Filter");
        panel3.add(this.filterData);
        this.filterData.addActionListener(this);
        this.mapSector = new Button("Map This Bubble");
        panel3.add(this.mapSector);
        this.mapSector.addActionListener(this);
        this.eprobeThisBubble = new Button("Eprobe This Bubble");
        panel3.add(this.eprobeThisBubble);
        this.eprobeThisBubble.addActionListener(this);
        this.eprobeAllBubbles = new Button("Eprobe Bubbles in List");
        panel3.add(this.eprobeAllBubbles);
        this.eprobeAllBubbles.addActionListener(this);
        panel.add((Component)panel3, "South");
        return panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mapSector) {
            if (this.theBubble != null) {
                TWSession.getCurrentSession().getMap().showWindow();
                TWSession.getCurrentSession().getMap().mapBubble(this.theBubble);
                return;
            }
        } else {
            if (actionEvent.getSource() == this.filterData) {
                this.filterLevel = Integer.parseInt(this.filterLevelTF.getText());
                this.m1();
                return;
            }
            if (actionEvent.getSource() == this.eprobeThisBubble) {
                Vector vector = new Vector();
                if (this.theBubble != null) {
                    this.addEprobeList(vector, this.theBubble);
                    this.helper.runScript(new EprobeExplore(2, vector));
                    return;
                }
            } else if (actionEvent.getSource() == this.eprobeAllBubbles) {
                Enumeration enumeration = this.sectorsListed.elements();
                Vector vector = new Vector();
                while (enumeration.hasMoreElements()) {
                    this.addEprobeList(vector, (NewBubble)enumeration.nextElement());
                }
                this.helper.runScript(new EprobeExplore(2, vector));
            }
        }
    }

    public void addEprobeList(Vector vector, NewBubble newBubble) {
        int n;
        int n2 = newBubble.sectors.size();
        int n3 = 0;
        if (n2 == 0) {
            vector.addElement(new Integer(newBubble.door.number));
            ++n3;
        } else {
            n = 0;
            while (n < n2) {
                Sector sector = (Sector)newBubble.sectors.elementAt(n);
                if (sector.getWarps(false).size() == 1) {
                    vector.addElement(new Integer(sector.number));
                    ++n3;
                }
                ++n;
            }
        }
        if (n3 == 0) {
            n = 0;
            while (n < newBubble.sectors.size()) {
                vector.addElement(new Integer(((Sector)newBubble.sectors.elementAt((int)n)).number));
                ++n;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.sectorNumber) {
            this.theBubble = (NewBubble)this.sectorsListed.get(this.sectorNumber.getSelectedItem());
            this.theSector = this.theBubble.door;
            this.m2();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.theSector != null) {
            this.theSector.setNote(this.sectorNote.getText());
        }
    }

    private void m1() {
        this.sectorsListed = new Hashtable();
        if (this.sectorNumber != null) {
            this.sectorNumber.removeAll();
            Enumeration enumeration = this.getResult().elements();
            while (enumeration.hasMoreElements()) {
                NewBubble newBubble = (NewBubble)enumeration.nextElement();
                if (newBubble.sectors.size() <= this.filterLevel) continue;
                String string = newBubble.door.number + " - " + newBubble.sectors.size();
                this.sectorNumber.addItem(string);
                this.sectorsListed.put(string, newBubble);
            }
        }
    }

    private void m2() {
        this.sectorData.setText("");
        String string = "Sector  : " + this.theSector.number + this.theSector.getArea();
        string = this.theSector.getVisited() ? string + " (Explored)\n" : string + " (Unexplored)\n";
        if (this.theSector.port != null) {
            string = string + " Ports   : ";
            if (this.theSector.port.name != null && this.theSector.port.name.length() > 0) {
                string = string + this.theSector.port.name + " ";
            }
            string = string + "(" + this.theSector.port.getTypeString() + ")\n";
        }
        string = string + "Warps to Sector(s) : ";
        Vector vector = this.theSector.getWarps(this.info);
        int n = 0;
        while (n < vector.size()) {
            Sector sector = (Sector)vector.elementAt(n);
            string = sector.getVisited() ? string + Integer.toString(sector.number) : string + "(" + Integer.toString(sector.number) + ")";
            if (n < vector.size() - 1) {
                string = string + " - ";
            }
            ++n;
        }
        string = string + "\n";
        string = string + "\n";
        string = string + "Bubble Info:  " + this.theBubble.sectors.size();
        this.sectorData.setText(string);
        this.sectorNote.setText(this.theSector.getNote());
    }
}

