/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.PortPairTradeScript;
import TWHelp.Sector;
import TWHelp.TWScript;
import TWHelp.Yytoken;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Vector;

public class AutoTradeScript
extends TWScript {
    int minamount;
    int hops;
    int[] amount;
    int[] percentages;
    boolean haggle = true;
    Vector pairs;
    TextField minamounttf;
    TextField hopstf;
    Checkbox fuel;
    Checkbox org;
    Checkbox equip;
    Checkbox percent;
    Checkbox hagglecb;
    TextField afuel;
    TextField aorg;
    TextField aequip;
    TextField pfuel;
    TextField porg;
    TextField pequip;

    public static String getName() {
        return "Auto PPT";
    }

    public static String getCategory() {
        return "Trade";
    }

    public String getHelpString() {
        return "This script will PPT all pairs in the analysis list. Port-Pair Trading: Trades between two ports what ever product and however much you tell it to. Make sure that the ports you pick match each other, such as BSB and BBS. Specifying a percentage will stop the trading when either port gets below that percentage in that product. You can select whether or not to haggle for the best price (more money!) and experience points. ";
    }

    public AutoTradeScript(Vector vector, int[] nArray, int[] nArray2, boolean bl) {
        this.pairs = vector;
        this.amount = nArray;
        this.percentages = nArray2;
        this.haggle = bl;
    }

    public AutoTradeScript(Vector vector) {
        this.pairs = vector;
        AutoTradeScript autoTradeScript = this;
        autoTradeScript.percentages = null;
        autoTradeScript.amount = null;
    }

    public void executeScript(Yytoken yytoken) {
        if (this.pairs == null || this.amount == null || this.percentages == null) {
            return;
        }
        if (yytoken.id != Yytoken.MAIN_PROMPT) {
            System.out.println("BAD PROMPT");
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        int n = 0;
        while (n < this.pairs.size() && !this.checkStopped()) {
            Sector[] sectorArray = (Sector[])this.pairs.elementAt(n);
            this.callScript(new PortPairTradeScript(sectorArray[0].number, sectorArray[1].number, this.amount, this.percentages, this.haggle));
            ++n;
        }
    }

    public Component getDialog() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(8, 1));
        panel.add(new Label("Items to trade."));
        panel.add(new Label("(Blank amount trades all available)"));
        Panel panel2 = new Panel(new FlowLayout(0));
        this.fuel = new Checkbox("Fuel: ");
        panel2.add(this.fuel);
        panel2.add(new Label("Amount: "));
        this.afuel = new TextField("", 4);
        panel2.add(this.afuel);
        panel2.add(new Label("Min %: "));
        this.pfuel = new TextField("10", 4);
        panel2.add(this.pfuel);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        this.org = new Checkbox("Organics: ");
        panel2.add(this.org);
        panel2.add(new Label("Amount: "));
        this.aorg = new TextField("", 4);
        panel2.add(this.aorg);
        panel2.add(new Label("Min %: "));
        this.porg = new TextField("10", 4);
        panel2.add(this.porg);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        this.equip = new Checkbox("Equipment: ");
        panel2.add(this.equip);
        panel2.add(new Label("Amount: "));
        this.aequip = new TextField("", 4);
        panel2.add(this.aequip);
        panel2.add(new Label("Min %: "));
        this.pequip = new TextField("10", 4);
        panel2.add(this.pequip);
        panel.add(panel2);
        this.percent = new Checkbox("Use percentages.");
        this.percent.setState(true);
        panel.add(this.percent);
        this.hagglecb = new Checkbox("Haggle for best price and exp.");
        this.hagglecb.setState(true);
        panel.add(this.hagglecb);
        panel.setSize(350, 200);
        return panel;
    }

    public boolean evaluateDialog() {
        this.amount = new int[3];
        this.percentages = new int[3];
        if (this.fuel.getState()) {
            if (this.afuel.getText().equals("")) {
                this.amount[0] = -1;
            } else {
                AutoTradeScript autoTradeScript = this;
                this.amount[0] = autoTradeScript.processInteger(autoTradeScript.afuel.getText());
            }
            AutoTradeScript autoTradeScript = this;
            this.percentages[0] = autoTradeScript.processInteger(autoTradeScript.pfuel.getText(), "percentage fuel", 0);
            if (this.percentages[0] == -1) {
                return false;
            }
        } else {
            this.amount[0] = 0;
            this.percentages[0] = -1;
        }
        if (this.org.getState()) {
            if (this.aorg.getText().equals("")) {
                this.amount[1] = -1;
            } else {
                AutoTradeScript autoTradeScript = this;
                this.amount[1] = autoTradeScript.processInteger(autoTradeScript.aorg.getText());
            }
            AutoTradeScript autoTradeScript = this;
            this.percentages[1] = autoTradeScript.processInteger(autoTradeScript.porg.getText(), "percentage org", 0);
            if (this.percentages[1] == -1) {
                return false;
            }
        } else {
            this.amount[1] = 0;
            this.percentages[1] = -1;
        }
        if (this.equip.getState()) {
            if (this.aequip.getText().equals("")) {
                this.amount[2] = -1;
            } else {
                AutoTradeScript autoTradeScript = this;
                this.amount[2] = autoTradeScript.processInteger(autoTradeScript.aequip.getText());
            }
            AutoTradeScript autoTradeScript = this;
            this.percentages[2] = autoTradeScript.processInteger(autoTradeScript.pequip.getText(), "percentage equipment");
            if (this.percentages[2] == -1) {
                return false;
            }
        } else {
            this.amount[2] = 0;
            this.percentages[2] = -1;
        }
        if (!this.percent.getState()) {
            this.percentages[2] = 0;
            this.percentages[1] = 0;
            this.percentages[0] = 0;
        }
        this.haggle = this.hagglecb.getState();
        return true;
    }
}

