/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.BuyRefurbScript;
import TWHelp.LeaveFightersScript;
import TWHelp.MoveScript;
import TWHelp.Port;
import TWHelp.SSTScript;
import TWHelp.Sector;
import TWHelp.TWScript;
import TWHelp.Yytoken;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Vector;

public class AutoSSTScript
extends TWScript {
    Vector evilPairs;
    int[] ships;
    String[] passwords;
    Sector[] shipSectors;
    int hops;
    int towShip;
    String towPassword;
    boolean refurb;
    int minimumHolds;
    int refurbSector;
    TextField s1;
    TextField p1;
    TextField s2;
    TextField p2;
    TextField ss1;
    TextField ss2;
    TextField sttf;
    TextField hopstf;
    TextField ts;
    TextField tp;
    TextField mhtf;
    TextField rfsecttf;
    Checkbox refurbcb;

    public static String getName() {
        return "Auto SST";
    }

    public static String getCategory() {
        return "Evil";
    }

    public String getHelpString() {
        return "This script uses the list of ports from the Evil Pair analysis and automatically moves around the universe running SST at the ports you've discovered.  This script takes the number and password of two ships, as well as thier current location.  You also provide a third ship, which must have a Type-2 transwarp drive (twarp tow).  When the script runs, the tow ship will go to the first pair of sectors on the list and drop a fighter.  It then will go back and retrieve the ships and twarp tow them into position.  You'll run SST until you bust.  At this point, several things can happen: if there is another xxB port within the number of hops you specified in the \"Hops\" box, you will move your busted ship there and begin SST again.  (The value put in hops must be equal or less than the x-port power of all three ships, or the script will break.)  If there is no port in range, the script will go to the next evil pair in the list and begin again.  If you checked \"Refurb when holds get below...\" and the number of holds in the busted ship is less than the value given, then the script will send your tow ship to stardock (it will travel to the sector outside SD specified,  otherwise the first available) and bring back the number of refurbs necessary to restore your ship.  Then the process continues as stated above.";
    }

    public void setDefaultArguments() {
        System.out.println("GOT CALLED");
        this.setArgument("ship1", "");
        this.setArgument("password1", "");
        this.setArgument("ship2", "");
        this.setArgument("password2", "");
        this.setArgument("towship", "");
        this.setArgument("towshippassword", "");
        this.setArgument("hops", "7");
        this.setArgument("refurb", new Boolean(true));
        this.setArgument("minimumHolds", "210");
        this.setArgument("refurbSector", "0");
    }

    public AutoSSTScript(Vector vector, int[] nArray, String[] stringArray, int n, int n2, String string, boolean bl, int n3, int n4) {
        this.evilPairs = vector;
        this.ships = nArray;
        this.passwords = stringArray;
        this.hops = n;
        this.towShip = n2;
        this.towPassword = string;
        this.refurb = bl;
        this.minimumHolds = n3;
        this.refurbSector = n4;
    }

    public AutoSSTScript(Vector vector) {
        this.evilPairs = vector;
        this.ships = new int[2];
        this.passwords = new String[2];
        this.shipSectors = new Sector[2];
    }

    public void executeScript(Yytoken yytoken) {
        if (this.ships.length < 2 || yytoken.id != Yytoken.MAIN_PROMPT) {
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        int n = 0;
        int n2 = 1;
        TWScript.generateTradeScript(new int[]{0, 0, -1});
        boolean bl = true;
        int n3 = 0;
        block0: while (n3 < this.evilPairs.size()) {
            Sector sector = ((Sector[])this.evilPairs.elementAt(n3))[0];
            Sector sector2 = ((Sector[])this.evilPairs.elementAt(n3))[1];
            if (!this.info.ti.isBusted(sector) && !this.info.ti.isBusted(sector2)) {
                TWScript tWScript = TWScript.generateMoveScript(sector.number, MoveScript.HOLO);
                if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                this.callScript(TWScript.generateLeaveFightersScript(1, true, LeaveFightersScript.DEFENSIVE));
                tWScript = TWScript.generateMoveScript(sector2.number, MoveScript.HOLO);
                if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                this.callScript(TWScript.generateLeaveFightersScript(1, true, LeaveFightersScript.DEFENSIVE));
                if (this.callScript((TWScript)TWScript.generateRefuelScript((int)0)).id != Yytoken.MAIN_PROMPT) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                tWScript = TWScript.generateMoveScript(this.shipSectors[0].number, MoveScript.TWARP);
                if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                if (this.callScript((TWScript)TWScript.generateRefuelScript((int)0)).id != Yytoken.MAIN_PROMPT) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                if (!bl) {
                    this.callScript(TWScript.generateLeaveFightersScript(0, true, LeaveFightersScript.DEFENSIVE));
                }
                TWScript tWScript2 = TWScript.generateTowScript(this.ships[0], this.passwords[0]);
                if (this.callScript((TWScript)tWScript2).id != Yytoken.MAIN_PROMPT || tWScript2.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                tWScript = TWScript.generateMoveScript(sector.number, MoveScript.TWARP_CONTINUE);
                if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                this.shipSectors[0] = sector;
                tWScript2 = TWScript.generateStopTowScript();
                if (this.callScript((TWScript)tWScript2).id != Yytoken.MAIN_PROMPT || tWScript2.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                if (this.callScript((TWScript)TWScript.generateRefuelScript((int)0)).id != Yytoken.MAIN_PROMPT) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                tWScript = TWScript.generateMoveScript(this.shipSectors[1].number, MoveScript.TWARP);
                if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                if (this.callScript((TWScript)TWScript.generateRefuelScript((int)0)).id != Yytoken.MAIN_PROMPT) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                if (!bl) {
                    this.callScript(TWScript.generateLeaveFightersScript(0, true, LeaveFightersScript.DEFENSIVE));
                }
                tWScript2 = TWScript.generateTowScript(this.ships[1], this.passwords[1]);
                if (this.callScript((TWScript)tWScript2).id != Yytoken.MAIN_PROMPT || tWScript2.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                tWScript = TWScript.generateMoveScript(sector2.number, MoveScript.TWARP_CONTINUE);
                if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                this.shipSectors[1] = sector2;
                Sector sector3 = sector2;
                tWScript2 = TWScript.generateStopTowScript();
                if (this.callScript((TWScript)tWScript2).id != Yytoken.MAIN_PROMPT || tWScript2.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                bl = false;
                TWScript tWScript3 = TWScript.generateTransportScript(this.ships[1], this.passwords[1]);
                if (this.callScript((TWScript)tWScript3).id != Yytoken.MAIN_PROMPT || tWScript3.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                if (this.callScript((TWScript)TWScript.generateRefuelScript((int)2)).id != Yytoken.MAIN_PROMPT) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                tWScript3 = TWScript.generateTransportScript(this.ships[0], this.passwords[0]);
                if (this.callScript((TWScript)tWScript3).id != Yytoken.MAIN_PROMPT || tWScript3.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                if (this.callScript((TWScript)TWScript.generateRefuelScript((int)2)).id != Yytoken.MAIN_PROMPT) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
                boolean bl2 = false;
                while (!bl2 && !this.checkStopped()) {
                    int n4;
                    Object object;
                    Vector<Integer> vector = new Vector<Integer>();
                    vector.addElement(new Integer(this.ships[n]));
                    vector.addElement(new Integer(this.ships[n2]));
                    Vector<String> vector2 = new Vector<String>();
                    vector2.addElement(this.passwords[n]);
                    vector2.addElement(this.passwords[n2]);
                    SSTScript sSTScript = new SSTScript(vector, vector2);
                    if (this.callScript((TWScript)sSTScript).id != Yytoken.MAIN_PROMPT || sSTScript.getExitStatus() == TWScript.FAILURE) {
                        this.setExitStatus(TWScript.FAILURE);
                        return;
                    }
                    if (this.checkStopped()) break block0;
                    if (this.info.getCS().number == this.shipSectors[1].number) {
                        n = 1;
                        n2 = 0;
                    } else {
                        n = 0;
                        n2 = 1;
                    }
                    if (this.refurb && this.info.ti.getHolds() <= this.minimumHolds) {
                        int n5 = (250 - this.info.ti.getHolds()) / 22;
                        if ((250 - this.info.ti.getHolds()) % 22 > 0) {
                            ++n5;
                        }
                        tWScript3 = TWScript.generateTransportScript(this.towShip, this.towPassword);
                        if (this.callScript((TWScript)tWScript3).id != Yytoken.MAIN_PROMPT || tWScript3.getExitStatus() == TWScript.FAILURE) {
                            this.setExitStatus(TWScript.FAILURE);
                            return;
                        }
                        tWScript = TWScript.generateMoveScript(this.shipSectors[n].number);
                        if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() == TWScript.FAILURE) {
                            this.setExitStatus(TWScript.FAILURE);
                            return;
                        }
                        object = new BuyRefurbScript(this.refurbSector, n5, "MY SHIP");
                        if (this.callScript((TWScript)object).id != Yytoken.MAIN_PROMPT || ((TWScript)object).getExitStatus() == TWScript.FAILURE) {
                            this.setExitStatus(TWScript.FAILURE);
                            return;
                        }
                        tWScript = TWScript.generateMoveScript(this.shipSectors[n2].number);
                        if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() == TWScript.FAILURE) {
                            this.setExitStatus(TWScript.FAILURE);
                            return;
                        }
                        tWScript3 = TWScript.generateTransportScript(this.ships[n], this.passwords[n]);
                        if (this.callScript((TWScript)tWScript3).id != Yytoken.MAIN_PROMPT || tWScript3.getExitStatus() == TWScript.FAILURE) {
                            this.setExitStatus(TWScript.FAILURE);
                            return;
                        }
                        n4 = 0;
                        while (n4 < n5) {
                            this.callScript(TWScript.generateRefurbScript());
                            ++n4;
                        }
                    } else if (sector3.equals(this.shipSectors[n])) {
                        tWScript3 = TWScript.generateTransportScript(this.towShip, this.towPassword);
                        if (this.callScript((TWScript)tWScript3).id != Yytoken.MAIN_PROMPT || tWScript3.getExitStatus() == TWScript.FAILURE) {
                            this.setExitStatus(TWScript.FAILURE);
                            return;
                        }
                        tWScript = TWScript.generateMoveScript(this.shipSectors[n2].number);
                        if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() == TWScript.FAILURE) {
                            this.setExitStatus(TWScript.FAILURE);
                            return;
                        }
                        tWScript3 = TWScript.generateTransportScript(this.ships[n], this.passwords[n]);
                        if (this.callScript((TWScript)tWScript3).id != Yytoken.MAIN_PROMPT || tWScript3.getExitStatus() == TWScript.FAILURE) {
                            this.setExitStatus(TWScript.FAILURE);
                            return;
                        }
                    }
                    if (this.callScript((TWScript)TWScript.generateRefuelScript((int)2)).id != Yytoken.MAIN_PROMPT) {
                        this.setExitStatus(TWScript.FAILURE);
                        return;
                    }
                    this.callScript(TWScript.generateLeaveFightersScript(0, true, LeaveFightersScript.DEFENSIVE));
                    if (this.checkStopped()) break block0;
                    Vector vector3 = this.info.getNearestPorts(this.shipSectors[n2], this.hops, 2, 2, Port.BUY);
                    object = null;
                    n4 = 0;
                    int n6 = 0;
                    while (n6 < vector3.size()) {
                        Sector sector4 = (Sector)((Object[])vector3.elementAt(n6))[1];
                        if (n4 < sector4.port.getProductAmount(2)) {
                            Vector vector4 = this.info.getNearestPorts(sector4, this.hops, 2, 2, Port.BUY);
                            int n7 = 0;
                            while (n7 < vector4.size()) {
                                if (((Sector)((Object[])vector4.elementAt(n7))[1]).equals(this.shipSectors[n2])) {
                                    n4 = sector4.port.getProductAmount(2);
                                    object = sector4;
                                    break;
                                }
                                ++n7;
                            }
                        }
                        ++n6;
                    }
                    if (object != null) {
                        tWScript = TWScript.generateMoveScript(((Sector)object).number);
                        if (this.callScript((TWScript)tWScript).id != Yytoken.MAIN_PROMPT || tWScript.getExitStatus() == TWScript.FAILURE) {
                            this.setExitStatus(TWScript.FAILURE);
                            return;
                        }
                        this.shipSectors[n] = object;
                        this.callScript(TWScript.generateLeaveFightersScript(1, true, LeaveFightersScript.DEFENSIVE));
                        continue;
                    }
                    bl2 = true;
                }
                tWScript3 = TWScript.generateTransportScript(this.towShip, this.towPassword);
                if (this.callScript((TWScript)tWScript3).id != Yytoken.MAIN_PROMPT || tWScript3.getExitStatus() == TWScript.FAILURE) {
                    this.setExitStatus(TWScript.FAILURE);
                    return;
                }
            }
            ++n3;
        }
    }

    public Component getDialog() {
        Panel panel = new Panel(new GridLayout(6, 1));
        Panel panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Ship #1: "));
        this.s1 = new TextField((String)this.getArgument("ship1"), 4);
        panel2.add(this.s1);
        panel2.add(new Label("Password: "));
        this.p1 = new TextField((String)this.getArgument("password1"), 12);
        panel2.add(this.p1);
        panel2.add(new Label("Sector: "));
        this.ss1 = new TextField(Integer.toString(this.info.getCS().number), 5);
        panel2.add(this.ss1);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Ship #2: "));
        this.s2 = new TextField((String)this.getArgument("ship2"), 4);
        panel2.add(this.s2);
        panel2.add(new Label("Password: "));
        this.p2 = new TextField((String)this.getArgument("password2"), 12);
        panel2.add(this.p2);
        panel2.add(new Label("Sector: "));
        this.ss2 = new TextField(Integer.toString(this.info.getCS().number), 5);
        panel2.add(this.ss2);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Tow Ship: "));
        this.ts = new TextField((String)this.getArgument("towship"), 4);
        panel2.add(this.ts);
        panel2.add(new Label("Password: "));
        this.tp = new TextField((String)this.getArgument("towshippassword"), 12);
        panel2.add(this.tp);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("Hops: "));
        this.hopstf = new TextField((String)this.getArgument("hops"), 4);
        panel2.add(this.hopstf);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        this.refurbcb = new Checkbox("Refub when holds get below ", (Boolean)this.getArgument("refurb"));
        panel2.add(this.refurbcb);
        this.mhtf = new TextField((String)this.getArgument("minimumHolds"), 3);
        panel2.add(this.mhtf);
        panel.add(panel2);
        panel2 = new Panel(new FlowLayout(0));
        panel2.add(new Label("    Sector to warp to: "));
        this.rfsecttf = new TextField((String)this.getArgument("refurbSector"), 5);
        panel2.add(this.rfsecttf);
        panel.add(panel2);
        return panel;
    }

    public boolean evaluateDialog() {
        AutoSSTScript autoSSTScript = this;
        this.ships[0] = autoSSTScript.processInteger(autoSSTScript.s1.getText(), "ship #1");
        if (this.ships[0] == -1) {
            return false;
        }
        AutoSSTScript autoSSTScript2 = this;
        int n = autoSSTScript2.processInteger(autoSSTScript2.ss1.getText(), "ship #1 sector");
        if (n == -1) {
            return false;
        }
        this.shipSectors[0] = this.info.getSector(n);
        this.passwords[0] = this.p1.getText() != null && !this.p1.getText().equals("") ? this.p1.getText() : "";
        AutoSSTScript autoSSTScript3 = this;
        this.ships[1] = autoSSTScript3.processInteger(autoSSTScript3.s2.getText(), "ship #2");
        if (this.ships[1] == -1) {
            return false;
        }
        this.passwords[1] = this.p2.getText() != null && !this.p2.getText().equals("") ? this.p2.getText() : "";
        AutoSSTScript autoSSTScript4 = this;
        n = autoSSTScript4.processInteger(autoSSTScript4.ss2.getText(), "ship sector #2");
        if (n == -1) {
            return false;
        }
        this.shipSectors[1] = this.info.getSector(n);
        AutoSSTScript autoSSTScript5 = this;
        autoSSTScript5.towShip = autoSSTScript5.processInteger(autoSSTScript5.ts.getText(), "tow ship");
        if (autoSSTScript5.towShip == -1) {
            return false;
        }
        this.towPassword = this.tp.getText() != null && !this.tp.getText().equals("") ? this.tp.getText() : "";
        AutoSSTScript autoSSTScript6 = this;
        autoSSTScript6.hops = autoSSTScript6.processInteger(autoSSTScript6.hopstf.getText(), "hops", 7);
        if (autoSSTScript6.hops == -1) {
            return false;
        }
        this.refurb = this.refurbcb.getState();
        if (this.refurb) {
            AutoSSTScript autoSSTScript7 = this;
            autoSSTScript7.minimumHolds = autoSSTScript7.processInteger(autoSSTScript7.mhtf.getText(), "minimum holds", 220);
            if (autoSSTScript7.minimumHolds == -1) {
                return false;
            }
            AutoSSTScript autoSSTScript8 = this;
            autoSSTScript8.refurbSector = autoSSTScript8.processInteger(autoSSTScript8.rfsecttf.getText(), "refurb sector");
            if (autoSSTScript8.refurbSector == -1) {
                return false;
            }
        }
        this.setArgument("ship1", this.s1.getText());
        this.setArgument("password1", this.p1.getText());
        this.setArgument("ship2", this.s2.getText());
        this.setArgument("password2", this.p2.getText());
        this.setArgument("towship", this.ts.getText());
        this.setArgument("towshippassword", this.tp.getText());
        this.setArgument("hops", this.hopstf.getText());
        this.setArgument("refurb", new Boolean(this.refurb));
        this.setArgument("minimumHolds", this.mhtf.getText());
        this.setArgument("refurbSector", this.rfsecttf.getText());
        return true;
    }
}

