/*
 * Decompiled with CFR 0.152.
 */
package TWHelp;

import TWHelp.MegaJettisonScript;
import TWHelp.MoveScript;
import TWHelp.Sector;
import TWHelp.TWScript;
import TWHelp.Yytoken;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Vector;

public class AutoMegaJettisonScript
extends TWScript {
    Vector sectors;
    int[] tradeamount;
    TextField ftf;
    TextField otf;
    TextField etf;
    Panel mainp;

    public static String getName() {
        return "Auto Mega-Jettison";
    }

    public static String getCategory() {
        return "Evil";
    }

    public String getHelpString() {
        return "This script will move to SSS ports sequentially from your analysis and run mega-jettison at the port you are currently stationed at. The options it gives are for you to fine tune how much of each product you want to buy per loop, but I suggest leaving it at the default. ";
    }

    public AutoMegaJettisonScript(Vector vector, int[] nArray) {
        this.sectors = vector;
        this.tradeamount = nArray;
    }

    public AutoMegaJettisonScript(Vector vector) {
        this.sectors = vector;
        this.tradeamount = new int[3];
    }

    public void executeScript(Yytoken yytoken) {
        if (yytoken.id != Yytoken.MAIN_PROMPT) {
            System.out.println("BAD PROMPT");
            this.setExitStatus(TWScript.FAILURE);
            return;
        }
        int n = 0;
        while (n < this.sectors.size() && !this.checkStopped()) {
            TWScript tWScript = TWScript.generateMoveScript(((Sector)this.sectors.elementAt((int)n)).number, MoveScript.HOLO);
            this.callScript(tWScript);
            if (tWScript.getExitStatus() == TWScript.SUCCESS) {
                if (this.checkStopped()) break;
                this.callScript(new MegaJettisonScript(this.tradeamount));
            }
            ++n;
        }
    }

    public Component getDialog() {
        if (this.mainp != null) {
            return this.mainp;
        }
        this.mainp = new Panel(new GridLayout(4, 1));
        this.mainp.add(new Label("Amount to buy:"));
        Panel panel = new Panel(new FlowLayout(0));
        panel.add(new Label("Fuel: "));
        this.ftf = new TextField("10", 3);
        panel.add(this.ftf);
        this.mainp.add(panel);
        panel = new Panel(new FlowLayout(0));
        panel.add(new Label("Organics: "));
        this.otf = new TextField("7", 3);
        panel.add(this.otf);
        this.mainp.add(panel);
        panel = new Panel(new FlowLayout(0));
        panel.add(new Label("Equipment: "));
        this.etf = new TextField("4", 3);
        panel.add(this.etf);
        this.mainp.add(panel);
        this.mainp.setSize(300, 250);
        return this.mainp;
    }

    public boolean evaluateDialog() {
        AutoMegaJettisonScript autoMegaJettisonScript = this;
        this.tradeamount[0] = autoMegaJettisonScript.processInteger(autoMegaJettisonScript.ftf.getText(), "fuel amount");
        if (this.tradeamount[0] == -1) {
            return false;
        }
        AutoMegaJettisonScript autoMegaJettisonScript2 = this;
        this.tradeamount[1] = autoMegaJettisonScript2.processInteger(autoMegaJettisonScript2.otf.getText(), "organic amount");
        if (this.tradeamount[1] == -1) {
            return false;
        }
        AutoMegaJettisonScript autoMegaJettisonScript3 = this;
        this.tradeamount[2] = autoMegaJettisonScript3.processInteger(autoMegaJettisonScript3.etf.getText(), "equipment amount");
        return this.tradeamount[2] != -1;
    }
}

