/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.gui;

import EDU.auburn.VGJ.algorithm.GraphAlgorithm;
import EDU.auburn.VGJ.algorithm.tree.TreeAlgorithm;
import EDU.auburn.VGJ.graph.GMLlexer;
import EDU.auburn.VGJ.graph.GMLobject;
import EDU.auburn.VGJ.graph.Graph;
import EDU.auburn.VGJ.graph.Node;
import EDU.auburn.VGJ.graph.ParseError;
import EDU.auburn.VGJ.graph.TWGraph;
import EDU.auburn.VGJ.gui.AlgPropDialog;
import EDU.auburn.VGJ.gui.AngleControlPanel;
import EDU.auburn.VGJ.gui.FontPropDialog;
import EDU.auburn.VGJ.gui.GraphCanvas;
import EDU.auburn.VGJ.gui.GraphEdit;
import EDU.auburn.VGJ.gui.GroupControl;
import EDU.auburn.VGJ.gui.LPanel;
import EDU.auburn.VGJ.gui.MessageDialog;
import EDU.auburn.VGJ.gui.PSdialog;
import EDU.auburn.VGJ.gui.ScrolledPanel;
import EDU.auburn.VGJ.gui.ViewportScroller;
import EDU.auburn.VGJ.util.DDimension;
import EDU.auburn.VGJ.util.DPoint;
import TWHelp.TWSession;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.util.Hashtable;

public class GraphWindow
extends Frame {
    protected static int spacing_ = 6;
    private Graph f1;
    private GraphCanvas f2;
    private Panel f3;
    private CheckboxMenuItem f4;
    private ViewportScroller f5;
    private ScrolledPanel f6;
    private Label f7;
    private double f8 = 1.0;
    private Menu f9;
    private Hashtable f10;
    private Hashtable f11;
    private Hashtable f12;
    private CheckboxMenuItem f13;
    private String f14 = null;
    private GMLobject f15 = null;
    private PSdialog f16 = null;
    private AlgPropDialog f17 = null;
    private FontPropDialog f18 = null;
    private GroupControl f19 = null;
    private static URL f20 = null;

    public Graph getGraph() {
        return this.f1;
    }

    public GraphWindow(boolean bl) {
        this.m1(new Graph(bl));
    }

    public GraphWindow(Graph graph) {
        this.m1(graph);
    }

    private void m1(Graph graph) {
        CheckboxMenuItem checkboxMenuItem;
        this.f10 = new Hashtable();
        this.f11 = new Hashtable();
        this.f12 = new Hashtable();
        boolean bl = graph.isDirected();
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        menu.add(new MenuItem("Open (GML)"));
        menu.add(new MenuItem("Save (GML)"));
        menu.add(new MenuItem("Save As (GML)"));
        menu.add(new MenuItem("-"));
        menu.add(new MenuItem("Open Example Graph"));
        menu.add(new MenuItem("-"));
        menu.add(new MenuItem("PostScript Output"));
        menu.add(new MenuItem("-"));
        menu.add(new MenuItem("Exit This Window"));
        menuBar.add(menu);
        this.f9 = new Menu("Algorithms");
        menuBar.add(this.f9);
        menu = new Menu("Edit");
        menu.add(new MenuItem("Edit Text Representation (GML)"));
        menu.add(new MenuItem("Delete Selected Items"));
        menu.add(new MenuItem("Select All"));
        menu.add(new MenuItem("Remove All Edge Bends"));
        menu.add(new MenuItem("Remove All Groups"));
        menu.add(new MenuItem("Group Control"));
        menuBar.add(menu);
        menu = new Menu("Properties");
        this.f4 = new CheckboxMenuItem("Show Controls  [s]");
        this.f4.setState(true);
        menu.add(this.f4);
        this.f13 = checkboxMenuItem = new CheckboxMenuItem("Directed");
        if (bl) {
            checkboxMenuItem.setState(true);
        }
        menu.add(checkboxMenuItem);
        menu.add(new MenuItem("Set New Node Properties"));
        menu.add(new MenuItem("Set Node Spacing"));
        menu.add(new MenuItem("Set Font"));
        checkboxMenuItem = new CheckboxMenuItem("Scale Node Size");
        checkboxMenuItem.setState(true);
        menu.add(checkboxMenuItem);
        checkboxMenuItem = new CheckboxMenuItem("Use Node ID As Default Label");
        checkboxMenuItem.setState(true);
        menu.add(checkboxMenuItem);
        checkboxMenuItem = new CheckboxMenuItem("High Quality Display");
        checkboxMenuItem.setState(false);
        menu.add(checkboxMenuItem);
        menuBar.add(menu);
        this.setLayout(new BorderLayout());
        LPanel lPanel = new LPanel();
        this.f5 = new ViewportScroller(90, 90, 500.0, 500.0, 400.0, 400.0, 0.0, 0.0);
        this.f5.setBackground(Color.lightGray);
        lPanel.constraints.insets.bottom = 0;
        lPanel.addButton("Map Current Sector", 0, 0, 1.0, 1.0, 0, 0);
        lPanel.addLabel("Viewing Offset", 0, 0, 1.0, 1.0, 0, 0);
        lPanel.constraints.insets.bottom = 0;
        lPanel.constraints.insets.top = 0;
        lPanel.addComponent(this.f5, 0, 0, 1.0, 1.0, 0, 0);
        lPanel.constraints.insets.bottom = 0;
        lPanel.constraints.insets.top = 0;
        lPanel.addButton("Center", 0, 0, 1.0, 1.0, 0, 0);
        this.f7 = lPanel.addLineLabel("Scale: 1", 0);
        LPanel lPanel2 = new LPanel();
        new LPanel().spacing = 0;
        lPanel2.constraints.insets.bottom = 0;
        lPanel2.constraints.insets.top = 0;
        lPanel2.addButton("Scale / 2", 1, -1, 1.0, 1.0, 0, 0);
        lPanel2.addButton("Scale = 1", 1, -1, 1.0, 1.0, 0, 0);
        lPanel2.addButton("Scale * 2", 0, -1, 1.0, 1.0, 0, 0);
        lPanel2.finish();
        lPanel.addComponent(lPanel2, 0, 0, 1.0, 1.0, 0, 0);
        lPanel.constraints.insets.top = 0;
        AngleControlPanel angleControlPanel = new AngleControlPanel(180, 76);
        lPanel.addComponent(angleControlPanel, 0, 0, 1.0, 1.0, 1, 0);
        Panel panel = new Panel();
        panel.add("North", lPanel);
        lPanel.finish();
        this.add("West", panel);
        this.f3 = panel;
        this.f1 = graph;
        Node.defaults.setBoundingBox(20.0, 20.0, 20.0);
        this.f2 = new GraphCanvas(this.f1, this);
        this.f2.setMouseMode(2);
        this.f6 = new ScrolledPanel(this.f2);
        this.add("Center", this.f6);
        ((Component)this).setBackground(Color.lightGray);
        this.validate();
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Checkbox) {
            String string = ((Checkbox)event.target).getCheckboxGroup().getCurrent().getLabel();
            if (string.equals("Create Edges") || string.equals("Select Nodes") || string.equals("Select Edges") || string.equals("Select Nodes or Edges")) {
                // empty if block
            }
            this.f2.setMouseMode(2);
        } else if (event.target instanceof CheckboxMenuItem) {
            String string = ((CheckboxMenuItem)event.target).getLabel();
            boolean bl = ((CheckboxMenuItem)event.target).getState();
            if (string.equals("Scale Node Size")) {
                this.f2.scaleBounds(bl);
            } else if (string.equals("Show Controls  [s]")) {
                if (bl) {
                    this.f3.show();
                } else {
                    this.f3.hide();
                }
                this.validate();
            } else if (string.equals("Directed")) {
                this.f2.setDirected(bl);
            } else if (string.equals("Use Node ID As Default Label")) {
                Node.setDefaultLabel(bl);
                this.f2.update(false);
            } else if (string.equals("High Quality Display")) {
                this.f2.setQuality(!bl ? 1 : 2);
            }
        } else if (event.target instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)event.target;
            GraphAlgorithm graphAlgorithm = (GraphAlgorithm)this.f10.get(menuItem);
            if (graphAlgorithm != null) {
                this.m4(graphAlgorithm);
            } else {
                String string = menuItem.getLabel();
                if (string.equals("Open Example Graph")) {
                    try {
                        InputStream inputStream = new URL(f20, "example.gml").openStream();
                        GMLlexer gMLlexer = new GMLlexer(inputStream);
                        this.f15 = new GMLobject(gMLlexer, null);
                        GMLobject gMLobject = this.f15.getGMLSubObject("graph", 3, false);
                        Graph graph = new Graph(gMLobject);
                        this.f1.copy(graph);
                        this.f2.update(true);
                        this.f14 = null;
                        this.m3();
                    }
                    catch (Exception exception) {
                        new MessageDialog((Frame)this, "Error", "Error loading example graph.", true);
                    }
                } else {
                    if (string.equals("Open (GML)")) {
                        FileDialog fileDialog;
                        try {
                            fileDialog = new FileDialog((Frame)this, "Open VGJ File (GML)", 0);
                            fileDialog.show();
                        }
                        catch (Throwable throwable) {
                            new MessageDialog((Frame)this, "Error", "It appears your VM does not allow file loading.", true);
                            return true;
                        }
                        String string2 = fileDialog.getFile();
                        if (string2 == null) {
                            return true;
                        }
                        string2 = fileDialog.getDirectory() + string2;
                        this.loadFile(string2);
                        return true;
                    }
                    if (string.equals("Save (GML)") || string.equals("Save As (GML)")) {
                        try {
                            String string3;
                            Object object2;
                            if (string.equals("Save As (GML)") || this.f14 == null) {
                                try {
                                    object2 = new FileDialog((Frame)this, "Save VGJ File (GML)", 1);
                                    ((Dialog)object2).show();
                                }
                                catch (Throwable throwable) {
                                    new MessageDialog((Frame)this, "Error", "It appears your VM does not allow file saving.", true);
                                    return true;
                                }
                                string3 = ((FileDialog)object2).getFile();
                                if (string3 == null) {
                                    return true;
                                }
                                if (string3.endsWith(".*.*")) {
                                    string3 = string3.substring(0, string3.length() - 4);
                                }
                                string3 = ((FileDialog)object2).getDirectory() + string3;
                            } else {
                                string3 = this.f14;
                            }
                            object2 = new PrintStream(new FileOutputStream(string3));
                            if (this.f15 == null) {
                                this.f15 = new GMLobject(null, 5);
                                this.f15.addObjectToEnd(new GMLobject("graph", 3));
                            }
                            GMLobject gMLobject = this.f15.getGMLSubObject("graph", 3, false);
                            this.f1.setGMLvalues(gMLobject);
                            gMLobject.prune();
                            ((PrintStream)object2).println(this.f15.toString(0));
                            ((PrintStream)object2).close();
                            this.f14 = string3;
                            this.m3();
                        }
                        catch (IOException iOException) {
                            new MessageDialog((Frame)this, "Error", iOException.getMessage(), true);
                        }
                    } else if (string.equals("Exit This Window")) {
                        this.m2();
                    } else if (string.equals("Delete Selected Items")) {
                        this.f2.deleteSelected(true);
                    } else if (string.equals("Select All")) {
                        this.f2.selectAll();
                    } else if (string.equals("Remove All Edge Bends")) {
                        this.f2.removeEdgeBends();
                    } else if (string.equals("Remove All Groups")) {
                        this.f2.removeGroups();
                    } else if (string.equals("Group Control")) {
                        if (this.f19 == null) {
                            GraphWindow graphWindow = this;
                            this.f19 = new GroupControl((Frame)graphWindow, graphWindow.f2);
                        } else {
                            this.f19.showMe();
                        }
                    } else if (string.equals("Set New Node Properties")) {
                        this.f2.setNodeProperties(true);
                    } else if (string.equals("Set Node Spacing")) {
                        if (this.f17 == null) {
                            GraphWindow graphWindow = this;
                            this.f17 = new AlgPropDialog((Frame)graphWindow, graphWindow.f2);
                        } else {
                            this.f17.showMe();
                        }
                    } else if (string.equals("Set Font")) {
                        if (this.f18 == null) {
                            GraphWindow graphWindow = this;
                            this.f18 = new FontPropDialog((Frame)graphWindow, graphWindow.f2);
                        } else {
                            this.f18.showMe();
                        }
                    } else if (string.equals("Edit Text Representation (GML)")) {
                        this.f2.unselectItems();
                        GraphEdit graphEdit = new GraphEdit(this.f1, this.f2);
                        graphEdit.pack();
                        graphEdit.show();
                    } else if (string.equals("PostScript Output")) {
                        if (this.f16 == null) {
                            GraphWindow graphWindow = this;
                            this.f16 = new PSdialog((Frame)graphWindow, graphWindow.f2);
                        } else {
                            this.f16.pack();
                            this.f16.show();
                        }
                    }
                }
            }
        } else if (event.target instanceof Button) {
            if (((String)object).equals("Map Current Sector")) {
                TWSession.getCurrentSession().getMap().mapCurrentSector(4);
            } else if (((String)object).equals("Scale / 2")) {
                this.f8 /= 2.0;
                this.f2.setScale(this.f8);
                this.f7.setText("Scale: " + this.f8);
            } else if (((String)object).equals("Scale * 2")) {
                this.f8 *= 2.0;
                this.f2.setScale(this.f8);
                this.f7.setText("Scale: " + this.f8);
            } else if (((String)object).equals("Scale = 1")) {
                this.f8 = 1.0;
                this.f2.setScale(this.f8);
                this.f7.setText("Scale: " + this.f8);
            } else if (((String)object).equals("Center")) {
                DDimension dDimension = this.f6.getPortSize();
                DDimension dDimension2 = this.f6.getContentSize();
                double d = (dDimension2.width - dDimension.width) / 2.0;
                double d2 = (dDimension2.height - dDimension.height) / 2.0;
                this.f6.scrollTo((int)d, (int)d2);
                System.out.println(d + " " + d2);
                this.f5.setOffset(d, d2);
            }
        }
        return true;
    }

    public boolean handleEvent(Event event) {
        if (event.target instanceof ScrolledPanel) {
            if (event.id == ScrolledPanel.RESIZE) {
                DDimension dDimension = this.f6.getPortSize();
                this.f5.setPortSize(dDimension.width, dDimension.height);
                dDimension = this.f6.getContentSize();
                this.f5.setContentSize(dDimension.width, dDimension.height);
                dDimension = this.f6.getOffset();
                this.f5.setOffset(dDimension.width, dDimension.height);
                return true;
            }
            if (event.id == ScrolledPanel.OFFSET) {
                DDimension dDimension = this.f6.getOffset();
                this.f5.setOffset(dDimension.width, dDimension.height);
                return true;
            }
        } else if (event.target instanceof ViewportScroller) {
            if (event.id == ViewportScroller.SCROLL) {
                this.f2.setWireframe(true);
                this.f6.scrollTo((int)this.f5.getOffsetX(), (int)this.f5.getOffsetY());
            }
            if (event.id == ViewportScroller.DONE) {
                this.f2.setWireframe(false);
                this.f6.scrollTo((int)this.f5.getOffsetX(), (int)this.f5.getOffsetY());
            }
        } else if (event.target instanceof AngleControlPanel) {
            DPoint dPoint;
            if (event.id == AngleControlPanel.ANGLE) {
                dPoint = (DPoint)event.arg;
                this.f2.setWireframe(true);
                this.f2.setViewAngles(dPoint.x, dPoint.y);
            }
            if (event.id == AngleControlPanel.DONE) {
                dPoint = (DPoint)event.arg;
                this.f2.setWireframe(false);
                this.f2.setViewAngles(dPoint.x, dPoint.y);
            }
        } else if (event.target instanceof GraphCanvas) {
            if (event.id == 38792) {
                this.f13.setState(this.f1.isDirected());
            }
        } else if (event.id == 201) {
            this.m2();
            return false;
        }
        return super.handleEvent(event);
    }

    public boolean keyDown(Event event, int n) {
        if (event.id == 401) {
            if (n == 115) {
                this.f4.setState(!this.f4.getState());
            } else {
                this.f2.keyDown(event, n);
            }
            if (this.f4.getState()) {
                this.f3.show();
            } else {
                this.f3.hide();
            }
            this.validate();
        }
        return false;
    }

    private void m2() {
        this.dispose();
    }

    public void addAlgorithm(GraphAlgorithm graphAlgorithm, String string) {
        MenuItem menuItem = new MenuItem(string);
        this.f9.add(menuItem);
        this.f10.put(menuItem, graphAlgorithm);
        this.f11.put(string, graphAlgorithm);
    }

    public void addAlgorithmMenu(String string) {
        Menu menu = new Menu(string);
        this.f9.add(menu);
        this.f12.put(string, menu);
    }

    public void addAlgorithm(GraphAlgorithm graphAlgorithm, String string, String string2) {
        Menu menu = (Menu)this.f12.get(string);
        if (menu != null) {
            MenuItem menuItem = new MenuItem(string2);
            menu.add(menuItem);
            this.f10.put(menuItem, graphAlgorithm);
            this.f11.put(string + "." + string2, graphAlgorithm);
        }
    }

    private void m3() {
        if (this.f14 != null) {
            this.setTitle("VGJ:   " + this.f14);
        }
    }

    public static void setContext(URL uRL) {
        f20 = uRL;
    }

    public void loadFile(String string) {
        try {
            File file = new File(string);
            int n = (int)file.length();
            int n2 = 0;
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[n];
            while (n2 < n) {
                n2 += fileInputStream.read(byArray, n2, n - n2);
            }
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(new String(byArray, 0));
            GMLlexer gMLlexer = new GMLlexer(stringBufferInputStream);
            try {
                this.f15 = new GMLobject(gMLlexer, null);
                GMLobject gMLobject = this.f15.getGMLSubObject("graph", 3, false);
                if (gMLobject == null) {
                    this.f15 = null;
                    new MessageDialog((Frame)this, "Error", "File does not contain a graph.", true);
                    return;
                }
                Graph graph = new Graph(gMLobject);
                this.f1.copy(graph);
                this.f2.update(true);
                this.f14 = string;
                this.m3();
                return;
            }
            catch (ParseError parseError) {
                new MessageDialog((Frame)this, "Error", parseError.getMessage() + " at line " + gMLlexer.getLineNumber() + " at or near \"" + gMLlexer.getStringval() + "\".", true);
                return;
            }
            catch (IOException iOException) {
                new MessageDialog((Frame)this, "Error", iOException.getMessage(), true);
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            new MessageDialog((Frame)this, "Error", "Error loading file  \"" + string + "\".", true);
            return;
        }
        catch (IOException iOException) {
            new MessageDialog((Frame)this, "Error", iOException.getMessage(), true);
            return;
        }
    }

    public void selectNode(int n) {
        this.f2.selectNode(n);
    }

    private void m4(GraphAlgorithm graphAlgorithm) {
        if (this.f1.numberOfNodes() < 1) {
            new MessageDialog((Frame)this, "Error", "Graph is empty.", true);
            return;
        }
        this.f1.removeGroups();
        this.f1.pack();
        this.f2.setWireframe(true);
        String string = graphAlgorithm.compute(this.f1, this.f2);
        this.f2.setWireframe(false);
        if (string != null) {
            new MessageDialog((Frame)this, "Message", string, true);
        }
        this.f2.update(true);
    }

    public void applyAlgorithm(String string) {
        GraphAlgorithm graphAlgorithm = (GraphAlgorithm)this.f11.get(string);
        if (graphAlgorithm != null) {
            this.m4(graphAlgorithm);
        }
    }

    public void scrollTo(int n, int n2) {
        this.f6.scrollTo(n, n2);
        this.f5.setOffset(n, n2);
    }

    public void TWUpdate() {
        if (this.isShowing() && this.f1.firstNode() != null) {
            TreeAlgorithm treeAlgorithm = (TreeAlgorithm)this.f11.get("Tree.Tree Down");
            treeAlgorithm.setRoot(((TWGraph)this.f1).getRoot());
            this.m4(treeAlgorithm);
            ((TWGraph)this.f1).getFocus();
        }
    }
}

