/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.gui;

import EDU.auburn.VGJ.gui.GraphCanvas;
import EDU.auburn.VGJ.gui.LPanel;
import EDU.auburn.VGJ.gui.MessageDialog;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextField;

public class FontPropDialog
extends Dialog {
    private GraphCanvas f1;
    private Frame f2;
    private TextField f3;
    private TextField f4;

    public FontPropDialog(Frame frame, GraphCanvas graphCanvas) {
        super(frame, "Font", true);
        this.f1 = graphCanvas;
        this.f2 = frame;
        LPanel lPanel = new LPanel();
        lPanel.addLabel("Font Name", 1, 1, 0.0, 1.0, 0, 2);
        this.f3 = lPanel.addTextField(15, 0, -1, 1.0, 1.0, 1, 1);
        lPanel.addLabel("Font Size", 1, 1, 0.0, 1.0, 0, 2);
        this.f4 = lPanel.addTextField(15, 0, -1, 1.0, 1.0, 1, 1);
        lPanel.addButtonPanel("Apply Cancel", 0);
        lPanel.finish();
        this.add("Center", lPanel);
        this.showMe();
    }

    public void showMe() {
        this.pack();
        Font font = this.f1.getFont();
        this.f3.setText(font.getName());
        this.f4.setText(String.valueOf(font.getSize()));
        this.show();
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            if ("Apply".equals(object)) {
                boolean bl = true;
                try {
                    Font font = new Font(this.f3.getText(), 0, Integer.valueOf(this.f4.getText()));
                    this.f1.setFont(font);
                }
                catch (NumberFormatException numberFormatException) {
                    new MessageDialog(this.f2, "Error", "Bad format for font size.", true);
                    bl = false;
                }
                if (bl) {
                    this.hide();
                }
            } else if ("Cancel".equals(object)) {
                this.hide();
            }
        }
        return false;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.hide();
            return true;
        }
        return super.handleEvent(event);
    }
}

