/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.graph;

import EDU.auburn.VGJ.graph.Graph;
import EDU.auburn.VGJ.graph.Node;
import TWHelp.Sector;
import TWHelp.TWInfo;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;

public class TWGraph
extends Graph {
    TWInfo info;
    Vector index;
    double twopie = Math.PI * 2;
    Node root;
    Sector currentCS;
    Hashtable expansion;
    Vector bubbleV;

    public TWGraph(TWInfo tWInfo) {
        super(true);
        this.info = tWInfo;
        this.index = new Vector();
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node node) {
        this.root = node;
    }

    public Sector getCS() {
        return this.currentCS;
    }

    public void setCS(Sector sector) {
        this.currentCS = sector;
    }

    public Node getFocus() {
        Node node;
        block3: {
            block2: {
                if (this.info.getCS() == null) break block2;
                TWGraph tWGraph = this;
                node = tWGraph.getNodeFromId(tWGraph.info.getCS().number);
                if (node != null) break block3;
            }
            node = this.getRoot();
        }
        return node;
    }

    public void deleteAll() {
        int n;
        while ((n = this.firstNodeIndex()) != -1) {
            this.removeNode(n);
        }
    }

    public void updateNodes() {
        Node node = this.firstNode();
        while (node != null) {
            Sector sector;
            if (!node.isGroup() && (sector = this.getSectorFromNode(node)) != null) {
                this.assignColor(node, sector);
            }
            node = this.nextNode(node);
        }
        if (this.firstNode() != null) {
            TWGraph tWGraph = this;
            if (tWGraph.getNodeFromId(tWGraph.info.getCS().number) != null) {
                TWGraph tWGraph2 = this;
                tWGraph2.addChildren(tWGraph2.info.getCS(), null);
            }
        }
    }

    public void rebuildGraph(Sector sector, int n) {
        this.deleteAll();
        this.expansion = new Hashtable();
        TWGraph tWGraph = this;
        tWGraph.setRoot(tWGraph.addSector(sector, null, 0.0, 0.0));
        Vector<Sector> vector = new Vector<Sector>();
        vector.add(sector);
        int n2 = 0;
        while (n2 < n) {
            Vector vector2 = new Vector();
            int n3 = 0;
            while (n3 < vector.size()) {
                this.addChildren((Sector)vector.elementAt(n3), vector2);
                ++n3;
            }
            vector = vector2;
            ++n2;
        }
    }

    public void rebuildGraphFromBubble(Sector sector, Vector vector) {
        this.deleteAll();
        this.expansion = new Hashtable();
        TWGraph tWGraph = this;
        tWGraph.setRoot(tWGraph.addSector(sector, null, 0.0, 0.0));
        Vector<Sector> vector2 = new Vector<Sector>();
        vector2.add(sector);
        vector.addElement(sector);
        this.bubbleV = vector;
        while (vector2.size() > 0) {
            Vector vector3 = new Vector();
            int n = 0;
            while (n < vector2.size()) {
                Sector sector2 = (Sector)vector2.elementAt(n);
                if (vector.contains(sector2)) {
                    this.addChildren(sector2, vector3);
                }
                ++n;
            }
            vector2 = vector3;
        }
    }

    public Sector getSectorFromNode(Node node) {
        return this.info.getSector(node.getId());
    }

    public boolean addChildren(Node node) {
        TWGraph tWGraph = this;
        return tWGraph.addChildren(tWGraph.getSectorFromNode(node), null);
    }

    public boolean addChildren(Sector sector, Vector vector) {
        Node node = this.getNodeFromId(sector.number);
        if (node == null) {
            return false;
        }
        boolean bl = false;
        Vector vector2 = sector.getWarps();
        int n = 0;
        while (n < vector2.size()) {
            Sector sector2 = (Sector)vector2.elementAt(n);
            int n2 = this.getIndexFromId(sector2.number);
            if (n2 == -1) {
                bl = true;
                node.addChild(this.addSector(sector2, sector, 0.0, 0.0));
                if (vector != null) {
                    vector.addElement(sector2);
                }
            } else {
                TWGraph tWGraph = this;
                if (tWGraph.getEdge(tWGraph.getIndexFromId(sector.number), n2) == null) {
                    TWGraph tWGraph2 = this;
                    tWGraph2.insertEdge(tWGraph2.getIndexFromId(sector.number), n2);
                }
            }
            ++n;
        }
        this.expansion.put(new Integer(sector.number), new Boolean(true));
        return bl;
    }

    public void deleteChildren(Node node) {
        Vector vector = node.getAllChildren();
        int n = 0;
        while (n < vector.size()) {
            Node node2 = (Node)vector.elementAt(n);
            this.deleteChildren(node2);
            this.removeNode(node2);
            ++n;
        }
        node.deleteChildren();
    }

    public Node addSector(Sector sector, Sector sector2, double d, double d2) {
        String string = Integer.toString(sector.number);
        if (sector.port != null) {
            string = string + " - " + sector.port.getTypeString();
        }
        TWGraph tWGraph = this;
        int n = tWGraph.insertNodeAtId(sector.number);
        Node node = tWGraph.getNodeFromIndex(n);
        node.setPosition(d, d2);
        node.setLabel(string);
        if (sector2 != null) {
            TWGraph tWGraph2 = this;
            tWGraph2.insertEdge(tWGraph2.getIndexFromId(sector2.number), n);
            if (!Sector.isOneWayWarp(sector2, sector)) {
                this.insertEdge(n, this.getIndexFromId(sector2.number));
            }
        }
        this.index.addElement(new Integer(n));
        this.assignColor(node, sector);
        Boolean bl = (Boolean)this.expansion.get(new Integer(sector.number));
        if (bl != null) {
            if (bl.booleanValue()) {
                this.addChildren(sector, null);
            }
        } else {
            this.expansion.put(new Integer(sector.number), new Boolean(false));
        }
        return node;
    }

    void assignColor(Node node, Sector sector) {
        if (this.bubbleV != null && this.bubbleV.contains(sector)) {
            node.setColor(Color.black);
            return;
        }
        if (this.info.getCS() == sector) {
            node.setColor(Color.magenta);
            return;
        }
        if (sector.isDeadEnd()) {
            node.setColor(Color.blue);
            return;
        }
        if (sector.getVisited()) {
            node.setColor(Color.green);
            return;
        }
        node.setColor(Color.red);
    }

    public void expandOrCollapseNode(Node node) {
        Boolean bl = (Boolean)this.expansion.get(node.getIdObject());
        if (bl != null) {
            if (bl.booleanValue()) {
                this.deleteChildren(node);
                this.expansion.put(node.getIdObject(), new Boolean(false));
                return;
            }
            this.addChildren(node);
            return;
        }
        System.out.println("EXPANDED OBJECT DID NOT EXIST");
    }
}

