/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.graph;

import EDU.auburn.VGJ.graph.Edge;
import EDU.auburn.VGJ.graph.GMLobject;
import EDU.auburn.VGJ.graph.Node;
import EDU.auburn.VGJ.graph.NodeList;
import EDU.auburn.VGJ.graph.Set;
import EDU.auburn.VGJ.util.DDimension3;
import EDU.auburn.VGJ.util.DPoint3;
import java.awt.Point;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Graph
implements Cloneable {
    private NodeList f1 = new NodeList();
    private Hashtable f2 = new Hashtable();
    private boolean f3 = false;
    private int f4 = 0;
    private Hashtable f5 = new Hashtable();

    public Graph() {
    }

    public Graph(boolean bl) {
        this.f3 = bl;
    }

    public Graph(GMLobject gMLobject) {
        Object object;
        Object object2;
        this.f3 = false;
        Integer n = (Integer)gMLobject.getValue("directed", 0);
        if (n != null) {
            this.f3 = n != 0;
        }
        GMLobject gMLobject2 = gMLobject.getGMLSubObject("node", 3, false);
        while (gMLobject2 != null) {
            Node node = new Node(gMLobject2);
            object2 = node.getIdObject();
            if (object2 != null) {
                if (!this.f2.containsKey(object2)) {
                    this.f2.put(object2, node);
                    this.f1.addNode(node);
                }
            } else {
                this.f1.addNode(node);
            }
            gMLobject2 = gMLobject.getNextGMLSubObject();
        }
        object2 = gMLobject.getGMLSubObject("edge", 3, false);
        while (object2 != null) {
            object = (Integer)((GMLobject)object2).getValue("source", 0);
            Integer n2 = (Integer)((GMLobject)object2).getValue("target", 0);
            if (object != null && n2 != null) {
                Node node = (Node)this.f2.get(object);
                Node node2 = (Node)this.f2.get(n2);
                if (node != null && node2 != null) {
                    this.insertEdge(new Edge(node, node2, (GMLobject)object2));
                }
            }
            object2 = gMLobject.getNextGMLSubObject();
        }
        this.m1();
        object = this.firstNode();
        while (object != null) {
            if (((Node)object).inGroup()) {
                ((Node)object).groupNode_ = (Node)this.f2.get(new Integer(((Node)object).groupNodeId_));
                if (((Node)object).groupNode_ != null) {
                    ((Node)object).groupNode_.isGroup_ = true;
                    ((Node)object).groupNode_.setChild(((Node)object).getIndex());
                }
            }
            object = this.nextNode((Node)object);
        }
    }

    private void m1() {
        this.f4 = 0;
        while (this.f2.containsKey(new Integer(this.f4))) {
            ++this.f4;
        }
        Node node = this.firstNode();
        while (node != null) {
            if (node.getIdObject() == null) {
                node.id_ = this.f4;
                node.haveId_ = true;
                this.f2.put(new Integer(this.f4), node);
                do {
                    ++this.f4;
                } while (this.f2.containsKey(new Integer(this.f4)));
            }
            node = this.nextNode(node);
        }
    }

    public void setGMLvalues(GMLobject gMLobject) {
        Object object;
        gMLobject.deleteAll("node", 3);
        Node node = this.f1.firstNode();
        while (node != null) {
            object = new GMLobject("node", 3);
            gMLobject.addObjectToEnd((GMLobject)object);
            node.setGMLvalues((GMLobject)object);
            node = this.f1.nextNode(node);
        }
        gMLobject.setValue("directed", 0, new Integer(this.f3 ? 1 : 0));
        gMLobject.deleteAll("edge", 3);
        object = this.f5.elements();
        while (object.hasMoreElements()) {
            Edge edge = (Edge)object.nextElement();
            if (!this.f3 && edge.tail().getIndex() > edge.head().getIndex()) continue;
            GMLobject gMLobject2 = new GMLobject("edge", 3);
            gMLobject.addObjectToEnd(gMLobject2);
            edge.setGMLvalues(gMLobject2);
        }
    }

    public boolean isDirected() {
        if (this.f3) {
            return this.f3;
        }
        return this.f3;
    }

    public Object clone() {
        try {
            Object object;
            Graph graph = (Graph)super.clone();
            ((Graph)super.clone()).f1 = (NodeList)this.f1.clone();
            graph.f2 = new Hashtable();
            graph.f5 = new Hashtable();
            graph.f3 = this.f3;
            graph.f4 = this.f4;
            Enumeration enumeration = this.f5.elements();
            while (enumeration.hasMoreElements()) {
                object = (Edge)enumeration.nextElement();
                Node node = graph.f1.nodeFromIndex(((Edge)object).tail_.getIndex());
                Node node2 = graph.f1.nodeFromIndex(((Edge)object).head_.getIndex());
                Edge edge = new Edge(node, node2, (Edge)object);
                graph.f5.put(new Point(node.index_, node2.index_), edge);
            }
            object = graph.firstNode();
            while (object != null) {
                graph.f2.put(new Integer(((Node)object).getId()), object);
                object = graph.nextNode((Node)object);
            }
            return graph;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void copy(Graph graph) {
        this.f3 = graph.f3;
        this.f1 = graph.f1;
        this.f2 = graph.f2;
        this.f5 = graph.f5;
        this.f4 = graph.f4;
    }

    public int insertNode() {
        return this.insertNode(false);
    }

    public int insertNode(boolean bl) {
        Node node = new Node(bl);
        this.f1.addNode(node);
        node.haveId_ = true;
        node.id_ = this.f4;
        this.f2.put(new Integer(this.f4), node);
        do {
            ++this.f4;
        } while (this.f2.containsKey(new Integer(this.f4)));
        return node.index_;
    }

    public int insertNodeAtId(int n) {
        Node node = new Node(false);
        this.f1.addNode(node);
        node.haveId_ = true;
        node.id_ = n;
        this.f2.put(new Integer(n), node);
        return node.index_;
    }

    public Node getNodeFromIndex(int n) {
        return this.f1.nodeFromIndex(n);
    }

    public Node getNodeFromId(int n) {
        return (Node)this.f2.get(new Integer(n));
    }

    public int getIndexFromId(int n) {
        Node node = (Node)this.f2.get(new Integer(n));
        if (node == null) {
            return -1;
        }
        return this.getIndexFromNode(node);
    }

    public void insertNodeAt(int n) throws IOException {
        IOException iOException = new IOException("Node " + n + " already exist.");
        if (this.f1.nodeFromIndex(n) == null) {
            Node node = new Node();
            this.f1.addNodeAt(node, n);
            node.haveId_ = true;
            node.id_ = this.f4;
            this.f2.put(new Integer(this.f4), node);
            do {
                ++this.f4;
            } while (this.f2.containsKey(new Integer(this.f4)));
            return;
        }
        throw iOException;
    }

    public void removeNode(int n) {
        int n2;
        new Set();
        new Set();
        Node node = this.f1.nodeFromIndex(n);
        if (node.isGroup()) {
            n2 = node.firstChild();
            while (n2 != -1) {
                this.removeNode(n2);
                n2 = node.nextChild();
            }
        } else {
            n2 = node.firstChild();
            while (n2 != -1) {
                this.removeEdge(n, n2);
                n2 = node.nextChild();
            }
            Node node2 = this.f1.firstNode();
            while (node2 != null) {
                if (node2.hasChild(n)) {
                    this.removeEdge(node2.getIndex(), n);
                }
                node2 = this.f1.nextNode(node2);
            }
        }
        this.f1.removeNodeAt(n);
        Integer n3 = node.getIdObject();
        this.f2.remove(n3);
        if (n3 < this.f4) {
            this.f4 = n3;
        }
        if (node.inGroup()) {
            node.groupNode_.clearChild(node.getIndex());
            if (node.groupNode_.firstChild() == -1) {
                this.removeNode(node.groupNode_.getIndex());
            }
        }
    }

    public void removeNode(Node node) {
        this.removeNode(node.getIndex());
    }

    public void insertEdge(int n, int n2) {
        this.insertEdge(n, n2, new DPoint3[0]);
    }

    public void insertEdge(int n, int n2, DPoint3[] dPoint3Array) {
        this.insertEdge(new Edge(this.f1.nodeFromIndex(n), this.f1.nodeFromIndex(n2), dPoint3Array, false));
    }

    public void insertEdge(int n, int n2, DPoint3[] dPoint3Array, String string) {
        Edge edge = new Edge(this.f1.nodeFromIndex(n), this.f1.nodeFromIndex(n2), dPoint3Array, false);
        this.insertEdge(edge);
        edge.setLabel(string);
    }

    public void insertEdge(Edge edge) {
        int n = edge.tail().getIndex();
        int n2 = edge.head().getIndex();
        this.f5.remove(new Point(n, n2));
        if (!this.f3) {
            this.f5.remove(new Point(n2, n));
        }
        edge.tail().setChild(n2);
        if (!this.f3) {
            edge.head().setChild(n);
        }
        this.f5.put(new Point(n, n2), edge);
        DPoint3[] dPoint3Array = edge.points();
        if (!this.f3 && n != n2) {
            int n3 = dPoint3Array.length;
            DPoint3[] dPoint3Array2 = new DPoint3[n3];
            int n4 = 0;
            while (n4 < n3) {
                dPoint3Array2[n4] = dPoint3Array[n3 - 1 - n4];
                ++n4;
            }
            this.f5.put(new Point(n2, n), new Edge(edge.head(), edge.tail(), dPoint3Array2, false));
        }
    }

    public DPoint3[] getEdgePathPoints(int n, int n2) {
        Edge edge = (Edge)this.f5.get(new Point(n, n2));
        if (edge == null) {
            return null;
        }
        return edge.points();
    }

    public Edge getEdge(int n, int n2) {
        return (Edge)this.f5.get(new Point(n, n2));
    }

    public void removeEdge(int n, int n2) {
        this.f1.nodeFromIndex(n).clearChild(n2);
        this.f5.remove(new Point(n, n2));
        if (!this.f3 && n != n2) {
            this.f1.nodeFromIndex(n2).clearChild(n);
            this.f5.remove(new Point(n2, n));
        }
    }

    public void removeEdge(Edge edge) {
        this.removeEdge(edge.tail().getIndex(), edge.head().getIndex());
    }

    public Set parents(int n) {
        Set set = new Set();
        Node node = this.f1.firstNode();
        while (node != null) {
            if (node.hasChild(n)) {
                set.includeElement(node.index_);
            }
            node = this.f1.nextNode(node);
        }
        return set;
    }

    public Set children(int n) {
        return this.f1.nodeFromIndex(n).getChildren();
    }

    public int numberOfNodes() {
        return this.f1.count();
    }

    public Node firstNode() {
        return this.f1.firstNode();
    }

    public Node nextNode(Node node) {
        return this.f1.nextNode(node);
    }

    public int getIndexFromNode(Node node) {
        return node.index_;
    }

    public int firstNodeIndex() {
        return this.f1.firstNodeIndex();
    }

    public int nextNodeIndex(int n) {
        return this.f1.nextNodeIndex(n);
    }

    public int firstAvailable() {
        return this.f1.getFirstAvailable();
    }

    public int highestIndex() {
        return this.f1.highestIndex();
    }

    public void setDirected(boolean bl) {
        if (bl != this.f3) {
            if (bl) {
                this.f3 = true;
                this.m3();
                return;
            }
            this.m2();
            this.f3 = false;
        }
    }

    private void m2() {
        Enumeration enumeration = this.f5.elements();
        while (enumeration.hasMoreElements()) {
            DPoint3[] dPoint3Array;
            Edge edge = (Edge)enumeration.nextElement();
            if (this.f5.get(new Point(edge.head().getIndex(), edge.tail().getIndex())) != null) continue;
            int n = edge.tail().getIndex();
            int n2 = edge.head().getIndex();
            edge.head().setChild(n);
            if (n > n2) {
                DPoint3[] dPoint3Array2 = edge.points();
                int n3 = dPoint3Array2.length;
                dPoint3Array = new DPoint3[n3];
                int n4 = 0;
                while (n4 < n3) {
                    dPoint3Array[n4] = dPoint3Array2[n3 - 1 - n4];
                    ++n4;
                }
            } else {
                dPoint3Array = new DPoint3[]{};
            }
            this.f5.put(new Point(n2, n), new Edge(edge.head(), edge.tail(), dPoint3Array, true));
        }
    }

    private void m3() {
        Enumeration enumeration = this.f5.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isDummy()) continue;
            edge.tail().clearChild(edge.head().getIndex());
            this.f5.remove(new Point(edge.tail().getIndex(), edge.head().getIndex()));
        }
    }

    public void pack() {
        int n = this.numberOfNodes();
        if (n != this.f1.highestIndex() + 1) {
            Node node;
            int n2 = this.f1.highestIndex();
            int[] nArray = new int[n2 + 1];
            int n3 = this.nextNodeIndex(n - 1);
            while (n3 != -1) {
                node = this.getNodeFromIndex(n3);
                this.f1.addNode(node);
                nArray[n3] = node.index_;
                this.f1.removeNodeAt(n3);
                n3 = this.nextNodeIndex(n3);
            }
            node = this.firstNode();
            while (node != null) {
                int n4 = node.searchNextChild(n - 1);
                while (n4 != -1) {
                    if (n4 >= n) {
                        node.setChild(nArray[n4]);
                        node.clearChild(n4);
                    }
                    n4 = node.searchNextChild(n4 + 1);
                }
                node = this.nextNode(node);
            }
            Enumeration enumeration = this.f5.keys();
            while (enumeration.hasMoreElements()) {
                Point point = (Point)enumeration.nextElement();
                if (point.x < n && point.y < n) continue;
                if (point.x > n2 || point.y > n2) {
                    this.f5.remove(point);
                    continue;
                }
                Edge edge = (Edge)this.f5.get(point);
                this.f5.remove(point);
                if (point.x >= n) {
                    point.x = nArray[point.x];
                }
                if (point.y >= n) {
                    point.y = nArray[point.y];
                }
                this.f5.put(point, edge);
            }
        }
    }

    public void removeEdgePaths() {
        Enumeration enumeration = this.f5.elements();
        while (enumeration.hasMoreElements()) {
            ((Edge)enumeration.nextElement()).points_ = new DPoint3[0];
        }
    }

    public void dummysToEdgePaths() {
        Node node = this.firstNode();
        while (node != null) {
            if (!node.isDummy_) {
                int n = node.firstChild();
                while (n != -1) {
                    Node node2;
                    Node node3 = node2 = this.getNodeFromIndex(n);
                    int n2 = 0;
                    String string = this.getEdge(node.index_, n).getLabel();
                    while (node3 != null && node3.isDummy_) {
                        ++n2;
                        node3 = this.getNodeFromIndex(node3.firstChild());
                    }
                    if (n2 > 0 && node3 != null) {
                        DPoint3[] dPoint3Array = new DPoint3[n2];
                        node3 = node2;
                        int n3 = 0;
                        while (node3.isDummy_) {
                            dPoint3Array[n3++] = new DPoint3(node3.getPosition3());
                            node3 = this.getNodeFromIndex(node3.firstChild());
                        }
                        this.insertEdge(node.index_, node3.index_, dPoint3Array, string);
                    }
                    n = node.nextChild();
                }
            }
            node = this.nextNode(node);
        }
        node = this.firstNode();
        while (node != null) {
            if (node.isDummy_) {
                this.removeNode(node);
            }
            node = this.nextNode(node);
        }
    }

    public Enumeration getEdges() {
        return this.f5.elements();
    }

    public Node nodeFromIndex(int n) {
        return this.f1.nodeFromIndex(n);
    }

    public void group(Node node, boolean bl) {
        if (bl && node.groupNode_ != null) {
            node.groupNode_.groupActive_ = true;
            Node node2 = node.groupNode_;
            this.m6(node2, true);
            DPoint3 dPoint3 = new DPoint3(0.0, 0.0, 0.0);
            DDimension3 dDimension3 = new DDimension3(0.0, 0.0, 0.0);
            int n = this.m4(node2, dPoint3, dDimension3);
            dPoint3.x /= (double)n;
            dPoint3.y /= (double)n;
            dPoint3.z /= (double)n;
            dDimension3.width = Math.sqrt(dDimension3.width);
            dDimension3.height = Math.sqrt(dDimension3.height);
            dDimension3.depth = Math.sqrt(dDimension3.depth);
            node2.setPosition(dPoint3);
            node2.setBoundingBox(dDimension3);
            node2.grouppos_ = dPoint3;
            node2.groupbox_ = dDimension3;
            return;
        }
        if (!bl && node.isGroup_) {
            node.groupActive_ = false;
            this.m6(node, false);
            node.setSelected(false);
            double d = node.x_ - node.grouppos_.x;
            double d2 = node.y_ - node.grouppos_.y;
            double d3 = node.z_ - node.grouppos_.z;
            double d4 = node.width_ / node.groupbox_.width;
            double d5 = node.height_ / node.groupbox_.height;
            double d6 = node.depth_ / node.groupbox_.depth;
            this.m5(node, d, d2, d3, d4, d5, d6);
        }
    }

    private int m4(Node node, DPoint3 dPoint3, DDimension3 dDimension3) {
        int n = 0;
        int n2 = node.firstChild();
        while (n2 != -1) {
            Node node2 = this.getNodeFromIndex(n2);
            if (node2.isGroup() && !node2.groupActive()) {
                n += this.m4(node2, dPoint3, dDimension3);
            } else {
                ++n;
                dDimension3.width += node2.width_ * node2.width_;
                dDimension3.height += node2.height_ * node2.height_;
                dDimension3.depth += node2.depth_ * node2.depth_;
                dPoint3.x += node2.x_;
                dPoint3.y += node2.y_;
                dPoint3.z += node2.z_;
            }
            n2 = node.nextChild();
        }
        return n;
    }

    private void m5(Node node, double d, double d2, double d3, double d4, double d5, double d6) {
        int n = node.firstChild();
        while (n != -1) {
            Node node2 = this.getNodeFromIndex(n);
            if (node2.isGroup() && !node2.groupActive()) {
                this.m5(node2, d, d2, d3, d4, d5, d6);
            } else {
                node2.x_ += d;
                node2.y_ += d2;
                node2.z_ += d3;
                node2.width_ *= d4;
                node2.height_ *= d5;
                node2.depth_ *= d6;
            }
            n = node.nextChild();
        }
    }

    private void m6(Node node, boolean bl) {
        int n = node.firstChild();
        while (n != -1) {
            Node node2 = this.getNodeFromIndex(n);
            this.getNodeFromIndex(n).inActiveGroup_ = bl;
            if (node2.isGroup_ && (bl || !node2.groupActive_)) {
                this.m6(node2, bl);
            }
            n = node.nextChild();
        }
    }

    public void killGroup(Node node) {
        if (node.isGroup()) {
            int n = node.firstChild();
            while (n != -1) {
                node.clearChild(n);
                Node node2 = this.getNodeFromIndex(n);
                this.getNodeFromIndex(n).inActiveGroup_ = false;
                node2.groupNode_ = null;
                if (node2.isGroup() && !node2.groupActive_) {
                    this.m6(node2, false);
                }
                n = node.nextChild();
            }
            this.removeNode(node.getIndex());
        }
    }

    public void setNodeGroup(Node node, Node node2) {
        if (node.inGroup()) {
            Node node3 = node.groupNode_;
            node3.clearChild(node.getIndex());
            if (node3.firstChild() == -1) {
                this.removeNode(node3.getIndex());
            }
        }
        node.groupNode_ = node2;
        node2.setChild(node.getIndex());
    }

    public void removeGroups() {
        int n = this.f1.firstNodeIndex();
        while (n != -1) {
            Graph graph = this;
            graph.killGroup(graph.getNodeFromIndex(n));
            n = this.f1.nextNodeIndex(n);
        }
    }
}

