/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.graph;

import EDU.auburn.VGJ.graph.Edge;
import EDU.auburn.VGJ.graph.Graph;
import EDU.auburn.VGJ.gui.InputDialog;
import EDU.auburn.VGJ.gui.LPanel;
import EDU.auburn.VGJ.gui.MessageDialog;
import EDU.auburn.VGJ.util.DPoint3;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class EdgePropertiesDialog
extends Dialog {
    private TextField f1;
    private TextArea f2;
    private TextArea f3;
    private Panel f4;
    private Edge f5;
    private Graph f6;
    private Component[] f7 = new Component[3];
    private int f8 = 0;
    private Frame f9;
    private Choice f10;
    private Choice f11;
    private Hashtable f12;
    private String f13;

    public EdgePropertiesDialog(Frame frame, Edge edge, Graph graph) {
        super(frame, "", true);
        this.f9 = frame;
        this.f6 = graph;
        this.f5 = edge;
        LPanel lPanel = new LPanel();
        new LPanel().constraints.weighty = 0.0;
        this.f7[this.f8++] = lPanel.addLineLabel("Label:", 1);
        this.f1 = lPanel.addTextField(8, 0, -1, 1.0, 0.0, 1, 1);
        lPanel.addLineLabel("Line Style", 1);
        this.f10 = new Choice();
        int n = 0;
        while (n < Edge.styleLabels.length) {
            this.f10.addItem(Edge.styleLabels[n]);
            ++n;
        }
        lPanel.addComponent(this.f10, 0, -1, 1.0, 0.0, 0, 1);
        lPanel.addLineLabel("Points in order x y z:", 0);
        this.f2 = new TextArea(4, 20);
        this.f2.setBackground(Color.white);
        lPanel.addComponent(this.f2, 0, -1, 1.0, 1.0, 3, 0);
        lPanel.constraints.gridwidth = 1;
        lPanel.constraints.weightx = 0.0;
        lPanel.addLineLabel("Data", 1);
        this.f11 = new Choice();
        this.f4 = new Panel();
        this.f4.add(this.f11);
        lPanel.addComponent(this.f4, 0, -1, 1.0, 0.0, 0, 1);
        this.f3 = new TextArea(4, 20);
        this.f3.setBackground(Color.white);
        lPanel.constraints.insets.top = 0;
        lPanel.addComponent(this.f3, 0, -1, 1.0, 1.0, 3, 0);
        lPanel.addButtonPanel("Apply Cancel", 0);
        lPanel.finish();
        this.add("Center", lPanel);
        EdgePropertiesDialog edgePropertiesDialog = this;
        edgePropertiesDialog.setEdge(edgePropertiesDialog.f5, this.f6);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            if ("Apply".equals(object)) {
                if (this.m1()) {
                    this.hide();
                }
                return true;
            }
            if ("Cancel".equals(object)) {
                this.hide();
                return true;
            }
        } else if (event.target == this.f11) {
            this.f12.put(this.f13, this.f3.getText());
            String string = this.f13;
            this.f13 = this.f11.getSelectedItem();
            if (!this.f13.equals("<NEW>")) {
                String string2 = (String)this.f12.get(this.f13);
                if (string2 == null) {
                    string2 = new String("");
                }
                this.f3.setText(string2);
            } else {
                new InputDialog(this.f9, "Enter name for new data item (must be a letter followed by letters and numbers).", this, 9999);
                if (this.f11.getSelectedItem().equals("<NEW>")) {
                    this.f11.select(string);
                }
            }
        }
        return false;
    }

    private boolean m1() {
        block14: {
            String string = this.f2.getText();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,", false);
            int n = stringTokenizer.countTokens();
            if (n % 3 != 0) {
                new MessageDialog(this.f9, "Error", "Expecting sets of three numbers for points", true);
            } else {
                Object object;
                int n2 = n / 3;
                DPoint3[] dPoint3Array = new DPoint3[n2];
                int n3 = 0;
                while (n3 < n2) {
                    dPoint3Array[n3] = new DPoint3();
                    ++n3;
                }
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    int n5 = 0;
                    while (n5 < 3) {
                        double d;
                        String string2 = stringTokenizer.nextToken();
                        try {
                            d = new Double(string2);
                        }
                        catch (Exception exception) {
                            char c = 'X';
                            if (n5 == 1) {
                                c = 'Y';
                            }
                            if (n5 == 2) {
                                c = 'Z';
                            }
                            new MessageDialog(this.f9, "Error", "Element " + c + " of point " + n4 + " is not" + " a number.", true);
                            break block14;
                        }
                        if (n5 == 0) {
                            dPoint3Array[n4].x = d;
                        } else if (n5 == 1) {
                            dPoint3Array[n4].y = d;
                        } else {
                            dPoint3Array[n4].z = d;
                        }
                        ++n5;
                    }
                    ++n4;
                }
                this.f12.put(this.f13, this.f3.getText());
                Enumeration enumeration = this.f12.keys();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    String string3 = (String)this.f12.get(object);
                    if (string3 == null || string3.length() == 0) continue;
                    this.f5.data_.put(object, string3);
                }
                object = new Edge(this.f5.tail(), this.f5.head(), dPoint3Array, false);
                this.f6.insertEdge((Edge)object);
                ((Edge)object).setLabel(this.f1.getText());
                ((Edge)object).setLineStyle(this.f10.getSelectedIndex());
                ((Edge)object).data_ = this.f5.data_;
                return true;
            }
        }
        return false;
    }

    public void setEdge(Edge edge, Graph graph) {
        String string;
        this.f6 = graph;
        this.f5 = edge;
        String string2 = "Edge " + this.f5.tail().id_ + " " + this.f5.head().id_;
        this.setTitle(string2);
        this.f10.select(this.f5.getLineStyle());
        this.f1.setText(this.f5.getLabel());
        String string3 = new String();
        DPoint3[] dPoint3Array = this.f5.points();
        int n = 0;
        while (n < dPoint3Array.length) {
            string3 = string3 + dPoint3Array[n].x + " " + dPoint3Array[n].y + " " + dPoint3Array[n].z + "\n";
            ++n;
        }
        this.f2.setText(string3);
        this.f4.remove(this.f11);
        this.f11 = new Choice();
        this.f4.add(this.f11);
        this.f12 = (Hashtable)this.f5.data_.clone();
        this.f11.addItem("<NEW>");
        Enumeration enumeration = this.f12.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.f11.addItem(string);
        }
        if (this.f11.countItems() == 1) {
            this.f11.addItem("Data");
        }
        this.f11.select(1);
        this.f13 = this.f11.getItem(1);
        string = (String)this.f12.get(this.f13);
        if (string == null) {
            string = new String("");
        }
        this.f3.setText(string);
        int n2 = 0;
        while (n2 < this.f8) {
            this.f7[n2].show();
            ++n2;
        }
        this.pack();
    }

    public boolean handleEvent(Event event) {
        if (event.target instanceof InputDialog) {
            String string = (String)event.arg;
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || n != 0 && c >= '0' && c <= '9')) {
                    new MessageDialog(this.f9, "Error", "Bad format for new data item name.", true);
                    return true;
                }
                ++n;
            }
            this.f11.addItem(string);
            this.f11.select(this.f11.countItems() - 1);
            this.f13 = string;
            this.f3.setText("");
            return true;
        }
        if (event.id == 201) {
            this.hide();
            return true;
        }
        return super.handleEvent(event);
    }
}

