/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.graph;

import EDU.auburn.VGJ.graph.GMLobject;
import EDU.auburn.VGJ.graph.Node;
import EDU.auburn.VGJ.gui.GraphCanvas;
import EDU.auburn.VGJ.util.DPoint;
import EDU.auburn.VGJ.util.DPoint3;
import EDU.auburn.VGJ.util.Matrix44;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Hashtable;

public class Edge {
    protected Node head_;
    protected Node tail_;
    protected DPoint3[] points_;
    private DPoint3[] f1 = null;
    private boolean f2 = false;
    public boolean selected = false;
    private String f3;
    private int f4;
    public static String[] styleNames = new String[]{"solid", "dashed", "dotted", "dashdot"};
    public static Color[] styleColors = new Color[]{Color.black, Color.blue, Color.green, Color.orange};
    public static String[] styleLabels = new String[]{"solid (black)", "dashed (blue)", "dotted (green)", "dashdot (orange)"};
    public static String[] stylePatterns = new String[]{"[1 0 0 0] 0", "[2 1 2 1] 0", "[1 1 1 1] 0", "[2 1 1 1] 0"};
    public static String[] defaultDataTypes_ = new String[]{"Data1", "Data2"};
    public Hashtable data_;
    public Object data;

    public Edge(Node node, Node node2, DPoint3[] dPoint3Array, boolean bl) {
        this.head_ = node2;
        this.tail_ = node;
        this.points_ = dPoint3Array;
        if (dPoint3Array == null) {
            DPoint3[] cfr_ignored_0 = new DPoint3[0];
        }
        this.f2 = bl;
        this.f3 = new String("");
        this.f4 = 0;
        this.data_ = new Hashtable((int)((double)(defaultDataTypes_.length + 1) * 1.5));
        int n = 0;
        while (n < defaultDataTypes_.length) {
            this.data_.put(defaultDataTypes_[n], "");
            ++n;
        }
    }

    public Edge(Node node, Node node2, Edge edge) {
        this.head_ = node2;
        this.tail_ = node;
        this.f2 = edge.f2;
        this.f3 = edge.f3;
        this.f4 = edge.f4;
        DPoint3[] dPoint3Array = edge.points();
        this.points_ = new DPoint3[dPoint3Array.length];
        System.arraycopy(dPoint3Array, 0, this.points_, 0, dPoint3Array.length);
        this.data_ = new Hashtable((int)((double)(defaultDataTypes_.length + 1) * 1.5));
        int n = 0;
        while (n < defaultDataTypes_.length) {
            this.data_.put(defaultDataTypes_[n], "");
            ++n;
        }
    }

    public Edge(Node node, Node node2, GMLobject gMLobject) {
        Object object;
        this.head_ = node2;
        this.tail_ = node;
        GMLobject gMLobject2 = gMLobject.getGMLSubObject("graphics", 3, false);
        if (gMLobject2 != null) {
            int n = 10;
            DPoint3[] dPoint3Array = new DPoint3[10];
            int n2 = 0;
            object = gMLobject2.getGMLSubObject("Point", 3, false);
            while (object != null) {
                Double d = (Double)((GMLobject)object).getValue("x", 1);
                Double d2 = (Double)((GMLobject)object).getValue("y", 1);
                Double d3 = (Double)((GMLobject)object).getValue("z", 1);
                if (d != null && d2 != null) {
                    if (n2 >= n) {
                        int n3 = n2;
                        n = n3 + n3;
                        DPoint3[] dPoint3Array2 = new DPoint3[n];
                        System.arraycopy(dPoint3Array, 0, dPoint3Array2, 0, n2);
                        dPoint3Array = dPoint3Array2;
                    }
                    dPoint3Array[n2] = new DPoint3(d, d2, 0.0);
                    dPoint3Array[n2].z = d3 != null ? d3 : 0.0;
                    ++n2;
                }
                object = gMLobject2.getNextGMLSubObject();
            }
            this.points_ = new DPoint3[n2];
            System.arraycopy(dPoint3Array, 0, this.points_, 0, n2);
        } else {
            this.points_ = new DPoint3[0];
        }
        object = (String)gMLobject.getValue("label", 2);
        if (object != null) {
            this.f3 = object;
        } else {
            new String();
        }
        this.f4 = 0;
        String string = (String)gMLobject.getValue("linestyle", 2);
        if (string != null) {
            int n = 0;
            while (n < styleNames.length) {
                if (styleNames[n].equals(string)) {
                    this.f4 = n;
                    break;
                }
                ++n;
            }
        }
        this.data_ = new Hashtable((int)((double)(defaultDataTypes_.length + 1) * 1.5));
        int n = 0;
        while (n < defaultDataTypes_.length) {
            this.data_.put(defaultDataTypes_[n], "");
            ++n;
        }
        gMLobject.setHashFromGML("data", 2, this.data_);
    }

    public void setGMLvalues(GMLobject gMLobject) {
        Object object;
        gMLobject.setValue("target", 0, new Integer(this.head_.getIdObject()));
        gMLobject.setValue("source", 0, new Integer(this.tail_.getIdObject()));
        gMLobject.setValue("data", 3, null);
        Enumeration enumeration = this.data_.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = (String)this.data_.get(object);
            if (string == null || string.length() == 0) continue;
            String string2 = "data." + (String)object;
            gMLobject.setValue(string2, 2, string);
        }
        if (this.points_.length > 0) {
            object = new GMLobject("graphics", 3);
            gMLobject.addObjectToEnd((GMLobject)object);
            int n = this.points_.length;
            int n2 = 0;
            while (n2 < n) {
                GMLobject gMLobject2 = new GMLobject("Point", 3);
                ((GMLobject)object).addObjectToEnd(gMLobject2);
                gMLobject2.setValue("z", 1, new Double(this.points_[n2].z));
                gMLobject2.setValue("y", 1, new Double(this.points_[n2].y));
                gMLobject2.setValue("x", 1, new Double(this.points_[n2].x));
                ++n2;
            }
        }
        gMLobject.setValue("label", 2, this.f3);
        gMLobject.setValue("linestyle", 2, styleNames[this.f4]);
    }

    public void draw(Graphics graphics, Matrix44 matrix44, boolean bl, boolean bl2, boolean bl3, int n, GraphCanvas graphCanvas, int n2) {
        DPoint3 dPoint3;
        DPoint3 dPoint32;
        DPoint3 dPoint33;
        DPoint3 dPoint34;
        int n3 = this.points_.length;
        graphics.setColor(styleColors[this.f4]);
        if (n3 == 0) {
            dPoint34 = this.head_.getPosition3();
            dPoint33 = this.tail_.getPosition3();
        } else {
            dPoint34 = this.points_[0];
            dPoint33 = this.points_[n3 - 1];
        }
        DPoint3 dPoint35 = this.tail_.intersectWithLineTo(dPoint34, bl, n);
        DPoint3 dPoint36 = this.head_.intersectWithLineTo(dPoint33, bl, n);
        dPoint35.transform(matrix44);
        dPoint36.transform(matrix44);
        if (this.head_ == this.tail_ && n3 == 0) {
            dPoint36.x = dPoint35.x + 1.0;
            dPoint36.y = dPoint35.y;
        }
        if (!bl3) {
            if (n3 == 0) {
                graphics.drawLine((int)dPoint35.x, (int)dPoint35.y, (int)dPoint36.x, (int)dPoint36.y);
            } else {
                dPoint32 = new DPoint3(this.points_[0]);
                dPoint32.transform(matrix44);
                graphics.drawLine((int)dPoint35.x, (int)dPoint35.y, (int)dPoint32.x, (int)dPoint32.y);
                dPoint3 = new DPoint3();
                int n4 = 1;
                while (n4 < n3) {
                    dPoint3.move(dPoint32);
                    dPoint32.move(this.points_[n4]);
                    dPoint32.transform(matrix44);
                    graphics.drawLine((int)dPoint3.x, (int)dPoint3.y, (int)dPoint32.x, (int)dPoint32.y);
                    ++n4;
                }
                graphics.drawLine((int)dPoint32.x, (int)dPoint32.y, (int)dPoint36.x, (int)dPoint36.y);
            }
        }
        if (bl2) {
            dPoint32 = new DPoint3(dPoint33);
            dPoint32.transform(matrix44);
            if ((int)dPoint32.x == (int)dPoint36.x && (int)dPoint32.y == (int)dPoint36.y) {
                dPoint32.x -= 10.0;
            }
            this.m1(graphics, dPoint32, dPoint36);
        }
        if (!bl3 && this.selected) {
            graphics.setColor(Color.red);
            graphics.drawRect((int)dPoint35.x - 2, (int)dPoint35.y - 2, 4, 4);
            if (this.head_ != this.tail_) {
                graphics.drawRect((int)dPoint36.x - 2, (int)dPoint36.y - 2, 4, 4);
            }
            int n5 = 0;
            while (n5 < n3) {
                dPoint36.move(this.points_[n5]);
                dPoint36.transform(matrix44);
                graphics.drawRect((int)dPoint36.x - 2, (int)dPoint36.y - 2, 4, 4);
                ++n5;
            }
            graphics.setColor(Color.white);
            graphics.drawRect((int)dPoint35.x - 1, (int)dPoint35.y - 1, 2, 2);
            if (this.head_ != this.tail_) {
                graphics.drawRect((int)dPoint36.x - 1, (int)dPoint36.y - 1, 2, 2);
            }
            int n6 = 0;
            while (n6 < n3) {
                dPoint36.move(this.points_[n6]);
                dPoint36.transform(matrix44);
                graphics.drawRect((int)dPoint36.x - 1, (int)dPoint36.y - 1, 2, 2);
                ++n6;
            }
            graphics.setColor(Color.black);
        }
        if (n > 0 && this.f3 != null && this.f3.length() > 0) {
            this.f3.toCharArray();
            if (n3 == 0) {
                dPoint3 = new DPoint3(dPoint36);
            } else {
                dPoint3 = new DPoint3(dPoint34);
                dPoint3.transform(matrix44);
            }
            if (dPoint35.x == dPoint3.x && dPoint35.y == dPoint3.y) {
                dPoint3.x += 1.0;
            }
            double d = (dPoint35.x + dPoint3.x) / 2.0;
            double d2 = (dPoint35.y + dPoint3.y) / 2.0;
            double d3 = Math.atan2(-(dPoint3.y - dPoint35.y), dPoint3.x - dPoint35.x);
            graphCanvas.drawRotatedText(this.f3, d3, (int)d, (int)d2, graphics, n2);
        }
    }

    private void m1(Graphics graphics, DPoint3 dPoint3, DPoint3 dPoint32) {
        double d = dPoint3.x - dPoint32.x;
        double d2 = dPoint3.y - dPoint32.y;
        double d3 = d;
        double d4 = d2;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        DPoint dPoint = new DPoint(dPoint32.x, dPoint32.y);
        double d6 = 6.0;
        dPoint.x += d6 / d5 * d;
        dPoint.y += d6 / d5 * d2;
        DPoint dPoint2 = new DPoint(dPoint.x, dPoint.y);
        dPoint2.x += d6 * 0.7 / d5 * d2;
        dPoint2.y -= d6 * 0.7 / d5 * d;
        dPoint.x -= d6 * 0.7 / d5 * d2;
        dPoint.y += d6 * 0.7 / d5 * d;
        graphics.drawLine((int)dPoint32.x, (int)dPoint32.y, (int)dPoint2.x, (int)dPoint2.y);
        graphics.drawLine((int)dPoint32.x, (int)dPoint32.y, (int)dPoint.x, (int)dPoint.y);
    }

    public String toPS(Matrix44 matrix44, boolean bl, boolean bl2) {
        DPoint3 dPoint3;
        DPoint3 dPoint32;
        DPoint3 dPoint33;
        String string = new String();
        int n = this.points_.length;
        if (n == 0) {
            dPoint33 = this.head_.getPosition3();
            dPoint32 = this.tail_.getPosition3();
        } else {
            dPoint33 = this.points_[0];
            dPoint32 = this.points_[n - 1];
        }
        DPoint3 dPoint34 = this.tail_.intersectWithLineTo(dPoint33, bl, 2);
        DPoint3 dPoint35 = this.head_.intersectWithLineTo(dPoint32, bl, 2);
        dPoint34.transform(matrix44);
        dPoint35.transform(matrix44);
        if (this.head_ == this.tail_ && n == 0) {
            dPoint35.x = dPoint34.x + 1.0;
            dPoint35.y = dPoint34.y;
        }
        string = string + this.m4(dPoint34.x) + this.m4(dPoint34.y) + "moveto\n";
        DPoint3 dPoint36 = new DPoint3();
        int n2 = 0;
        while (n2 < n) {
            dPoint36.move(this.points_[n2]);
            dPoint36.transform(matrix44);
            string = string + this.m4(dPoint36.x) + this.m4(dPoint36.y) + "lineto\n";
            ++n2;
        }
        string = string + this.m4(dPoint35.x) + this.m4(dPoint35.y) + "lineto\n";
        string = string + stylePatterns[this.f4] + " setdash\n";
        string = string + "stroke\n";
        string = string + "[1 0 0 0] 0 setdash\n";
        if (this.f3 != null && this.f3.length() > 0) {
            double d;
            if (n == 0) {
                dPoint3 = new DPoint3(dPoint35);
            } else {
                dPoint3 = new DPoint3(dPoint33);
                dPoint3.transform(matrix44);
            }
            if (dPoint34.x == dPoint3.x && dPoint34.y == dPoint3.y) {
                dPoint3.x += 1.0;
            }
            double d2 = (dPoint34.x + dPoint3.x) / 2.0;
            double d3 = (dPoint34.y + dPoint3.y) / 2.0;
            double d4 = dPoint3.x - dPoint34.x;
            double d5 = dPoint3.y - dPoint34.y;
            double d6 = Math.atan2(d4, d5) * 180.0 / Math.PI - 90.0;
            if (Math.abs(d) > 90.0) {
                d6 += 180.0;
            }
            Edge edge = this;
            string = string + "(" + edge.m2(edge.f3) + ") " + d2 + " " + d3 + " " + d6 + " slantlabel\n";
        }
        if (bl2) {
            dPoint3 = new DPoint3(dPoint32);
            dPoint3.transform(matrix44);
            if ((int)dPoint3.x == (int)dPoint35.x && (int)dPoint3.y == (int)dPoint35.y) {
                dPoint3.x -= 10.0;
            }
            string = string + this.m3(dPoint3, dPoint35);
        }
        return string + "\n";
    }

    private StringBuffer m2(String string) {
        int n;
        int n2 = n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + n2);
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '(' || c == ')' || c == '\\') {
                stringBuffer.append('\\');
            }
            if (c >= ' ' && c < '\u0080') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("\\" + (c >> 6 & 7) + (c >> 3 & 7) + (c & 7));
            }
            ++n3;
        }
        return stringBuffer;
    }

    private String m3(DPoint3 dPoint3, DPoint3 dPoint32) {
        double d = dPoint3.x - dPoint32.x;
        double d2 = dPoint3.y - dPoint32.y;
        double d3 = d;
        double d4 = d2;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        return this.m4(dPoint32.x) + this.m4(dPoint32.y) + this.m4(d /= d5) + this.m4(d2 /= d5) + "arrow\n";
    }

    private String m4(double d) {
        if (d > 0.0) {
            return String.valueOf(d) + " ";
        }
        if (d < 0.0) {
            return String.valueOf(-d) + " neg ";
        }
        return "0 ";
    }

    public DPoint3[] points() {
        return this.points_;
    }

    public Node head() {
        return this.head_;
    }

    public Node tail() {
        return this.tail_;
    }

    public boolean isDummy() {
        return this.f2;
    }

    public void saveState() {
        this.f1 = new DPoint3[this.points_.length];
        int n = 0;
        while (n < this.points_.length) {
            this.f1[n] = new DPoint3(this.points_[n]);
            ++n;
        }
    }

    public void slide(Matrix44 matrix44, Matrix44 matrix442, int n, int n2) {
        if (this.f1 != null) {
            int n3 = 0;
            while (n3 < this.points_.length) {
                this.points_[n3].move(this.f1[n3]);
                this.points_[n3].transform(matrix442);
                this.points_[n3].x += (double)n;
                this.points_[n3].y += (double)n2;
                this.points_[n3].transform(matrix44);
                ++n3;
            }
        }
    }

    public String getLabel() {
        return this.f3;
    }

    public void setLabel(String string) {
        this.f3 = string;
    }

    public void setLineStyle(int n) {
        this.f4 = n;
    }

    public int getLineStyle() {
        return this.f4;
    }
}

