/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ;

import EDU.auburn.VGJ.algorithm.GraphAlgorithm;
import EDU.auburn.VGJ.algorithm.cartegw.BiconnectGraph;
import EDU.auburn.VGJ.algorithm.cgd.CGDAlgorithm;
import EDU.auburn.VGJ.algorithm.shawn.Spring;
import EDU.auburn.VGJ.algorithm.tree.TreeAlgorithm;
import EDU.auburn.VGJ.examplealg.ExampleAlg2;
import EDU.auburn.VGJ.graph.Node;
import EDU.auburn.VGJ.graph.TWGraph;
import EDU.auburn.VGJ.gui.GraphWindow;
import TWHelp.TWInfo;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;

public class VGJ
extends Applet {
    private int f1 = 0;
    private boolean f2 = false;

    public void init() {
        if (this.f2) {
            this.setLayout(new GridLayout(2, 1));
            this.add(new Button("Start a Graph Window"));
            this.add(new Button("Exit"));
        } else {
            this.setLayout(new GridLayout(1, 1));
            this.add(new Button("Start a Graph Window"));
        }
        Node.setToolkit(this.getToolkit());
        if (!this.f2) {
            Node.setContext(this.getCodeBase());
            GraphWindow.setContext(this.getCodeBase());
        }
        this.validate();
        this.show();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("VGJ v1.03");
        VGJ vGJ = new VGJ();
        new VGJ().f2 = true;
        vGJ.init();
        vGJ.start();
        frame.add("Center", vGJ);
        frame.resize(200, 300);
        frame.validate();
        frame.show();
        if (stringArray.length > 0) {
            String string = null;
            int n = -1;
            String string2 = null;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("-f") && n2 < stringArray.length) {
                    string = stringArray[++n2];
                } else if (stringArray[n2].equals("-s") && n2 < stringArray.length) {
                    n = Integer.parseInt(stringArray[++n2]);
                } else if (stringArray[n2].equals("-l") && n2 < stringArray.length) {
                    string2 = stringArray[++n2];
                }
                ++n2;
            }
            if (string != null) {
                GraphWindow graphWindow = VGJ.buildWindow_();
                graphWindow.loadFile(string);
                if (n != -1) {
                    graphWindow.selectNode(n);
                }
                if (string2 != null) {
                    graphWindow.applyAlgorithm(string2);
                }
            }
        }
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            if (((String)object).equals("Exit")) {
                System.exit(0);
            } else {
                VGJ.buildWindow_();
            }
        }
        return super.action(event, object);
    }

    public static GraphWindow buildWindow(TWInfo tWInfo) {
        TWGraph tWGraph = new TWGraph(tWInfo);
        GraphWindow graphWindow = new GraphWindow(tWGraph);
        graphWindow.addAlgorithmMenu("Tree");
        TreeAlgorithm treeAlgorithm = new TreeAlgorithm('d');
        graphWindow.addAlgorithm(treeAlgorithm, "Tree", "Tree Down");
        treeAlgorithm = new TreeAlgorithm('u');
        graphWindow.addAlgorithm(treeAlgorithm, "Tree", "Tree Up");
        treeAlgorithm = new TreeAlgorithm('l');
        graphWindow.addAlgorithm(treeAlgorithm, "Tree", "Tree Left");
        treeAlgorithm = new TreeAlgorithm('r');
        graphWindow.addAlgorithm(treeAlgorithm, "Tree", "Tree Right");
        graphWindow.addAlgorithmMenu("CGD");
        CGDAlgorithm cGDAlgorithm = new CGDAlgorithm();
        graphWindow.addAlgorithm(cGDAlgorithm, "CGD", "CGD");
        cGDAlgorithm = new CGDAlgorithm(true);
        graphWindow.addAlgorithm(cGDAlgorithm, "CGD", "show CGD parse tree");
        Spring spring = new Spring();
        graphWindow.addAlgorithm(spring, "Spring");
        graphWindow.addAlgorithmMenu("Biconnectivity");
        BiconnectGraph biconnectGraph = new BiconnectGraph(true);
        graphWindow.addAlgorithm(biconnectGraph, "Biconnectivity", "Remove Articulation Points");
        BiconnectGraph biconnectGraph2 = new BiconnectGraph(false);
        graphWindow.addAlgorithm(biconnectGraph2, "Biconnectivity", "Find Articulation Points");
        graphWindow.setTitle("Sector Map");
        graphWindow.pack();
        return graphWindow;
    }

    public static GraphWindow buildWindow_() {
        GraphWindow graphWindow = new GraphWindow(true);
        graphWindow.addAlgorithmMenu("Tree");
        ExampleAlg2 exampleAlg2 = new ExampleAlg2();
        graphWindow.addAlgorithm((GraphAlgorithm)exampleAlg2, "Random");
        TreeAlgorithm treeAlgorithm = new TreeAlgorithm('d');
        graphWindow.addAlgorithm(treeAlgorithm, "Tree", "Tree Down");
        treeAlgorithm = new TreeAlgorithm('u');
        graphWindow.addAlgorithm(treeAlgorithm, "Tree", "Tree Up");
        treeAlgorithm = new TreeAlgorithm('l');
        graphWindow.addAlgorithm(treeAlgorithm, "Tree", "Tree Left");
        treeAlgorithm = new TreeAlgorithm('r');
        graphWindow.addAlgorithm(treeAlgorithm, "Tree", "Tree Right");
        graphWindow.addAlgorithmMenu("CGD");
        CGDAlgorithm cGDAlgorithm = new CGDAlgorithm();
        graphWindow.addAlgorithm(cGDAlgorithm, "CGD", "CGD");
        cGDAlgorithm = new CGDAlgorithm(true);
        graphWindow.addAlgorithm(cGDAlgorithm, "CGD", "show CGD parse tree");
        Spring spring = new Spring();
        graphWindow.addAlgorithm(spring, "Spring");
        graphWindow.addAlgorithmMenu("Biconnectivity");
        BiconnectGraph biconnectGraph = new BiconnectGraph(true);
        graphWindow.addAlgorithm(biconnectGraph, "Biconnectivity", "Remove Articulation Points");
        BiconnectGraph biconnectGraph2 = new BiconnectGraph(false);
        graphWindow.addAlgorithm(biconnectGraph2, "Biconnectivity", "Find Articulation Points");
        graphWindow.setTitle("Sector Map");
        graphWindow.pack();
        return graphWindow;
    }
}

