/***************************************************************************
 *                                                                         *
 *   POLLSTER.C                                                            *
 *                                                                         *
 *   Copyright (C) 1988-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS pollster's paradise module.                     *
 *                                                                         *
 *                                          - T. Stryker 7/19/87           *
 *                                                                        *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galpolls.h"

void EXPORT init__pollster(void);
void makpmt(void);
void shomnu(void);
void prfnpct(int msgno);
void flushp(void);
void opnprs(void);
int pollster(void);
int prfcurq(void);
void newmcv(void);
void clspol(void);

struct module pollblock={     /* module interface block               */
     "",                      /*    name used to refer to this module */
     NULL,                    /*    user logon supplemental routine   */
     pollster,                /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     clspol                   /*    finish-up (sys shutdown) routine  */
};

static
FILE *polmb;                  /* pollster named-message file block pointer */
static
FILE *polrsp;                 /* regular DOS file for poll responses       */

static
int polstt;                   /* pollster's paradise state number          */

#define POLCNT 10             /* maximum number of different polls active  */
#define QPERPL 20             /* maximum number of questions per poll      */
#define NCHPOL 8              /* num of chars from QID for use as Q name   */

static
char polnam[POLCNT][NCHPOL+1];/* names of questionaires (first NCHPOL chrs)*/

void EXPORT
init__pollster(void)               /* initialize pollster module           */
{
     stzcpy(pollblock.descrp,gmdnam("GALPOL.MDF"),MNMSIZ);
     polstt=register_module(&pollblock);
     makpmt();
     opnprs();
     rtkick(120,flushp);
}

void
makpmt(void)                       /* create polls from message file       */
{
     int i;
     char *idstg;

     polmb=opnmsg("galpolls.mcv");
     setmem(polnam,POLCNT*(NCHPOL+1),0);
     for (i=0 ; i < POLCNT ; i++) {
          idstg=getmsg(QID1+i);
          stpans(idstg);
          if (*idstg != '\0') {
               movmem(idstg,polnam[i],NCHPOL);
          }
     }
}

void
shomnu(void)                       /* show a user the polls main menu      */
{
     int i;
     char *idstg;

     prfnpct(INTRO);
     strcpy(vdatmp,getmsg(MNULIN));
     for (i=0 ; i < POLCNT ; i++) {
          if (*skpans(idstg=getmsg(QID1+i)) != '\0') {
               prf(vdatmp,i+1,idstg);
          }
     }
     prfnpct(INTRAIL);
}

void
prfnpct(msgno)                     /* prf() without percents               */
int msgno;
{
     if (msgno == PMSHORT && (usrptr->flags&CONCEX)) {
          longjmp(eximod,1);
     }
     prf("%s",getmsg(msgno));
}

void
flushp(void)                       /* save pollster replies                */
{
     fclose(polrsp);
     opnprs();
     rtkick(120,flushp);
}

void
opnprs(void)                       /* open pollster response file          */
{
     if ((polrsp=fopen("galprsps.txt",FOPAA)) == NULL) {
          catastro("CAN'T OPEN GALPRSPS.TXT FOR APPEND!");
     }
}

int
pollster(void)                     /* pollster main input handler          */
{
     int polsel;

     setmbk(polmb);
     do {
          bgncnc();
          switch (usrptr->substt) {
          case 0:
               shomnu();
               usrptr->substt=-1;
               cncchr();
               usrptr->flags&=~X2MAIN;
               break;
          case -1:
               cncall();
               if (margc == 0) {
                    prfnpct(PMSHORT);
               }
               else if (margc == 1) {
                    if (sameas(margv[0],"?")) {
                         shomnu();
                    }
                    else if (sameas(margv[0],"r")) {
                         prfnpct(RESULTS);
                         prfnpct(PMSHORT);
                    }
                    else if (sameas(margv[0],"x")) {
                         return(0);
                    }
                    else if (sameas(margv[0],"update") && hasmkey(PCUKEY)) {
                         newmcv();
                    }
                    else if (sameas(margv[0],"clear") && hasmkey(PCUKEY)) {
                         fclose(polrsp);
                         unlink("galprsps.txt");
                         opnprs();
                         prfnpct(PMSHORT);
                    }
                    else if ((polsel=atoi(margv[0])) > 0
                       && polsel <= POLCNT
                       && polnam[polsel-1][0] != '\0') {
                         usrptr->substt=polsel;
                         usrptr->countr=1;
                         prf("\r");
                         prfcurq();
                    }
                    else {
                         prfmsg(PMERR,margv[0]);
                         prfnpct(PMSHORT);
                    }
               }
               else {
                    prfnpct(JSTONE);
                    prfnpct(PMSHORT);
               }
               break;
          default:
               cncall();
               if (margc == 0) {
                    prfcurq();
               }
               else if (margc == 1 && sameas(margv[0],"x")) {
                    prfnpct(EXIQES);
                    prfnpct(PMSHORT);
                    usrptr->substt=-1;
               }
               else {
                    rstrin();
                    fprintf(polrsp,"%-8s%02d %-29s %c %c %s\n",
                         polnam[usrptr->substt-1],usrptr->countr,usaptr->userid,
                         usaptr->sex,tstcrd(1) ? 'P' : 'F',margv[0]);
                    if (usrptr->countr++ >= QPERPL || !prfcurq()) {
                         clrprf();
                         if (usrptr->flags&CONCEX) {
                              longjmp(eximod,1);
                         }
                         prfmsg(POLDUN,usrptr->substt);
                         usrptr->substt=-1;
                    }
               }
          }
     } while (!endcnc());
     outprf(usrnum);
     return(1);
}

int
prfcurq(void)                      /* displays current poll question       */
{
     prfnpct(Q1TXT1+(usrptr->substt-1)*QPERPL+usrptr->countr-1);
     return(prfbuf[0] != '\0');
}

void
newmcv(void)                       /* install new galpolls.mcv file        */
{
     int i;
     struct user *uptr;
     FILE *fp;

     for (i=0,uptr=user ; i < nterms ; i++,uptr++) {
          if (uptr->state == polstt && i != usrnum) {
               prfnpct(NONEWM);
               prfnpct(PMSHORT);
               return;
          }
     }
     if ((fp=fopen("galpolls.upd",FOPRA)) == NULL) {
          prfnpct(NOUPDF);
          prfnpct(PMSHORT);
          return;
     }
     fclose(fp);
     clsmsg(polmb);
     unlink("galpolls.xxx");
     rename("galpolls.mcv","galpolls.xxx");
     rename("galpolls.upd","galpolls.mcv");
     rename("galpolls.xxx","galpolls.upd");
     makpmt();
     shomnu();
}

void
clspol(void)                       /* close pollster files for shutdown    */
{
     clsmsg(polmb);
     if (polrsp != NULL) {
          fclose(polrsp);
     }
}

