/***************************************************************************
 *                                                                         *
 *   PLBBS.C                                                               *
 *                                                                         *
 *   Copyright (C) 1993 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   Routines to load and initialize DLL files in MJRBBS.CFG.  Also has    *
 *   BBS-specific GP report.  With support for Ring 0 GSBL tick handler.   *
 *                                                                         *
 *                                    - Robert A. Rose 02/18/92            *
 *   Ring 0                           - Robert A. Rose 06/23/92            *
 *   Was BBS-specific SCANPL.C        - Robert N. Stein 1/06/93            *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "plstuff.h"

#define I asm
#pragma inline

char btrset[80];                   /* parameters we're passing to Btrieve  */

#define BTROFF 13             /* strlen("BTRIEVE >NUL ") for extracting    */
                              /*   btrset parameters from BBSBTR.BAT       */

extern int shdl,stthue;

int cpu=0;                    /* cpu type=[286 | 386 | 486]                */

SEL gdtsel,idtsel;            /* LDT ring 3 selector to GDT                */
SEL gccode;

struct {                      /* Interrupt & Global Descriptor registers   */
     unsigned int limit;
     unsigned long base;
} idtr,gdtr;

struct {                      /* GDT selector format                       */
     unsigned int limit;      /*   size of selector                        */
     unsigned int base1;      /*   base of region (bits  0-15)             */
     unsigned char base2;     /*   base of region (bits 16-23)             */
     char flags;              /*   DPL, P, DT, Type, etc.                  */
     int rsvd;                /*   used on 386 and up only                 */
} *gdt,*ldt;

struct {                      /* IDT selector format                       */
     unsigned int offset;
     unsigned int seg;
     char rsvd1;
     char type;
     int rsvd2;
} *idt;


void prntscn(void);
void pandb(void);
void initrng3(void);
void DosMapLDT(void);
void DosMapIDT(void);
void DosMapGDT(void);

void
setbparm(void)           /* read in btrieve parms                          */
{
     FILE *fp;

     if ((fp=fopen("BBSBTR.BAT",FOPRA)) != NULL) {
          if (fgets(btrset,sizeof(btrset),fp) != NULL) {
               movmem(btrset+BTROFF,btrset,strlen(btrset+BTROFF)+1);
               btrset[strlen(btrset)-1]='\0';
          }
          fclose(fp);
     }
}

void
callinits(void)          /* set up from MJRBBS.CFG file (including DLLs)   */
{
     char *fn386;

     if (cpu == 0) {
          cpu=cputype();
     }
     if (tfsopn("MJRBBS.CFG") == 0) {
          catastro("Can't find DLL list (MJRBBS.CFG)!");
     }
     while (tfsrdl() != TFSDUN) {
          if (tfstate == TFSLIN && tfspfx("DLL=")) {
               cntdir(fn386=spr("%s.386",tfspst));
               actvscn(shdl);
               sstatr(stthue);
               if (cpu >= 386 && numfils != 0) {
                    printfat(32,20,"Loading: %8.8s (386 specific)",tfspst);
                    loaddll(fn386);
               }
               else {
                    printfat(32,20,"Loading: %8.8s               ",tfspst);
                    loaddll(tfspst);
               }
          }
     }
     actvscn(shdl);
     sstatr(stthue);
     printfat(28,20,"Initializing:         ");
     prtdnam=1;
     initdlls();
     sstatr(stthue);
     printfat(28,20,"                      ");
}

void
appgprept(void)                    /* BBS-specific GP report               */
{                                  /* (called from PLSTUFF.C)              */
     char uid[UIDSIZ];
     FILE *gpdst;                  /* File handle for GP dumps             */
     int usrval=0;
     char *catfix2(void);

     gpdst=fopen(dstname,FOPAA);
     fprintf(gpdst,"\nBBS Version: %d.%02d%s\n",BBSVER/100,BBSVER%100,BBSIRV);
     fprintf(gpdst,"User %d",usrnum);
     if (0 <= usrnum && usrnum < nterms) {
          if (goodptr(&channel[usrnum])) {
               fprintf(gpdst,"  channel %02X",channel[usrnum]);
          }
     }
     if (goodstg(usaptr->userid) && isprint(usaptr->userid[0])) {
          movmem(usaptr->userid,uid,UIDSIZ-1);
          uid[UIDSIZ-1]='\0';
          fprintf(gpdst,"  User-ID \"%s\"",uid);
     }
     fprintf(gpdst,"  status %d\n",status);
     if (goodptr(usrptr)) {
          usrval=1;
          fprintf(gpdst,"Online level %d, state %d, substate %d\n",
                        usrptr->class,
                        usrptr->state,
                        usrptr->substt);
     }
     if (goodptr(curmbk)) {
          fprintf(gpdst,"%s\n",catfix2());
     }
     if (usrval && goodstg(module[usrptr->state]->descrp)) {
          fprintf(gpdst,"Module \"%s\"\n",module[usrptr->state]->descrp);
     }
     if (input[0] == '\0' || isprint(input[0])) {
          input[INPSIZ-1]='\0';
          fprintf(gpdst,"Input \"%s\"\n",input);
     }
     else {
          fprintf(gpdst,"Input unprintable (starts with %02X)\n",input[0]);
     }
     fclose(gpdst);
}

void
appgprecd(void)                        /* BBS-specific GP recording of info */
{
     extern int lastusrnu;                          /* (used in MAJORBBS.C) */

     lastusrnu=usrnum;
}

void
initrng3(void)                /* Initialize and put our fifo code in ring 0*/
{
     int tidx,i;
     void pl0rti(void);

     DosMapGDT();
     DosMapLDT();
     gccode=0;
     for (i=1 ; i < 48 ; i++) {
          if (gdt[i].flags == 0) {
               gccode=i;
               break;
          }
     }
     if (gccode == 0) {
          catastro("GDT is full!");
     }
     tidx=(int)((long)pl0rti>>19)&0xFFFF;
     gdt[gccode].flags=ldt[tidx].flags;
     gdt[gccode].base1=ldt[tidx].base1;
     gdt[gccode].base2=ldt[tidx].base2;
     gdt[gccode].limit=ldt[tidx].limit;
     gdt[gccode].rsvd=0;
     gdt[gccode].flags=0x9A;
     DosMapIDT();
     DosBlockIntr();
     idt[8].offset=FP_OFF(pl0rti);
     idt[8].seg=gccode*8;
     DosUnblockIntr();
}

void
DosMapLDT(void)               /* Return a selector mapped over the LDT     */
{
     SEL ldtsel;
     unsigned long linadr;

/* asm  sldt ax */
asm  db 0x0f,0x00,0xc0
asm  mov  ldtsel,ax

     linadr=(ULONG)(gdt[ldtsel>>3].base1+((long)(gdt[ldtsel>>3].base2)<<16));
     DosMapLinSeg(linadr,(ULONG)(gdt[ldtsel>>3].limit),&ldtsel);
     ldt=MK_FP(ldtsel,0);
}

void
DosMapIDT(void)               /* Return a selector mapped over the IDT     */
{
/* asm sidt idtr */
asm  mov  bx,offset idtr
asm  db   0x0f,0x01,0x0f

     DosMapLinSeg(idtr.base,idtr.limit,&idtsel);
     idt=MK_FP(idtsel,0);
}

void
DosMapGDT(void)               /* Return a selector mapped over the GDT     */
{
/* asm  sgdt gdtr */
asm  mov  bx,offset gdtr
asm  db   0x0f,0x01,0x07

     DosMapLinSeg(gdtr.base,gdtr.limit,&gdtsel);
     gdt=MK_FP(gdtsel,0);
}
