/***************************************************************************
 *                                                                         *
 *   MHSHDL.C                                                              *
 *                                                                         *
 *   Copyright (C) 1992-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS online MHS handling routines.  These routines   *
 *   are based on MHS v1.5 and the SMF-70 specifications.  Only a subset   *
 *   is being supported.                                                   *
 *                                                                         *
 *                                            - R. Skurnick 2/8/92         *
 *   -File Attachment Support                 - C. Robert   2/1/93         *
 *                                            - C. Kotacka  2/1/93         *
 ***************************************************************************/

#include "gcomm.h"
#include "fcntl.h"
#include "io.h"
#include "share.h"
#include "sys\stat.h"
#include "majorbbs.h"
#include "galms.h"
#include "message.h"

#pragma inline
#define I asm

STATIC int mhsinp(void);
STATIC void mhssta(void);
STATIC void mhscup(void);
STATIC void xltcrs(char *cp);
STATIC int chkuse(long msgno);
STATIC int sndito(struct message *msg,char *to);
STATIC int chkdir(char *dir);
STATIC void zapbck(char *dir);
STATIC void expwdn(void);
STATIC int mhscfil(char *from,char *to,void (*(whndun))());
STATIC void fincpy(void);
STATIC int frenhd(void);
STATIC void trycpy(void);
STATIC void impwdn(void);
STATIC void dlattm(struct message *msg);
STATIC char *mhsatn(struct message *msg);
STATIC char *strpex(char *fil);
STATIC char *strppt(char *fil);
STATIC void mhsfpst(void);
STATIC void bad2sy(void);
STATIC int chk4bad(char *fname);
STATIC struct mhskar *keywdok(char *stgptr);
STATIC int attmnt(void);
STATIC int touid(void);
STATIC int frmadr(void);
STATIC int msgsub(void);
STATIC int hdlsum(void);
STATIC int nottyp(void);
STATIC int retrec(void);
STATIC int nodnot(void);
STATIC int errnum(void);
STATIC int msgdte(void);
STATIC int nulrou(void);
STATIC char netseterror(int mode);
STATIC void sndnod(void);
STATIC void delimp(void);
STATIC void clnmhs(char *filpth,char *msgpth);
STATIC void bldrfl(char *msgpth);
STATIC char *makpth(char *pthpre,char *filnam);

struct module mhsmod={        /* module interface block               */
     "MHS Service",           /*    name used to refer to this module */
     NULL,                    /*    user logon supplemental routine   */
     mhsinp,                  /*    input routine if selected         */
     mhssta,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     NULL,                    /*    hangup (lost carrier) routine     */
     mhscup,                  /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     NULL                     /*    finish-up (sys shutdown) routine  */
};

int mhsact,                        /* Is MHS active 1=Yes 0=No             */
    mhsstt;                        /* MHS state code (if mhsact)           */

static
long curexp=0L,                    /* current message # being exported     */
     curfps=0L,                    /* currect msg #'s fpos in esgbb        */
     curimp=0L;                    /* currect message # being imported     */

static
int filhdl,                        /* Input file handle for importing MHS  */
    fnduid,                        /* Is proposed destination user on file?*/
    fndsig,                        /* Is proposed destination a valid sig? */
    appmsg;                        /* Is this a continuation message 1=Yes */

static
FILE *filfp,                       /* Input file stream for filhdl         */
     *mhsfp;                       /* file pointer for MHS-Outbound Message*/

char *mhssfn,                      /* file name for writing outgoing msgs  */
     *mhsfnm,                      /* file name hold area                  */
     *mhsfn2,                      /* file name hold area #2               */
     *mhsvdp;                      /* ptr to vda to parse keyword options  */

BTVFILE *mhsbb,                    /* MHS btrieve file block pointer       */
        *mhmbb;                    /* MHS btr file ptr for outbound msgs   */

static int numrfd;                 /* number of files referenced in msgs   */
static char **refdfl;              /* "referenced in msgs" file list       */

/*--- OPTIONS FROM GALMS.MSG ---*/

char *mhsoutd,                     /* Directory for outgoing MHS messages  */
     *mhsfild,                     /* Directory for outgoing MHS files     */
     *mhsind,                      /* Directory for incoming MHS messages  */
     *gtwnme,                      /* BBS gateway name                     */
     *mhskey;                      /* key required to send MHS messages    */

int scnmhs,                        /* How often to scan for incoming msgs  */
    outscn;                        /* How often to scan for outgoing msgs  */

struct mhskar {                    /* struct for dealing with keywords     */
     char *hdrwrd;                 /*   keyword name                       */
     int (*routine)();             /*   routine to execute                 */
};

#define HDRSIZ (sizeof(mhskwd)/sizeof(struct mhskar))

struct mhskar mhskwd[]={
     {"ATTACHMENT", attmnt},
     {"DATE",       msgdte},
     {"ERC",        errnum},
     {"FROM",       frmadr},
     {"NDN",        nodnot},
     {"ROC",        nulrou},
     {"RRN",        retrec},
     {"SUBJECT",    msgsub},
     {"SUMMARY",    hdlsum},
     {"TO",         touid},
     {"TYPE",       nottyp}
};

#define ATTBGN "Attachment-name:"  /* attachment line in msg begins w/ this*/

                                   /* Bit definitions for mhsimp.flags     */
#define HASSUB      0x01           /*   Subject has been defined           */
#define ISNOTI      0x02           /*   This is only a notification        */
#define REQREC      0x04           /*   Return Receipt Requested           */
#define REQNOD      0x08           /*   Request Non-Delivery Notice        */
#define FILEAT      0x10           /*   File attachment present            */

struct mhsimp {                    /* struct for handling MHS import data  */
     long oldmsg;                  /*   last message number for TBC        */
     char from[MHSADR];            /*   from address - for replys          */
     char subject[TPCSIZ];         /*   message subject                    */
     char to[UIDSIZ];              /*   where to send this message to      */
     char userto[UIDSIZ];          /*   where to send this msg to (User-ID)*/
     char date[80];                /*   date information                   */
     char attnme[FSPSIZ];          /*   file Att. name (inc. inmsg path)   */
     int errcode;                  /*   errcode if notification            */
     char flags;                   /*   misc flags                         */
} mhsimp;

struct mhschn {                    /* vda channel definition for mhs chans */
     char from[FSPSIZ];                 /* copying from this file          */
     char to[FSPSIZ];                   /* copying to this file            */
     FILE *infp;                        /* from file pointer               */
     FILE *outfp;                       /* to file pointer                 */
     void (*(whndun))();                /* when done routine pointer       */
};

#define mhsusr ((struct mhschn *)vdaptr)
#define othmhs(x) ((struct mhschn *)vdaoff(x))

                                   /* MHS channel substt code definitions  */
#define   STARTC    1                   /* starting to copy file now       */
#define   INCOPY    2                   /* in the copying procedure now    */

#define   MHSDLY    1              /* MHS cycle-based delay for copying    */
#define   MHSCHK    256            /* MHS "chunk size" for copying files   */

struct mhsinf tmpinf;              /* temporary mhsinf structure           */

#define esgmhs ((struct esgusr *)vdatmp)
#define mhstmp ((struct message *)vdatmp)

void
inimhs(void)                       /* Initialize MHS                       */
{
     int siz;

     mhsbb=opnbtv("galmhs.dat",sizeof(struct mhsinf));
     if (ahibtv(&tmpinf,0)) {
          if (tmpinf.msgno > sv.msgtot) {
               sv.msgtot=tmpinf.msgno;
          }
     }
     mhmbb=opnbtv("galmhsm.dat",sizeof(struct message)+msgbyts);
     if (ynopt(ALWMHS) == 1) {
          zapbck(mhsoutd=stgopt(OUTMSG));
          zapbck(mhsfild=stgopt(OUTFIL));
          if (mhsfild[0] == '\0') {
               free(mhsfild);
               mhsfild=alcdup(spr("%s\\PARCEL",mhsoutd));
          }
          zapbck(mhsind=stgopt(INMSG));
          if (chkdir(mhsoutd)) {
               if (chkdir(mhsind)) {
                    if (fnd1st(&sigfnd,mhsfild,FAMDIR) || mkdir(mhsfild) == 0) {
                         mhsact=1;
                    }
               }
          }
          if (mhsact == 0) {
               usrnum=-1;
               shocst("MHS: Inactive","MHS: Directory Structure Incomplete!");
               return;
          }
          mhsfnm=alczer((siz=max(strlen(mhsoutd),strlen(mhsind))+16));
          mhsfn2=alczer(siz);
          mhssfn=alczer(siz);
          gtwnme=stgopt(GTWNME);
          mhskey=stgopt(MHSKEY);
          scnmhs=numopt(SCNMHS,5,3600);
          outscn=numopt(OUTSCN,3,3600);
          rtkick(5,mhsscn);
          rtkick(5,outrtk);
     }
     if (mhsact) {
          mhsstt=register_module(&mhsmod);
          dclvda(sizeof(struct mhschn));
     }
}

int
sendmhs(void)                      /* open output for MHS message          */
{
     stzcpy(esgptr->msg.from,usaptr->userid,UIDSIZ);
     mhscpy();
     return(1);
}

void
mhscpy(void)                       /* send a copy of something to MHS      */
{
     setbtv(mhmbb);
     invbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
     rstbtv();
     setbtv(mhsbb);
     tmpinf.msgno=esgptr->msg.msgno;
     if (esgptr->msg.to[0] == SIGIDC) {
          stzcpy(tmpinf.addr,(esgptr->sflags&MHSORG) ? nxtcmd :
                 sdtptr->mhsaddr,MHSADR);
     }
     else {
          stzcpy(tmpinf.addr,esgptr->mhs.addr,MHSADR);
     }
     insbtv(&tmpinf);
     rstbtv();
}


STATIC int
sndito(msg,to)                     /* send the MHS message text off        */
struct message *msg;                    /* message structure to send off   */
char *to;                               /* to field (MHS address)          */
{
     int handle,savusn;
     char sumlin[MHSADR];

     strcpy(mhssfn,mhsoutd);
     strcat(mhssfn,"\\");
     if ((handle=creattemp(mhssfn,0)) != -1) {
          close(handle);
          if ((mhsfp=fopen(mhssfn,FOPWA)) != NULL) {
               fprintf(mhsfp,"SMF-70\n");
               fprintf(mhsfp,"To: %s\n",to);
               fprintf(mhsfp,"From: MBBS@%s {MBBS: %s}\n",gtwnme,msg->from);
               fprintf(mhsfp,"Subject: %s\n",msg->topic);
               if (msg->to[0] == SIGIDC && !sameas(msg->userto,ALL)) {
                    stzcpy(sumlin,msg->userto,MHSADR);
                    if (strstr(sumlin,"@") == NULL && uidxst(sumlin)) {
                         strncat(sumlin,"@",MHSADR-1);
                         strncat(sumlin,gtwnme,MHSADR-1);
                    }
                    fprintf(mhsfp,"Summary: MBBS: %s\n",sumlin);
               }
               if (msg->flags&FILATT) {
                    msg->flags&=~INDRCT;
                    fprintf(mhsfp,"Attachment-name: %s\n",mhsatn(msg));
               }
               fprintf(mhsfp,"MCB-options: %s\n\n",
                       (msg->flags&RECREQ) ? "NYYNPNP" : "NNYNPNP");
               xltcrs(msg->text);
               fprintf(mhsfp,"%s",msg->text);
               fclose(mhsfp);
               return(1);
          }
     }
     savusn=usrnum;
     usrnum=0;
     shocst("MHS AUTOMATICALLY DISABLED",
            "Couldn't create file in outbound directory!");
     usrnum=savusn;
     mhsact=0;
     return(0);
}

STATIC void
xltcrs(cp)                         /* translate msg.text \r's -> \n's      */
char *cp;
{
     for ( ; *cp != '\0' ; cp++) {
          if (*cp == '\r') {
               *cp='\n';
          }
     }
}

STATIC int
chkdir(dir)                        /* check directory structure for MHS    */
char *dir;
{
     char chknam[40];

     strcpy(chknam,dir);
     strcat(chknam,"\\PARCEL");
     if (fnd1st(&sigfnd,dir,FAMDIR)) {
          if (!fnd1st(&sigfnd,chknam,FAMDIR)) {
               return(mkdir(chknam) == 0);
          }
          return(1);
     }
     if (mkdir(dir) == 0) {
          return(mkdir(chknam) == 0);
     }
     return(0);
}

STATIC void
zapbck(dir)                        /* zap trailing backslash if present    */
char *dir;
{
     int pos;

     if (dir[(pos=strlen(dir)-1)] == '\\') {
          dir[pos]='\0';
     }
}

int
valmhs(buff)                       /* does stg contain valid MHS '@' char  */
char *buff;
{
     char *ptr;

     for (ptr=buff ; *ptr != '\0' ; ptr++) {
          if (*ptr == '@') {
               return(1);
          }
     }
     return(0);
}

int
mhsfsnd(void)                      /* find if MHS sender is available      */
{
     int retval;

     setbtv(mhsbb);
     if ((retval=acqbtv(&esgptr->mhs,&esgptr->msg.msgno,0)) == 1) {
          esgptr->mhsfpos=absbtv();
     }
     else {
          esgptr->mhs.addr[0]='\0';
     }
     rstbtv();
     return(retval);
}

int
fwdmhs(void)                  /* forward or copy current msg to MHS        */
{
     estabc();
     mkmsgn();
     if (sendmhs()) {
          prfmsg(SNTMHS);
          return(1);
     }
     return(0);
}

void
sigmhs(void)                       /* copy the SIG message to MHS          */
{
     if (findsigu(esgptr->msg.to,1) != NOSIG) {
          if (mhsact && sdtptr->mhsaddr != NULL) {
               sendmhs();
               clrprf();
          }
     }
}

void
clsmhs(void)                       /* shutdown MHS processing              */
{
     if (filfp != NULL) {
          fclose(filfp);
          filfp=NULL;
     }
     if (filhdl > -1) {
          close(filhdl);
     }
     clsbtv(mhsbb);
     clsbtv(mhmbb);
}

/* The following routines deal with background exporting of MHS messages:  */

void
outrtk(void)                       /* scan for outgoing MHS messages       */
{
     char frmfil[FSPSIZ];

     if (!mhsact) {
          return;
     }
     setbtv(mhmbb);
     if (alobtv(mhstmp,0)) {
          if (mhstmp->to[0] == SIGIDC || !chkuse(mhstmp->msgno)) {
               if (mhstmp->flags&FILATT) {
                    stzcpy(frmfil,attfs(mhstmp),FSPSIZ);
                    if (mhscfil(frmfil,mhsatn(mhstmp),expwdn)) {
                         curexp=mhstmp->msgno;
                         setbtv(esgbb);
                         strcpy(compos.userid,mhstmp->to);
                         compos.msgno=curexp;
                         if (acqbtv(NULL,&compos,TONUM)) {
                              curfps=absbtv();
                         }
                         return;
                    }
               }
               else {
                    setbtv(mhsbb);
                    if (acqbtv(&tmpinf,&mhstmp->msgno,0)) {
                         if (sndito(mhstmp,tmpinf.addr)) {
                              delbtv();
                              setbtv(mhmbb);
                              delbtv();
                         }
                    }
               }
          }
     }
     rtkick(outscn,outrtk);
}

STATIC int
chkuse(msgno)                      /* check a msgno for use (1=used,0=not) */
long msgno;                             /* message number to check for     */
{
     int i;

     for (i=0 ; i < nterms ; i++) {
          if (user[i].state == emlstt || user[i].state == sigstt) {
               if (esgarr(i)->msg.msgno == msgno ||
                   esgarr(i)->curpos == msgno) {
                    return(1);
               }
          }
     }
     return(0);
}

int
mhschk(fpos)                       /* is MHS using this message now?       */
long fpos;                              /* file position for this message  */
{
     return(curfps == fpos);
}

STATIC void
expwdn(void)                       /* copying exported msg when done rou   */
{
     setbtv(mhmbb);
     if (acqbtv(mhstmp,&curexp,0)) {
          if (mhstmp->to[0] != SIGIDC) {
               unlink(attfsd(mhstmp));
          }
          setbtv(mhsbb);
          if (acqbtv(&tmpinf,&mhstmp->msgno,0)) {
               if (sndito(mhstmp,tmpinf.addr)) {
                    delbtv();
                    setbtv(mhmbb);
                    delbtv();
               }
          }
     }
     curexp=curfps=0L;
     rtkick(outscn,outrtk);
}

STATIC int
mhscfil(from,to,whndun)            /* copy an MHS-related file now         */
char *from;                             /* from this file                  */
char *to;                               /* to this file                    */
void (*(whndun))();                     /* when all done, call this        */
{
     int unum,savusn;
     struct user *uptr;

     if ((unum=frenhd()) != -1) {
          uptr=&user[unum];
          uptr->class=BBSPRV;
          uptr->state=mhsstt;
          uptr->substt=STARTC;
          uptr->flags|=(NOZAP|NOINJO);
          setmem(othmhs(unum),sizeof(struct mhschn),0);
          stzcpy(othmhs(unum)->from,from,FSPSIZ);
          stzcpy(othmhs(unum)->to,to,FSPSIZ);
          othmhs(unum)->whndun=whndun;
          btuinj(unum,CYCLE);
          savusn=usrnum;
          usrnum=unum;
          shochl("(Copying MHS file attachment)",'A',baudat(uptr->baud,0));
          usrnum=savusn;
          return(1);
     }
     return(0);
}

STATIC int
frenhd(void)                       /* return 1st free non-hardware channel */
{
     int i;

     for (i=0 ; i < nterms ; i++) {
          if (user[i].flags&NOHDWE) {
               if (user[i].class == VACANT && user[i].state == AWAITC) {
                    return(i);
               }
          }
     }
     return(-1);
}

STATIC int
mhsinp(void)                       /* MHS input handler (stub)             */
{
     return(1);
}

STATIC void
mhssta(void)                       /* MHS export handler status routine    */
{
     int siz;
     static int cyccnt=0;

     if (status == CYCLE) {
          if (++cyccnt > MHSDLY) {
               cyccnt=0;
               switch (usrptr->substt) {
               case STARTC:
                    if ((mhsusr->infp=fopen(mhsusr->from,FOPRB)) == NULL) {
                         fincpy();
                         return;
                    }
                    if ((mhsusr->outfp=fopen(mhsusr->to,FOPWB)) == NULL) {
                         fclose(mhsusr->infp);
                         fincpy();
                         return;
                    }
                    usrptr->substt=INCOPY;
                    break;
               case INCOPY:
                    siz=fread(vdatmp,1,MHSCHK,mhsusr->infp);
                    fwrite(vdatmp,1,siz,mhsusr->outfp);
                    if (siz < MHSCHK) {
                         fclose(mhsusr->infp);
                         fclose(mhsusr->outfp);
                         fincpy();
                         return;
                    }
                    break;
               }
          }
          btuinj(usrnum,CYCLE);
     }
}

STATIC void
mhscup(void)                       /* MHS general cleanup routine          */
{
     clnmhs(mhsfild,mhsoutd);
}

STATIC void
clnmhs(filpth,msgpth)              /* clean out old MHS file attachments   */
char *filpth;                           /* path to find outgoing MHS files */
char *msgpth;                           /* path to find outgoing MHS msgs  */
{
     int delit,i;
     char *curfil;
     struct fndblk fb;

     bldrfl(msgpth);
     curfil=makpth(filpth,"*.*");
     if (fnd1st(&fb,curfil,0)) {
          do {
               curfil=makpth(filpth,fb.name);
               if (curfil[strlen(curfil)-1] == '.') {
                    curfil[strlen(curfil)-1]='\0';
               }
               delit=1;
               for (i=0 ; i < numrfd ; i++) {
                    if (sameas(curfil,refdfl[i])) {
                         delit=0;
                         break;
                    }
               }
               if (delit) {
                    unlink(curfil);
               }
          } while (fndnxt(&fb));
     }
     for (i=0 ; i < numrfd ; i++) {
          free(refdfl[i]);
     }
     free(refdfl);
}

STATIC void
bldrfl(msgpth)                     /* build "referenced in msgs" file list */
char *msgpth;                           /* path to find outgoing MHS msgs  */
{
     FILE *fp;
     char *curfil;
     struct fndblk fb;

     numrfd=0;
     refdfl=NULL;
     curfil=makpth(msgpth,"*.*");
     cntdir(curfil);
     if (numfils == 0L || !fnd1st(&fb,curfil,0)) {
          return;
     }
     refdfl=(char **)alczer(sizeof(char *)*(int)numfils);
     do {
          curfil=makpth(msgpth,fb.name);
          if ((fp=fopen(curfil,FOPRA)) != NULL) {
               while (fgets(vdatmp,vdasiz,fp) != NULL) {
                    if (sameto(ATTBGN,vdatmp)) {
                         refdfl[numrfd]=alcdup(skpwht(&vdatmp[strlen(ATTBGN)]));
                         depad(refdfl[numrfd]);
                         numrfd++;
                         break;
                    }
               }
               fclose(fp);
          }
     } while (fndnxt(&fb));
}

STATIC char *
makpth(pthpre,filnam)              /* make a path out of prefix and file   */
char *pthpre;                           /* path prefix to use              */
char *filnam;                           /* file name to use                */
{
     static char retbuf[FSPSIZ];

     stzcpy(retbuf,pthpre,FSPSIZ);
     if (retbuf[strlen(retbuf)-1] != '\\') {
          strncat(retbuf,"\\",FSPSIZ-1);
     }
     strncat(retbuf,filnam,FSPSIZ-1);
     return(retbuf);
}

STATIC void
fincpy(void)                       /* finish up copying a MHS file now     */
{
     mhsusr->whndun();
     rstchn();
}

STATIC char *
mhsatn(msg)                        /* returns exact path\name for file att */
struct message *msg;                    /* message structure pointer       */
{
     static char filnam[FSPSIZ];

     stzcpy(filnam,mhsfild,FSPSIZ);
     strncat(filnam,"\\",FSPSIZ-1);
     strncat(filnam,strppt(attfsd(msg)),FSPSIZ-1);
     return(strpex(filnam));
}

STATIC char *
strpex(fil)                        /* strip the extension off of a file    */
char *fil;                              /* file name to strip from         */
{
     char *ptr;

     if ((ptr=strchr(fil,'.')) != NULL) {
          *ptr='\0';
     }
     return(fil);
}

STATIC char *
strppt(fil)                        /* strip the path prefix off of a file  */
char *fil;                              /* file name to strip from         */
{
     int i;

     for (i=strlen(fil)-1 ; i >= 0 ; i--) {
          if (fil[i] == '\\') {
               break;
          }
     }
     if (i != -1) {
          strcpy(fil,&fil[i+1]);
     }
     return(fil);
}

/* The following routines deal with background importing of MHS messages:  */

void
mhsscn(void)                       /* scan for incoming MHS messages       */
{
     struct fndblk fb;

     if (!mhsact) {
          return;
     }
     strcpy(mhsfnm,mhsind);
     strcat(mhsfnm,"\\*.*");
     if (fnd1st(&fb,mhsfnm,0)) {
          do {
               if (!chk4bad(fb.name)) {
                    strcpy(mhsfnm,mhsind);
                    strcat(mhsfnm,"\\");
                    strcat(mhsfnm,fb.name);
                    netseterror(1);
                    if ((filhdl=sopen(mhsfnm,O_RDONLY,SH_DENYRW,0)) < 0) {
                         netseterror(0);
                    }
                    else {
                         netseterror(0);
                         if ((filfp=fdopen(filhdl,FOPRA)) == NULL) {
                              close(filhdl);
                         }
                         else {
                              rtkick(5,mhsrhd);
                              return;
                         }
                    }
               }
          } while (fndnxt(&fb));
     }
     rtkick(scnmhs,mhsscn);
}

void
mhsrhd(void)                       /* read and process the incoming header */
{
     struct mhskar *kptr;
     char *sptr,*dptr;
     char keywd[20];

     fnduid=0;
     fndsig=NOSIG;
     setmem(&mhsimp,sizeof(struct mhsimp),0);
     while ((sptr=fgets(vdatmp,vdasiz,filfp)) != NULL) {
          if (*sptr == '\n') {
               rtkick(5,mhschkh);
               return;
          }
          dptr=keywd;
          while (*sptr != ':' && *sptr != '\0'
            && dptr-keywd < sizeof(keywd)-1) {
              *dptr++=*sptr++;
          }
          if (*sptr != ':') {
               mhsbad();
               return;
          }
          *dptr='\0';
          if ((kptr=keywdok(keywd)) == NULL) {
               mhsbad();
               return;
          }
          sptr++;
          while (isspace(*sptr)) {
               sptr++;
          }
          mhsvdp=sptr;
          if (!(*(kptr->routine))()) {
               return;
          }
     }
     mhsbad();
}

void
mhschkh(void)                      /* check header components              */
{
     if (mhsimp.from[0] == '\0') {
          mhsbad();
     }
     else if (fnduid || fndsig != NOSIG) {
          appmsg=0;
          curimp=++sv.msgtot;
          if (mhsimp.flags&FILEAT) {
               trycpy();
          }
          else {
               mhstxt();
          }
     }
     else {
          sndnod();
     }
}

STATIC void
trycpy(void)                       /* try to copy (import) a file now      */
{
     mhstmp->msgno=curimp;
     stzcpy(mhstmp->to,mhsimp.to,UIDSIZ);
     if (!mhscfil(mhsimp.attnme,attfsd(mhstmp),impwdn)) {
          rtkick(3,trycpy);
     }
}

STATIC void
impwdn(void)                       /* when done routine for import copy    */
{
     unlink(mhsimp.attnme);
     mhstxt();
}

void
sndnot(wchtyp)                     /* send a return notice                 */
int wchtyp;                        /* 0=Non Delivery 1=Return Receipt      */
{
     int handle;

     setmem(esgmhs,vdasiz,0);
     strcpy(mhsfn2,mhsoutd);
     strcat(mhsfn2,"\\");
     if ((handle=creattemp(mhsfn2,0)) != -1) {
          close(handle);
          if ((esgmhs->fp=fopen(mhsfn2,FOPWA)) != NULL) {
               fprintf(esgmhs->fp,"SMF-70\n");
               fprintf(esgmhs->fp,"MCB-Type: 1\n");
               fprintf(esgmhs->fp,"To: %s\n", mhsimp.from);
               fprintf(esgmhs->fp,"From: MBBS@%s {MBBS: %s}\n", gtwnme,mhsimp.to);
               fprintf(esgmhs->fp,"Subject: %s\n",
                    wchtyp == 0 ? "Non-Delivery Notification"
                                : "Return Receipt Notification");
               setmbk(esgmb);
               prfmsg(wchtyp == 0 ? MHSNOD : MHSREC,
                      mhsimp.date[0] == '\0' ? "Unknown" : mhsimp.date,
                      mhsimp.to);
               stpans(prfbuf);
               strcpy(esgmhs->msg.text,prfbuf);
               xltcrs(esgmhs->msg.text);
               clrprf();
               fprintf(esgmhs->fp,"\n");
               fprintf(esgmhs->fp,"%s",esgmhs->msg.text);
               fclose(esgmhs->fp);
          }
     }
}

void
mhstxt(void)                       /* read and process the incoming text   */
{
     int addmsg=0;
     int totbyt,maxsiz,cnt=0;
     char *ptr,buf[90];
     signed char c;

     setmem(esgmhs,vdasiz,0);
     if (appmsg) {
          curimp=++sv.msgtot;
          sprintf(buf,"\r<< Continued from Message #%ld >>\r\r",mhsimp.oldmsg);
          strcpy(esgmhs->msg.text,buf);
          totbyt=strlen(esgmhs->msg.text);
     }
     else {
          strcpy(esgmhs->msg.text,"\r");
          totbyt=1;
     }
     maxsiz=msgbyts-300;
     while (totbyt+79+1 < maxsiz) {
          ptr=NULL;
          while (cnt < 79 && (c=fgetc(filfp)) != EOF) {
               if (c == ' ') {
                    ptr=&buf[cnt];
               }
               if (c == '\n' || c == '\r') {
                    buf[cnt++]='\r';
                    buf[cnt]='\0';
                    strcat(esgmhs->msg.text,buf);
                    totbyt=strlen(esgmhs->msg.text);
                    cnt=0;
                    break;
               }
               else {
                    buf[cnt++]=c;
               }
          }
          if (c == EOF) {
               buf[cnt]='\r';
               buf[cnt++]='\0';
               strcat(esgmhs->msg.text,buf);
               break;
          }
          if (cnt >= 79) {
               if (ptr != NULL) {
                    *ptr='\0';
                    buf[cnt]='\0';
                    strcat(esgmhs->msg.text,buf);
                    strcat(esgmhs->msg.text,"\r");
                    movmem(ptr+1,buf,(int)(&buf[cnt]-ptr));
                    cnt=strlen(buf);
               }
               else {
                    buf[cnt]='\r';
                    buf[++cnt]='\0';
                    cnt=0;
                    strcat(esgmhs->msg.text,buf);
               }
               totbyt=strlen(esgmhs->msg.text);
          }
     }
     if (c != EOF) {
          appmsg=addmsg=1;
          mhsimp.oldmsg=sv.msgtot+1;
          strcat(esgmhs->msg.text,"\r<< Continued in next Message >>\r");
     }
     else {
          addmsg=0;
     }
     esgmhs->msg.msgno=curimp;
     strcpy(esgmhs->msg.to,mhsimp.to);
     if (fndsig != NOSIG && mhsimp.userto[0] != '\0') {
          stzcpy(esgmhs->msg.userto,mhsimp.userto,UIDSIZ);
     }
     else {
          strcpy(esgmhs->msg.userto,fndsig != NOSIG ? ALL : mhsimp.to);
     }
     stzcpy(esgmhs->msg.from,mhsimp.from,UIDSIZ);
     strcpy(esgmhs->msg.topic,(mhsimp.flags&HASSUB) ? mhsimp.subject
                                                    : "<< None >>");
     esgmhs->msg.crdate=today();
     esgmhs->msg.crtime=now();
     esgmhs->msg.flags=MHSMSG;
     if (esgmhs->msg.to[0] == SIGIDC) {
          if (findsigu(esgmhs->msg.to,0) == NOSIG) {
               sndnod();
               dlattm(&esgmhs->msg);
               return;
          }
     }
     else {
          setbtv(accbb);
          if (!acqbtv(&acctmp,esgmhs->msg.to,0) || (acctmp.flags&DELTAG)) {
               sndnod();
               rstbtv();
               dlattm(&esgmhs->msg);
               return;
          }
          rstbtv();
     }
     if (mhsimp.flags&FILEAT) {
          esgmhs->msg.flags|=FILATT;
          if (esgmhs->msg.to[0] != SIGIDC) {
               esgmhs->msg.flags|=APPVED;
          }
          mhsimp.flags&=~FILEAT;
     }
     sendmsg(&esgmhs->msg,NULL);
     setbtv(mhsbb);
     esgmhs->mhs.msgno=esgmhs->msg.msgno;
     strcpy(esgmhs->mhs.addr,mhsimp.from);
     insbtv(&esgmhs->mhs);
     rstbtv();
     curimp=0L;
     if (!addmsg) {
          mhsfpst();
     }
     else {
          rtkick(3,mhstxt);
     }
}

STATIC void
dlattm(msg)                        /* possibly delete the file attachment  */
struct message *msg;                    /* message structure for att       */
{
     if (mhsimp.flags&FILEAT) {
          unlink(attfsd(msg));
     }
}

STATIC void
mhsfpst(void)                      /* finish up posting messages           */
{
     if (onsys(esgmhs->msg.userto)) {
          setmbk(esgmb);
          clrmlt();
          prfmlt(MHSDLR);
          injoth();
     }
     if (mhsimp.flags&REQREC) {
          sndnot(1);
     }
     delimp();
     rtkick(scnmhs,mhsscn);
}

void
mhsbad(void)                       /* something wrong with msg to import   */
{
     char *ptr;

     fclose(filfp);
     filfp=NULL;
     strcpy(mhsfn2,mhsfnm);
     if ((ptr=strchr(mhsfn2,'.')) == NULL) {
          strcat(mhsfn2,".BAD");
     }
     else {
          *++ptr='B';
          *++ptr='A';
          *++ptr='D';
     }
     if (mhsimp.flags&ISNOTI) {
          delimp();
     }
     else if (!rename(mhsfnm,mhsfn2)) {
          bad2sy();
     }
     rtkick(scnmhs,mhsscn);
}

STATIC void
bad2sy(void)                  /* send email to Sysop about a .BAD message  */
{
     setmem(esgmhs,vdasiz,0);
     esgmhs->msg.msgno=++sv.msgtot;
     strcpy(esgmhs->msg.to,"Sysop");
     strcpy(esgmhs->msg.userto,"Sysop");
     strcpy(esgmhs->msg.from,"Sysop");
     strcpy(esgmhs->msg.topic,"* MHS Import Notice *");
     setmbk(esgmb);
     prfmsg(INVMHS,mhsfnm);
     stpans(prfbuf);
     strcpy(esgmhs->msg.text,prfbuf);
     xltcrs(esgmhs->msg.text);
     clrprf();
     esgmhs->msg.crdate=today();
     esgmhs->msg.crtime=now();
     setbtv(esgbb);
     invbtv(&esgmhs->msg,NVMSIZ+strlen(esgmhs->msg.text));
     rstbtv();
     sv.emlopn++;
}

STATIC int
chk4bad(fname)                     /* check for ".BAD" extension           */
char *fname;
{
     char *ptr;

     ptr=strchr(fname,'.');
     if (ptr != NULL) {
          if (sameas(ptr,".BAD")) {
               return(1);
          }
     }
     return(0);
}

STATIC struct mhskar *
keywdok(stgptr)                    /* check valid keyword list             */
char *stgptr;
{
     int cond;
     struct mhskar *low,*mid,*high;

     low=&mhskwd[0];
     high=&mhskwd[HDRSIZ-1];
     while (low <= high) {
          mid=low+((int)(high-low))/2;
          if ((cond=stricmp(stgptr,mid->hdrwrd)) < 0) {
               if (mid == low) {
                    break;
               }
               high=mid-1;
          }
          else if (cond > 0) {
               if (mid == high) {
                    break;
               }
               low=mid+1;
          }
          else {
               return(mid);
          }
     }
     return(NULL);
}

STATIC int
touid(void)                        /* process "TO" keyword data            */
{
     int i=0,siz,spc=0;
     char uid[UIDSIZ];
     char *ptr;

     ptr=strchr(mhsvdp,'{');
     if (ptr != NULL) {
          ptr++;
          if (sameto("MBBS:",ptr)) {
               ptr+=5;
               while (isspace(*ptr)) {
                    ptr++;
               }
          }
          siz=(*ptr == SIGIDC ? SIGSIZ : UIDSIZ)-1;
          do {
               uid[i++]=*ptr++;
          } while (i < siz && *ptr != '\0' && *ptr != '}');
          uid[i]='\0';
          for (spc = i; spc > 0 ; spc--) {
               if ((uid[spc] == ' ') || (uid[spc] == '\0')) {
                    uid[spc]='\0';
               }
               else {
                    break;
               }
          }                    /* loop thru backwards and pow all spaces... */
          strcpy(mhsimp.to,uid);                   /* for NDN's */
          if (uid[0] == SIGIDC) {
               if ((fndsig=findsigu(uid,0)) != NOSIG) {
                    strcpy(mhsimp.to,uid);
               }
          }
          else {
               setbtv(accbb);
               if ((fnduid=qeqbtv(uid,0)) == 1) {
                    makhdl(uid);
                    strcpy(mhsimp.to,uid);
               }
               rstbtv();
          }
     }
     return(1);
}

STATIC int
frmadr(void)                       /* process "FROM" keyword data          */
{
     char *ptr;

     ptr=strchr(mhsvdp,'\n');
     if (ptr != NULL) {
          *ptr='\0';
     }
     ptr=strchr(mhsvdp,'\r');
     if (ptr != NULL) {
          *ptr='\0';
     }
     if (*mhsvdp != '\0') {
          stzcpy(mhsimp.from,mhsvdp,MHSADR);
     }
     return(1);
}

STATIC int
msgsub(void)                       /* process "SUBJECT" keyword data       */
{
     int len;

     stzcpy(mhsimp.subject,mhsvdp,TPCSIZ);
     len=strlen(mhsimp.subject);
     if (len != 0 && mhsimp.subject[len-1] == '\n') {
          mhsimp.subject[len-1]='\0';
     }
     mhsimp.flags|=HASSUB;
     return(1);
}


STATIC int
hdlsum(void)                       /* process "SUMMARY" keyword data       */
{
     char *ptr,*gptr,*tptr;

     ptr=skpwht(mhsvdp);
     if (sameto("MBBS: ",ptr)) {
          ptr+=strlen("MBBS: ");
          if ((gptr=strstr(ptr,"@")) != NULL) {
               if (sameas(gptr+1,gtwnme)) {
                    *gptr='\0';
               }
          }
          tptr=strchr(ptr,'\n');             /* Zap the NL */
          if (tptr!= NULL) {
               *tptr='\0';
          }
          tptr=strchr(ptr,'\r');             /* Zap the CR */
          if (tptr!= NULL) {
               *tptr='\0';
          }
          stzcpy(mhsimp.userto,ptr,UIDSIZ);
     }
     return(1);
}

STATIC int
nottyp(void)                       /* process "TYPE" keyword data          */
{                                  /* 0=Message 1=Some notification        */
     if (*mhsvdp == '1') {
          mhsimp.flags|=ISNOTI;
     }
     return(1);
}

STATIC int
retrec(void)                       /* process "RRN" keyword data           */
{                                  /* Return Receipt Requested?            */
     if (*mhsvdp != 'Y' && *mhsvdp != 'N') {
          mhsbad();
          return(0);
     }
     if (*mhsvdp == 'Y') {
          mhsimp.flags|=REQREC;
     }
     return(1);
}

STATIC int
attmnt(void)                       /* process "ATTACHMENT" line            */
{
     char fbuf[13];

     if (*mhsvdp != '\0') {
          stzcpy(fbuf,mhsvdp,sizeof(fbuf));
          stzcpy(mhsimp.attnme,mhsind,FSPSIZ);
          strncat(mhsimp.attnme,"\\PARCEL\\",FSPSIZ);
          strncat(mhsimp.attnme,fbuf,FSPSIZ-1);
          depad(mhsimp.attnme);
          mhsimp.flags|=FILEAT;
     }
     return(1);
}



STATIC int
nodnot(void)                       /* process "NDN" keyword data           */
{                                  /* Non-delivery note Requested?         */
     if (*mhsvdp != 'Y' && *mhsvdp != 'N') {
          mhsbad();
          return(0);
     }
     if (*mhsvdp == 'Y') {
          mhsimp.flags|=REQNOD;
     }
     return(1);
}

STATIC int
errnum(void)                       /* process "ERC" keyword data           */
{                                  /* What's wrong if this is non-delivery */
     mhsimp.errcode=atoi(mhsvdp);
     return(1);
}

STATIC int
msgdte(void)                       /* process "DATE" keyword data          */
{
     char *ddptr;

     ddptr=strchr(mhsvdp,'\n');
     if (ddptr != NULL) {
          *ddptr='\0';
     }
     ddptr=strchr(mhsvdp,'\r');
     if (ddptr != NULL) {
          *ddptr='\0';
     }
     if (*mhsvdp != '\0') {
          stzcpy(mhsimp.date,mhsvdp,sizeof(mhsimp.date));
     }
     return(1);
}

STATIC int
nulrou(void)
{
     return(1);
}

STATIC char
netseterror(mode)                  /* set network error mode               */
int mode;
{
     char rv;

I    mov  ah,0x0DD
I    mov  dx,mode
I    int  21h
I    xor  ah,ah
I    mov  rv,al
     return(rv);
}

STATIC void
sndnod(void)                       /* NDN requested? Delete MHS import     */
{
     if (mhsimp.flags&REQNOD) {
          sndnot(0);
     }
     delimp();
     rtkick(scnmhs,mhsscn);
}

STATIC void
delimp(void)                       /* delete a message from import dir     */
{
     fclose(filfp);
     filfp=NULL;
     unlink(mhsfnm);
}

/***********************************************************************
  support for new exportable message-send API code follows...
 ***********************************************************************/

int
snd2mhs(msg,to)                    /* send a message to an MHS address     */
struct message *msg;
char *to;
{
     if (mhsact && uhskey(msg->from,mhskey)) {
          setbtv(mhmbb);
          invbtv(msg,NVMSIZ+strlen(msg->text));
          rstbtv();
          setbtv(mhsbb);
          tmpinf.msgno=msg->msgno;
          stzcpy(tmpinf.addr,to,MHSADR);
          insbtv(&tmpinf);
          rstbtv();
          return(1);
     }
     return(0);
}
