###############################################################################
##### This Makefile generates the "MAJORBBS.EXE" and all standard DLL's   #####
###############################################################################

.autodepend
.silent
.path.c=\bbsv6\src
.path.h=\bbsv6\src
.path.dll=\bbsv6
.path.msg=\bbsv6
.path.obj=\bbsv6\phobj
.path.exe=\bbsv6

majorbbs.exe: \
     bbsacct.h      bbsedtf.h      bbsedtm.h      bbsfsd.h                 \
     bbsftf.h       bbsmajor.h     bbssup.h       plstuff.h                \
     about.obj      account.obj    accscn.obj     ain.obj        audit.obj \
     autsns.obj     bbsgen.obj     bbsutils.obj   plbtvstf.obj   cncutl.obj\
     dftstats.obj   editfse.obj    emulate.obj    filexfer.obj   fsd.obj   \
     fsdbbs.obj     ftf.obj        ftfascii.obj   ftfcrc.obj               \
     ftfkerm.obj    ftfview.obj    ftfxymd.obj    ftfzmod.obj              \
     helpscn.obj    local.obj      locknkey.obj   majorbbs.obj             \
     menuing.obj    monitor.obj    oprlow.obj     plbbs.obj                \
     plstuff.obj    saputl.obj     signup.obj     statscns.obj             \
     summary.obj    users.obj                                              \
     galglo.dll     gallib.dll     galmjd.dll     galmsg.dll     galpol.dll\
     galreg.dll     galrsy.dll     galtlc.dll     galtxv.dll     galuie.dll\
     galxit.dll                                                            \
     \bbsv6\dlib\phgcomm.lib       \bbsv6\dlib\plhide.lib                  \
     \run286\bc3\lib\bch286.lib    \run286\bc3\lib\phapi.lib               \
     \bbsv6\dlib\majorbbs.def
     ltph

###############################################################################
#####                           Build DLL's                               #####
###############################################################################

galglo.dll: \
     galglo.h                                                              \
     galglo.obj                                                            \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib     \bbsv6\dlib\nodef.def
     ltdll galglo

gallib.dll: \
     gallibr.h                                                             \
     galfiln.obj    gallibn.obj    libdisp.obj    library.obj              \
     libsupt.obj    libutil.obj                                            \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib     \bbsv6\dlib\gallib.def
     ltdll gallib

galmjd.dll: \
     galmjd.h                                                              \
     galmjd.obj                                                            \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib     \bbsv6\dlib\nodef.def
     ltdll galmjd

galmsg.dll: \
     galms.h                                                               \
     datutils.obj   distlst.obj    esgutl.obj     sigs.obj                 \
     email.obj      mhshdl.obj                                             \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib     \bbsv6\dlib\galmsg.def
     ltdll galmsg

galpol.dll: \
     galpolls.h                                                            \
     pollster.obj                                                          \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib     \bbsv6\dlib\nodef.def
     ltdll galpol

galreg.dll: \
     galregis.h                                                            \
     registry.obj                                                          \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib     \bbsv6\dlib\nodef.def
     ltdll galreg

galrsy.dll: \
     galrsy.h                                                              \
     remsys.obj     remsys2.obj                                            \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib     \bbsv6\dlib\nodef.def
     ltdll galrsy

galtlc.dll: \
     galtlc.h                                                              \
     mjrtlc.obj                                                            \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib     \bbsv6\dlib\nodef.def
     ltdll galtlc

galtxv.dll: \
     txtvbl.obj                                                            \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib     \bbsv6\dlib\nodef.def
     ltdll galtxv

galuie.dll: \
     bbssup.h                                                              \
     uinfed.obj                                                            \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib     \bbsv6\dlib\nodef.def
     ltdll galuie

galxit.dll: \
     bbsmajor.h                                                            \
     mjrexit.obj                                                           \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib     \bbsv6\dlib\nodef.def
     ltdll galxit

###############################################################################
#####                 Build Objects For GALLIB DLL                        #####
###############################################################################

galfiln.obj: galfiln.c
     ctdll galfiln.c

gallibn.obj: gallibn.c
     ctdll gallibn.c

libdisp.obj: libdisp.c
     ctdll libdisp

library.obj: library.c
     ctdll library.c

libsupt.obj: libsupt.c
     ctdll libsupt.c

libutil.obj: libutil.c
     ctdll libutil.c

###############################################################################
#####                 Build Objects For GALMJD DLL                        #####
###############################################################################

galmjd.obj: galmjd.c
     ctdll galmjd

###############################################################################
#####                 Build Objects For GALMSG DLL                        #####
###############################################################################

datutils.obj: datutils.c
     ctdll datutils

distlst.obj: distlst.c
     ctdll distlst

email.obj: email.c
     ctdll email

esgutl.obj: esgutl.c
     ctdll esgutl

mhshdl.obj: mhshdl.c
     ctdll mhshdl

sigs.obj: sigs.c
     ctdll sigs

###############################################################################
#####                 Build Objects For GALPOL DLL                        #####
###############################################################################

pollster.obj: pollster.c
     ctdll pollster

###############################################################################
#####                 Build Objects For GALGLO DLL                        #####
###############################################################################

galglo.obj: galglo.c
     ctdll galglo

###############################################################################
#####                 Build Objects For GALREG DLL                        #####
###############################################################################

registry.obj: registry.c
     ctdll registry

###############################################################################
#####                 Build Objects For GALRSY DLL                        #####
###############################################################################

remsys.obj: remsys.c
     ctdll remsys

remsys2.obj: remsys2.c
     ctdll remsys2

###############################################################################
#####                 Build Objects For GALTLC DLL                        #####
###############################################################################

mjrtlc.obj: mjrtlc.c
     ctdll mjrtlc

###############################################################################
#####                 Build Objects For GALTXV DLL                        #####
###############################################################################

txtvbl.obj: txtvbl.c
     ctdll txtvbl

###############################################################################
#####                 Build Objects For GALUIE DLL                        #####
###############################################################################

uinfed.obj: uinfed.c
     ctdll uinfed

###############################################################################
#####                 Build Objects For GALXIT DLL                        #####
###############################################################################

mjrexit.obj: mjrexit.c
     ctdll mjrexit

###############################################################################
#####                    Build Objects For main Executive                 #####
###############################################################################

about.obj: about.c
     ctph about

account.obj: account.c
     ctph account

accscn.obj: accscn.c
     ctph accscn

ain.obj: ain.c
     ctph ain

audit.obj: audit.c
     ctph audit

autsns.obj: autsns.c
     ctph autsns

bbsgen.obj: bbsgen.c
     ctph bbsgen

bbsutils.obj: bbsutils.c
     ctph bbsutils

plbtvstf.obj: plbtvstf.c
     ctph plbtvstf

cncutl.obj: cncutl.c
     ctph cncutl

dftstats.obj: dftstats.c
     ctph dftstats

editfse.obj: editfse.c
     ctph editfse

emulate.obj: emulate.c
     ctph emulate

filexfer.obj: filexfer.c
     ctph filexfer

fsd.obj: fsd.c
     ctph fsd

fsdbbs.obj: fsdbbs.c
     ctph fsdbbs

ftf.obj: ftf.c
     ctph ftf

ftfascii.obj: ftfascii.c
     ctph ftfascii

ftfcrc.obj: ftfcrc.c
     ctph ftfcrc

ftfkerm.obj: ftfkerm.c
     ctph ftfkerm

ftfview.obj: ftfview.c
     ctph ftfview

ftfxymd.obj: ftfxymd.c
     ctph ftfxymd

ftfzmod.obj: ftfzmod.c
     ctph ftfzmod

helpscn.obj: helpscn.c
     ctph helpscn

local.obj: local.c
     ctph local

locknkey.obj: locknkey.c
     ctph locknkey

majorbbs.obj: majorbbs.c
     ctph majorbbs

menuing.obj: menuing.c
     ctph menuing

monitor.obj: monitor.c
     ctph monitor

oprlow.obj: oprlow.c
     ctph oprlow

plbbs.obj: plbbs.c
     ctph plbbs

plstuff.obj: plstuff.c
     ctph plstuff.c

saputl.obj: saputl.c
     ctph saputl

signup.obj: signup.c
     ctph signup

statscns.obj: statscns.c
     ctph statscns

summary.obj: summary.c
     ctph summary

users.obj: users.c
     ctph users

###############################################################################
#####               Generate Headers for Compilation                      #####
###############################################################################

bbsacct.h: bbsacct.msg
     cd \bbsv6
     bbsmsx bbsacct -osrc
     cd \bbsv6\src

bbsedtf.h: bbsedtf.msg
     cd \bbsv6
     bbsmsx bbsedtf -osrc
     cd \bbsv6\src

bbsedtm.h: bbsedtm.msg
     cd \bbsv6
     bbsmsx bbsedtm -osrc
     cd \bbsv6\src

galms.h: galms.msg
     cd \bbsv6
     bbsmsx galms -osrc
     cd \bbsv6\src

bbsfsd.h: bbsfsd.msg
     cd \bbsv6
     bbsmsx bbsfsd -osrc
     cd \bbsv6\src

bbsftf.h: bbsftf.msg
     cd \bbsv6
     bbsmsx bbsftf -osrc
     cd \bbsv6\src

bbsmajor.h: bbsmajor.msg
     cd \bbsv6
     bbsmsx bbsmajor -osrc
     cd \bbsv6\src

galglo.h: galglo.msg
     cd \bbsv6
     bbsmsx galglo -osrc
     cd \bbsv6\src

galtlc.h: galtlc.msg
     cd \bbsv6
     bbsmsx galtlc -osrc
     cd \bbsv6\src

galpolls.h: galpolls.msg
     cd \bbsv6
     bbsmsx galpolls -osrc
     cd \bbsv6\src

galregis.h: galregis.msg
     cd \bbsv6
     bbsmsx galregis -osrc
     cd \bbsv6\src

galrsy.h: galrsy.msg
     cd \bbsv6
     bbsmsx galrsy -osrc
     cd \bbsv6\src

bbssup.h: bbssup.msg
     cd \bbsv6
     bbsmsx bbssup -osrc
     cd \bbsv6\src

gallibr.h: gallibr.msg
     cd \bbsv6
     bbsmsx gallibr -osrc
     cd \bbsv6\src

galmjd.h: galmjd.msg
     cd \bbsv6
     bbsmsx galmjd -osrc
     cd \bbsv6\src
