/***************************************************************************
 *                                                                         *
 *   MAJORBBS.C                                                            *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS mainline.                                       *
 *                                                                         *
 *                                        - T. Stryker 6/24/86             *
 *                    v6.0 enhancements   - C. Robert & S. Brinker 10/1/91 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "bbsmajor.h"
#include "ipx.h"
#include "saputl.h"
#include "filexfer.h"
#include "fsdbbs.h"
#include "plstuff.h"

int lastusrnu=-1;             /* usernum of last exception                 */

char version[9],              /* main version code, in form X.YY           */
     subvers[40];             /* sub-version info, ext ed rls letters      */

struct module module00={      /* module interface block                    */
     "Menuing System",        /*    description for main menu              */
     NULL,                    /*    user logon supplemental routine        */
     mainu,                   /*    input routine if selected              */
     musthn,                  /*    status-input routine if selected       */
     NULL,                    /*    "injoth" routine for this module       */
     NULL,                    /*    user logoff supplemental routine       */
     loscar,                  /*    hangup (lost carrier) routine          */
     midnit,                  /*    midnight cleanup routine               */
     NULL,                    /*    delete-account routine                 */
     mjrfin                   /*    finish-up (sys shutdown) routine       */
};

int syslod=1;                 /* system loading (constantly updated)       */
unsigned long sysinj;         /* time of injection for system loading      */

struct module **module;       /* in-memory array of online modules         */
int nmods=0;                  /* current number of online modules in memory*/

struct mdstats *mdstats;      /* in-memory array of module statistics      */

struct textvar *txtvars;      /* in-memory array of text variables         */
int ntvars=0;                 /* current number of text variables in memory*/

int numxrf;                   /* size of possible user-id listing for usrs */
long *xrfpos;                 /* uid xref positions/user in BBSXRF.DAT     */
BTVFILE *xrfbb;               /* Btrieve file pointer for BBSXRF.DAT       */
struct uidxrf uidxrf;         /* general user-id cross reference structure */

BTVFILE *genbb;               /* generic user data file btrieve file ptr   */

#define xrfidx(n)   (usrnum*numxrf+n)

int nterms=1,                 /* this many simultaneous users are config'd */
    hichp1=1;                 /* highest channel number in use, plus 1     */

int usrnum,                   /* global user-number (channel) in effect    */
    othusn,                   /* general purpose other-user channel number */
    uisusn;                   /* uinsys() other-user channel number        */
int nchans;                   /* number of GSBL channels defined, nterms+1?*/
int sapsup=0;                 /* Server Advertising Protocol supported?    */
struct user *user,            /* user volatile-data structure array        */
            *usrptr,          /* global pointer to user data in effect     */
            *othusp;          /* gen purp other-user user structure ptr    */
struct extusr *extusr,        /* extra user volatile-data structure array  */
              *extptr,        /* global pointer to extra info about cur usr*/
              *othexp;        /* gen purp other-user user structre ptr     */

BTVFILE *mstbb;               /* module statistics btrieve file pointer    */

char input[INPSIZ],           /* raw user input data buffer                */
     *margv[INPSIZ/2],        /* array of ptrs to word starts, a la argv[] */
     *margn[INPSIZ/2];        /* array of ptrs to word ends, for rstrin()  */

int nglobs,                   /* # of global command handlers in operation */
    (*globs[GLBMAX])();       /* array of ptrs to glbl cmd hdlr functions  */

                              /* INTERCEPT VECTORS                         */
                              /* Use as you would interrupt vectors:  save */
                              /* what's here, replace with your handler    */
                              /* routine, then when that routine executes, */
                              /* call the vector that was saved.           */

void (*hdlcon)();             /* handle connection with user               */
void (*hdlc25)();             /* handle incoming X.25 call string (margv)  */
void (*hdlnrg)();             /* handle non-RING strings during AWAITC     */
void (*hdlrng)();             /* handle non-X25 RING string (AWAITC,HARING)*/
int (*hdlcnc)();              /* handle non-RING whatever during HARING    */

#define RTIMAX  5             /* max number of real-time interrupt routines*/
int nrtirs;                   /* # of real-time irpt routines in operation */
void (*rtirs[RTIMAX])(void);  /* array of ptrs to real-time irpt routines  */

int margc;                    /* number of words in margv[], a la argc     */
int inplen,                   /* overall raw input string length           */
    status,                   /* raw status from btusts, where appropriate */
    pfnlvl,                   /* profanity level of current input (0-3)    */
    shortm;                   /* display short (0) or long (1) menus on x? */

jmp_buf eximod;               /* exit-module longjmp save block            */

FILE *mjrmb;                  /* executive named-message file block ptr    */
int mbdone;                   /* main-loop exit flag                       */
int rsmode,                   /* reset-mode code for channels              */
    *rsmodes;                 /* reset-mode array by channel number        */
int kilipg=0;                 /* kill-system command in progress           */
int kilctr;                   /* number of minutes to shutdown             */
int kilsrc;                   /* kill-command source (-1=console, -2=MCU,  */
                              /* -3=timed event, >=0=chan #)               */
int emubel;                   /* emulation bell period                     */
int maxscns;                  /* maximum number of screens                 */
int initdn;                   /* tells mjrfin all done initializing        */
int mcuctr=-1;                /* auto-cleanup minute counter               */
int lasthr;                   /* last hour reading sensed by ckmcu()       */
int gsblup=0;                 /* one btuitz() and zero btuend() calls?     */

int multsk;                   /* is a multitasker being used?              */
int mulmth;                   /* if multitasking what method is used       */

int errcod;                   /* MS-DOS exit codes (for batch files)       */
                              /*    errorlevel  0 - auto-cleanup (mcukil)  */
                              /*    errorlevel  1 - operator "kill-system" */
                              /*    errorlevel  8 - remote Sysop kill sys  */
                              /*    errorlevel 11 - mail shutdown #1       */
                              /*    errorlevel 12 - mail shutdown #2       */
                              /*    errorlevel 13 - mail shutdown #3       */
                              /*    errorlevel 14 - mail shutdown #4       */
                              /*    errorlevel 49 - out of memory          */
                              /*    errorlevel 70 - 1 catastro, clean kill */
                              /*    errorlevel 80 - 2 cata's, need reboot  */
                              /*    errorlevel 90 - cata w/no shutdown vec */
                              /*    errorlevel 99 - nonrecoverable GP      */

int *shterc;                  /* auto-shutdown errorlevels as a function   */
                              /*    of the hour of the day                 */

int *channel;                 /* array of channel codes (as displayed)     */
int *grpnum;                  /* array of group numbers, by channel number */
int *zaptbl;                  /* array of connect timeout values           */

#define   DFTOFF    0x0400    /* default offset between channels for GSBL  */

unsigned maxspd=2400;         /* overall maximum bps of all channels       */
unsigned maxpol=2400;         /* overall maximum polling rate for channels */
unsigned mxbaud[NGROUPS]={    /* array of maximum baud rates, by chan group*/
     2400,2400,2400,2400,2400,2400,2400,2400,2400};
char echtyp[NGROUPS];         /* array of echo options:                    */
#define ECHNON 0              /*    no echo at all of user keystrokes      */
#define ECHPLX 1              /*    echo comes from user's PAD             */
#define ECHBBS 2              /*    echo comes from the BBS thru X.25 net  */
char *startv[NGROUPS];        /* array of pointers to startup AT-commands  */
char chanty[NGROUPS];         /* array of btusdf() codes for LAN chan grps */
char grtype[NGROUPS];         /* array of Group Type codes                 */
int usofgr[NGROUPS];          /* 1st usrnum of each channel group (-1=NONE)*/
signed char sapstt[NGROUPS];  /* S.A.P. status 1=avail -1=busy 0=not used  */

                              /* line charges for X.25 lines:              */
long ksec[NGROUPS];           /* credits consumed per minute               */
long kpak[NGROUPS];           /* credits consumed per kilo-packet          */
long kchar[NGROUPS];          /* credits consumed per kilo-character       */

char *vdarea;                 /* volatile data area table (vdasiz per user)*/
char *vdaptr;                 /* user's pointer to volatile data area      */
char *vdatmp;                 /* general-purpose temporary vda-size area   */
int vdasiz=0;                 /* max. size requirement of volatile data    */
char *region=NULL;            /* GSBL channel data region                  */

unsigned tcklst;              /* last value of ticker                      */
unsigned long timcntr,        /* temporary time (btuhrt) storage           */
              prodtmr;        /* total productive time counter             */

extern
int stthue,                   /* system status display attribute code      */
    lblhue,                   /* soft-key labels display attribute code    */
    dsphue,                   /* data display box attribute code           */
    manhue,                   /* monitor-all normal display attribute code */
    mashue,                   /* monitor-all "special" disp attribute code */
    emthue,                   /* emulation text display attribute code     */
    emshue;                   /* emulation status display attribute code   */

extern int atoggl;            /* ANSI-display toggle (defaults to ON)      */

/*--- OPTIONS FROM BBSMAJOR.MSG ---*/

int outbsz,                   /* output buffer size per channel             */
    sampln,                   /* number of non-live (free-sample) channels */
    exicnc,                   /* concatenation implies module exit?        */
    langop,                   /* Language query at log-on? 1=auto 2=ask    */
    ansiop,                   /* ANSI option: on=N; off=F; ask=K; auto=O   */
    rsetop,                   /* reset option: busy=B; no-answer=N         */
    pfceil,                   /* profanity-detection ceiling               */
    visbel,                   /* bell setting when emulation is visible    */
    invbel,                   /* bell setting when emulation is hidden     */
    sopaud,                   /* route Audit Trail stuff to online Sysop   */
    auxist,                   /* enable secondary crt?                     */
    outata,                   /* output ATA to modems when answering?      */
    vispsw,                   /* make passwords visible in detail displays?*/
    modzap,                   /* the modem zap interval                    */
    idlzap,                   /* the idle user zap interval                */
    zapser,                   /* whether or not to idle-zap serial ports   */
    zapdlan,                  /* idle-zap direct-circuit LAN channels?     */
    zapvlan,                  /* idle-zap virtual-circuit LAN channels?    */
    mcumin,                   /* max grace period minutes on auto-cleanup  */
    mcuwrn,                   /* number of warning messages before hangup  */
    lonaud,                   /* make audit trail entry for each logon?    */
    lofaud,                   /* make audit trail entry for each logoff?   */
    mmuaud,                   /* make audit trail entry for main menu sels?*/
    mmucrr,                   /* Main menu credit consumption rate per min */
    svrate,                   /* System-variable save rate (seconds/save)  */
    mcuhr;                    /* Hour of day for midnight clean-up         */
char *bbsttl,                 /* Title of your BBS                         */
     *company,                /* Your company name                         */
     *addres1,                /* Company address line 1 (street)           */
     *addres2,                /* Company address line 2 (city,state,zip)   */
     *dataph,                 /* The first phone line connected to BBS     */
     *liveph,                 /* The first phone line reserved 4 live users*/
     *chghour,                /* Connect time charge per hour              */
     *chgmin,                 /* Minimum charge                            */
     *chgtime,                /* Minimum connect time                      */
     **scnpaus,               /* screen pause prompt text for btuxnf()     */
     *syskey,                 /* key for "sysop" powers: profanity and idle*/
     *mmuatr,                 /* default attribute for main menu selections*/
     *ansdim;                 /* dimmed attribute for main menu selections */

void (*tjoinrou)()=NULL,      /* teleconference JOINT routine              */
     (*ntfysopr)()=NULL,      /* notify remote sysop routine               */
     (*emlsdrou)()=NULL;      /* Send Email to Sysop/ New User routine     */

char eurmsk=0x7F;             /* 0x7F if U.S.A. only, 0xFF if European     */

unsigned tspxt;          /* ticker time of SPX session terminate command   */
#define MAXSPXT 10       /* Max time allowed for SPX termination           */
char *chantn[]={"IPXD","IPXV","SPX"};    /* LAN channel type names         */
unsigned answait=2*16;                     /* ANSI/ASCII detection timeout */
char *auansi="    [6n\b\b\b\b\r";         /* ANSI/ASCII detection string  */


STATIC void init(void);
STATIC int ctrlch(void);
STATIC void incx25(void);
STATIC void nonrng(void);
STATIC void incrng(void);
STATIC int mdmcnc(void);
STATIC void saphdl(int group,int opt);
STATIC void svacant(void);
STATIC int lsvans(void);
STATIC void gtsens(void);
STATIC void ansperm(void);
STATIC int ansisns(unsigned snccon,char *incbuf,int nbytes);
STATIC void figlang(void);
STATIC void askansi(void);
STATIC void greetem(void);
STATIC void uidpmt(void);
STATIC void sonline(void);
STATIC void hdlogo(void);
STATIC void othtrm(void);
STATIC void ssupipg(void);
STATIC void susing(void);
STATIC void inirel(void);
STATIC void inimzt(void);
STATIC void inirch(void);
STATIC void inimod(void);
STATIC void updclk(void);
STATIC void kalert(int msgnum,int nmins);
STATIC char secchi(int chan,int c);
STATIC void ret2mnu(int substt);
STATIC void gsbldn(void);
STATIC void failsf(void);
STATIC int newxrf(char *uid);
STATIC void xrfutl(char *userid,int add);
STATIC int prtpsk(int unum,char *lock);
STATIC int grppsk(int unum,char *lock);
STATIC int lngpsk(int unum,char *lock);
STATIC int propsk(int unum,char *lock);
STATIC void bbsrti(void);

void
main(void)                         /* The Major BBS main program loop      */
{
     int polnum=0;
     void aud1st(void);
     extern BTVFILE *audbb;
     char tmp[80];

     protinit("BBS ");
     sprintf(version,"%d.%02d%s",BBSVER/100,BBSVER%100,BBSIRV);
     if ((errcod=setjmp(disaster)) != 0) {
          (*module00.finrou)();
     }
     pascrit();
     errcod=1;
     init();
     usrnum=-1;
     setbtv(audbb);
     ghibtv(NULL,0);
     iniaud();
     setbtv(audbb);
     ghibtv(NULL,0);
     aud1st();
     tcklst=ticker;
     while (!mbdone) {
          if ((usrnum=btuscn()) >= 0) {
               status=btusts(usrnum);
               if (status == SYSSTS) {
                    syslod=syslod-((syslod+6)>>3)
                      +(int)(((hrtval()-sysinj+491L)/982L+4)>>3);
               }
               else if (usrnum == nterms) {
                    sapsts(status);
               }
               else {
                    curusr(usrnum);
                    if (status != CRSTG && status != CYCLE
                       && status != FSESTS) {
                         shomal();
                    }
                    if ((usrptr->flags&BYEBYE) && status == OUTMT) {
                         if (usrptr->class > SUPIPG) {
                              (*(module00.huprou))();
                         }
                         else {
                              if (usrptr->class == SUPIPG) {
                                   suphup();
                              }
                              rstchn();
                         }
                    }
                    else {
                         if (status < 250) {
                              usrptr->flags|=ACTIVE;
                              if (status != OUTMT) {
                                   usrptr->nazapc=0;
                              }
                         }
                         clrmlt();
                         switch (usrptr->class) {
                         case VACANT:
                              svacant();
                              break;
                         case ONLINE:
                              sonline();
                              break;
                         case SUPIPG:
                              ssupipg();
                              break;
                         case SUPLON:
                         case SUPLOF:
                         default:
                              susing();
                         }
                    }
               }
          }
          usrnum=polnum+1;
          do {
               if (usrnum == nterms) {
                    usrnum=0;
               }
               if (user[usrnum].polrou != NULL) {
                    curusr(polnum=usrnum);
                    clrmlt();
                    if (usrptr->class > SUPLOF && setjmp(eximod)) {
                         ret2mnu(0);
                    }
                    else {
                         (*(usrptr->polrou))();
                    }
                    break;
               }
          } while (++usrnum != polnum+1);
          dwopr();
          while (tcklst != ticker) {
               tcklst++;
               prcrtk();
          }
          unfrez();
          sapprc();
          if (gpcntr > 0) {
               curusr(lastusrnu);
               sprintf(tmp,"%04X:%04X/#%02X:%s/%d",FP_SEG(lastexcro),
                    FP_OFF(lastexcro),channel[lastusrnu],usaptr->userid,
                    usrptr->state);
               shocst("ERROR: GENERAL PROTECTION FAULT",tmp);
               btuinj(usrnum,RING);
               gpcntr=0;
          }
     }
     usrnum=kilsrc;
     if (mbdone > 1) {
          catastro("GALGSBL License Violation Detected!");
     }
     shocst("BBS SHUTDOWN","(Going down to DOS)");
     (*(module00.finrou))();
}

STATIC
void
init(void)                         /* initialize the hardware and software */
{
     char *cp;
     long memreq;
     int i,group,chan,msg,iobase,numchn,rc;
     char grt;
     int irpsrc;
     int itzerr;
     int alttmr;
     void initrng3();
     extern int btux25,btusrs,btulan;
     unsigned thisbaud;
     int chnoff;

     ctrlbrk(ctrlch);
     explodem=0;
     hdlcon=gtsens;
     hdlc25=incx25;
     hdlnrg=nonrng;
     hdlrng=incrng;
     hdlcnc=mdmcnc;
     setbparm();
     srand(now());
     fclose(stdaux);
     fclose(stderr);
     fclose(stdprn);
     inilingo();
     inimsg(4096);
     mjrmb=opnmsg("bbsmajor.mcv");
     monorcol();
     gpboot=ynopt(GPBOOT);
     shortm=sameas(lastwd(getmsg(SHORTM)),"LONG");
     grtype[0]=GTMODEM;
     chanty[0]=0;
     for (group=1,msg=0 ; group < NGROUPS ; group++,msg+=GROUP2-GROUP1) {
          grtype[group]=tokopt(msg+GROUP1,"MODEM","(lock)","SERIAL","X.25","LAN",NULL);
          chanty[group]=0;
          if (grtype[group] == GTMODEM && ynopt(msg+LOCK1)) {
               grtype[group]=GTMLOCK;
          }
          if (grtype[group] != GTNONE) {
               nterms+=numopt(msg+NUMBR1,1,256);
          }
          if (grtype[group] == GTLAN) {
               i=tokopt(msg+LANTYP1,"IPXD","IPXV","SPX",NULL);
               chanty[group]=SDFIPXD-1+i;
               if (chanty[group] == SDFIPXV || chanty[group] == SDFSPX) {
                    if (*rawmsg(msg+SAPNAM1) != '\0' && (btulan&BTLIPXV) != 0) {
                         sapsup=1;
                    }
               }
          }
     }
     if (nterms > 256) {
          catastro("MORE THAN 256 CHANNELS!");
     }
     outbsz=numopt(OUTBSZ,4096,16384);
     sampln=numopt(SAMPLN,0,256);
     exicnc=ynopt(EXICNC);
     mmucrr=numopt(MMUCRR,0,32767);
     shterc=(int *)alcmem(25*sizeof(int));
     shterc++;
     setmem(shterc,24*sizeof(int),-1);
     shterc[mcuhr=numopt(MCUHR,-1,23)]=0;
     for (i=1 ; i <= 4 ; i++) {
          shterc[numopt(MSHHR1-1+i,-1,23)]=10+i;
     }
     mcumin=numopt(MCUMIN,0,59);
     mcuwrn=numopt(MCUWRN,0,59);
     maxcat=numopt(MAXCAT,1,32767);
     pfceil=numopt(PFCEIL,0,3);
     visbel=numopt(VISBEL,0,2000);
     invbel=numopt(INVBEL,0,2000);
     sopaud=ynopt(SOPAUD);
     auxist=ynopt(AUXIST);
     outata=ynopt(OUTATA);
     vispsw=ynopt(VISPSW);
     gphdlr=ynopt(GPHDLR);
     gpslmt=(unsigned)lngopt(GPSLMT,1L,50000L);
     maxscns=numopt(MAXSCNS,10,50);
     modzap=numopt(MODZAP,0,32767);
     idlzap=numopt(IDLZAP,0,32767);
     zapser=ynopt(ZAPSER);
     zapdlan=ynopt(ZAPDLAN);
     zapvlan=ynopt(ZAPVLAN);
     svrate=numopt(SVRATE,0,32767);
     lonaud=ynopt(LONAUD);
     lofaud=ynopt(LOFAUD);
     mmuaud=ynopt(MMUAUD);
     bbsttl=stgopt(BBSTTL);
     syskey=stgopt(SYSKEY);
     mmuatr=stgopt(MMUATR);
     ansdim=stgopt(ANSDIM);
     company=stgopt(COMPANY);
     addres1=stgopt(ADDRES1);
     addres2=stgopt(ADDRES2);
     dataph=stgopt(DATAPH);
     liveph=stgopt(LIVEPH);
     chghour=stgopt(CHGHOUR);
     chgmin=stgopt(CHGMIN);
     chgtime=stgopt(CHGTIME);
     scnpaus=(char **)alcmem(nlingo*sizeof(char *));
     for (clingo=0 ; clingo < nlingo ; clingo++) {
          stpans(cp=rawmsg(SCNPAUS));
          scnpaus[clingo]=alcdup(cp);
     }
     clingo=0;
     langop=tokopt(LANGOP,"AUTO","ASK",NULL);
     iniaus();
     cp=lastwd(rawmsg(ANSIOP));
     ansiop=*(cp+strlen(cp)-1);
     if (ansiop == 'O') {
          regautsns(ansisns);
     }
     rsetop=chropt(RSETOP);
     nchans=nterms+((btulan&BTLIPXV) ? 1 : 0);
     if ((memreq=btulsz(nchans,INPSIZ,outbsz)) < 0L) {
          catastro("BTULSZ ERROR");
     }
     if ((region=getml(memreq)) == NULL) {
          memcata();
     }
     insdbz();
     multsk=ynopt(MULTSK);
     if (!multsk && undwin()) {
          catastro("HARDWARE SETUP NOT CONFIGURED FOR WINDOWS!");
     }
     itzerr=multsk ? btuitm(region) : btuitz(region);
     if (itzerr == MEMERR) {
          memcata();
     }
     else if (itzerr != 0) {
          catastro("BTUITZ ERROR #%d",itzerr);
     }
     gsblup=1;
     if (btux25) {
          strcat(subvers,"/X25");
     }
     if ((btulan&(BTLIPXV+BTLSPX)) == BTLIPXV+BTLSPX) {
          strcat(subvers,"/LAN");
     }
     strcat(subvers,spr("-%d",btusrs));
     if (ynopt(ENAEUR)) {
          eurmsk=0xFF;
          for (i=128 ; i < 256 ; i++) {
               btuxlt(i,i);
          }
     }
     if (multsk) {
          switch(mulmth=tokopt(MLTMTH,"TIMER","INTER",NULL)) {
          case 1:
               if (btuirp(alttmr=chropt(ALTTMR)-'0') != 0) {
                    catastro("ALTERNATE TIMER (COM%d) NOT PRESENT",alttmr);
               }
               break;
          case 2:
               if (btuirp(-1) != 0) {
                    catastro("INTERRUPT HANDLER NOT INITIALIZED");
               }
               if (btuhit(irpsrc=numopt(IRPSRC1,2,7)) != 0) {
                    catastro("INVALID PRIMARY INTERRUPT %d",irpsrc);
               }
               if ((irpsrc=numopt(IRPSRC2,0,7)) > 1) {
                    if (btuhit(irpsrc) != 0) {
                         catastro("INVALID SECONDARY INTERRUPT %d",irpsrc);
                    }
               }
               break;
          default:
               catastro("INVALID MULTITASKING METHOD SELECTED");
          }
     }
     else if (ynopt(RNG3HD)) {
          initrng3();
     }
     inimnu();
     xrfbb=opnbtv("bbsxrf.dat",sizeof(struct uidxrf));
     if ((numxrf=numopt(NUMXRF,0,MAXXRF)) != 0) {
          xrfpos=(long *)alczer(sizeof(long)*numxrf*nterms);
     }
     else {
          xrfpos=(long *)alczer(sizeof(long)*2);
     }
     mstbb=opnbtv("bbsstats.dat",sizeof(struct mdstats));
     genbb=opnbtv("bbsgen.dat",GENSIZ);
     user=(struct user *)alczer(nterms*sizeof(struct user));
     extusr=(struct extusr *)alczer(nterms*sizeof(struct extusr));
     rsmodes=(int *)alcmem(nterms*sizeof(int));
     grpnum=(int *)alcmem(nterms*sizeof(int));
     zaptbl=(int *)alczer(nterms*sizeof(int));
     setmem(channel=(int *)alcmem((nterms+3)*2),(nterms+3)*2,-1);
     *channel++=-3;     /* note: channel[-3] == -3 */
     *channel++=-2;     /*       channel[-2] == -2 */
     *channel++=-1;     /*       channel[-1] == -1 */
     sapecb=16;
     sapisiz=outbsz>>1;
     saposiz=1024;
     if (sapsup && !sapitz(nterms,GALSVR)) {
          sapsup=0;
     }
     inimlt(outbsz);
     initmsg(outbsz);
     inisho();
     iniacc();
     setmbk(mjrmb);
     usrnum=0;
     if ((thisbaud=(unsigned)atol(lastwd(rawmsg(POLRATE)))) != 0) {
          maxpol=thisbaud;
     }
     for (group=1,msg=0 ; group < NGROUPS ; group++,msg+=GROUP2-GROUP1) {
          if ((grt=grtype[group]) != GTNONE) {
               usofgr[group]=usrnum;
               numchn=numopt(msg+NUMBR1,1,256);
               chan=hexopt(msg+START1,0x00,0xFF);
               sapstt[group]=0;
               switch (grt) {
               case GTX25:
                    echtyp[group]=tokopt(msg+ECHO1,"PLEX","BBS",NULL);
                    strcpy(prfbuf,rawmsg(msg+X3PAR1));
                    strcat(prfbuf," ");
                    strcat(prfbuf,rawmsg(msg+X3MOR1));
                    strcpy(startv[group]=alcmem(strlen(prfbuf)+1),prfbuf);
                    if (fmtx3(startv[group]) == 0) {
                         catastro("ERROR IN HARDWARE CONFIGURATION OPTION \"X3PAR%d\" OR \"X3MOR%d\":\nBAD X.3 PARAMETER(S)",group,group);
                    }
                    ksec[group]=lngopt(msg+KSEC1,-1000000L,1000000L);
                    kpak[group]=lngopt(msg+KPAK1,-1000000L,1000000L);
                    kchar[group]=lngopt(msg+KCHAR1,-1000000L,1000000L);
                    rc=btusdf(usrnum,numchn,SDFX25,numopt(msg+CARD1,0,7),
                                                   numopt(msg+LINE1,0,1),
                                                   numopt(msg+LCN1,0,255));
                    if (rc == X25ERR) {
                         catastro("ERROR IN HARDWARE CONFIGURATION OPTION \"GROUP%d\":\nX.25 TYPE NOT OPERATIVE",group);
                    }
                    break;
               case GTLAN:
                    if (chanty[group] != 0) {
                         rc=btusdf(usrnum,numchn,chanty[group],GALSOC+group-1,
                                          numopt(msg+NUMECB1,0,32767));
                         if (rc == LANERR) {
                              catastro("ERROR IN HARDWARE CONFIGURATION OPTION \"LANTYP%d\":\nLAN TYPE NOT OPERATIVE",group);
                         }
                         if (rc == MEMERR) {
                              memcata();
                         }
                         if (chanty[group] != SDFIPXD && sapsup
                          && *rawmsg(msg+SAPNAM1) != '\0') {
                              sapstt[group]=-1;
                         }
                    }
                    echtyp[group]=1;
                    break;
               default:
                    iobase=hexopt(msg+ADDR1,0x0000,0xFFFF);
                    thisbaud=mxbaud[group]=(unsigned)lngopt(msg+BAUD1,300L,
                                                                      38400L);
                    if (thisbaud > maxspd) {
                         maxspd=thisbaud;
                    }
                    echtyp[group]=ynopt(msg+DUPLX1);
                    chnoff=hexopt(msg+CHOFF1,0x0001,0x1000);
                    strcpy(prfbuf,rawmsg(msg+INIT1));
                    strcat(prfbuf,"\r");
                    startv[group]=(char *)alcmem(strlen(prfbuf)+1);
                    strcpy(startv[group],prfbuf);
                    if (numchn == 1 || chnoff == DFTOFF) {
                         btudef(usrnum,iobase,numchn);
                    }
                    else {
                         for (i=0 ; i < numchn ; i++) {
                              btudef(i+usrnum,iobase,1);
                              iobase+=chnoff;
                         }
                    }
                    for (i=0 ; i < numchn ; i++) {
                         if (btuffo(i+usrnum,0x07) == 0) {
                              maxpol=max(maxpol,thisbaud/4);
                         }
                         else {
                              maxpol=max(maxpol,thisbaud);
                         }
                    }
               }
               for (i=0 ; i < numchn ; i++) {
                    if (chan > 0xFF) {
                         catastro("ERROR IN HARDWARE CONFIGURATION, CHANNEL GROUP %d:\nCHANNEL NUMBER EXCEEDS FF",group);
                    }
                    if (usridx(chan) >= 0) {
                         catastro("ERROR IN HARDWARE CONFIGURATION, CHANNEL GROUP %d:\nCHANNEL NUMBER %02x OVERLAPS",group,chan);
                    }
                    hichp1=max(hichp1,chan+1);
                    channel[usrnum]=chan;
                    grpnum[usrnum]=group;
                    usrnum++;
                    chan++;
               }
          }
          else {
               usofgr[group]=-1;
          }
     }
     usofgr[0]=usrnum;
     mxbaud[0]=maxpol;
     echtyp[0]=1;
     sapstt[0]=0;
     startv[0]="Local channel ready...";
     channel[usrnum]=0;
     grpnum[usrnum]=0;
     btudef(usrnum,hexopt(LOCALP,0,0xFFFF),1);
     inisho2();
     usrnum=-1;
     shocst(spr("BBS UP: V%s%s",version,subvers),"(Ready to service users)");
     inisup();
     inimod();
     doaditbx();
     inikys();
     register_pseudok("_PORT#",prtpsk);
     register_pseudok("_GROUP#",grppsk);
     register_pseudok("_LANG=",lngpsk);
     register_pseudok("_PROT=",propsk);
     iniftf1();
     inifsd();
     doaditbx();
     alcvda();
     iniftf2();
     doaditbx();
     initdn=1;
     lasthr=dthour(now());
     rtkick(50,ckmcu);
     setmbk(mjrmb);
     maxpol=(multsk && sameas("AUTO",lastwd(rawmsg(POLRATE)))) ? 2400 : maxpol;
     maxpol=(multsk && mulmth == COMIRP ? maxspd : maxpol);
     btumxs(maxpol);
     globalcmd(globalgo);
     doaditbx();
     for (usrnum=0 ; usrnum < nterms ; usrnum++) {
          rsmodes[usrnum]=NORMRS;
          rstchn();
     }
     if (idlzap) {
          inirel();
          inirch();
     }
     if (modzap) {
          inimzt();
     }
     rtkick(ZAPINT,zapdec);
     rtkick(120,updclk);
}

STATIC
int
ctrlch(void)                       /* ignore ctrl-c's from keyboard & ret  */
{
     return(1);
}

STATIC
void
incx25(void)                       /* handle incoming X.25 call            */
{
     btucmd(usrnum,"A");
}

STATIC
void
nonrng(void)                       /* handle non-RING rec'd during AWAITC  */
{
}

STATIC
void
incrng(void)                       /* handle incoming "RING" string        */
{
}

STATIC
int
mdmcnc(void)                       /* handle non-"RING" during HARING      */
{                                       /* 1=connect, 0=reset, -1=ignore   */
     if (margc == 0) {
          return(-1);
     }
     return(bdspec());
}

STATIC
void
saphdl(                    /* handle S.A.P. (if any) for this channel group */
int group,                                         /* channel group, 0 to 8 */
int opt)        /* -1=shut down, 1=bring up, 0=up if any channels available */
{
     int altusn;
     struct user *altusp;
     char svrnam[SNMLEN+1];

     if (sapstt[group] == 0) {
          return;
     }
     if (opt == 0 && (altusn=usofgr[group]) >= 0) {
          opt=-1;
          for (altusp=&user[altusn] ;
               altusn < nterms && grpnum[altusn] == group ;
               altusn++,altusp++) {
               if (altusp->class == VACANT && altusp->state == AWAITC) {
                    opt=1;
                    break;
               }
          }
     }
     if (opt != 0 && sapstt[group] == -opt) {
          setmbk(mjrmb);
          sprintf(svrnam,"%0.*s(%3.3s)",SNMLEN-5,
                  rawmsg(SAPNAM1+(group-1)*(GROUP2-GROUP1)),
                  chantn[chanty[group]-SDFIPXD]);
          rstmbk();
          if ((sapstt[group]=opt) > 0) {
               sapadv(svrnam,GALSVR,GALSOC+group-1);
          }
          else {
               sapdwn(svrnam);
          }
     }
}

int
fmtx3(                          /* Format X.3 PAD-config string into prfbuf */
char *prmstg)                  /* (returns length of X.29 string in prfbuf) */
{                          /* warning: copies to input[] buffer for parsing */
     int i;
     int parm,val;
     char *cp;

     strcpy(input,prmstg);
     parsin();
     cp=prfbuf;
     *cp++=2;
     for (i=0 ; i < margc ; i++) {
          if (sscanf(margv[i],"%d:%d",&parm,&val) != 2+CNTLIT) {
               return(0);
          }
          *cp++=parm;
          *cp++=val;
     }
     return(margc*2+1);
}

void
globalcmd(                         /* install global command handler       */
int (*rouptr)())
{
     if (nglobs >= GLBMAX) {
          catastro("TOO MANY GLOBAL COMMAND HANDLERS");
     }
     globs[nglobs++]=rouptr;
}

void
rtihdlr(                      /* install 18 Hz real-time irpt-invoked rou  */
void (*rouptr)(void))
{
     if (nrtirs >= RTIMAX) {
          catastro("TOO MANY REAL-TIME IRPT ROUTINES");
     }
     rtirs[nrtirs]=rouptr;
     nrtirs++;
     bturti(18,bbsrti);
}

STATIC void
bbsrti(void)                  /* master 18 Hz real-time irpt routine       */
{
     int i;

     for (i=0 ; i < nrtirs ; i++) {
          (*rtirs[i])();
     }
}

void
xltctls(                      /* translate up-arrow seqs to CTRL chars     */
char *txtbuf)
{
     char *cp,c;

     for (cp=txtbuf ; *cp != '\0' ; cp++) {
          if (*cp == '^') {
               switch (c=*(cp+1)) {
               case '\0':
                    break;
               case '^':
                    movmem(cp+1,cp,strlen(cp));
                    break;
               default:
                    *cp=(c&~0x40);
                    movmem(cp+2,cp+1,strlen(cp+1));
                    break;
               }
          }
     }
}

int
usridx(                            /* find "usrnum", given visible chan #  */
int chan)
{
     int idx;

     for (idx=0 ; idx < nterms ; idx++) {
          if (channel[idx] == chan) {
               return(idx);
          }
     }
     return(-1);
}

void
begin_polling(                     /* begin polling user (c/o polrou())    */
int unum,
void (*rouptr)())
{
     user[unum].polrou=rouptr;
}

void
stop_polling(                      /* stop polling user                    */
int unum)
{
     user[unum].polrou=NULL;
}

int
register_textvar(                  /* register a text variable for use     */
char *name,                             /* name of text variable           */
char *(*varrou)())                      /* pointer to text var function    */
{
     if (ntvars == 0) {
          txtvars=(struct textvar *)alcmem(sizeof(struct textvar));
     }
     else {
          txtvars=(struct textvar *)alcrsz(txtvars,
                                           sizeof(struct textvar)*ntvars,
                                           sizeof(struct textvar)*(ntvars+1));
     }
     stzcpy(txtvars[ntvars].name,name,TVRSIZ);
     txtvars[ntvars].varrou=varrou;
     return(ntvars++);
}

int
findtvar(                          /* find text varibale & return number   */
char *name)                             /* name of text variable to find   */
{
     int i;

     for (i=0 ; i < ntvars ; i++) {
          if (sameas(name,txtvars[i].name)) {
               return(i);
          }
     }
     return(-1);
}

int
register_module(                   /* register a module for online use     */
struct module *mod)                     /* pointer to a module block       */
{
     if (strlen(mod->descrp) > MNMSIZ-1) {
          catastro("MODULE NAME \"%s\" TOO LONG!",mod->descrp);
     }
     if (nmods == 0) {
          module=(struct module **)alcmem(sizeof(struct module *));
          mdstats=(struct mdstats *)alcmem(sizeof(struct mdstats));
     }
     else {
          module=(struct module **)alcrsz(module,sizeof(struct module *)*nmods,
                                         sizeof(struct module *)*(nmods+1));
          mdstats=(struct mdstats *)alcrsz(mdstats,sizeof(struct mdstats)*nmods,
                                           sizeof(struct mdstats)*(nmods+1));
     }
     module[nmods]=mod;
     setbtv(mstbb);
     if (qeqbtv(mod->descrp,0)) {
          gcrbtv(&mdstats[nmods],0);
     }
     else {
          setmem(&mdstats[nmods],sizeof(struct mdstats),0);
          strcpy(mdstats[nmods].mdname,mod->descrp);
     }
     rstbtv();
     return(nmods++);
}

int
findmod(                           /* find module and return module number */
char *name)                             /* name of module to find          */
{
     int i;

     for (i=1 ; i < nmods ; i++) {
          if (sameas(name,module[i]->descrp)) {
               return(i);
          }
     }
     return(-1);
}

char *
gmdnam(mdfnam)                     /* get a module's name from .MDF file   */
char *mdfnam;                           /* name of module's .MDF file      */
{
     FILE *fp;
     static char tmpbuf[40];

     if ((fp=fopen(mdfnam,FOPRA)) == NULL) {
          catastro("GMDNAM: CAN'T OPEN \"%s\"",mdfnam);
     }
     while (fgets(tmpbuf,sizeof(tmpbuf),fp) != NULL) {
          if (sameto("Module Name:",tmpbuf)) {
               unpad(tmpbuf);
               fclose(fp);
               return(skpwht(tmpbuf+12));
          }
     }
     catastro("GMDNAM: NO MODULE NAME IN \"%s\"",mdfnam);
     return(tmpbuf);
}

void
dclvda(                            /* module declaration for vdarea        */
int size)
{
     if (size > vdasiz) {
          vdasiz=size;
     }
}

void
alcvda(void)                       /* allocate volatile data area          */
{
     if (vdasiz != 0) {
          vdarea=alctile(nterms,vdasiz);
          vdatmp=alcmem(vdasiz);
     }
}

char *
vdaoff(                            /* vdaptr calculation routine           */
int unum)
{
     return(ptrtile(vdarea,unum));
}

STATIC
void
svacant(void)                      /* vacant channel status handler        */
{
     setmbk(mjrmb);
     switch (usrptr->state) {
     case JSTRST:                    /* channel just reset, status received */
          btulok(usrnum,0);
          if (status == CMN2OK) {
               usrptr->flags|=IS2698;
               btuoes(usrnum,1);
               if (grtype[grpnum[usrnum]] == GTSERIAL) {
                    usrptr->flags|=ISRIAL;
               }
               switch (rsmodes[usrnum]) {
               case NORMRS:
                    if (usrptr->flags&ISRIAL) {
                         prf("%s",startv[grpnum[usrnum]]);
                         usrptr->state=ESTVEC;
                    }
                    else {
                         prf("ATZ\r");
                         usrptr->state=EMTATZ;
                    }
                    break;
               case BUSYRS:
                    if (usrptr->flags&ISRIAL) {
                         kiletc("Disabled serial channel");
                         prf("");
                    }
                    else {
                         prf("ATM0H1\r");
                         usrptr->state=EKLVEC;
                    }
                    break;
               case NANSRS:
                    if (usrptr->flags&ISRIAL) {
                         kiletc("Disabled serial channel");
                         prf("");
                    }
                    else {
                         prf("ATS0=0\r");
                         usrptr->state=EKLVEC;
                    }
                    break;
               }
               powprf();
          }
          else if (status == CMDOK) {
               switch (rsmodes[usrnum]) {
               case NORMRS:
                    usrptr->state=AWAITC;
                    break;
               case BUSYRS:
                    btucmd(usrnum,"D");
                    usrptr->state=EKLVEC;
                    break;
               case NANSRS:
                    kiletc(usrnum != nterms-1 ? "Modem set to NO-ANSWER" : "Local session disabled");
                    break;
               }
          }
          else {
               rstchn();
          }
          break;
     case EMTATZ:                                      /* ATZ sent to modem */
          if (status == OUTMT) {
               btucmd(usrnum,"P");
          }
          else if (status == CRSTG) {
               if (sameas(getin(),"OK") || sameas(margv[0],"0")) {
                    shochl("ATZ OK, sending init string",'.',
                           baudat(usrptr->baud,0)&0xF7);
                    btuclc(usrnum);
                    btucmd(usrnum,"ttttt");
                    usrptr->state=ATZDUN;
               }
          }
          else if (status != LOST2C) {
               rstchn();
               shochl("ERROR: no response to ATZ!",'#',0x9c);
          }
          break;
     case EKLVEC:  /* chan "kill vector" (busy-out/no answer) has been sent */
          if (status == OUTMT) {
               btuoes(usrnum,0);
               btucmd(usrnum,"P");
          }
          else if (status == CRSTG) {
               if (sameas(getin(),"OK")) {
                    kiletc(rsmodes[usrnum] == BUSYRS ?
                         "Modem set to BUSY-OUT" : "Modem set to NO-ANSWER");
               }
          }
          else if (status == CMDOK) {
               kiletc("Modem set to BUSY-OUT");
          }
          else if (status == CMN2OK) {
               kiletc("Disabled serial channel");
          }
          else {
               rstchn();
          }
          break;
     case W4KILL:         /* this channel ready (limbo) for system shutdown */
          if ((usrptr->flags&ISX25) && status == CRSTG) {
               rstchn();
          }
          break;
     case ATZDUN:           /* waiting for 1/10-sec delay after OK from ATZ */
          if (status == CMN2OK) {
               prf("%s",startv[grpnum[usrnum]]);
               powprf();
               usrptr->state=ESTVEC;
          }
          else if (status != LOST2C) {
               rstchn();
               shochl("ERROR: bad status after ATZ!",'#',0x9c);
          }
          break;
     case ESTVEC:                 /* channel "startup vector" has been sent */
          if (status == OUTMT) {
               btuoes(usrnum,0);
               if (usrptr->flags&ISRIAL) {
                    usrptr->state=AWAITC;
                    shochl("Serial port ready to use...",'.',
                           baudat(usrptr->baud,0)&0xF7);
               }
               else {
                    btucmd(usrnum,"P");
                    usrptr->state=W4ISOK;
               }
          }
          else if (status != LOST2C && status != CMN2OK) {
               rstchn();
               shochl("ERROR: bad/no init response",'#',0x09c);
          }
          break;
     case W4ISOK:
          if (status == CRSTG) {
               if (sameas(getin(),"OK")) {
                    btuclc(usrnum);
                    usrptr->state=AWAITC;
                    shochl("Modem awaiting incoming call",'.',
                           baudat(usrptr->baud,0)&0xF7);
               }
          }
          else if (status != LOST2C) {
               rstchn();
               shochl("ERROR: bad status during init",'#',0x09c);
          }
          break;
     case W4SPXT:             /* wait for previous SPX session to terminate */
          switch (status) {
          case CYCLE:
               if (ticker-tspxt <= MAXSPXT) {   /* give up on SPX terminate? */
                    btuinj(usrnum,CYCLE);
                    break;
               }
          default:
               rstchn();
               break;
          }
          break;
     case AWAITC:                                 /* Await in incoming call */
          switch (status) {
          case RING:
               if (usrptr->flags&ISX25 || grtype[grpnum[usrnum]] == GTLAN) {
                    zaptbl[usrnum]=0;
                    (*hdlcon)();           /* non-hardware X.25 or LAN chan */
               }
               else {                /* hardware/non-hardware XECOM channel */
                    zaptbl[usrnum]=ZAPMAX;
                    shochl("ANSWERING CALL...",'',baudat(usrptr->baud,0));
                    btucmd(usrnum,"Ap^H");
                    usrptr->state=XERING;
               }
               break;
          case CRSTG:
               zaptbl[usrnum]=ZAPMAX;
               if (sameas(getin(),"RING")) {
                    if (usrptr->flags&ISX25) {        /* X.25 channel w/hdw */
                         btuinj(usrnum,CYCLE);
                         usrptr->state=WAIT29;
                         (*hdlc25)();
                    }
                    else {                           /* HAYES channel w/hdw */
                         shochl("ANSWERING CALL...",'',baudat(usrptr->baud,0));
                         usrptr->state=HARING;
                         if (outata && !(usrptr->flags&ISRIAL)) {
                              btucmd(usrnum,"^E=A");
                         }
                         (*hdlrng)();
                    }
               }
               else if (usrptr->flags&ISRIAL) {       /* UART channel w/hdw */
                    zaptbl[usrnum]=0;
                    (*hdlcon)();
               }
               else if (usrptr->lcstat == LSDCOMM) {  /* IPX Direct channel */
                    zaptbl[usrnum]=0;
                    (*hdlcon)();
               }
               else {
                    (*hdlnrg)();
               }
               break;
          case INBLK:                                /* IPX Virtual channel */
               if (usrptr->lcstat == LSVRAWP) {
                    if (lsvans()) {
                         usrptr->lcstat=LSVCOMM;
                         zaptbl[usrnum]=0;
                         (*hdlcon)();
                    }
                    else {
                         shochl("Spurious IPX traffic",'#',0x9c);
                    }
                    btucli(usrnum);
               }
               break;
          case SPXINC:                                       /* SPX channel */
               if (usrptr->lcstat == LSSINWT) {
                    usrptr->lcstat=LSSESTB;
                    zaptbl[usrnum]=0;
                    (*hdlcon)();
               }
               break;
          case LOST2C:
          case CMN2OK:
          case CYCLE:
          case SPXWDG:
               break;
          default:
               shochl("Status invoked reset",'#',0x9c);
               rstchn();
               break;
          }
          break;
     case WAIT29:                       /* keep trying to send X.29 message */
          switch (status) {
          case CM25OK:
          case RCVX29:
               break;
          case CYCLE:
          case CLOX29:
               if (startv[grpnum[usrnum]] == '\0') {
                    zaptbl[usrnum]=0;
                    (*hdlcon)();
                    break;
               }
               switch (btux29(usrnum,fmtx3(startv[grpnum[usrnum]]),prfbuf)) {
               case 0:
                    zaptbl[usrnum]=0;
                    (*hdlcon)();
                    break;
               case X25CLO:
                    btuinj(usrnum,CLOX29);
                    break;
               default:
                    btuinj(usrnum,ERRX29);
                    break;
               }
               break;
          default:
               rstchn();
               break;
          }
          break;
     case XERING:              /* has answered XECOM call detected carrier? */
          if (status == CMDOK) {
               if (!(usrptr->flags&NOHDWE)) {
                    usrptr->baud=1200;
               }
               zaptbl[usrnum]=0;
               (*hdlcon)();
          }
          else if (status == INAPP) {
               usrptr->baud=300;
               zaptbl[usrnum]=0;
               (*hdlcon)();
          }
          else if (status != CRSTG) {
               rstchn();
          }
          break;
     case HARING:              /* has answered HAYES call detected carrier? */
          if (status == CRSTG) {
               if (sameas(getin(),"RING")) {
                    (*hdlrng)();
               }
               else {
                    switch ((*hdlcnc)()) {
                    case 1:
                         btucmd(usrnum,"p");
                         usrptr->state=HPAUSE;
                         break;
                    case 0:
                         break;
                    }
               }
          }
          else if (status != CMN2OK) {
               rstchn();
          }
          break;
     case HPAUSE:         /* pause after detecting carrier on HAYES channel */
          switch (status) {
          case CMN2OK:
               zaptbl[usrnum]=0;
               (*hdlcon)();
               break;
          case CRSTG:
               getin();
               break;
          default:
               rstchn();
          }
          break;
     case AUTSNS:                        /* waiting out auto-sensing period */
          switch (status) {
          case CYCLE:
               if (prcaus()) {
                    figlang();
               }
               else {
                    btuinj(usrnum,CYCLE);
               }
               break;
          case CMDOK:
          case CMN2OK:
          case CM25OK:
          case RCVX29:
          case OUTMT:
          case IPXRER:
          case IPXUNK:
          case INBLK:
               break;
          case SPXTRM:
          case SPXWDG:
               othtrm();
          default:
               rstchn();
          }
          break;
     }
}

STATIC
int
lsvans(void)                          /* Answer an IPX Virtual circuit call */
{
     struct ipxhdr ihbuf;
     char outadr[24+1],*cp;
     int i;

     btutrg(usrnum,sizeof(struct ipxhdr));
     if (btuict(usrnum,(char *)&ihbuf) > 0) {
          for (cp=ihbuf.srcnet,i=0 ; i < 12 ; i++,cp++) {
               sprintf(outadr+i+i,"%02X",*cp);
          }
          btucmd(usrnum,"W");
          btucmd(usrnum,outadr);
          btucmd(usrnum,"M");
          btutrg(usrnum,0);
          return(1);
     }
     return(0);
}

void
powprf(void)                       /* "power" outprf() - cut through input  */
{
     btuxct(usrnum,strlen(prfbuf),prfbuf);
     clrprf();
     btucli(usrnum);
}

int
bdspec(void)                       /* goto baud rate given in input, if any */
{
     int baud;

     if (sameas(margv[0],"CONNECT") || sameas(margv[0],"CARRIER")) {
          if (margc == 1) {
               baud=300;
          }
          else if (sameas(margv[1],"FAST")) {        /* for Telebit */
               baud=mxbaud[grpnum[usrnum]];          /* Trailblazer */
          }
          else {
               baud=atoi(margv[1]);
          }
          usrptr->baud=baud;
          if (grtype[grpnum[usrnum]] == GTMODEM ||
              grtype[grpnum[usrnum]] == GTSERIAL) {
               btubrt(usrnum,baud);
          }
          return(1);
     }
     return(0);
}

STATIC
void
updcal(void)                       /* update baud rate based statistics    */
{
     int i;
     unsigned int brates[]={300,1200,2400,9600,14400,19200u,38400u};

     if (!(usrptr->flags&NOHDWE)) {
          sv2.totcalls++;
          if (chanty[grpnum[usrnum]] != SDFIPXD
              && chanty[grpnum[usrnum]] != SDFIPXV
              && chanty[grpnum[usrnum]] != SDFSPX
              && !(usrptr->flags&ISX25)) {
               for (i=0 ; i < 7 ; i++) {
                    if (usrptr->baud == brates[i]) {
                         sv.calls[i]++;
                         return;
                    }
               }
          }
          sv.calls[7]++;
     }
}

void
kiletc(                            /* kill a channel, and possibly the sys */
char *legend)
{
     int unum;
     struct user *uptr;

     shochl(legend,240,baudat(usrptr->baud,0)&0xF7);
     usrptr->state=W4KILL;
     if (errcod != 1 || kilipg) {
          for (unum=0,uptr=user ; unum < nterms ; unum++,uptr++) {
               if (uptr->class != VACANT || uptr->state != W4KILL) {
                    return;
               }
          }
          failsf();
     }
}

STATIC void
failsf(void)                       /* failsafe cleanup and shutdown routine*/
{
     int savusn;

     if (errcod == 0) {
          mcuctr=-1;
          savusn=usrnum;
          (*(module00.mcurou))();
          curusr(savusn);
          kilsrc=-2;
     }
     else if (errcod >= 11 && errcod <= 14) {
          kilsrc=-3;
     }
     kilipg=1;
     rtkoff=1;                          /* prevent all future rtkick's     */
     mbdone=max(1,mbdone);
}

STATIC void
gtsens(void)                       /* begin automatic sensing              */
{
     static char *strtst[]={"Modem has carrier",
                            "Locked modem has carrier",
                            "Serial channel has activity",
                            "Incoming X.25 contact",
                            "Incoming LAN contact",
                            "Local channel has activity"};
     static char stgchr[]="";

     setmbk(mjrmb);
     shochl(strtst[(usrnum != nterms-1 ? grtype[grpnum[usrnum]]-1 : 5)],
            stgchr[(usrnum != nterms-1 ? grtype[grpnum[usrnum]]-1 : 5)],
            baudat(usrptr->baud,0));
     saphdl(grpnum[usrnum],0);
     ansperm();
     if (numaus > 0) {
          prf(getasc(AUTOSENS));
          powprf();
          bgnaus(1);
          btuinj(usrnum,CYCLE);
          usrptr->state=AUTSNS;
     }
     else {
          bgnaus(0);
          figlang();
     }
}

STATIC void
ansperm(void)                      /* auto-set ANSI if configured to do so */
{
     switch (ansiop) {
     case 'N':  /* ON */
          usaptr->ansifl=ANSON;
          break;
     case 'F':  /* OFF */
          usaptr->ansifl=0;
          break;
     }
     stansi();
}

STATIC int
ansisns(                           /* ANSI/ASCII autosense routine         */
unsigned snccon,                   /* time since connect, 1/16 second units*/
char *incbuf,                      /* bytes coming in (not NUL terminated) */
int nbytes)                        /* number of bytes coming in            */
{
     if (usrptr->flags&NOHDWE) {
          usaptr->ansifl=atoggl ? ANSON : 0;
          return(1);
     }
     if (snccon == 0) {
          btuxct(usrnum,strlen(auansi),auansi);
          return(0);
     }
     while (nbytes-- > 0) {
          if (((*incbuf++)&0x7F) == 'R') {
               usaptr->ansifl=ANSON;
               return(1);
          }
     }
     if (snccon >= answait) {
          usaptr->ansifl=0;
          return(1);
     }
     return(0);
}

STATIC void                        /* auto sensing is done...              */
figlang(void)                      /* figure out what language we're using */
{
     usrptr->class=ONLINE;
     usrptr->state=0;
     usaptr->scnbrk=24;
     rstrxf();
     stansi();
     echon();
     if (cntcand() <= 1 || langop == 1) {
          clingo=extptr->lingo=fstcand;
          askansi();
     }
     else {
          prfmsg(LONLANGS);
          lnglist(0);
          lngfoot(0);
          outprf(usrnum);
          usrptr->substt=-2;
     }
}

STATIC void
askansi(void)                      /* do we need to ask ANSI versus ASCII? */
{
     if (ansiop == 'K') {
          if (samend(languages[extptr->lingo]->name,"/ANSI")) {
               prfmsg(QANSI);
               outprf(usrnum);
               usrptr->substt=-1;
          }
          else {
               usaptr->ansifl=ANSON;
               stansi();
               greetem();
          }
     }
     else {
          greetem();
     }
}

STATIC void
greetem(void)                      /* about time to welcome the guy online */
{
     int ctyp;

     btuxnf(usrnum,0,19);
     if (usrptr->flags&ISX25) {
          prfmsg(HELLO25);
     }
     else if ((ctyp=chanty[grpnum[usrnum]]) != 0) {
          prfmsg(HELLOGN,spr("via LAN (%s)",chantn[ctyp-SDFIPXD]));
     }
     else {
          prfmsg(HELLO);
     }
     if (strlen(sv.lonmsg) != 0) {
          prfmsg(LONHDR);
          prf("\r%s\r",sv.lonmsg);
          prfmsg(LONTRL);
     }
     outprf(usrnum);
     usrptr->countr=0;
     uidpmt();
}

STATIC
void
uidpmt(void)                       /* send the user-id prompt (or file)    */
{
     char *cp;

     clrprf();
     prfmsg(sampok() ? ENTUSID : LOGUID);
     if (strlen(prfbuf) < 40) {
          stpans(prfbuf);
          depad(cp=skpwht(prfbuf));
          if (*cp == '$' && opnans(cp+1)) {
               usrptr->substt=0;
               clrprf();
               return;
          }
          clrprf();
          prfmsg(sampok() ? ENTUSID : LOGUID);
     }
     outprf(usrnum);
     usrptr->substt=1;
}

STATIC
void
sonline(void)                      /* "online" channel status handler      */
{
     setmbk(mjrmb);
     switch (status) {
     case CMDOK:
     case CMN2OK:
     case CM25OK:
     case RCVX29:
          break;
     case ABOREQ:
          if (usrptr->substt == 0) {
               clfile();
               usrptr->substt=1;
          }
          else {
               btuclo(usrnum);
               if (usrptr->substt == -2) {
                    lngfoot(0);
                    outprf(usrnum);
               }
          }
          break;
     case OUTMT:
          if (usrptr->flags&INJOIP) {
               btuoes(usrnum,0);
               if (usrptr->substt == 2) {    /* got injo b4 done logging on*/
                    prfmsg(ENTPSW);
                    outprf(usrnum);
               }
          }
          break;
     case CRSTG:
          hdlogo();
          break;
     case OBFCLR:
          if (btuoba(usrnum) >= outbsz-2) {
               usrptr->flags|=ABOIP;
               clrinp();
               hdlogo();
               usrptr->flags&=~ABOIP;
          }
          break;
     case IPXRER:
     case IPXUNK:
          break;
     case CYCLE:
          if (usrptr->substt == 0 && !rdfile()) {
               usrptr->substt=1;
          }
          break;
     case SPXTRM:
     case SPXWDG:
          othtrm();
     default:
          if (usrptr->substt == 0) {
               clfile();
          }
          rstchn();
     }
}

STATIC
void
hdlogo(void)                       /* handle logon: lang, ansi, userid, psw*/
{
     int ctyp,ilingo;

     switch (usrptr->substt) {
     case -2:                      /* choosing language fm list of possible*/
          switch (*getin()) {
          case '?':
          case '\0':
               prfmsg(LONLANGS);
               lnglist(0);
               lngfoot(0);
               outprf(usrnum);
               break;
          default:
               rstrin();
               if (alldgs(input)) {
                    ilingo=lngposn(atoi(input));
               }
               else {
                    ilingo=lngfnd(input);
               }
               if (ilingo == -1) {
                    lngfoot(0);
                    outprf(usrnum);
               }
               else {
                    clingo=extptr->lingo=ilingo;
                    askansi();
               }
               break;
          }
          break;
     case -1:                      /* choosing between ANSI/ASCII          */
          getin();
          bgncnc();
          switch (cncyesno()) {
          case 'Y':
               usaptr->ansifl|=ANSON;
               break;
          case 'N':
               usaptr->ansifl&=~ANSON;
               break;
          default:
               prfmsg(QANSI);
               outprf(usrnum);
               return;
          }
          stansi();
          greetem();
          break;
     case 0:                       /* user-id or new entered during file   */
     case 1:                       /* user has entered User-ID (or new)    */
          if (usrptr->substt == 0) {
               getin();
               clfile();
               usrptr->substt=1;
               if (*input == '\0') {
                    break;
               }
          }
          else if ((usrptr->flags&ABOIP) || *getin() == '\0') {
               uidpmt();
               return;
          }
          rstrin();
          if (sampok() && (sameas(margv[0],"new")
                       || sameas(margv[0],"\"new\""))) {
               shochl("New user signing up...",'?',baudat(usrptr->baud,0));
               usrptr->class=SUPIPG;
               usrptr->substt=0;
               updcal();
               signup();
          }
          else if (onbbs(margv[0],1)) {
               prfmsg(sampok() ? ALRDON : LOGDON);
               outprf(usrnum);
          }
          else if (loadup()) {
               if (!sampok() && !hasmkey(SAMPKY)) {
                    shochl("Deadbeat user (hanging up)",9,baudat(usrptr->baud,0));
                    byenow(MEMONL);
               }
               else if (usaptr->flags&SUSPEN) {
                    shochl("Suspended user (hanging up)",9,baudat(usrptr->baud,0));
                    byenow(ACCSUS);
               }
               else {
                    shochl("Logging on...",15,baudat(usrptr->baud,0));
                    prfmsg(ENTPSW);
                    outprf(usrnum);
                    usrptr->usetmr=0;
                    echsec(secchr,PSWSIZ-1);
                    usrptr->substt=2;
                    usrptr->countr=0;
               }
          }
          else if (++(usrptr->countr) < 3) {
               if (!sampok()) {
                    prfmsg(LOGNOG);
               }
               else {
                    prfmsg(UIDNOG);
               }
               outprf(usrnum);
          }
          else {
               byenow(STRUKO);
          }
          break;
     case 2:                       /* user has entered his/her password    */
          if (!(usrptr->flags&ABOIP)) {
               inplen=btuinp(usrnum,input);
          }
          if (sameas(input,usaptr->psword)) {
               btuclo(usrnum);
               strcpy(input,"<password>");
               shomal();
               shochl(usaptr->userid,'',baudat(usrptr->baud,0));
               echon();
               updcal();
               if (nlingo > 1
                && getgen(&genbuf,usaptr->userid)
                && (ilingo=lngfnd(genbuf.lngnam)) != -1
                && poslng[usrnum*nlingo+ilingo] >=
                   poslng[usrnum*nlingo+clingo]
                && (langop == 1 || cntcand() <= 1)) {
                    prfmsg(LNGSWT,languages[ilingo]->name);
                    extptr->lingo=clingo=ilingo;
                    rstrxf();
               }
               if (!imbump(1)) {
                    usrptr->usetmr=0;
                    prfmsg(HITHAR);
                    if (sameas(usaptr->userid,"Sysop")
                      || (usaptr->flags&HASMST)) {
                         usrptr->flags|=MASTER;
                    }
                    outprf(usrnum);
                    if (!lonstf()) {
                         ret2mnu(-1);
                    }
               }
          }
          else {
               strcpy(input,"<invalid password>");
               shomal();
               if (++(usrptr->countr) < 3) {
                    prfmsg(PSWNOG);
                    outprf(usrnum);
               }
               else {
                    shochl("Invalid password attempt",'!',baudat(usrptr->baud,0));
                    byenow(STRUKO);
                    shocst("INVALID PASSWORD ATTEMPT","%s attempt on \"%s\"",
                          (usrptr->flags&ISX25) ? "X.25"
                        : ((ctyp=chanty[grpnum[usrnum]]) != 0) ?
                            chantn[ctyp-SDFIPXD] : spr("%ubps",usrptr->baud),
                      usaptr->userid);
               }
          }
          break;
     }
}

STATIC
void
othtrm(void)        /* other party in an SPX session terminated the session */
{
     if (usrptr->lcstat > LSSIDLE && usrptr->lcstat <= LSSESTB) {
          usrptr->lcstat=LSSIDLE;
     }
}

STATIC
void
ssupipg(void)                      /* sign-up is in progress               */
{
     switch (status) {
     case CRSTG:
          getin();
          if (!signup()) {
               shochl(usaptr->userid,'',baudat(usrptr->baud,0));
               if (!lonstf()) {
                    ret2mnu(-1);
               }
          }
          break;
     case CYCLE:
          supcyc();
          break;
     case OBFCLR:
          if (usrptr->substt == 1) {
               clfile();
               cntsup();
          }
          else {
               usrptr->flags|=ABOIP;
               clrinp();
               signup();
               usrptr->flags&=~ABOIP;
          }
          break;
     case ABOREQ:
          if (usrptr->substt == 1) {
               clfile();
               cntsup();
          }
          else {
               btuclo(usrnum);
          }
          break;
     case CMDOK:
     case CMN2OK:
     case CM25OK:
     case IPXPSE:
     case 251:
     case RCVX29:
          break;
     case IPXRER:
     case IPXUNK:
          break;
     case SPXTRM:
     case SPXWDG:
          othtrm();
     default:
          suphup();
          rstchn();
     }
}

STATIC
void
susing(void)                       /* "using" channel status handler       */
{
     if (usrptr->class > SUPLOF && setjmp(eximod)) {
          ret2mnu(0);
     }
     else {
          switch (status) {
          case SPXTRM:
          case SPXWDG:
               othtrm();
          case RING:
          case LOST2C:
          case LOST25:
               (*(module00.huprou))();
               break;
          case CRSTG:
               if (usrptr->flags&INJOIP) {
                    btuoes(usrnum,0);
                    usrptr->flags&=~INJOIP;
               }
               getin();
               if (!(usrptr->flags&OPCHAT)) {
                    hdlinp();
               }
               break;
          case OBFCLR:
               if (btuoba(usrnum) >= outbsz-2) {
                    usrptr->flags|=ABOIP;
                    injacr();
                    usrptr->flags&=~ABOIP;
               }
               break;
          case ABOREQ:
               btuclo(usrnum);
               usrptr->flags|=ABOIP;
               injacr();
               usrptr->flags&=~ABOIP;
               break;
          case OUTMT:
               if (usrptr->flags&INJOIP) {
                    btuoes(usrnum,0);
                    injacr();
                    break;
               }
          default:
               (*(module[usrptr->state]->stsrou))();
          }
     }
}

void
condex(void)                       /* conditional module-exit              */
{
     if (usrptr->flags&CONCEX) {
          usrptr->flags&=~(ABOIP+INJOIP);
          longjmp(eximod,1);
     }
}

void
injacr(void)                       /* inject a <CR> to current channel     */
{                                  /*    (re-prompt current text)          */
     usrptr->flags|=INJOIP;
     status=CRSTG;
     clrinp();
     hdlinp();
     usrptr->flags&=~INJOIP;
}

void
clrinp(void)                       /* clear user-input buffer and qtys     */
{
     input[0]='\0';
     margv[0]=input;
     inplen=0;
     margc=0;
}

STATIC void
inirel(void)                       /* real-time check for idle channels    */
{
     setmbk(mjrmb);
     for (usrnum=0,usrptr=user ; usrnum < nterms ; usrnum++,usrptr++) {
          extptr=extoff(usrnum);
          if (!(usrptr->flags&NOHDWE)) {
               if (usrptr->class != VACANT) {
                    if (!(usrptr->flags&ACTIVE || haskey(syskey))
                     && usrptr->nazapc == 0
                     && isuidc(uacoff(usrnum)->userid[0])
                     && !((usrptr->flags&ISRIAL) && !zapser)
                     && !(chanty[grpnum[usrnum]] == SDFIPXD && !zapdlan)
                     && !((chanty[grpnum[usrnum]] == SDFIPXV
                        || chanty[grpnum[usrnum]] == SDFSPX) && !zapvlan)) {
                         clingo=extptr->lingo;
                         prfmsg(NOTACV,idlzap/60);
                         outprf(usrnum);
                         btucli(usrnum);
                         usrptr->nazapc=4;
                    }
                    usrptr->flags&=~ACTIVE;
               }
          }
     }
     rtkick(idlzap,inirel);
}

STATIC void
inimzt(void)                       /* real-time check for idle modems      */
{
     setmbk(mjrmb);
     for (usrnum=0,usrptr=user ; usrnum < nterms ; usrnum++,usrptr++) {
          extptr=extoff(usrnum);
          if ((usrptr->flags&(NOHDWE+ISX25)) == 0
           && grtype[grpnum[usrnum]] != GTLAN
           && usrptr->class == VACANT
           && usrptr->state != W4KILL
           && zaptbl[usrnum] == 0) {
               rstchn();
          }
     }
     rtkick(modzap,inimzt);
}

STATIC void
inirch(void)                       /* real-time check for idle log-offs    */
{
     setmbk(mjrmb);
     for (usrnum=0,usrptr=user ; usrnum < nterms ; usrnum++,usrptr++) {
          extptr=extoff(usrnum);
          if (usrptr->nazapc > 0 && --(usrptr->nazapc) == 0) {
               clingo=extptr->lingo;
               byenow(NAZAPM);
          }
     }
     rtkick(15,inirch);
}

int
sampok(void)                       /* is this line a free sample one?      */
{
     return(usrnum < sampln || (usrptr->flags&NOHDWE));
}

void
hdlinp(void)                       /* handle CR-terminated input           */
{
     int i;
     int (*rouptr)();

     numcat=0;
     if (!(usrptr->flags&NOGLOB)) {
          for (i=0 ; i < nglobs ; i++) {
               switch ((*globs[i])()) {
               case -2:
                    outprf(usrnum);
               case -1:
                    return;
               case 0:
                    break;
               default:
                    injacr();
                    return;
               }
          }
     }
     switch (usrptr->class) {
     case SUPLON:
          if (usrptr->polrou == nxtlon) {
               return;
          }
          rouptr=module[usrptr->state]->lonrou;
          break;
     case SUPLOF:
          rouptr=module[usrptr->state]->lofrou;
          break;
     default:
          rouptr=module[usrptr->state]->sttrou;
     }
     if ((i=(*rouptr)()) == 0) {
          usrptr->substt=0;
          usrptr->crdrat=mmucrr;
          switch (usrptr->class) {
          case SUPLON:
               nxtlon();
               break;
          case SUPLOF:
               if (usrptr->state == usrptr->lofstt) {
                    ret2mnu(0);
               }
               else {
                    nxtlof();
               }
               break;
          default:
               ret2mnu(0);
          }
     }
     else if (i == -1 && usrptr->class == SUPLOF) {
          ret2mnu(0);
     }
}

void
clrxrf(void)                       /* clear current user's x-ref data      */
{
     if (numxrf) {
          setmem(&xrfpos[xrfidx(0)],sizeof(long)*numxrf,0);
     }
}

void
addxrf(newuid)                     /* add new x-refs for a user-id         */
char *newuid;                           /* new user-id to add              */
{
     xrfutl(newuid,1);
}

void
delxrf(userid)                     /* delete all x-refs for a user-id      */
char *userid;                           /* user-id to delete x-refs for    */
{
     xrfutl(userid,0);
}

STATIC void
xrfutl(userid,add)                 /* low-level x-ref add and delete util  */
char *userid;                           /* user-id to add or delete        */
int add;                                /* add this guy? (1=yes 0=no, del) */
{
     char *bas;
     struct uidxrf tmpxrf;

     setbtv(xrfbb);
     stzcpy(uidxrf.userid,userid,UIDSIZ);
     bas=userid;
     do {
          bas=skpwht(bas);
          stzcpy(uidxrf.xrfstg,bas,XRFSIZ);
          uidxrf.xrfstg[XRFSIZ]=(sameas(uidxrf.xrfstg,uidxrf.userid) ? 0 : 1);
          if (add) {
               insbtv(&uidxrf);
          }
          else {
               if (acqbtv(&tmpxrf,uidxrf.xrfstg,0)) {
                    do {
                         if (sameas(uidxrf.userid,tmpxrf.userid)) {
                              delbtv();
                         }
                    } while (aqnbtv(&tmpxrf));
               }
          }
     } while (*(bas=skpwrd(bas)) != '\0');
     rstbtv();
}

int
hdluid(stg)                        /* handle the entering of a user-id     */
char *stg;                              /* string entered as user-id       */
{
     char uid[UIDSIZ];
     int num,retval=1;

     setbtv(xrfbb);
     if (xrfpos[xrfidx(0)] != NULL && (numxrf == 1 ||
         xrfpos[xrfidx(1)] == NULL)) {
          if (lingyn(stg[0]) == 'Y') {
               gabbtv(&uidxrf,xrfpos[xrfidx(0)],0);
               retval=UIDFND;
          }
          else {
               retval=UIDPMT;
          }
     }
     else {
          stzcpy(uid,stg,UIDSIZ);
          if (numxrf > 1 && isdigit(*uid) && strlen(uid) < 3 &&
              xrfpos[xrfidx(1)] != NULL) {
               num=atoi(uid);
               if (num > 0 && num <= numxrf && xrfpos[xrfidx(num-1)] != NULL) {
                    gabbtv(&uidxrf,xrfpos[xrfidx(num-1)],0);
                    retval=UIDFND;
               }
          }
     }
     clrxrf();
     if (retval == 1) {
          retval=newxrf(uid);
     }
     rstbtv();
     return(retval);
}

STATIC int
newxrf(uid)                        /* get new x-ref listing for user       */
char *uid;                              /* for *this* partial user-id      */
{
     char xrf[XRFSIZ+1];
     struct uidxrf tmpxrf;
     int retval=UIDPMT,num=0;

     setmbk(mjrmb);
     setmem(&tmpxrf,sizeof(struct uidxrf),0);
     stzcpy(xrf,uid,XRFSIZ);
     xrf[XRFSIZ]='\0';        /* this char is a 1 or 0 in the data file    */
     if (!agebtv(&uidxrf,xrf,0)) {
          prfmsg(NOXREF);
     }
     else if (numxrf == 0) {
          if (sameas(uidxrf.userid,uid)) {
               retval=UIDFND;
          }
          else {
               prfmsg(NOXREF);
          }
     }
     else {
          prfmsg(sameas(uid,uidxrf.userid) ? XRFHDM : XRFHDR);
          do {
               if (!sameto(xrf,uidxrf.xrfstg)) {
                    break;
               }
               if (!sameas(uidxrf.userid,tmpxrf.userid)) {
                    xrfpos[xrfidx(num++)]=absbtv();
                    prfmsg(XRFLIN,num,uidxrf.userid);
               }
               if (!qnxbtv()) {
                    break;
               }
               movmem(&uidxrf,&tmpxrf,sizeof(struct uidxrf));
               movmem(xrfbb->data,&uidxrf,sizeof(struct uidxrf));
          } while (num < numxrf);
          if (num == 0) {
               clrprf();
               prfmsg(NOXREF);
          }
          else if (num == 1) {
               gabbtv(&uidxrf,xrfpos[xrfidx(0)],0);
               clrprf();
               if (sameas(uid,uidxrf.userid)) {
                    xrfpos[xrfidx(0)]=0L;
                    retval=UIDFND;
               }
               else {
                    prfmsg(THSXRF,uidxrf.userid);
                    retval=UIDCAL;
               }
          }
          else {
               prfmsg(XRFOOT);
          }
     }
     rstmbk();
     return(retval);
}

void
delgen(userid)                     /* delete generic data records for user */
char *userid;                           /* userid to delete records for    */
{
     char usrmdl[UIDSIZ+MNMSIZ];

     setbtv(genbb);
     stzcpy(usrmdl,userid,UIDSIZ+MNMSIZ);
     if (qgebtv(usrmdl,0)) {
          do {
               gcrbtv(NULL,0);
               if (!sameas((char *)genbb->data,usrmdl)) {
                    break;
               }
               delbtv();
          } while (qnxbtv());
     }
     rstbtv();
}

STATIC int
prtpsk(unum,lock)                  /* validate the _PORT# pseudokey        */
int unum;                               /* user number trying to use key   */
char *lock;                             /* lock name key is for            */
{
     int chn;

     sscanf(lock,"_PORT#%x",&chn);
     return(channel[unum] == chn);
}

STATIC int
grppsk(unum,lock)                  /* validate the _GROUP# pseudokey       */
int unum;                               /* user number trying to use key   */
char *lock;                             /* lock name key is for            */
{
     int grp;

     sscanf(lock,"_GROUP#%x",&grp);
     return(grpnum[unum] == grp);
}

STATIC int
lngpsk(unum,lock)                  /* validate the _LANG= pseudokey        */
int unum;                               /* user number trying to use key   */
char *lock;                             /* lock name key is for            */
{
     char *ptr;
     static char lngnam[LNGSIZ];

     strcpy(lngnam,languages[extoff(unum)->lingo]->name);
     if ((ptr=strchr(lngnam,'/')) != NULL) {
          *ptr='\0';
     }
     return(sameas(lngnam,&lock[6]));
}

STATIC int
propsk(unum,lock)                  /* validate the _PROT= pseudokey        */
int unum;                               /* user number trying to use key   */
char *lock;                             /* lock name key is for            */
{
     char *ptr;
     static char prot[LNGSIZ];

     strcpy(prot,languages[extoff(unum)->lingo]->name);
     if ((ptr=strchr(prot,'/')) != NULL) {
          strcpy(prot,ptr+1);
     }
     else {
          prot[0]='\0';
     }
     return(sameas(prot,&lock[6]));
}

int
onsys(                             /* conditional check if user is on the  */
char *uid)                         /* system and class > SUPIPG            */
{
     return(onsysn(uid,0));
}

int
onsysn(                            /* check "uid" to see if on the system  */
char *uid,
int invis)          /* 0=use INVISB flag in decision, 1=ignore INVISB flag */
{
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          othuap=uacoff(othusn);
          othexp=extoff(othusn);
          if (othusp->class > SUPIPG && sameas(uid,othuap->userid)) {
               if (invis || !(othusp->flags&INVISB)) {
                    return(1);
               }
          }
     }
     return(0);
}

int
uinsys(             /* conditional check to see if a user is on the system */
char *uid)                                             /* Even logging in! */
{
     return(onbbs(uid,0));
}

int
onbbs(              /* is a userid ANYWHERE on the BBS? (even logging in)  */
char *uid,
int invis)          /* 0=use INVISB flag in decision, 1=ignore INVISB flag */
{
     if (*uid != '\0') {
          for (uisusn=0 ; uisusn < nterms ; uisusn++) {
               if (uisusn != usrnum && sameas(uid,uacoff(uisusn)->userid)) {
                    if (invis || !(user[uisusn].flags&INVISB)) {
                         return(1);
                    }
               }
          }
     }
     return(0);
}

int
instat(                            /* is userid in a given state?          */
char *uid,
int qstate)
{
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          othuap=uacoff(othusn);
          othexp=extoff(othusn);
          if (othusp->state == qstate && sameas(uid,othuap->userid)) {
               if (!(othusp->flags&INVISB)) {
                    return(1);
               }
          }
     }
     return(0);
}

char *
catfix1(void)                      /* MajorBBS catfix1() for catamsg()     */
{
     static char ufbuff[80]={""};

     if (uacoff(0) != NULL && user != NULL && usrnum >= 0 && usrnum < nterms) {
          curusr(usrnum);
          sprintf(ufbuff,"CH%02X=%s:%d/%d",channel[usrnum],usaptr->userid,
                  usrptr->state,usrptr->substt);
     }
     return(ufbuff);
}

STATIC
void
inimod(void)                       /* initialize the MajorBBS modules      */
{
     register_module(&module00);
     inifse();
     callinits();
}

void
prepff(void)                      /* prepare vacant chans for further stuff */
{   /* rsmode implicit input: NORMRS=incoming calls, BUSYRS/NANSRS=shutdown */
     for (usrnum=0,usrptr=user ; usrnum < nterms ; usrnum++,usrptr++) {
          extptr=extoff(usrnum);
          rsmodes[usrnum]=rsmode;
          if (usrptr->class == VACANT
            && (rsmode == NORMRS || usrptr->state != W4KILL)) {
               rstchn();
          }
     }
}

void
ckmcu(void)                        /* check for time for midnight cleanup  */
{
     int hr;

     if ((hr=dthour(now())) != lasthr) {
          lasthr=hr;
          if (shterc[hr] >= 0) {
               mcuctr=0;
               errcod=shterc[dthour(now())];
               rsmode=rsetop;
               prepff();
          }
     }
     if (mcuctr >= 0 && mcuctr <= mcumin) {
          if (mcuctr == mcumin) {
               hupall();
          }
          else if (mcuctr >= mcumin-mcuwrn) {
               kalert(errcod == 0 ? GOINGD2 : GOINGM,mcumin-mcuctr);
          }
          mcuctr++;
     }
     if (sapsup) {
          sapmin();
     }
     rtkick(60,ckmcu);
}

void
zapdec(void)                       /* decrement zap table counters         */
{
     int i;

     for (i=0 ; i < nterms ; i++) {
          if (zaptbl[i] > 0) {
               zaptbl[i]=max(0,zaptbl[i]-ZAPINT);
               if (zaptbl[i] == 0) {
                    usrnum=i;
                    rstchn();
               }
          }
     }
     rtkick(ZAPINT,zapdec);
}

STATIC void
updclk(void)                       /* update DOS clock from CMOS           */
{
     union REGS regs;
     int totsec,dtots;
     unsigned char hour,min,sec,dh,dm,ds;

     regs.x.ax=0x0200;                  /* get CMOS time                   */
     int86(0x1A,&regs,&regs);
     hour=(regs.h.ch&0x0F)+(regs.h.ch>>4)*10;
     min=(regs.h.cl&0x0F)+(regs.h.cl>>4)*10;
     sec=(regs.h.dh&0x0F)+(regs.h.dh>>4)*10;
     totsec=min*60+sec;
     regs.x.ax=0x2C00;                  /* get DOS time                    */
     int86(0x21,&regs,&regs);
     dh=regs.h.ch;
     dm=regs.h.cl;
     ds=regs.h.dh;
     dtots=dm*60+ds;
     if (dh == hour && abs(totsec-dtots) > 60) {
          regs.x.ax=0x2D00;             /* set DOS time                    */
          regs.h.ch=hour;
          regs.h.cl=min;
          regs.h.dh=sec;
          regs.h.dl=0;
          int86(0x21,&regs,&regs);
     }
     rtkick(120,updclk);
}

STATIC void
kalert(                            /* system shutdown alert                */
int msgnum,
int nmins)
{
     setmbk(mjrmb);
     prfmlt(msgnum,nmins,(nmins == 1 ? "" : "s"));
     for (othusn=0 ; othusn < nterms ; othusn++) {
          if (user[othusn].class > SUPIPG) {
               injoth();
          }
     }
     clrmlt();
}

void
midnit(void)                       /* MajorBBS midnight cleanup function   */
{
     int i;
     void (*rouptr)();

     gsbldn();
     if (accmcu()) {
          for (i=1 ; i < nmods ; i++) {
               if ((rouptr=module[i]->mcurou) != NULL) {
                    clingo=0;
                    (*rouptr)();
               }
          }
     }
}

char *
getin(void)                        /* get input, parse, return first arg   */
{
     paccin();
     parsin();
     return(margv[0]);
}

void
parsin(void)                       /* parse input into margv[], etc.       */
{
     char *inpptr;

     margc=0;
     inplen=0;
     inpptr=input-1;
     while (1) {
          while (*++inpptr == ' ') {
          }
          if (*inpptr == '\0') {
               break;
          }
          margv[margc]=inpptr;
          while (*++inpptr != ' ') {
               if (*inpptr == '\0') {
                    margn[margc++]=inpptr;
                    inplen=(int)(inpptr-input);
                    return;
               }
          }
          *inpptr='\0';
          margn[margc++]=inpptr;
     }
     if (margc != 0) {
          inplen=(int)(margn[margc-1]-input);
          setmem(margn[margc-1],sizeof(input)-inplen,0);
     }
     else {
          margv[0]="";
     }
}

void
paccin(void)             /* get user input and do initial preprocessing    */
{
     inplen=btuinp(usrnum,input);
     paccit();
}

void
paccit(void)             /* show input on modem monitor, check profanity   */
{
     shomal();
     if ((pfnlvl=profan(input)) != 0) {
          if (haskey(syskey)) {
               pfnlvl=0;
          }
          else if (pfnlvl > pfceil) {
               pfnlvl=pfceil;
          }
     }
     if (pfnlvl > 1) {
          usrptr->pfnacc+=pfnlvl;
     }
}

void
rstrin(void)                  /* restore parsed input to a single string   */
{
     int i;

     for (i=0 ; i < margc-1 ; i++) {
          *margn[i]=' ';
     }
}

void
chkdft(                       /* check for default (<CR>) input            */
char c)
{
     if (margc == 0) {
          if (c != '\0') {
               input[0]=c;
               input[1]='\0';
               margn[0]=input+1;
               margc=1;
          }
          margv[0]=input;
          inplen=strlen(input);
     }
}

char
getdft(void)                  /* return default char based on cur prfbuf   */
{
     int len;
     char rv='\0',*ptr;
     static char wrkbuf[80];

     if (prfptr != prfbuf && !isspace(*(prfptr-1))) {
          stzcpy(wrkbuf,ptr=lastwd(prfbuf),sizeof(wrkbuf));
          stpans(wrkbuf);
          if ((len=strlen(wrkbuf)) > 0) {
               rv=wrkbuf[len-1];
               if (len == strlen(ptr) || len == strlen(skpans(ptr))) {
                    *(--prfptr)='\0';
               }
               else {
                    *(skpans(ptr)+len-1)=' ';
               }
          }
     }
     return(rv);
}

void
byenow(                            /* log-off a user w/ message utility    */
int msgnum,
long p1,long p2,long p3)
{
     btulok(usrnum,1);
     btucli(usrnum);
     btuclo(usrnum);
     btuoes(usrnum,1);
     prfmsg(msgnum,p1,p2,p3);
     outprf(usrnum);
     clrprf();
     user[usrnum].flags|=BYEBYE;
}

long
lincst(                     /* find cost of using X.25 line for 15 seconds */
int unum)                               /* for this user                   */
{
     int grp;
     long btuset(),deltap,deltab,rc;

     if (user[unum].flags&ISX25) {
          grp=grpnum[unum];
          rc=(ksec[grp]>>2)+((user[unum].minut4&3)<(ksec[grp]&3));
          deltab=btuset(unum,CNTCHR,0L);
          deltap=btuset(unum,CNTPAK,0L);
          rc+=(deltab*kchar[grp]+500)/1000+
              (deltap*kpak[grp]+500)/1000;
          deltab+=sv2.x25bs;
          sv2.x25mbs+=deltab/1000000L;
          sv2.x25bs  =deltab%1000000L;
          deltap+=sv2.x25ps;
          sv2.x25kps+=(int)(deltap/1000L);
          sv2.x25ps  =(int)(deltap%1000L);
          return(rc);
     }
     return(0L);
}

void
rstchn(void)                       /* completely reset a modem channel     */
{
     int rc;
     extern int chnemd;

     if (usrnum == chnemd) {
          emdisp(" * RESET * ");
     }
     usrptr=&user[usrnum];
     extptr=extoff(usrnum);
     if (usrptr->lcstat == LSSESTB) {
          btucmd(usrnum,"T");
          shochl("SPX Terminating...",'T',baudat(usrptr->baud,0));
          usrptr->lcstat=LSSTERM;
          btuinj(usrnum,CYCLE);
          usrptr->class=VACANT;
          usrptr->state=W4SPXT;
          tspxt=ticker;
          return;
     }
     if (usrptr->keys != NULL) {
          freekey();
     }
     setmem(usrptr,sizeof(struct user),0);
     setmem(extptr,sizeof(struct extusr),0);
     mnuusr=mnuoff(usrnum);
     setmem(mnuusr,sizeof(struct usrmnu),0);
     setmem(uacoff(usrnum),sizeof(struct usracc),0);
     usrptr->baud=mxbaud[grpnum[usrnum]];
     lincst(usrnum);
     rc=bturst(usrnum);
     switch (rc) {
     case 3:
          rstlan(1);
          break;
     case 2:
          rstx25("X.25 channel ready for use",'.');
          break;
     case 1:
          btubrt(usrnum,usrptr->baud);
          btuhwh(usrnum,outbsz-20);
     case 0:
          btuffo(usrnum,0x07);
          shochl("Initializing...",'.',baudat(usrptr->baud,0)&0xF7);
          break;
     default:
          usrptr->flags|=NOHDWE;
          switch (grtype[grpnum[usrnum]]) {
          case GTLAN:
               rstlan(0);
               break;
          case GTX25:
               rstx25("Non-Hardware X.25",'-');
               break;
          default:
               usrptr->baud=maxpol;
               shochl(usrnum != nterms-1 ? "Non-Hardware" : "Local Session",'-',
                      baudat(usrptr->baud,0)&0xF7);
               break;
          }
     }
     btuscr(usrnum,'\n');
     btutru(usrnum,'O'&0x1F);
     btutrs(usrnum,1);
     btumil(usrnum,DFTIMX);
     btuech(usrnum,0);
     if (!(usrptr->flags&ISX25) && chanty[grpnum[usrnum]] == 0) {
          btulok(usrnum,1);
          btucmd(usrnum,"^E=");
     }
     btucli(usrnum);
     zaptbl[usrnum]=0;
}

void
rstx25(                            /* reset-related x.25 activity          */
char *dspstg,
char dspc)
{
     usrptr->flags|=ISX25;
     usrptr->baud=(unsigned int)38400L;
     if (rsmodes[usrnum] != NORMRS) {
          kiletc("Disabled X.25");
     }
     else {
          shochl(dspstg,dspc,baudat(usrptr->baud,0)&0xF7);
          usrptr->state=AWAITC;
     }
}

void
rstlan(                                       /* reset-related LAN activity */
int ishard)
{
     int group,ci,i,chan,found;
     char *cp;

     shochl("LAN channel ready for use",'.',baudat(usrptr->baud,0)&0xF7);
     usrptr->baud=(unsigned int)38400L;
     if (rsmodes[usrnum] != NORMRS) {
          saphdl(grpnum[usrnum],0);
          kiletc("Disabled LAN");
          return;
     }
     usrptr->state=AWAITC;
     if (!ishard) {
          shochl("Non-Hardware LAN",'-',baudat(usrptr->baud,0)&0xF7);
          return;
     }
     switch (chanty[group=grpnum[usrnum]]) {
     case SDFIPXD:
          setmbk(mjrmb);
          cp=rawmsg(IPXADR1+(group-1)*(GROUP2-GROUP1));
          rstmbk();
          chan=usofgr[group];
          ci=0;
          found=0;
          stpans(cp);
          while (*cp != '\0') {
               while (*cp != '\0' && !isxdigit(*cp)) {
                    cp++;
               }
               if (*cp == '\0') {
                    break;
               }
               for (i=0 ; i < 24 && isxdigit(*cp) ; i++,cp++) {
                    *cp=toupper(*cp);          /* (btucmd() will need u.c.) */
               }
               if (i == 24 && !isxdigit(*cp)) {
                    if (chan+ci == usrnum) {
                         *cp='\0';
                         cp-=24;
                         found=1;
                         break;
                    }
                    ci++;
               }
               else {
                    while (isxdigit(*cp)) {
                         cp++;
                    }
               }
          }
          if (!found) {
               shochl("ERROR: bad IPX address",'#',0x9c);
               return;
          }
          btucmd(usrnum,"W");
          btucmd(usrnum,cp);
          btucmd(usrnum,"M");
          usrptr->lcstat=LSDCOMM;
          break;
     case SDFIPXV:
          usrptr->lcstat=LSVRAWP;
          btutrg(usrnum,sizeof(struct ipxhdr));
          break;
     case SDFSPX:
          btucmd(usrnum,"L");
          usrptr->lcstat=LSSINWT;
          break;
     }
     saphdl(grpnum[usrnum],1);
}

void
rstrxf(void)                       /* restore screen-length to usracc setting */
{
     btuxnf(usrnum,0,-19,usaptr->scnbrk-CTNUOS,scnpaus[extptr->lingo]);
     btuhpk(usrnum,hpkrou);
     btupbc(usrnum,20);
     btucpc(usrnum,19);
}

unsigned long
hrtval(void)                       /* get btuhrt in a safe manner (dsairp) */
{
     unsigned long hrtsmp;

     dsairp();
     hrtsmp=btuhrt;
     enairp();
     return(hrtsmp);
}

int
hpkrou(                            /* "handle pause key" irp routine       */
int chan,
char c)
{
     switch (toupper(c)) {
     case 'N':
          return(2);
     case 'Q':
          chiinj(chan,ABOREQ);
          chiout(chan,c);
          chious(chan,"\r\n");
          return(0);
     case 19:  /* XOFF char (CTRL-S)    */
     case 17:  /* XON char (CTRL-Q)     */
          return(0);
     default:
          return(1);
     }
}

void
stansi(void)                       /* set ANSI handling to usracc setting  */
{
     btucmd(usrnum,(usaptr->ansifl&ANSON) ? "[" : "]");
}

void
echon(void)                                                 /* turn echo on */
{
     echonu(usrnum);
}

void
echonu(                                             /* turn echo on utility */
int usrnum)
{
     btuech(usrnum,echtyp[grpnum[usrnum]]);
     if (extptr->wid > 0) {
          btuchi(usrnum,NULL);
          extptr->wid=0;
     }
}

void
echsec(ech,lwidth)                 /* echo "secret" character code         */
char ech;                          /* character to echo                    */
int lwidth;                        /* maximum line width                   */
{
     btuech(usrnum,0);
     extptr->col=0;
     extptr->wid=(char)(max(1,min(255,lwidth)));
     extptr->ech=ech;
     btuchi(usrnum,secchi);
}

STATIC char
secchi(chan,c)                     /* btuchi() routine for '*' echoing     */
int chan;
int c;
{
     struct extusr *xptr;

     xptr=extoff(chan);
     switch(c&=eurmsk) {
     case '\r':
          xptr->col=0;
          chiout(chan,c);
          break;
     case '\b':
     case 0x7F:
          c='\b';
          if (xptr->col > 0) {
               xptr->col--;
               chiout(chan,c);
          }
          break;
     default:
          if (c >= ' ' && xptr->col < xptr->wid) {
               xptr->col++;
               chiout(chan,xptr->ech);
          }
          else {
               c=0;
          }
          break;
     }
     return(c);
}

int
injoth(void)                       /* inject a message into othusn's chan. */
{
     FILE *savmb;
     int retval=1,ilingo;
     int (*rouptr)();

     savmb=curmbk;
     if (mltflg) {
          prfbuf=ptrtile(prfbuffers,extoff(othusn)->lingo);
     }
     if (user[othusn].flags&NOINJO) {
          retval=0;
     }
     else if ((rouptr=module[user[othusn].state]->injrou) == NULL) {
          dftinj();
     }
     else {
          retval=rouptr();
     }
     for (ilingo=0 ; ilingo < nlingo ; ilingo++) {
          prfpointers[ilingo]=ptrtile(prfbuffers,ilingo);
     }
     prfptr=prfbuf=prfpointers[0];
     curmbk=savmb;
     return(retval);
}

void
dftinj(void)
{
     btuxmn(othusn,prfbuf);
     btuoes(othusn,1);
     user[othusn].flags|=INJOIP;
}


int
lonstf(void)                       /* supplemental log-on stuff            */
{
     int i;
     int (*rouptr)();

     if (lonaud) {
          if (usrptr->flags&ISX25) {
               shocst("USER LOGON VIA X.25","User-ID: %s",usaptr->userid);
          }
          else if ((i=chanty[grpnum[usrnum]]) != 0) {
               shocst(spr("USER LOGON VIA LAN (%s)",chantn[i-SDFIPXD]),
                      "User-ID: %s",usaptr->userid);
          }
          else {
               shocst(spr("USER LOGON AT %ubps",usrptr->baud),
                      "User-ID: %s",usaptr->userid);
          }
          if (sopaud && (usrptr->flags&MASTER)) {
               btuoes(usrnum,0);
               usrptr->flags&=~INJOIP;
          }
     }
     usrptr->crdrat=mmucrr;
     for (i=0 ; i < nmods && !(usrptr->flags&BYEBYE) ; i++) {
          if ((rouptr=module[i]->lonrou) != NULL) {
               usrptr->state=i;
               usrptr->substt=0;
               usrptr->class=SUPLON;
               setmem(vdaptr,vdasiz,0);
               clrmlt();
               usrptr->linlim=i+1;
               if (!(*rouptr)()) {
                    begin_polling(usrnum,nxtlon);
               }
               return(1);
          }
     }
     usrptr->class=ACTUSR;
     usrptr->linlim=i;
     usrptr->state=0;
     return(0);
}

void
nxtlon(void)                       /* look for next logon sup routine      */
{
     int i;
     int (*rouptr)();

     stop_polling(usrnum);
     for (i=usrptr->state+1 ; i < nmods && !(usrptr->flags&BYEBYE) ; i++) {
          if ((rouptr=module[i]->lonrou) != NULL) {
               usrptr->state=i;
               usrptr->substt=0;
               clrmlt();
               usrptr->linlim=i+1;
               setmem(vdaptr,vdasiz,0);
               if (!(*rouptr)()) {
                    begin_polling(usrnum,nxtlon);
               }
               return;
          }
     }
     usrptr->linlim=i;
     ret2mnu(-1);
}

void
bgnlof(void)                       /* begin logoff supplemental links      */
{
     if (module[usrptr->state]->lofrou == NULL) {
          ret2mnu(0);
     }
     else {
          usrptr->lofstt=usrptr->state;
          usrptr->state=-1;
          nxtlof();
     }
}

void
nxtlof(void)                       /* look for next logoff sup routine     */
{
     int i,ret;
     int (*rouptr)();

     usrptr->crdrat=mmucrr;
     usrptr->class=SUPLOF;
     for (i=usrptr->state+1 ; i < nmods && !(usrptr->flags&BYEBYE) ; i++) {
          if (i != usrptr->lofstt && (rouptr=module[i]->lofrou) != NULL) {
               usrptr->state=i;
               usrptr->substt=0;
               setmem(vdaptr,vdasiz,0);
               clrmlt();
               if ((ret=(*rouptr)()) == 1) {
                    return;
               }
               else if (ret == -1) {
                    ret2mnu(0);
                    return;
               }
          }
     }
     if (!(usrptr->flags&BYEBYE)) {
          usrptr->state=usrptr->lofstt;
          usrptr->substt=0;
          setmem(vdaptr,vdasiz,0);
          clrmlt();
          if ((*(module[usrptr->lofstt]->lofrou))() != 1) {
               ret2mnu(0);
          }
     }
}

STATIC
void
ret2mnu(substt)                    /* return to main menuing system now    */
int substt;                             /* substt to set the user to       */
{
     usrptr->class=ACTUSR;
     usrptr->state=0;
     usrptr->substt=substt;
     prf("");
     outprf(usrnum);
     (*(module00.sttrou))();
}

int
mainu(void)                        /* main menuing command handler         */
{
     int i,c,took=0;

     setmbk(mjrmb);
     btumil(usrnum,DFTIMX);
     usrptr->crdrat=mmucrr;
     usrptr->flags&=~NOZAP;
     bgncnc();
     switch (usrptr->substt) {
     case -1:                      /* user has just logged on              */
          cncall();
          gopage("TOP",1,0);
          break;
     case 0:                       /* user is returning from a mod -> menu */
          cncall();
          gopage(mnuusr->parpag,shortm,1);
          break;
     case 1:                       /* user is selecting from a menu page   */
          if (margc == 0) {
               if (usrptr->flags&INJOIP) {
                    gopage(mnuusr->curpag,0,0);
               }
               else {
                    gopage(mnuusr->curpag,1,0);
               }
               break;
          }
          do {
               bgncnc();
               if ((c=toupper(*nxtcmd)) == '?') {
                    prfmsg(HLPMSG);
                    if (usrptr->flags&MASTER) {
                         prfmsg(SYSHLP);
                    }
                    cncall();
                    gopage(mnuusr->curpag,1,0);
                    break;
               }
               if (sameas(nxtcmd,"find")) {
                    cncall();
                    prfmsg(FNDHLP);
                    gopage(mnuusr->curpag,0,0);
               }
               else if (sameto("find ",nxtcmd)) {
                    bgnfnd();
               }
               else if (usrptr->flags&MASTER && (sameto("disable",nxtcmd) ||
                        sameto("enable",nxtcmd))) {
                    cncwrd();
                    if (morcnc()) {
                         if (c == 'D') {
                              dispag(margv[1]);
                         }
                         else {
                              enapag(margv[1]);
                         }
                    }
                    else {
                         prfmsg(c == 'D' ? DISHLP : ENAHLP);
                    }
                    cncall();
                    gopage(mnuusr->curpag,0,0);
               }
               else {
                    for (i=0 ; i < MAXSEL ; i++) {
                         if (c == mnuusr->selchrs[i]) {
                              if (mnuusr->keyreq[i] != -1 &&
                                  !haskno(mnuusr->keyreq[i])) {
                                   if (mnuusr->optdsp[i] > 0) {
                                        prfmsg(NOAXSS,c);
                                   }
                                   else {
                                        prfmsg(NOTINL,c);
                                   }
                                   cncall();
                                   gopage(mnuusr->curpag,0,0);
                              }
                              else {
                                   if (mmuaud) {
                                        shocst(spr("%s MENU SELECTION '%c'",
                                               mnuusr->curpag,toupper(c)),
                                               "User-ID: %s",usaptr->userid);
                                   }
                                   gopage(mnuusr->pages[i],1,0);
                              }
                              took=1;
                              break;
                         }
                    }
                    if (!took && c == 'X') {
                         cncall();
                         gopage(mnuusr->parpag,shortm,1);
                    }
                    else if (!took) {
                         prfmsg(NOTINL,c);
                         cncall();
                         gopage(mnuusr->curpag,0,0);
                    }
                    took=0;
               }
          } while (usrptr->state == 0 && usrptr->substt == 1 && !endcnc());
          break;
     case 2:                       /* a menu file is being displayed       */
          clfile();
          gopage(mnuusr->curpag,0,0);
          break;
     case 3:                       /* any ol' file is being displayed      */
          clfile();
          if (!gopage(mnuusr->parpag,shortm,1)) {
               catastro("BAD OR MISSING PARENT PAGE \"%s\"!",mnuusr->parpag);
          }
          break;
     case 4:                       /* user is trying to "find" a page      */
          abtfnd();
          break;
     default:
          rstchn();
          return(1);
     }
     if (usrptr->state == 0) {
          outprf(usrnum);
     }
     return(1);
}

void
curusr(                                 /* set current user parameters     */
int uno)
{
     usrnum=uno;
     usrptr=&user[usrnum];
     extptr=extoff(usrnum);
     mnuusr=mnuoff(usrnum);
     usaptr=uacoff(usrnum);
     vdaptr=vdaoff(usrnum);
     clingo=extptr->lingo;
}

struct extusr *
extoff(unum)                       /* get pointer to extusr[unum]          */
int unum;                               /* user to get pointer for         */
{
     return(&extusr[unum]);
}

void
usrson(void)                            /* display-users-online utility    */
{
     othusp=user;
     setmbk(mjrmb);
     prfmsg(ULSHDR);
     for (othusn=0 ; othusn < nterms ; othusn++) {
          othuap=uacoff(othusn);
          othexp=extoff(othusn);
          switch (othusp->class) {
          case VACANT:
               break;
          case ONLINE:
               prfmsg(ULSLIN,channel[othusn],"(log-on)","");
               break;
          case SUPIPG:
               prfmsg(ULSLIN,channel[othusn],"(sign-up)","");
               break;
          default:
               if (!(othusp->flags&INVISB)
                  && (isuidc(othuap->userid[0]) || othuap->userid[0] == '(')) {
                    prfmsg(ULSLIN,channel[othusn],othuap->userid,
                           module[othusp->state]->descrp);
               }
               break;
          }
          othusp++;
     }
     prfmsg(ULSTRL);
     outprf(usrnum);
     prf("");
     rstmbk();
}

void
musthn(void)
{
     if (status == CYCLE && usrptr->substt > 1) {
          if (!rdfile()) {
               if (usrptr->substt == 2) {
                    usrptr->substt=1;
               }
               else if (usrptr->substt == 3) {
                    if (!gopage(mnuusr->parpag,shortm,1)) {
                         catastro("BAD OR MISSING PARENT PAGE \"%s\"!",mnuusr->parpag);
                    }
                    outprf(usrnum);
               }
          }
     }
     else {
          dfsthn();
     }
}

void
dfsthn(void)                            /* default status handler          */
{
     switch (status) {
     case CMDOK:
     case INBLK:
     case OUTMT:
     case OBFCLR:
     case ABOREQ:
     case CMN2OK:
     case CM25OK:
     case RCVX29:
     case IPXRER:
     case IPXUNK:
     case CYCLE:
     case 251:
     case 252:
     case 253:
          break;
     default:
          loscar();
     }
}

char *
getmsg(msgnum)                     /* get a message (by number, w/ tvars)  */
int msgnum;                             /* message number to get           */
{
     return(xlttxv(rawmsg(msgnum),mxmssz));
}

void
kiloop(void)                       /* kill-system loop once per minute     */
{
     if (kilipg) {
          if (kilctr == 0) {
               hupall();
          }
          else {
               if (kilctr > 0) {
                    kalert(GOING2,kilctr);
                    kilctr--;
               }
               rtkick(60,kiloop);
          }
     }
}

void
bootem(                            /* boot User-ID about to be killed      */
char *who)
{
     if (onsysn(who,1)) {
          curusr(othusn);
          loscar();
     }
}

void
kilchn(                            /* kill a channel by channel number     */
int num)
{
     int temp;

     if (user[num].class == VACANT) {
          temp=usrnum;
          usrnum=num;
          rstchn();
          curusr(temp);
     }
     else {
          btuinj(num,RING);
     }
}

void
loscar(void)                       /* lost carrier "hang up" routine       */
{
     int i,svbaud,svlcs;
     unsigned long svflgs;
     void (*rouptr)();
     static int lstunm=-1,lststt;

     clfile();
     if (isuidc(usaptr->userid[0])) {
          if (lstunm == -1) {      /* in case of catastro(), save usrnum   */
               lstunm=usrnum;
               lststt=1;
          }
          for (i=(usrnum == lstunm ? lststt : 1) ; i < usrptr->linlim ; i++) {
               if (usrnum == lstunm) {
                    lststt++;      /* ...and save huprous already called   */
               }
               if ((rouptr=module[i]->huprou) != NULL) {
                    (*rouptr)();
               }
          }
          if (usrnum == lstunm) {  /* if no catastro(), don't save usrnum  */
               lstunm=-1;
          }
          usaptr->usedat=today();
          updacc();
          if (lofaud) {
               shocst("USER LOGOFF","User-ID: %s",usaptr->userid);
          }
          if (status == RELOG) {
               svflgs=(usrptr->flags&(NOHDWE+ACTIVE+IS2698+ISRIAL+ISX25));
               svbaud=usrptr->baud;
               svlcs=usrptr->lcstat;
               if (usrptr->keys != NULL) {
                    free(usrptr->keys);
               }
               setmem(usrptr,sizeof(struct user),0);
               setmem(extptr,sizeof(struct extusr),0);
               setmem(usaptr,sizeof(struct usracc),0);
               usrptr->flags=svflgs;
               usrptr->baud=svbaud;
               usrptr->lcstat=svlcs;
               setmbk(mjrmb);
               zaptbl[usrnum]=0;
               (*hdlcon)();
          }
          else {
               rstchn();
          }
     }
     else {
          clrmlt();
          (*(module[usrptr->state]->stsrou))();
     }
}

void
hupall(void)                       /* hang-up on all users                 */
{
     for (usrnum=0 ; usrnum < nterms ; usrnum++) {
          curusr(usrnum);
          rsmodes[usrnum]=rsetop;
          if (usrptr->class > SUPIPG) {
               status=RING;
               (*(module00.huprou))();
          }
          else if (usrptr->class != VACANT || usrptr->state != W4KILL) {
               if (usrptr->class == SUPIPG) {
                    suphup();
               }
               rstchn();
          }
     }
     rtkick(20,failsf);
}

STATIC
void
gsbldn(void)                                         /* bring down the GSBL */
{
     int i;

     if (gsblup) {
          if (sapsup) {
               sapfin();
               for (i=ticker ; ticker-i < 3 && !sapfdn() ; ) {
               }            /* 3-second timeout for S.A.P. server shutdowns */
               sapsup=0;
          }
          btuend();
          gsblup=0;
     }
}

void
mjrfin(void)                       /* finish up stuff; shutdown system     */
{
     int i;
     void (*rouptr)();

     if (initdn) {
          hupall();
          for (i=1 ; i < nmods ; i++) {
               if ((rouptr=module[i]->finrou) != NULL) {
                    (*rouptr)();
               }
          }
          gsbldn();
          clslnk();
          clsedt();
          clsmnu();
          setbtv(mstbb);
          for (i=0 ; i < nmods ; i++) {
               if (acqbtv(NULL,module[i]->descrp,0)) {
                    updbtv(&mdstats[i]);
               }
               else {
                    insbtv(&mdstats[i]);
               }
          }
          finsup();
          clsacc();
     }
     clsmsg(mjrmb);
     clsbtv(mstbb);
     clsbtv(xrfbb);
     clsbtv(genbb);
     finsho();
     gsbldn();
     cursiz(LILCURS);
     cursact(1);
     locate(0,23);
     exit(errcod);
}
