/***************************************************************************
 *                                                                         *
 *   LINGO.H                                                               *
 *                                                                         *
 *   Copyright (C) 1993 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   Multilingual information gathering and storage, based on info in      *
 *   the MJRBBS.CFG file.                                                  *
 *                                                                         *
 *   Used by CNF, BBSMTREE, BBSMSX, MSGUTL, etc.                           *
 *                                                                         *
 *                                    - Robert N. Stein 1/7/93             *
 *                                                                         *
 ***************************************************************************/

#define LNGSIZ 16                       /* 15-character language name + NUL */
#define LNGDSC 51                /* 50-character language description + NUL */
#define LNGEDT 41                     /* 40-character language editor + NUL */
#define LNGEXT (1+3+1)   /* dot + 3-character language file extension + NUL */
#define LNGYN  13                      /* 12-character yes/no options + NUL */

struct lingo {                            /* INFORMATION ON A USER-LANGUAGE */
     char name[LNGSIZ];                       /* spoken language / protocol */
     char desc[LNGDSC];                                      /* description */
     char extans[LNGEXT];             /* for .ANS users  \  file extensions */
     char extasc[LNGEXT];             /* for .ASC users   >  for temp files */
     char extibm[LNGEXT];             /* for .IBM users  /     & menu files */
     char editor[LNGEDT];      /* editor for .MSG options or for menu files */
     char yes[LNGYN],no[LNGYN];         /* (must have unique first letters) */
};

/*--- variables set by inilingo() ---*/
extern
int nlingo;                                          /* number of languages */
extern
int clingo;                                             /* current language */
extern
struct lingo **languages;      /* dyn array of pointers to lingo structures */

#define DFTLNG "English/ANSI"                      /* defautl user-language */
#define DFTSPK "English"                         /* default spoken language */
#define DFTPRT "ANSI"                                   /* default protocol */
#define DFTEDR "BBSDRAW %s"                      /* default language editor */
#define DFTYES "YES"                                /* default language yes */
#define DFTNO  "NO"                                  /* default language no */
#define LINGOFILE "MJRBBS.CFG"            /* where LNG lines are to be read */
                                /* (must agree with finint() in INTEGROU.C) */

void inilingo(void);              /* read in and construct lingo info array */
void stfext(struct lingo *lp,char *exts);          /* stuff into extensions */
void alclng(void);               /* allocate *languages[] array of pointers */
int lngfnd(char *lngnam);              /* find a language by name, -1=can't */
int chgspk(int lgo,char *spoken);     /* Alternate spoken language? (-1=no) */
int chgprt(int lgo,char *protoc);            /* Alternate protocol? (-1=no) */
void alg1st(int lgo);                /* prepare to seek alternate languages */
int algnxt(void);                               /* seek alternate languages */

