/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *   _____________                                                         *
 *  |             |  This header file defines constants, data structures,  *
 *  |  LIBUTIL.H  |  and macros used by the Library facility, including    *
 *  |_____________|  source files LIBRARY.C, LIBUTIL.C and LIBSUPT.C       *
 *                                                                         *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.  All Rights Reserved        *
 *                                                                         *
 *                                                     RNStein  May 1991   *
 *                                                                         *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

extern int libstate;                          /* Library usrptr->state code */
#define DOSPTH 80               /* Max len of DOS path spec in Copy command */

/*  Databases  */
/*-------------*/
extern BTVFILE *sigbb;        /* LIB database file handle                   */
extern BTVFILE *filbb;        /* File database file handle                  */
extern BTVFILE *kwdbb;        /* Keyword database file handle               */

/*  Database Buffers  */
/*--------------------*/
extern struct libdat *sigbuf;
extern struct fildat *filbuf;
extern struct kwddat *kwdbuf;
extern struct libdat *sigkbf;                 /* LIB Name                */
extern struct fildat *filkbf;                 /* Status/LIB/File Name    */
extern struct kwddat *kkwkbf;                 /* Keyword/LIB/File Name   */
extern struct kkilib *kkikbf;                 /* LIB/Keyword/File Name   */

/*  Macros  */
/*----------*/
#define gslsig()  getsig(libptr->selsig)     /* get data on the Selected LIB*/
#define gtgsig()  getsig(libptr->sigbpr)     /* get data on the Target LIB  */
#define gmnsig()  getsig(mainsig)            /* get data on the Main LIB    */
#define gtgfil()  getfil(libptr->filbpr)     /* get data on the Target file */
#define liborsig(l,s) (usrptr->state == LIBSTT ? (l) : (s))
#define filans(filptr) ((&filptr->astoff)+1+FILAST)   /* file answer string */
#define libans(sigptr) ((&sigptr->astoff)+1+LIBAST)    /* LIB answer string */

/*  Library User Array */
/*---------------------*/
struct libusr {               /* Library data on each user (malloc, not vda)*/
     long selsig;             /*   sigbb pointer to currently selected LIB  */
     long filbpr;             /*   filbb ptr to target file in GALFILES.DAT */
     long sigbpr;             /*   sigbb ptr to target LIB in GALLIBS.DAT   */
     int num;                 /*   gp number                                */
     int ind;                 /*   gp index                                 */
     long lnum;               /*   gp long number                           */
     long lnum2;              /*   gp long number                           */
     int flags;               /*   flags, see below                         */
     int linkst;              /*   substt (msg id) for after generic task   */
     char dribbl;             /*   helps aleviate bkground task time hogging*/
     int savstt;              /*   save state, FTF -> Library subordination */
     int savsbs;              /*   save substate, FTF -> Library            */
     long sigres;             /*   lib reserved by FRDRES or FWTRES         */
     char filres[FILNAM+1];   /*   file reserved by FRDRES or FWTRES        */
     long sigre2;             /*   lib reserved by FNMRES                   */
     char filre2[FILNAM+1];   /*   file reserved by FNMRES                  */
};

/* Special contents of libptr->filbpr:                                     */
/*                                                                         */
/* During Downloads:  filbpr points to the file in GALFILES.DAT, or for a  */
/*                    DOS-only LIB, filbpr is NULL.                        */
/* During Upload of a brand new file:  filbpr is NULL                      */
/* During Re-upload of a file:  filbpr points to the file in GALFILES.DAT, */
/*                              or for a DOS-only LIB, filbpr is -1L       */

extern struct libusr *libusr; /* Library data array (dynamically allocated) */
extern struct libusr *libptr; /* Library data for current user (pointer to) */

/*  Extra states (those not in GALLIBR.H)  */
/*-----------------------------------------*/
#define LIBDESC -1            /* LIB description after it is selected      */
#define LMENTER -2            /* Library menu enter from main menu         */
#define SHHEAD  -3            /* LIB list header                           */
#define SHSEL2  -4            /* Waiting for end of LIB-list               */
#define SHSELC  -5            /* LIB-list state from "S?"                  */
#define UALXNS  -7            /* 40: list unappr files (page1 transition)  */
#define SHSEL   -8            /* outputting LIB list                       */
#define DDMORE  -9            /* DOS directory listing                     */
#define DDMOREL -10           /* Lead in state to DDMORE                   */
#define FUPLOG  -11           /* after logging in an upload                */
#define FUPLOG2 -12           /* etc.                                      */
#define FILMOD  -13           /* after modifying a file                    */
#define KWSBAK  -14           /* keword search scanning backward (move)    */
#define KWSBKW  -15           /* keword search scanning backward (check)   */
#define KWSFOR  -16           /* keword search scanning forward (move)     */
#define KWSFWD  -17           /* keword search scanning forward (check)    */
#define KWSRSP  -18           /* waiting for response to keyword srch menu */
#define REUPLOAD -19          /* re-uploading after modifying              */
#define LMEXIT  -20           /* state for exiting Library                 */

/*  Flag masks for libptr->flags  */
/*--------------------------------*/
#define KWSILB 0x0001         /* Keyword search intra-LIB (vs Library wide) */
#define KWSDNT 0x0002         /* Keyword search date&time (vs nml keyword)  */
#define SUBBRK 0x0004         /* Some concatenated cmds return to Lib menu  */
#define INLIB  0x0008         /* User is "in" LIB (or FSD, or FTF)          */
#define FILRES 0x0010         /* File handle reserved (fopen-protector)     */
#define FNMRES 0x0020         /* File name reserved (sigbpr/filres)         */
#define FRDRES 0x0040         /* File read reserve  (sigbpr/filres)         */
#define FWTRES 0x0080         /* File write reserve (sigbpr/filres)         */
#define BAKGND 0x0100         /* User processes are executing in background */
#define DELLIB 0x0200         /* Sysop deciding whether to delete LIB or not*/
#define BKSLNT 0x0400         /* Background processes should not prfmsg()   */
#define LOPRES 0x0800         /* LIB-Op or Sysop privileged function        */
#define CPYMOV 0x1000         /* Destructive form of copy command           */
#define MULTUP 0x2000         /* Multi-file upload possible                 */
#define LOGPND 0x4000         /* Logging 1 file postponed til after upld ssn*/
#define FCOMMD 0x8000         /* dual \/ F command download                 */
#define ZFRAGM 0x8000         /* role /\ ZMODEM upload, saving fragment     */

#if KWSILB != KKILIB || KKLIBW != 0
#error KWSILB flag should be such that libptr->flags&KWDTRA is KKILIB or KKLIBW
#endif

#if KWSILB != 1 || KWSDNT != 2
#error prfmsg()'s in LIBRARY.C depend on tstufl(KWSDNT+KWSILB) forming 0,1,2,3
#endif

#define setufl(m) (libptr->flags|=(m))    /* Set user flags                 */
#define clrufl(m) (libptr->flags&=~(m))   /* Clear user flags               */
#define tstufl(m) (libptr->flags&(m))     /* Test user flags                */


/*--- Volatile Data Area structure overlays ---*/

#define filtmp ((struct fildat *)vdaptr)                       /* file info */
#define FKTSIZ (FILSIZ+FILMXA)                         /* size of file info */
                           /* filtmp must also agree with filalt in LUTIL.C */

#define sigtmp ((struct libdat *)vdaptr)              /* temporary lib info */
#define LIBASIZ (LIBSIZ+LIBMXA)             /* size of lib info (w/ans stg) */

#define ENTOFF 0
#define enttmp (vdaptr+ENTOFF)  /* for FSD entry of LIB or file information */

struct filmnu {            /* array element used in download keyword search */
     char sig[LIBNAM+1];
     char file[FILNAM+1];
     char keywrd[KWDLEN+1];
     long kwdbpr;
};                                       /* indexed 0,1,...,kwscan,kwscan+1 */
#define mnutmp ((struct filmnu *)(vdaptr+FKTSIZ))

/*

Format of the mnutmp[] array:
          ____
     0   |____|    (keyword just before displayed menu entry 1)
     1   |____| 1. keyword search menu entry 1
     2   |    | 2. keyword search menu entry 2
     :   :    : :
     N-1 |____| :
     N   |____| N. keyword search menu entry N = <kwscan>
     N+1 |____|    (keyword just after displayed menu entry <kwscan>)

*/

struct rndata {                            /* data used while renaming file */
     char path2[MAXPTH+1];                                 /* new path name */
     char file2[FILNAM+1];                                 /* new file name */
     char path1[MAXPTH+1];                                 /* old path name */
     char file1[FILNAM+1];                                 /* old file name */
     char sig[LIBNAM+1];                                   /* LIB name      */
};                   /* Note:  rccfil() expects path2 to be the first field */

#define RNDSIZ sizeof(struct rndata)
#define rndtmp ((struct rndata *)(vdaptr+FKTSIZ))

struct cpydat {                             /* data used while copying file */
     long fmsig;                                /* from LIB btrieve pointer */
     char fmfile[FILNAM+1];                     /* from file name           */
     char fmpath[DOSPTH+1];                     /* from path name           */
     long tosig;                                /*   to LIB btrieve pointer */
     char tofile[FILNAM+1];                     /*   to file name           */
     char topath[DOSPTH+1];                     /*   to path name           */
     long mtime;                                /* modification time&date   */
};

#define CPYSIZ sizeof(struct cpydat)
#define cpytmp ((struct cpydat *)(vdaptr+FKTSIZ))


/*  Local Variables  */
/*-------------------*/
extern FILE *libmb;           /* library message file block pointer         */
extern int libstt;            /* new substate for this state                */
extern char *cmdptr;          /* pointer to commands                        */
extern int margi;             /* margv[] index                              */
extern char ntrstt;           /* substt when entering Library               */
extern long mainsig;          /* Btrieve pointer to the Main LIB            */
extern long siggvn;           /* Global variable for filnam() and isfil()   */
extern int namres;            /* Global var for filnam() (reserved name)    */
extern char fnwild;           /* aux return value of filnam() in LIBUTIL.C  */
extern long byteroom;         /* return value of sigroom()                  */


/*  Level 3,4 Configuration Variables  */
/*-------------------------------------*/
extern int cpyblk;             /* Maximum suggested copy size at a time     */
extern int topfil;             /* list how many often-downloads in TOPFILES */
extern int umlimit;            /* limit file quantity on multi-file uploads */
extern char kwscan;            /* keyword scan, number at a time            */
extern char comeff;            /* Communications efficiency (in %)          */
extern int maxres;             /* Maximum number of user files open at once */
extern char chgabt;            /* Charge users for aborted downlaods?       */
extern char chgsys;            /* Charge for TOPFILES, INDEX, FILES, LIBS?  */
extern char libcln;            /* 1=auto-cleanup 0=no auto-cleanup for libs */
extern char dofiles;           /* 1=Look for FILES in DOS-Only LIBs 0=no    */
extern char zuresume;          /* allow partial zmodem upload & later resume*/
extern char poschk;            /* check absolute file positions & report err*/
extern char *fsyslock;         /* lock on Sysop features of the File Library*/

extern long (*tftabl)[2];      /* Dynamic 2D array for "TOPFILES" generation*/
                               /*      containing [0]=absptr [1]=numdld     */
                               /*      1st entries are most popular entries */
extern long (*mtftab)[2];      /* 2D array for "MAIN\TOPFILES" regeneration */


struct ftglib {                   /* TAGSPEC structure for the File Library */
     long sigbpr;                           /* pointer to LIB in LIBSIG.DAT */
     char filspc[FILNAM+1];                 /* File spec ("FFFFFFFF.EEE\0") */
};

#define ltgptr ((struct ftglib *)(ftgptr->tagspc))

#if sizeof(struct ftglib) > TSLENG
#error ftglib structure too big (or include "filexfer.h" before "libutil.h")
#endif

/*--- routines in LIBRARY.C ---*/

void
setlib(void);                        /* set up globals for the File Library */

void
lmreturn(void);                          /* Implicit return to Library menu */

void
libexit(void);                             /* Explicit exit to Library menu */

int
sigmnu(void);                                 /* libop Library menu options */

int
sysmnu(void);                                 /* Sysop Library menu options */


void
rollcall(void);                              /* Prepare to scan other users */

char *
rcsig(                                          /* Next user using this LIB */
long sigbpr);

int
rclop(void);                                             /* Another LIB-Op? */

int
rcbsig(                                    /* Next user (backgnd) using LIB */
long sigbpr);

int
reschk(                               /* Find next user reserving this file */
long sigbpr,                                                         /* LIB */
char *fname,                                                   /* file name */
int resmsk);                       /* reserve mask:  FRDRES, FWTRES, FNMRES */

int
frexcd(void);                    /* Number of reserved files exceeds limit? */

void
bkgbeg(                                           /* Begin background tasks */
int lockout);          /* 1=lockout input while in background 0=allow input */

/*--- routines in LIBUTIL.C ---*/

int
rsvnam(                         /* Is a name reserved by MSDOS for a device */
char *name);

void
getsig(                                      /* Get data on a specified LIB */
long sigbpr);

void
getfil(                                     /* Get data on a specified File */
long filbpr);

int
signam(                                        /* Is this a valid LIB name? */
char *name);                               /* if so:  sigkbf->name <-- name */

int
issig(void);                              /* Does the valid LIB name exist? */

int
filnam(                                   /* Is this a valid LIB\file name? */
long defsig,                                                 /* default LIB */
char *name);

int
isfil(                                    /* Does the valid LIB\file exist? */
char status);                                /* A(pproved) or U(napproved)  */

void
astlib(void);   /* correct GALLIBS.DAT record for fields added after astoff */

void
astfil(void);  /* correct GALFILES.DAT record for fields added after astoff */

void
inslib(                                        /* insert GALLIBS.DAT record */
struct libdat *sigptr);

void
updlib(                                   /* update information about a LIB */
struct libdat *sigptr);

void
insfil(                                       /* insert GALFILES.DAT record */
struct fildat *filptr);

void
updfil(                                       /* update GALFILES.DAT record */
struct fildat *filptr);

char *
liblin(void);                             /* Short description line for LIB */
                                                /* sigbuf is implicit input */
char *
fillin(void);                            /* Short description line for FILE */
                                                /* filbuf is implicit input */

int
kwdval(                                         /* Is this a valid keyword? */
char *keywrd);                                         /* modifies in place */
                                                 /* libptr->sigbpr implicit */

void
fmtkwd(char *keywrd);                            /* Create a keyword record */
                      /* (filbuf is implicit input, kwdbuf implicit output) */

int
autofs(                             /* How many auto files are in this LIB? */
long sigbpr,                                 /* btrieve pointer to LIB data */
char status);                                      /* File status to search */

int
isautf(             /* Is file name an automatically generated system file? */
char *name);

void
sluhdr(void);                        /* put header for LIB list into prfbuf */

void
sgl1st(void);                              /* Regen LIB Listing:  first LIB */

int
sglnxt(void);                              /* Regen LIB Listing:  next LIB? */

int
sglfin(void);                                       /* Wind up the LIB List */

void
slu1st(void);                                  /* begin formatting LIB list */

int
slunxt(                                     /* continue formatting LIB list */
int vis);      /* 1=output LIB info -1=blank-pad 0=just advance to next LIB */

void
slufin(void);                                 /* finish formatting LIB list */

int
fld1st(                               /* Regen File Directory:  get started */
long sigbpr);
                                   /* 1=ok 0=had trouble creating .{T} file */

int
fldnxt(void);                          /* Regen File Directory:  next file? */

int
fldfin(void);                                 /* Wind up the file directory */

void
ufd1st(                            /* Auto-cleanup scan of unapproved files */
long sigbpr);                                /* Btrieve pointer to LIB data */

int
ufdnxt(void);     /* set fldbpr and mfdptr fields of unapproved files to 0L */
                         /* for files that were unapproved using command 42 */

void
updfld(                      /* Update info about file in file directory(s) */
long sigbpr,                                 /* Btrieve pointer to LIB data */
long filbpr,                                /* Btrieve pointer to file data */
int exist);                           /* 1=file exists 0=file being deleted */

void
updfld1(                            /* Update entry in LOCAL file directory */
long sigbpr,                                 /* Btrieve pointer to LIB data */
long filbpr,                                /* Btrieve pointer to file data */
int exist,                            /* 1=file exists 0=file being deleted */
int addlin);        /* 1=add line to file directory, 0=update existing line */

void
mfd1st(void);                          /* Prepare for master file directory */

int
mfdnxt(void);    /* Concatenate all file directories to main file directory */

void
mfdfin(void);                          /* Wind up the master file directory */

int
ind1st(                                        /* Regen Index:  get started */
long sigbpr);
                                   /* 1=ok 0=had trouble creating .{T} file */

int
indnxt(void);                                /* Regen Index:  next keyword? */

int
mind1st(void);                          /* Regen Master Index:  get started */
                                   /* 1=ok 0=had trouble creating .{T} file */

int
mindnxt(void);                        /* Regen Master Index:  next keyword? */

void
tfl1st(                                   /* Prepare to generate "TOPFILES" */
long (*tblptr)[2]);

void
tflnxt(           /* Gen "TOPFILES" table, called for successive candidates */
long (*tblptr)[2]);

void
tflfin(                            /* Generate "TOPFILES" from tblptr table */
long (*tblptr)[2],
long sigbpr);                       /* put list in this LIB's TOPFILES file */

void
libcup(void);                           /* Library-specific midnite cleanup */

char *
path(                                             /* Create a DOS path spec */
long sigbpr,                                                 /* LIB pointer */
char *fname);               /* file name (NULL if you just want the prefix) */

int
updfdt(                           /* update file data if date/time/size chg */
long sigbpr,                                                 /* LIB pointer */
char *fname,                                                   /* file name */
int mindsz);  /* minimum delta-size to retrigger INDEX & FILES regeneration */

void
enckdt(               /* Encode kwd date&time in format:  " CCCCC HH:MM:SS" */
char *cp,                 /* where CCCCC is the number of days since 1/1/80 */
unsigned dat,
unsigned tim);

int
deckdt(                                              /* Decode keyword date */
char *cp);

void
fmtkdt(void);         /* Create the keyword that has the file's date & time */

int
kwdins(                          /* insert a keyword, check for duplication */
char *kwd,                                          /* returns 1 if no dups */
int explain);                             /* 1=if problem, tell us about it */
                                                /* filbuf is implicit input */

int
kwddel(          /* delete a keyword, with checking to make sure it's there */
char *kwd,                                             /* returns 1=deleted */
int explain);                             /* 1=if problem, tell us about it */
                                                /* filbuf is implicit input */

int
kwdupd(                              /* PREPARE keyword record for updating */
char *kwd,      /* returns 1=present, needs update  0=missing, needs insert */
int explain);                             /* 1=if problem, tell us about it */
                                                /* filbuf is implicit input */

char *
nxtkwd(                          /* extract next keyword from answer string */
struct fildat *filptr);        /* pointer to file & answer string structure */

void
crfsgl(void);                      /* Create the LIB list file "MAIN\LIBS." */

void
crfflm(void);               /* Create the main File directory "MAIN\FILES." */

void
crffli(                               /* Create the File directory "FILES." */
long sigbpr);                                                  /* what LIB? */

void
crftfl(                                      /* Create the "TOPFILES." file */
long sigbpr);

void
cmnsig(void);                                        /* Create the MAIN LIB */

void
updcnt(                                          /* Update file/byte counts */
long sigbpr,                            /* LIB pointer                      */
char stat,      /* 'A' means add deltas to approved counters                */
                /* 'U' means add deltas to unapproved counters              */
                /* 'a' means transfer deltas from unapproved to approved    */
                /* 'u' means transfer deltas from approved to unapproved    */
long dfiles,                            /* change in number of files        */
long dsize,                             /* change in number of bytes        */
int dupl,                               /* change in number of uploads today*/
int didx);                              /* will index change?               */

int
updsgl(            /* Update LIB data in LIB list text file, incl LIB name, */
                   /* number of approved files, description, and total.     */
long sigbpr);      /* pointer to LIB whose file count or descr has changed. */
                   /* Does nothing (returns 0) iff "LIBS." file dont exist. */

int
sft1st(                                 /* Get first file in the target LIB */
char status);                     /* of the A(pproved) or U(napproved) list */
                       /* libptr->filbpr returned pointing to file (if any) */

int
sftnxt(                                  /* Get next file in the target LIB */
char status);                     /* of the A(pproved) or U(napproved) list */
                  /* libptr->filbpr returned pointing to file (if any more) */

int
cpy1st(                                       /* Prepare to copy a DOS file */
char *from,
char *to,                              /* returns true if open's successful */
int binmod);                 /* 1=binary mode, 0=ASCII mode (strips '\x1A') */

int
cpynxt(                                    /* Copy the next block of a file */
int nbytes);                                /* returns true if more to copy */

int
cpysrc(                   /* Change to new source file in concatenated copy */
char *from);                             /* returns true if open successful */

int
cpyfin(void);                                     /* Wind up copy operation */

void
lmback(int all);         /* return to the File Library from some expedition */

void
lmshort(void);             /* Short Library menu (may auto-exit to menuman) */

void
libpmt(void);                           /* Prompts User in the File Library */

/*--- routines in LIBDISP.C ---*/

void
kxfref(void);                        /* Cross-ref keyword data to File data */

void
kwsfil(void);         /* Record keyword info into temoporary menu structure */

int
getkwd(                /* get back your place in a keyword scan, if you can */
int explain);                        /* 1=if you can't, let's hear about it */

int
kwdprv(void);                       /* is there a keyword looking backward? */

int
kwdnxt(void);                        /* is there a keyword looking forward? */

void
rdtmpf(void);        /* Read target file and keywords into temporary buffer */

void
mknewf(                              /* create a brand new file data record */
struct fildat *filbpr);                         /* where to make the record */
                    /* assumes file name is in filkbf->name (from filnam()) */
                                    /* assumes libptr->sigbpr points to LIB */
void
shodesc(                             /* show long description (LIB or file) */
char *ans);                                         /* entire answer string */

void
shofil(void);                        /* Show information on the target file */
                      /* (filbuf contains info, libptr->sigbpr is implicit) */
long
filcst(                    /* Estimates total file download cost in credits */
long bytes);                                     /* number of bytes in file */
                                         /* implicit input:  libptr->sigbpr */

long
dnlprc(                        /* price for downloading a file of this size */
long nbytes);                                    /* number of bytes in file */
                                         /* implicit input:  libptr->sigbpr */

long
dnlsec(                                /* Estimate download time in seconds */
long bytes);                                /* implicitly uses usrptr->baud */
                /* Formula:  seconds = #bytes / (baud/10)*(%efficiency/100) */

void
ddr1st(                             /* Generate DOS-like directory of files */
char *path,
int mask);           /* FAMDIR to include sub-directories, 0 for just files */

int
ddrnxt(void);          /* Continue generating DOS-like directories of files */

void
ual1st(void);   /* Prepare for unapproved file list (selected LIB implicit) */

int
ualnxt(void);                                  /* Show next unnaproved file */
      /* returns number of lines that will be output by NEXT call to ualnxt */

int
wildcmd(void);                 /* Are there wildcard characters in command? */

int
fnresv(void);                          /* Rebuke user if file name reserved */

int
snresv(void);                           /* Rebuke user if LIB name reserved */

int
fnwbad(void);                         /* Is new sig\file specification bad? */

int
fsnbad(                                 /* Is a sig\file specification bad? */
int bfmsg);                                        /* message to give if so */

int
fdosalr(                  /* Rebuke user if file name already exists in DOS */
int msg,
char *fname);

int
lbncant(        /* Detects modification of approved file on another LIB */
int msg);                                       /* message to provide if so */

int
helpusr();                                   /* Help user if he asks for it */

int
nodosf();                              /* Rebuke user if no DOS file exists */

int
fexist(                                       /* Rebuke user if file exists */
int msg);

int
snoexs(                                /* Rebuke user if LIB does not exist */
int explain);        /* 1=rebuke with message 0=don't rebuke, just return 1 */
                                     /* side effect:  libptr->sigbpr is set */
                               /* must call right after filnam() or isfil() */
int
signow(                        /* Rebuke if cannot write to LIB (read-only) */
char *doing);                           /* whats he trying to do to the LIB */
                                     /* NULL if we don't want to rebuke him */
int
snosel(                /* Rebuke user if specified LIB not the selected LIB */
int msg);

int
chksig(void);                      /* makes sure explicit LIB really exists */
                  /* 1=exists or implicit lib, 0=explicit lib doesn't exist */
                                     /* side effect:  libptr->sigbpr is set */
                              /* must call right after filnam() or signam() */
int
uploader(void);                       /* is this the uploader of this file? */

int
ucansee(                           /* Is there a file for this user to see? */
int msg);                                /* error message, or 0 to be quiet */
                              /* if true, leaves file data in filtmp buffer */
                                   /* and points libptr->sigbpr to LIB info */

int
tfstat(                    /* Rebuke user if status of target file is wrong */
char stat,
int msg);

int
ckroom(                                    /* Check on room in LIB for file */
int tough);                  /* Give a warning if LIB size limit constrains */

int
fwtres(                                             /* Write-reserve a file */
char *usage);           /* what you're doing with it, or NULL to keep quiet */
                            /* implicit input: libptr->sigbpr, filtmp->name */

int
frdres(                                      /* Read-reserve a Library file */
char *fname,                                                   /* file name */
int explain);                      /* 1=explain why 0=just return yes or no */
                                          /* implicit input: libptr->sigbpr */

int
fnmres(                    /* Make sure no one else is using this file name */
int explain);               /* 1=tell who if they are, 0=just say yes or no */
                            /* implicit input: libptr->sigbpr, filtmp->name */

int
doncant(                        /* rebuff if trying to do in a DOS-only LIB */
char *doing);                                          /* what trying to do */

int
lopres(                                          /* reserve LIB-Op function */
int explain);

int
sigdie(                                            /* Is LIB being deleted? */
long sigbpr,
int explain);                      /* 1=explain why 0=just return yes or no */

void
uprept(                    /* Report number of uploads today, and this week */
int spacit);                         /* 1=prepend CRLF if any report at all */

int
daford(                           /* can user afford to download this file? */
int explain);                                      /* 1=if not, tell him so */
                                                   /* sigbuf implicit input */
void
dlcharge(               /* charge user for download (w/royalty to uploader) */
long amount);                                          /* amount of credits */
              /* assumes sigbuf contains LIB data, usaptr pts to downloader */

long
sigroom(                        /* How much room in this LIB for an upload? */
long sigbpr);                          /* pointer to LIB data in LIBSIG.DAT */
                     /* returns room in #files, sets byteroom=room in bytes */

void
prptsp(                          /* prepare tagspec for download submission */
int wild);                     /* 1=wild, multi-file download 0=single file */
                    /* inputs: filkbf->name, libptr->sigbpr, libptr->filbpr */
                     /* this is what's needed between ftgnew() and ftgsbm() */

void
tagmnu(                                             /* display tagging menu */
char *cmd,                                /* initial command, or "" if none */
int silent);                           /* 1=silent 0=display Library prompt */

void
prpup(     /* prepare for upload (like goupld(), but protocol is parameter) */
char *protocol);

void
goupld(                                                  /* initiate upload */
int expprt);                                       /* is protocol explicit? */
                 /* filtmp->name is nominal file name, or "" for multi-file */

int
libkey(                              /* does user have the appropriate key? */
long sigbpr,
char *keyname,                                /* name of key (see LIBDAT.H) */
int picky);        /* 1=reject if no lock 0=no lock means anyone can access */
                                        /* libptr->sigbpr is implicit input */

int
keypass(                               /* does this guy have the right key? */
char *kname,                                  /* name of key (see LIBDAT.H) */
char *doing);                       /* type of access, or NULL to be silent */
                                                 /* libptr->sigbpr implicit */

int
libop(void);                      /* is user the libop of the selected LIB? */

int
libops(                             /* is user the libop of a specific LIB? */
long sigbpr);

int
libsys(void);                    /* is user the Sysop for the File Library? */

int
smlchk(                 /* check against access to system files in MAIN LIB */
int explain);                                          /* 1=if not, tell us */

int
smwchk(                          /* check against overwriting a system file */
int explain);                                          /* 1=if not, tell us */
                                 /* libptr->sigbpr, filtmp->name are inputs */
int
socheck(void);   /* check that the Sysop is the only one doing these things */

int
locheck(void);        /* check that LIB-Op has LIB-Op key to the TARGET LIB */
                                        /* libptr->sigbpr is implicit input */

/*--- routines in LIBSUPT.C ---*/

int
okrupl(                                 /* is it ok to re-upload this file? */
int explain);                             /* 1=if not, tell us why 0=silent */
                                                       /* returns 1=ok 0=no */
                                 /* assumes filnam() has just returned != 0 */
                    /* if okrupl() returns 1, libptr->filbpr points to file */
                            /* (except if DOS-only LIB, -1L=exists, 0L=new) */
                                       /* and file data is read into filtmp */

int
okupl(                        /* is it ok to upload this file from scratch? */
int explain);                             /* 1=if not, tell us why 0=silent */
                                                       /* returns 1=ok 0=no */
                                 /* assumes filnam() has just returned != 0 */
                             /* if returns 1, libptr->filbpr gets set to 0L */
                                       /* and filtmp structure is filled up */
                                             /* BUT, FNMRES flag is NOT set */

void
hdllmu(void);                      /* Handle initial entry into the Library */

int
hdlmnu(void);                             /* Handle Library menu selections */

int
hdlssl(void);                          /* Handle LIB name for selecting */

int
hdlrfn(void);                              /* Handle name of file to rename */

void
hdlrnn(void);                              /* Handle rename file (new);name */

void
hdlapf(void);                                   /* Handle approving file(s) */

void
hdlsdn(void);                                     /* Handle LIB Delete name */

void
hdlsgc(void);                                   /* Handle sig creation name */

int
hdlkws(void);                     /* Handle keyword search (1-N, F, B, ...) */
        /* 0=handled 1=number picked -1=need to handle as keyword/file name */

int
hdldkw(void);                       /* Handle download keyword or file name */

int
hdlunm(void);                              /* Handle name for uploaded file */

void
hdlowc(void);     /* checking if approved & reserved overwrite is OK w/user */

void
hdlufs(void);                   /* Handle uploaded file's short description */

int
hdlmnm(void);                              /* Handle name of file to modify */

void
hdlap1(void);                                  /* Handle approving one file */

void
hdlapn(void);                   /* Handle approving the next file in a scan */

void
hdlupf(void);                                  /* Handle unapproving a file */

void
hdlup1(void);                                /* Handle unapproving one file */

void
hdldfn(void);                              /* Handle file name for deletion */

int
hdldfc(void);                            /* Handle confirming file deletion */

void
hdldfd(void);                /* Handle asking if delete applies to DOS file */

void
hdldds(void);                               /* confirm deletion of DOS file */

void
hdlddr(void);                      /* Handle path for DOS directory listing */

void
hdlsdc(void);                                     /* Handle deletion of LIB */

int
hdlcfn(void);                             /* Handle copy file (source) name */

void
hdlcdn(void);           /* Handle copy from DOS file to another file (name) */

void
hdlcln(void);       /* Handle copy from library file to another file (name) */

void
hdlcfe(void);         /* Handle confirm of overwriting an existing DOS file */

void
hdlclg(void);                               /* Handle logging a copied file */

void
hdllfn(void);                                    /* Handle log-in file name */

void
hdllfs(void);                    /* Handle short description of logged file */

void
hdllfa(void);                               /* Handle approving logged file */

void
hdlchq(                /* handle change question before linear edit session */
int inhmsg);

void
pmtcfe(void);                        /* Prompt for overwriting a file (etc) */

void
pmtcf(void);                                   /* Prompt for copying a file */

void
pmtdkw(void);              /* Ask for a keyword, in download keyword search */

void
stdmnu(void);                             /* show the standard library menu */

void
pmtlmu(void);                      /* Prompt for the (initial) library menu */

void
pmtsgd(void);    /* Prompt for showing the LIB description (after selected) */

void
pmtkws(void);                                      /* keyword search prompt */
