/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *   _____________                                                         *
 *  |             |  Here are many utility routines used by The Major      *
 *  |  LIBUTIL.C  |  BBS Library facility (LIBRARY.C)                      *
 *  |_____________|                                                        *
 *                                                                         *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.  All Rights Reserved        *
 *                                                                         *
 *                                                     RNStein  May 1991   *
 *                                                                         *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"
#include "gallibr.h"
#include "libdat.h"
#include "libutil.h"
#include "fsd.h"

#define USE2152 1     /* keep to use INT21/52/+22, delete to use INT2F/122C */

STATIC void
crsfil(                                     /* Create system file */
long sigbpr,                                                         /* LIB */
char *fname,                                                   /* File name */
int msg,                             /* Message id of description paragraph */
char status);                                 /* A(pproved) or U(napproved) */

/*  Librarian varibles  */
/*----------------------*/
long  lbncta;           /* Librarian counter A (sigs in sgl, files in fld)  */
long  lbnctb;           /* Librarian counter B (files in sgl, bytes in fld) */
FILE *lbnfp;            /* Librarian file pointer                           */
FILE *lbnfp2;           /* Librarian file pointer #2                        */
long  lbnkwd;           /* Librarian keyword database btrieve pointer       */
long  lbnfil;           /* Librarian file database btrieve pointer          */
long  lbnsig;           /* Librarian LIB database btrieve pointer           */



/*  Master File Directory Subtasks  */
/*----------------------------------*/
int mfdtsk;

#define CPMAIN 0     /* Copy (existing) Main file directory, up to "mfdptr" */
#define ADVLIB 1     /* Find the next LIB (that's not the Main LIB)         */
#define OPNLIB 2     /* Open the file directory for the next LIB            */
#define CPYMFD 3     /* Copy block of file directory                        */
#define MFDONE 4     /* Write EOF and close output                          */
#define MFNULL 5     /* No work for mfdnxt()                                */

int bincpy=1;        /* 1=binary copy 0=ascii copy (see cpy1st() cpynxt())  */


char sflchr[]="ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!#$&'()-@^_`";
                                  /* Valid characters for LIB or file names */
                               /* According to DOS, all of these are valid. */
            /* But according to DOS, these could also be valid:   % { } ~   */
                 /* these could never be valid:   : \ / . " * ? , ; = [ ]   */
/* these could be valid, but couldn't be typed at the DOS prompt:   < | >   */

char kwdchr[]="abcdefghijklmnopqrstuvwxyz0123456789,'-";
                               /* Valid characters for keywords             */

static char *autonm[]={        /* Names for system files                    */
     "LIBS",
     "LIBS.",
     "LIBS.{T}",
     "FILES",
     "FILES.",
     "FILES.{T}",
     "INDEX",
     "INDEX.",
     "TOPFILES",
     "TOPFILES."
};

char fnwild;                  /* aux return value of filnam() in LIBUTIL.C  */
long appbyt,appfil,uapbyt,uapfil;               /* globals used in libcup() */
long apptot,uaptot;
static int cpyerr;    /* Set by cpynxt on write error, reported by cpyfin() */
static FILE *sglfp;                       /* for regenerating the LIBS list */

#ifdef ECLIPSE
struct msb {                       /* "machine state block"                */
     int ax,bx,cx,dx;              /*    (registers for eclint())          */
     int flags;
     int si,di,ds,es;
};
#endif

void
getsig(                                      /* Get data on a specified LIB */
long sigbpr)
{
     setbtv(sigbb);
     if (aabbtv(NULL,sigbpr,0)) {
          astlib();
     }
     else {
          if (poschk) {
               rstrin();
               catastro("Absolute read error in GALLIBS.DAT, "
                        "substate %d, input=\"%s\"",libstt,input);
          }
          setmem(sigbuf,LIBSIZ+LIBMXA,0);
     }
}

void
getfil(                                     /* Get data on a specified File */
long filbpr)
{
     setbtv(filbb);
     if (aabbtv(NULL,filbpr,0)) {
          astfil();
     }
     else {
          if (poschk) {
               rstrin();
               catastro("Absolute read error in GALFILES.DAT, "
                        "substate %d, input=\"%s\"",libstt,input);
          }
          setmem(filbuf,FILSIZ+FILMXA,0);
     }
}

#ifdef PHARLAP    /*--------------- special PHARLAP routines ---------------*/

STATIC void *
rtosel(         /* convert real mode pointer to protected mode selector ptr */
void *realptr,                                         /* real mode pointer */
int nbytes)                           /* number of bytes (sizeof(*realptr)) */
{                /* you should pass return value through unrsel() when done */
     unsigned short rmseg,rmoff,sel;

     rmoff=FP_OFF(realptr);
     rmseg=FP_SEG(realptr);
     DosMapRealSeg(rmseg+(rmoff>>4),nbytes+15,&sel);
     return(MK_FP(sel,rmoff&0x0F));
}

STATIC void
unrsel(                   /* free up protected selector created by rtosel() */
void *selptr)
{
     DosFreeSeg(FP_SEG(selptr));
}

STATIC struct devhdr *
firstdev(void)       /* Get address of first device driver, PHARLAP version */
{                 /* returns pointer to first device header (or NULL=error) */
     REGS16 r;
     struct devhdr *realp,*protp;

     setmem(&r,sizeof(REGS16),0);
     #if USE2152
          r.ax=0x5200;
          if (DosRealIntr(0x21,&r,0L,0) != 0) {
               return(NULL);
          }
          realp=(struct devhdr *)MK_FP(r.es,r.bx+0x22);
          protp=rtosel(realp,sizeof(struct devhdr));
          if (memcmp(protp->dh_name,"NUL     ",8) != 0) {
               unrsel(protp);
               return(NULL);
          }
          unrsel(protp);
          return(realp);
     #else
          r.ax=0x122C;
          if (DosRealIntr(0x2F,&r,0L,0) != 0) {
               return(NULL);
          }
          return((struct devhdr *)MK_FP(r.bx,r.ax));
     #endif
}

#define PROTMODE 1                         /* PROTMODE = PHARLAP || ECLIPSE */
#endif

#ifdef ECLIPSE    /*--------------- special ECLIPSE routines ---------------*/

STATIC void *
rtosel(         /* convert real mode pointer to protected mode selector ptr */
void *realptr,                                         /* real mode pointer */
int nbytes)                           /* number of bytes (sizeof(*realptr)) */
{                /* you should pass return value through unrsel() when done */
     unsigned offs;
     union REGS regs;
     long absadr;

     absadr=FP_SEG(realptr);
     absadr<<=4;
     absadr+=FP_OFF(realptr);
     offs=(unsigned)(absadr)&0x0F;
     absadr-=offs;
     regs.x.ax=0xE803;
     regs.x.cx=0;
     regs.x.dx=nbytes+15;
     regs.x.si=(unsigned)(absadr>>16);
     regs.x.bx=(unsigned)(absadr);
     intdos(&regs,&regs);
     return(MK_FP(regs.x.ax,offs));
}

STATIC void
unrsel(                   /* free up protected selector created by rtosel() */
void *selptr)
{
     free(selptr);
}

STATIC struct devhdr *
firstdev(void)       /* Get address of first device driver, ECLIPSE version */
{                 /* returns pointer to first device header (or NULL=error) */
     struct msb eclregs;
     struct devhdr *realp,*protp;

     #if USE2152
          eclregs.ax=0x5200;
          eclint(0x21,&eclregs);
          realp=(struct devhdr *)(MK_FP(eclregs.es,eclregs.bx+0x22));
          protp=rtosel(realp,sizeof(struct devhdr));
          if (memcmp(protp->dh_name,"NUL     ",8) != 0) {
               unrsel(protp);
               return(NULL);
          }
          unrsel(protp);
          return(realp);
     #else
          eclregs.ax=0x122C;
          eclint(0x2F,&eclregs);
          return((struct devhdr *)(MK_FP(eclregs.bx,eclregs.ax)));
     #endif
}

#define PROTMODE 1                         /* PROTMODE = PHARLAP || ECLIPSE */
#endif

#ifndef PROTMODE   /*-------------- special REAL MODE routines -------------*/

#define rtosel(realptr,nbytes) realptr
#define unrsel(dp)

STATIC struct devhdr *
firstdev(void)                  /* Get DOS list of lists, REAL MODE version */
{                 /* returns pointer to first device header (or NULL=error) */
     #if USE2152
          union REGS regs;
          struct SREGS sregs;
          struct devhdr *devptr;

          segread(&sregs);
          regs.h.ah=0x52;
          intdosx(&regs,&regs,&sregs);
          devptr=(struct devhdr *)(MK_FP(sregs.es,regs.x.bx+0x22));
          if (memcmp(devptr->dh_name,"NUL     ",8) != 0) {
               return(NULL);
          }
          return(devptr);
     #else
          union REGS regs;

          regs.x.ax=0x122C;
          int86(0x2F,&regs,&regs);
          return((struct devhdr *)(MK_FP(regs.x.bx,regs.x.ax)));
     #endif
}

#endif                /*-------------- end of special routines -------------*/

int
rsvnam(                         /* Is a name reserved by MSDOS for a device */
char *name)
{
     struct devhdr *dp,*dpnew;
     char badname[8+1];

     if (sameas(name,"NUL")) {
          return(1);
     }
     if ((dp=firstdev()) == NULL) {
          catastro("Incompatible version of DOS (can't find device chain)");
     }
     while (dp != NULL && (unsigned)dp != 0xFFFFL) {
          dp=rtosel(dp,sizeof(struct devhdr));
          movmem(dp->dh_name,badname,8);
          badname[8]='\0';
          if (dp->dh_attr&0x8000 && sameas(name,unpad(badname))) {
               unrsel(dp);
               return(1);
          }
          dpnew=(struct devhdr *)dp->dh_next;
          unrsel(dp);
          dp=dpnew;
     }
     return(0);
}

int
signam(                                        /* Is this a valid LIB name? */
char *name)                                /* if so:  sigkbf->name <-- name */
{
     int i;

     namres=0;
     setmem(sigkbf->name,LIBNAM+1,0);
     for (i=0 ; i < LIBNAM && *name != '\0' ; i++,name++) {
          if (strchr(sflchr,sigkbf->name[i]=toupper(*name)) == NULL) {
               break;
          }
     }
     return(i > 0 && *name == '\0' && (namres=rsvnam(sigkbf->name)) == 0);
}

int
issig(void)                               /* Does the valid LIB name exist? */
{                                         /* if so absbtv() points to it    */
     setbtv(sigbb);
     return(qeqbtv(NULL,0));
}

int
filnam(                                   /* Is this a valid LIB\file name? */
long defsig,                                                 /* default LIB */
char *name)
/*   Cases:          retval  fnwild   siggvn    sigkbf->name   filkbf->name  */
/*   Initial "\"        0       0       0L         empty          empty      */
/*   Bad LIB name       0       0       0L       something        empty      */
/*   Bad file name      0       0       0L       something      something    */
/*   Bad file name      0       0     defsig       empty           ---       */
/*   WILDCARD imp LIB   0       1     defsig       empty        something    */
/*   WILDCARD exp LIB   0       1       0L       something      something    */
/*   OK, implicit LIB   1       0     defsig       empty        something    */
/*   OK, explicit LIB   1       0       0L       something      something    */
{
     int i,n;
     char *sp,*ep;
     int badch=0;                           /* bad characters in file name? */

     fnwild=0;
     namres=0;
     setmem(filkbf->name,FILNAM+1,0);
     sigkbf->name[0]='\0';
     if ((sp=strchr(name,'\\')) == NULL) {
          siggvn=defsig;
     }
     else {
          siggvn=0L;
          stzcpy(sigbuf->name,name,min(LIBNAM,(int)(sp-name))+1);
          if (sp == name || !signam(sigbuf->name)) {
               return(0);
          }
          name=sp+1;
     }
     if ((ep=strchr(name,'.')) != NULL) {
          n=(int)(ep-name);
          ep++;
     }
     else {
          n=strlen(name);
          ep=name+n;
     }
     if (n < 1 || n > 8 || strlen(ep) > 3 ) {
          filkbf->name[0]='.';           /* leave something in filkbf->name */
          return(0);                     /* to help fsnbad() and fnwbad()   */
     }
     for (sp=name,i=0 ; i < n ; sp++,i++) {
          if (strchr(sflchr,filkbf->name[i]=toupper(*sp)) == NULL) {
               if (*sp == '?' || *sp == '*') {
                    fnwild=1;
               }
               else {
                    badch=1;
               }
          }
     }
     if ((namres=rsvnam(filkbf->name)) != 0) {
          return(0);
     }
     filkbf->name[i++]='.';
     for ( ; *ep ; ep++,i++) {
          if (strchr(sflchr,filkbf->name[i]=toupper(*ep)) == NULL) {
               if (*ep == '?' || *ep == '*') {
                    fnwild=1;
               }
               else {
                    badch=1;
               }
          }
     }
     if (badch) {
          fnwild=0;
     }
     return(!badch && !fnwild);
}

int
isfil(                                    /* Does the valid LIB\file exist? */
char status)                                 /* A(pproved) or U(napproved)  */

  /*   Cases:       ret val  siggvn    absbtv()  sigkbf->name  filkbf->name */
  /*   No such LIB     0       0L        ---      something        ---      */
  /*   No such file    0     LIB ptr     ---       LIB name     something   */
  /*   File exists     1     LIB ptr   file ptr    LIB name     file name   */

{
     if (siggvn == 0L) {
          if (!issig()) {
               return(0);
          }
          siggvn=absbtv();
     }
     getsig(siggvn);
     setbtv(filbb);
     filkbf->status=status;
     stzcpy(filkbf->sig,sigbuf->name,LIBNAM+1);
     return(qeqbtv(NULL,0));
}

void
astlib(void)    /* correct GALLIBS.DAT record for fields added after astoff */
{
#if LIBAST > 0
     char *cp;
     int n;

     if (sigbuf->astoff < LIBAST) {
          n=stranslen(cp=(&sigbuf->astoff)+1+sigbuf->astoff);
          movmem(cp,libans(sigbuf),n);
          setmem(cp,LIBAST-sigbuf->astoff,0);
          sigbuf->astoff=LIBAST;
     }
#endif
}

void
astfil(void)   /* correct GALFILES.DAT record for fields added after astoff */
{
#if FILAST > 0
     char *cp;
     int n;

     if (filbuf->astoff < FILAST) {
          n=stranslen(cp=(&filbuf->astoff)+1+filbuf->astoff);
          movmem(cp,filans(filbuf),n);
          setmem(cp,FILAST-filbuf->astoff,0);
          filbuf->astoff=FILAST;
     }
#endif
}

void
inslib(                                        /* insert GALLIBS.DAT record */
struct libdat *sigptr)
{
     if (sigptr == NULL) {
          sigptr=sigbuf;
     }
     setbtv(sigbb);
     invbtv(sigptr,LIBSIZ+stranslen(libans(sigptr)));
}

void
updlib(                                   /* update information about a LIB */
struct libdat *sigptr)
{
     if (sigptr == NULL) {
          sigptr=sigbuf;
     }
     setbtv(sigbb);
     upvbtv(sigptr,LIBSIZ+stranslen(libans(sigptr)));
}

void
insfil(                                       /* insert GALFILES.DAT record */
struct fildat *filptr)
{
     if (filptr == NULL) {
          filptr=filbuf;
     }
     setbtv(filbb);
     invbtv(filptr,FILSIZ+stranslen(filans(filptr)));
}

void
updfil(                                       /* update GALFILES.DAT record */
struct fildat *filptr)
{
     if (filptr == NULL) {
          filptr=filbuf;
     }
     setbtv(filbb);
     upvbtv(filptr,FILSIZ+stranslen(filans(filptr)));
}

char *
liblin(void)                              /* Short description line for LIB */
{                                               /* sigbuf is implicit input */
     return(fsdxan(libans(sigbuf),"S"));
}

char *
fillin(void)                             /* Short description line for FILE */
{                                               /* filbuf is implicit input */
     return(fsdxan(filans(filbuf),"S"));
}

int
kwdval(                                         /* Is this a valid keyword? */
char *keywrd)                                          /* modifies in place */
{
     char c;
     int n;

     strlwr(keywrd);
     for (n=0 ; (c=*keywrd++) != '\0' ; n++) {
          if (strchr(kwdchr,c) == NULL) {
               return(0);
          }
     }
     return(n <= KWDLEN);
}

STATIC void
rnfile(                                  /* Rename {T}emporary Library file */
long sigbpr,
char *oldnam,
char *newnam)
{
     char newpath[MAXPTH+1];         /* local buffer for path and file name */
     char *cp;

     unlink(cp=path(sigbpr,newnam));
     strcpy(newpath,cp);
     if (rename(cp=path(sigbpr,oldnam),newpath)) {
          catastro("ERROR RENAMING FILE \"%s\"",cp);
     }
     updfdt(sigbpr,newnam,0);
}

void
fmtkwd(char *keywrd)                             /* Create a keyword record */
{                     /* (filbuf is implicit input, kwdbuf implicit output) */
     strcpy(kwdbuf->sig,filbuf->sig);
     strcpy(kwdbuf->file,filbuf->name);
     stzcpy(kwdbuf->keywrd,keywrd,KWDLEN+1);
     strlwr(kwdbuf->keywrd);
}

int
autofs(                             /* How many auto files are in this LIB? */
long sigbpr,                                 /* btrieve pointer to LIB data */
char status)                                       /* File status to search */
{
     int i,n;

     getsig(sigbpr);
     stzcpy(filkbf->sig,sigbuf->name,LIBNAM+1);
     filkbf->status=status;
     setbtv(filbb);
     for (i=0,n=0 ; i < (sizeof(autonm)/sizeof(char *)) ; i++) {
          stzcpy(filkbf->name,autonm[i],FILNAM+1);
          n+=qeqbtv(NULL,0);
     }
     return(n);
}

int
isautf(             /* Is file name an automatically generated system file? */
char *name)
{
     int i;

     if (name != NULL) {
          for (i=0 ; i < (sizeof(autonm)/sizeof(char *)) ; i++) {
               if (sameas(name,autonm[i])) {
                    return(1);
               }
          }
     }
     return(0);
}

STATIC void
filprf(void)               /* write accumulated prf() strings to LIBS. file */
{
     fprintf(sglfp,"%s",prfbuf);
     clrprf();
}

void
sluhdr(void)                         /* put header for LIB list into prfbuf */
{
     static char sglhdr[]="\
LIBRARY INFORMATION BANKS\n\
=========================\n\
\n\
        LIB         Files   Description\n\
     ---------      -----   -----------\n\
";

     prf(sglhdr);
}

void
sgl1st(void)                               /* Regen LIB Listing:  first LIB */
{
     if (!filnam(mainsig,"LIBS.") || (!isfil('A') && !isfil('U'))) {
          crfsgl();
     }
     if ((sglfp=fopen(path(mainsig,"LIBS.{T}"),FOPWA)) == NULL) {
          catastro("UNABLE TO OPEN FOR WRITE MAIN\\LIBS.{T}");
     }
     sluhdr();
     filprf();
     gmnsig();
     sigbuf->sglptr=ftell(sglfp);
     updlib(NULL);
     slu1st();
     filprf();
}

int
sglnxt(void)                               /* Regen LIB Listing:  next LIB? */
{
     int rc=0;

     if (libptr->sigbpr != 0L) {
          gtgsig();
          sigbuf->sglptr=ftell(sglfp);
          updlib(NULL);
          slunxt((sigbuf->flags&OMTMAI) ? 0 : -1);
          filprf();
          rc=1;
     }
     else {
          slunxt(-1);
          filprf();
          gmnsig();
          sigbuf->sltptr=ftell(sglfp);
          updlib(NULL);
          slufin();
          filprf();
          fclose(sglfp);
     }
     return(rc);
}

int
sglfin(void)                                        /* Wind up the LIB List */
{
     if (reschk(mainsig,"LIBS.",FRDRES+FWTRES)) {
          return(0);
     }
     rnfile(mainsig,"LIBS.{T}","LIBS.");
     return(1);
}

STATIC void
slulin(                                      /* format one line of LIB list */
int pad)                                  /* 1=pad out line to fixed length */
{
     prf(pad ? "     %-9.9s%11s   %-40s\n"
             : "     %-9.9s%11s   %.40s\n",sigbuf->name,
                                           l2as(sigbuf->appfil),
                                           liblin());
}

void
slu1st(void)                                   /* begin formatting LIB list */
{
     gmnsig();
     slulin(1);
     libptr->lnum=sigbuf->appfil;
     libptr->lnum2=1L;
     setbtv(sigbb);
     qlobtv(0);
     if ((libptr->sigbpr=absbtv()) == mainsig) {
          libptr->sigbpr=qnxbtv() ? absbtv() : 0L;
     }
}

int
slunxt(                                     /* continue formatting LIB list */
int vis)       /* 1=output LIB info -1=blank-pad 0=just advance to next LIB */
{
     if (libptr->sigbpr != 0L) {
          getsig(libptr->sigbpr);
          if (vis) {
               slulin(vis == -1);
               libptr->lnum+=sigbuf->appfil;
               libptr->lnum2++;
          }
          setbtv(sigbb);
          while ((libptr->sigbpr=qnxbtv() ? absbtv() : 0L) == mainsig);
          return(1);
     }
     else {
          prf("                    -----\n");
          return(0);
     }
}

void
slufin(void)                                  /* finish formatting LIB list */
{
     prf("              %11s files\n",l2as(libptr->lnum));
     prf("              %11s LIB's\n",l2as(libptr->lnum2));
}

STATIC void
fldhdr(void)                               /* Header for the file directory */
{
     fprintf(lbnfp,"     File           Bytes  Source     Description\r\n");
     fprintf(lbnfp,"     ----           -----  ------     -----------\r\n");
}

STATIC void
fldlin(                                    /* write one line about the file */
int exist)                               /* 1=it exists, 0=has been deleted */
{
     if (exist) {
          fprintf(lbnfp,"     %-12.12s%8.8s  %-9.9s  %-40.40s\r\n",
                  filbuf->name,
                  l2as(filbuf->size),
                  fsdxan(filans(filbuf),"WHO"),
                  fillin());
     }
     else {
          fprintf(lbnfp,"     %-12.12s%21s------<REMOVED>------%19s\r\n",
                  filbuf->name,"","");
     }
}

int
fld1st(                               /* Regen File Directory:  get started */
long sigbpr)                       /* returns 1=ok 0=couldn't make the file */
{
     lbnsig=sigbpr;
     if (!filnam(lbnsig,"FILES.") || (!isfil('A') && !isfil('U'))) {
          if (lbnsig == mainsig) {
               crfflm();
          }
          else {
               crffli(lbnsig);
               fmtkwd(filbuf->name);
               setbtv(kwdbb);
               dinsbtv(NULL);
               updcnt(lbnsig,'A',1L,0L,0,1);
          }
     }
                                                     /* Open temporary file */
     if ((lbnfp=fopen(path(lbnsig,"FILES.{T}"),FOPWB)) == NULL) {
          return(0);
     }
     fprintf(lbnfp,"FILE DIRECTORY OF LIB %s   %s\r\n\r\n",sigbuf->name,liblin());
     fldhdr();
     filkbf->status='A';
     stzcpy(filkbf->sig,sigbuf->name,LIBNAM+1);
     setmem(filkbf->name,FILNAM+1,0);
     setbtv(filbb);                            /* Initiate scan of database */
     lbnfil=(qgebtv(NULL,0) && sameas(filkbf->sig,sigbuf->name)
                            && filkbf->status == 'A')  ?  absbtv() : 0L;
     lbncta=0L;
     lbnctb=0L;
     return(1);
}

int
fldnxt(void)                           /* Regen File Directory:  next file? */
{
     long peofch;

     getsig(lbnsig);
     if (lbnfil != 0L) {                    /* NEXT LINE OF FILE DIRECTORY: */
          getfil(lbnfil);
          filbuf->fldptr=ftell(lbnfp);
          filbuf->mfdptr=0L;
          updfil(NULL);
          fldlin(1);                                   /* One line per file */
          lbncta+=filbuf->size;
          lbnctb++;
          setbtv(filbb);
          lbnfil=(qnxbtv() && sameas(filkbf->sig,sigbuf->name)
                           && filkbf->status == 'A')  ?  absbtv() : 0L;
          return(1);
     }
     else {                                       /* END OF FILE DIRECTORY: */

          fprintf(lbnfp,"                    -----\r\n");
          fprintf(lbnfp,"              %11s bytes (approx)\r\n",l2as(lbncta));
          fprintf(lbnfp,"              %11s files\r\n\r\n",l2as(lbnctb));
          peofch=ftell(lbnfp);
          fclose(lbnfp);
          lbnfp=NULL;
          getsig(lbnsig);
          if (lbnsig == mainsig) {     /* Remember end of the list of files */
               sigbuf->mfdptr=peofch;  /* of the main LIB, in MAIN\FILES.   */
          }
          sigbuf->flags&=~FLDEXT;    /* File directory no longer "extended" */
          updlib(NULL);
          return(0);
     }
}

int
fldfin(void)                                  /* Wind up the file directory */
{
     if (reschk(lbnsig,"FILES.",FRDRES+FWTRES)) {
          return(0);
     }
     rnfile(lbnsig,"FILES.{T}","FILES.");
     if (filnam(lbnsig,"FILES.") && isfil('A')) {
          updfld1(lbnsig,absbtv(),1,0);
     }
     return(1);
}

void
ufd1st(                            /* Auto-cleanup scan of unapproved files */
long sigbpr)                                 /* Btrieve pointer to LIB data */
{
     getsig(lbnsig=sigbpr);
     filkbf->status='U';
     stzcpy(filkbf->sig,sigbuf->name,LIBNAM+1);
     setmem(filkbf->name,FILNAM+1,0);
     setbtv(filbb);                    /* Initiate scan of unapproved files */
     lbnfil=(qgebtv(NULL,0) && sameas(filkbf->sig,sigbuf->name)
                            && filkbf->status == 'U')  ?  absbtv() : 0L;
}

int
ufdnxt(void)      /* set fldbpr and mfdptr fields of unapproved files to 0L */
{                 /* for files that were unapproved using UNAPPROVE command */
     if (lbnfil != 0L) {
          getfil(lbnfil);
          if (filbuf->fldptr != 0L || filbuf->mfdptr != 0L) {
               filbuf->fldptr=0L;
               filbuf->mfdptr=0L;
               updfil(NULL);
          }
          lbnfil=(qnxbtv() && sameas(filkbf->sig,sigbuf->name)
                           && filkbf->status == 'U')  ?  absbtv() : 0L;
          return(1);
     }
     else {
          return(0);
     }
}

STATIC void
mfdeln(              /* write an extended line in the master file directory */
int exist)                               /* 1=it exists, 0=has been deleted */
{
     if (exist) {
          fprintf(lbnfp,"%-8.8s %-12.12s%8.8s  %-9.9s %-38.38s\r\n",
                  filbuf->sig,
                  filbuf->name,
                  l2as(filbuf->size),
                  fsdxan(filans(filbuf),"WHO"),
                  fillin());
     }
     else {
          fprintf(lbnfp,"%-8.8s %-12.12s%20s------<REMOVED>------%17s\r\n",
                  filbuf->sig,filbuf->name,"","");
     }
}

STATIC void
poseof(            /* position the file at the EOF ('\x1A' or physical EOF) */
FILE *fp)                                            /* fopen() file handle */
{

     if (fseek(fp,-1L,2) == 0 && getc(fp) == '\x1A') {
          fseek(fp,-1L,2);
     }
     else {
          fseek(fp,0L,2);          /* (required due to "bug" in fseek/getc) */
     }
}

void
updfld(                      /* Update info about file in file directory(s) */
long sigbpr,                                 /* Btrieve pointer to LIB data */
long filbpr,                                /* Btrieve pointer to file data */
int exist)                            /* 1=file exists 0=file being deleted */
{
     int addlin;            /* need we add a line to the file directory(s)? */
     long lp;

     getfil(filbpr);
     addlin=filbuf->fldptr == 0L;
     if (sigbpr == mainsig) {
          addlin=(addlin && filbuf->mfdptr == 0L);
     }
     else if ((lbnfp=fopen(path(sigbpr,"FILES."),FOPRB)) != NULL) {
          fclose(lbnfp);
          updfld1(sigbpr,filbpr,exist,addlin);
     }
     getsig(sigbpr);
     if (!(sigbuf->flags&OMTMAI)
      && (lbnfp=fopen(path(mainsig,"FILES."),FOPRWB)) != NULL) {
          if (addlin) {               /* Make a new line in master file dir */
               poseof(lbnfp);
               getsig(mainsig);
               if (!(sigbuf->flags&FLDEXT)) {        /* Header needed also? */
                    fprintf(lbnfp,"\r\n\r\n\r\nLATEST ADDITIONS\r\n----------------\r\n\r\n");
                    fprintf(lbnfp,"LIB      File           Bytes  Source    Description\r\n");
                    fprintf(lbnfp,"---      ----           -----  ------    -----------\r\n");
                    sigbuf->flags|=FLDEXT;
                    updlib(NULL);
               }
               getfil(filbpr);
               filbuf->mfdptr=ftell(lbnfp);
               updfil(NULL);
               mfdeln(exist);
          }
          else if (filbuf->mfdptr != 0L) {          /* Update extended line */
               fseek(lbnfp,filbuf->mfdptr,0);       /* in master file dir   */
               mfdeln(exist);
          }
          else {                 /* Update existing line in master file dir */
               getsig(sigbpr);
               lp=filbuf->fldptr;
               if (sigbpr != mainsig) {
                    lp+=sigbuf->mfdptr;
               }
               fseek(lbnfp,lp,0);
               fldlin(exist);
          }
          fclose(lbnfp);
     }
}

void
updfld1(                            /* Update entry in LOCAL file directory */
long sigbpr,                                 /* Btrieve pointer to LIB data */
long filbpr,                                /* Btrieve pointer to file data */
int exist,                            /* 1=file exists 0=file being deleted */
int addlin)         /* 1=add line to file directory, 0=update existing line */
{
     if ((lbnfp=fopen(path(sigbpr,"FILES."),FOPRWB)) != NULL) {
          if (addlin) {                 /* Make a new line in file dir */
               poseof(lbnfp);
               getsig(sigbpr);
               if (!(sigbuf->flags&FLDEXT)) {   /* Header needed also? */
                    fprintf(lbnfp,"\r\n\r\n\r\nLATEST ADDITIONS\r\n----------------\r\n\r\n");
                    fldhdr();
                    sigbuf->flags|=FLDEXT;
                    updlib(NULL);
               }
               getfil(filbpr);
               filbuf->fldptr=ftell(lbnfp);
               updfil(NULL);
               fldlin(exist);
          }
          else {                   /* Update existing line in file dir */
               fseek(lbnfp,filbuf->fldptr,0);
               fldlin(exist);
          }
          fclose(lbnfp);
     }
}

void
mfd1st(void)                           /* Prepare for master file directory */
{
     char buff[MAXPTH+1];

     if (!filnam(mainsig,"FILES.") || (!isfil('A') && !isfil('U'))) {
          mfdtsk=MFNULL;           /* No MAIN\FILES. in Library ==> no work */
          return;
     }
     setbtv(sigbb);
     if (!qlobtv(0) || absbtv() == mainsig && !qnxbtv()) {
          lbnsig=0L;                                   /* Only the Main LIB */
     }
     else {
          lbnsig=absbtv();                   /* Note the first non-main LIB */
     }
     strcpy(buff,path(mainsig,"FILES."));
     if (!cpy1st(buff,path(mainsig,"FILES.{T}"),0)) {
          mfdtsk=MFNULL;                   /* Cannot open files ==> no work */
          return;
     }
     gmnsig();
     lbncta=sigbuf->mfdptr;            /* copy no more than this many bytes */
     mfdtsk=CPMAIN;                                     /* from MAIN\FILES. */
}

int
mfdnxt(void)     /* Concatenate all file directories to main file directory */
{
     switch (mfdtsk) {

     case CPMAIN:    /* Copy (existing) Main file directory, up to "mfdptr" */
          if (lbncta <= cpyblk) {           /* copy last bit of MAIN\FILES. */
               cpynxt((int)lbncta);
               if (lbnfp != NULL) {
                    fclose(lbnfp);
                    lbnfp=NULL;
               }
          }
          else if (cpynxt(cpyblk)) {      /* copy next block of MAIN\FILES. */
               lbncta-=cpyblk;
               break;
          }
          if (lbnsig == 0L) {
               mfdtsk=MFDONE;
          }
          else {
               getsig(lbnsig);                  /* done copying MAIN\FILES. */
               mfdtsk=(sigbuf->flags&OMTMAI) ? ADVLIB : OPNLIB;
          }
          break;

     case ADVLIB:            /* Find the next LIB (that's not the Main LIB) */
          getsig(lbnsig);
          if (qnxbtv()) {
               getsig(lbnsig=absbtv());
               if (lbnsig != mainsig && !(sigbuf->flags&OMTMAI)) {
                    mfdtsk=OPNLIB;
               }
          }
          else {
               mfdtsk=MFDONE;
          }
          break;

     case OPNLIB:               /* Open the file directory for the next LIB */
          getsig(lbnsig);                        /* Remember where the file */
          sigbuf->mfdptr=ftell(lbnfp2);          /* directory for this LIB  */
          updlib(NULL);                          /* begins in MAIN\FILES.   */
          mfdtsk=cpysrc(path(lbnsig,"FILES.")) ? CPYMFD : ADVLIB;
          break;

     case CPYMFD:                           /* Copy block of file directory */
          if (!cpynxt(cpyblk)) {
               mfdtsk=ADVLIB;
          }
          break;

     case MFDONE:                             /* Write EOF and close output */
          cpyfin();
          return(0);

     case MFNULL:                                   /* No work for mfdnxt() */
          return(0);
     }
     return(1);
}

void
mfdfin(void)                           /* Wind up the master file directory */
{
     rnfile(mainsig,"FILES.{T}","FILES.");
}

STATIC void
shokwd(void)                              /* Format keyword for the indexes */
{
     if (kwdbuf->keywrd[0] == ' ') {
          fprintf(lbnfp," %s  %-5.5s",
                  ncdate(datofc(atoi(kwdbuf->keywrd+1))),kwdbuf->keywrd+7);
     }
     else {
          fprintf(lbnfp,"%-16s",kwdbuf->keywrd);
     }
}

STATIC void
indhdr(void)                     /* Write the next page header to the Index */
{
     fprintf(lbnfp,"\r\n\r\nINDEX FOR LIB %s   %-40s  Page %d\r\n\r\n",
             sigbuf->name,liblin(),(int)lbnctb);
     fprintf(lbnfp,"    Keyword         Filename              Description\r\n");
     fprintf(lbnfp,"----------------  ------------  -------------------------------\r\n");
}

int
ind1st(                                        /* Regen Index:  get started */
long sigbpr)
{

     lbnsig=sigbpr;
     if (!filnam(lbnsig,"INDEX.") || (!isfil('A') && !isfil('U'))) {
          crsfil(lbnsig,"INDEX.",FDIANS,'A');
     }
     if ((lbnfp=fopen(path(lbnsig,"INDEX."),FOPWB)) == NULL) {
          return(0);
     }
     lbnctb=1;
     indhdr();
     lbncta=0;
     getsig(lbnsig);
     setbtv(kwdbb);                            /* Initiate scan of keywords */
     lbnkwd=(qgebtv(sigbuf->name,KKILIB)
             && sameas(kkikbf->sig,sigbuf->name)) ? absbtv() : 0L;
     return(1);
}

int
indnxt(void)                                 /* Regen Index:  next keyword? */
{
     char *cp;

     getsig(lbnsig);
     if (lbnkwd != 0L) {                             /* NEXT LINE OF INDEX: */
          setbtv(kwdbb);
          gabbtv(NULL,lbnkwd,KKILIB);
          filkbf->status='A';
          strcpy(filkbf->sig,kwdbuf->sig);
          strcpy(filkbf->name,kwdbuf->file);
          setbtv(filbb);
          if (!qeqbtv(NULL,0)) {
               cp="";
          }
          else {
               getfil(absbtv());
               cp=fillin();
          }
          if (strchr(kwdbuf->keywrd,'.')) {
               strupr(kwdbuf->keywrd);
          }
          if (lbncta >= 50) {
               lbnctb++;
               indhdr();
               lbncta=0;
          }
          shokwd();
          fprintf(lbnfp,"  %-12s  %s\r\n",kwdbuf->file,cp);
          lbncta++;
          setbtv(kwdbb);
          lbnkwd=(qnxbtv() && sameas(kkikbf->sig,sigbuf->name)) ? absbtv() : 0L;
          return(1);
     }
     else {                                                /* END OF INDEX: */
          fclose(lbnfp);
          lbnfp=NULL;
          return(0);
     }
}

STATIC void
mindhdr(void)             /* Write the next page header to the master index */
{
     fprintf(lbnfp,"\r\n\r\nMASTER INDEX FOR THE LIBRARY                                    Page %d\r\n\r\n",(int)lbnctb);
     fprintf(lbnfp,"    Keyword        LIB      Filename             Description          \r\n");
     fprintf(lbnfp,"---------------- -------- ------------ -------------------------------\r\n");
}

int
mind1st(void)                           /* Regen Master Index:  get started */
{
     if (!filnam(mainsig,"INDEX.") || (!isfil('A') && !isfil('U'))) {
          crsfil(mainsig,"INDEX.",FDMIANS,'A');
     }                                               /* Open temporary file */
     if ((lbnfp=fopen(path(mainsig,"INDEX."),FOPWB)) == NULL) {
          return(0);
     }
     lbnctb=1;
     mindhdr();
     lbncta=0;
     setbtv(kwdbb);                            /* Initiate scan of keywords */
     lbnkwd=qlobtv(KKLIBW) ? absbtv() : 0L;
     return(1);
}

int
mindnxt(void)                         /* Regen Master Index:  next keyword? */
{
     char *cp;
     char hide;

     if (lbnkwd != 0L) {                             /* NEXT LINE OF INDEX: */
          setbtv(kwdbb);
          gabbtv(NULL,lbnkwd,KKLIBW);
          if (signam(kwdbuf->sig) && issig()) {
               getsig(absbtv());
               hide=((sigbuf->flags&OMTMAI) != 0);
          }
          else {
               hide=0;
          }
          if (!hide) {
               filkbf->status='A';
               strcpy(filkbf->sig,kwdbuf->sig);
               strcpy(filkbf->name,kwdbuf->file);
               setbtv(filbb);
               if (!qeqbtv(NULL,0)) {
                    cp="";
               }
               else {
                    getfil(absbtv());
                    cp=fillin();
               }
               if (strchr(kwdbuf->keywrd,'.')) {
                    strupr(kwdbuf->keywrd);
               }
               if (lbncta >= 50) {
                    lbnctb++;
                    mindhdr();
                    lbncta=0;
               }
               shokwd();
               fprintf(lbnfp," %-8s %-12s %s\r\n",
                       kwdbuf->sig,kwdbuf->file,cp);
               lbncta++;
          }
          setbtv(kwdbb);
          lbnkwd=qnxbtv() ? absbtv() : 0L;
          return(1);
     }
     else {                                         /* END OF MASTER INDEX: */
          fclose(lbnfp);
          lbnfp=NULL;
          return(0);
     }
}

void
tfl1st(                                   /* Prepare to generate "TOPFILES" */
long (*tblptr)[2])
{
     if (tblptr != NULL) {
          setmem(tblptr,sizeof(*tblptr)*topfil,0);
     }
}

void
tflnxt(           /* Gen "TOPFILES" table, called for successive candidates */
long (*tblptr)[2])
{               /* filbuf implicit input, as are setbtv(filbb) and absbtv() */
     int i,n;

     if (tblptr == NULL) {
          return;
     }
     if (filbuf->numdld <= tblptr[topfil-1][1]) {
          return; /* reject rarely-downloaded and prefer earlier candidates */
     }
     if (isautf(filbuf->name)) {
          return;            /* reject automatically-generated system files */
     }
     for (i=0 ; i < topfil && tblptr[i][0] != 0L ; i++) {
          if (filbuf->numdld > tblptr[i][1]) {
               n=topfil-i-1;
               if (n > 0) {
                    movmem(&tblptr[i][0],&tblptr[i+1][0],n*sizeof(*tblptr));
               }
               break;
          }
     }
     if (i < topfil) {
          tblptr[i][0]=absbtv();
          tblptr[i][1]=filbuf->numdld;
     }
}

void
tflfin(                            /* Generate "TOPFILES" from tblptr table */
long (*tblptr)[2],
long sigbpr)                        /* put list in this LIB's TOPFILES file */
{
     FILE *fp;
     int i;
     static char mtflttl[]="\
TOP %u DOWNLOADS FROM THE ENTIRE LIBRARY, AS OF %-5.5s %s\r\n\
\r\n\
                        Number of\r\n\
  LIB      File Name    downloads                Description\r\n\
--------  ------------  ---------  ----------------------------------------\r\n\
";
     static char tflttl[]="\
TOP %u DOWNLOADS FROM THE %s LIB, AS OF %-5.5s %s\r\n\
\r\n\
                        Number of\r\n\
 File Name     Bytes    downloads                Description\r\n\
------------  --------  ---------  ----------------------------------------\r\n\
";
     static char mtflimg[]="%-8.8s  %-12.12s %7ld     %s\r\n";
     static char tflimg[]="%-12.12s%10ld %7ld     %s\r\n";

     if (tblptr == NULL) {
          return;
     }
     if ((fp=fopen(path(sigbpr,"TOPFILES."),FOPWB)) == NULL) {
          return;
     }
     if (sigbpr == mainsig) {
          fprintf(fp,mtflttl,topfil,nctime(now()),ncdate(today()));
     }
     else {
          getsig(sigbpr);
          fprintf(fp,tflttl,topfil,sigbuf->name,nctime(now()),ncdate(today()));
     }
     for (i=0 ; i < topfil && tblptr[i][0] != 0L ; i++) {
          getfil(tblptr[i][0]);
          if (sigbpr == mainsig) {
               fprintf(fp,mtflimg,
                       filbuf->sig,filbuf->name,filbuf->numdld,fillin());
          }
          else {
               fprintf(fp,tflimg,
                       filbuf->name,filbuf->size,filbuf->numdld,fillin());
          }
     }
     if (tblptr[0][0] == 0L) {
          fprintf(fp,"\r\n--- NO DOWNLOADS YET ---\r\n");
     }
     fclose(fp);
     filnam(sigbpr,"TOPFILES.");
     if (!isfil('A') && !isfil('U')) {
          crftfl(sigbpr);
     }
     updfdt(sigbpr,"TOPFILES.",100);
}

STATIC void
filscn(void)                              /* Scan files for midnite cleanup */
{
     char oldsig[LIBNAM+1];
     char newsig[LIBNAM+1];
     int more;
     long filbpr;
     int dosonl;

     tfl1st(mtftab);
     setbtv(filbb);
     if (qlobtv(0)) {
          filbpr=absbtv();
          appbyt=appfil=uapbyt=uapfil=0L;
          stzcpy(oldsig,filkbf->sig,LIBNAM+1);
          setbtv(sigbb);
          dosonl=acqbtv(NULL,filkbf->sig,0) && (sigbuf->flags&DOSONL);
                /* if dosonl, leftover files and keywords may remain anyway */
                       /* but this can only happen from misuse of option 27 */
          if (!dosonl && !sameas(oldsig,"MAIN")) {
               tfl1st(tftabl);
          }
          do {                             /* scan all files in all LIBs... */
               getfil(filbpr);
               if (!dosonl) {
                    if (filbuf->status == 'A') {
                         appbyt+=filbuf->size;
                         appfil++;
                         if (!sameas(oldsig,"MAIN")) {
                              tflnxt(tftabl);
                         }
                         if (!(sigbuf->flags&OMTMAI)) {
                              tflnxt(mtftab);
                         }
                    }
                    else if (filbuf->status == 'U') {
                         uapbyt+=filbuf->size;
                         uapfil++;
                    }
               }
               more=qnxbtv();
               stzcpy(newsig,filkbf->sig,LIBNAM+1);
               filbpr=absbtv();
               if (!more || !sameas(newsig,oldsig)) {
                    setbtv(sigbb);                       /* wind up old LIB */
                    if (qeqbtv(oldsig,0)) {
                         getsig(absbtv());
                         sigbuf->appbyt+=appbyt;
                         sigbuf->appfil+=appfil;
                         sigbuf->uapbyt+=uapbyt;
                         sigbuf->uapfil+=uapfil;
                         updlib(NULL);
                         if (!dosonl && absbtv() != mainsig && appfil > 0L) {
                              tflfin(tftabl,absbtv());
                         }
                    }
                    apptot+=appfil;
                    uaptot+=uapfil;
                    appbyt=appfil=uapbyt=uapfil=0L;
                    if (more) {                      /* prepare for new LIB */
                         stzcpy(oldsig,newsig,LIBNAM+1);
                         setbtv(sigbb);
                         dosonl=acqbtv(NULL,newsig,0) && (sigbuf->flags&DOSONL);
                         if (!dosonl && absbtv() != mainsig) {
                              tfl1st(tftabl);
                         }
                    }
               }
          }
          while (more);
          tflfin(mtftab,mainsig);
     }
}

STATIC void
sigscn(void)                              /* Scan LIB's for midnite cleanup */
{
     long sigbpr;

     setbtv(sigbb);
     if (qlobtv(0)) {
          do {
               getsig(sigbpr=absbtv());
               if (sigbuf->flags&DOSONL) {      /* DOS-only: forget uploads */
                    setmem(sigbuf->upday,sizeof(sigbuf->upday),0);
                    cntdir(path(sigbpr,"*.*"));
                    sigbuf->appfil=numfils;
                    sigbuf->appbyt=numbyts;
                    apptot+=numfils;
               }
               else {              /* normal: advance daily upload counters */
                    movmem(sigbuf->upday,
                           sigbuf->upday+1,6*sizeof(unsigned char));
                    sigbuf->upday[0]=0;
               }
               updlib(NULL);
               if (sigbpr != mainsig
                && (sigbuf->flags&(NEWIDX+NOIDX+DOSONL)) == NEWIDX) {
                    if (ind1st(sigbpr)) {
                         while (indnxt()) {              /* regen LIB index */
                         }
                    }
               }
               getsig(sigbpr);
               if ((sigbuf->flags&(NEWIDX+DOSONL)) == NEWIDX) {
                    if (fld1st(sigbpr)) {
                         while (fldnxt()) {               /* regen file dir */
                         }
                         fldfin();
                    }
                    ufd1st(sigbpr);
                    while (ufdnxt()) {                  /* scan unapp files */
                    }
               }
               if (sigbpr != mainsig && sigbuf->flags&NEWIDX) {
                    getsig(sigbpr);
                    sigbuf->flags&=~NEWIDX;
                    updlib(NULL);
               }
               getsig(sigbpr);
          }
          while (qnxbtv());
     }
}

void
libcup(void)                            /* Library-specific midnite cleanup */
{
     if (!libcln) {
          return;
     }
     setmbk(libmb);
     setbtv(sigbb);
     if (qlobtv(0)) {
          do {
               getsig(absbtv());
               sigbuf->appbyt=0L;
               sigbuf->appfil=0L;
               sigbuf->uapbyt=0L;
               sigbuf->uapfil=0L;
               updlib(NULL);
          }
          while (qnxbtv());
     }
     apptot=uaptot=0L;

     filscn();

     sigscn();

     gmnsig();
     sigbuf->apptot=apptot;
     sigbuf->uaptot=uaptot;
     updlib(NULL);

     gmnsig();
     if ((sigbuf->flags&(NEWIDX+NOIDX)) == NEWIDX) {
          sigbuf->flags&=~NEWIDX;
          updlib(NULL);
          if (mind1st()) {
               while(mindnxt()) {
               }
          }
     }
     for (sgl1st() ; sglnxt() ;) {
     }
     sglfin();
     if (fld1st(mainsig)) {
          while (fldnxt()) {
          }
          fldfin();
     }
     for (mfd1st() ; mfdnxt() ;) {
     }
     mfdfin();
     updsgl(mainsig);
}

char *
path(                                             /* Create a DOS path spec */
long sigbpr,                                                 /* LIB pointer */
char *fname)                /* file name (NULL if you just want the prefix) */
{
     static char path[MAXPTH+1];
     char *cp;

     path[0]='\0';
     if (sigbpr != 0L) {
          getsig(sigbpr);
          if (*(cp=fsdxan(libans(sigbuf),"PREFIX")) == '\0'
           || sigbuf->flags&RDONLY && isautf(fname)) {
               strcpy(path,sigbuf->name);
               strcat(path,"\\");
          }
          else {
               stzcpy(path,cp,MAXPPF+1);
          }
     }
     if (fname != NULL) {
          strcat(path,fname);
     }
     return(path);
}

int
updfdt(                           /* update file data if date/time/size chg */
long sigbpr,                                                 /* LIB pointer */
char *fname,                                                   /* file name */
int mindsz)   /* minimum delta-size to retrigger INDEX & FILES regeneration */
                                             /* or -1 to force regeneration */
     /* Return codes:                                                       */
     /* 0 if the file is not found on disk (nothing is done about it)       */
     /* 0 if the file is not found on database (also nothing done)          */
     /* 1 if the file is on disk and in database (a few fields are updated) */
{
     long dsize;
     int dupl;
     struct fndblk fb;
     char buff[KWDLEN+1];
     long filbpr;

     if (!fnd1st(&fb,path(sigbpr,fname),0)) {
          return(0);
     }
     stzcpy(filkbf->sig,sigbuf->name,LIBNAM+1);
     stzcpy(filkbf->name,fname,FILNAM+1);
     setbtv(filbb);
     if ((filkbf->status='A',!qeqbtv(NULL,0)) &&
         (filkbf->status='U',!qeqbtv(NULL,0))) {
           return(0);
     }
     getfil(filbpr=absbtv());
     dsize=fb.size-filbuf->size;
     dupl=fb.date > filbuf->date ||
          fb.date == filbuf->date && fb.time > filbuf->time;
     if (dsize > mindsz
      || dsize < -mindsz
      || dupl && !sameas(fname,"TOPFILES.")) {
          if (filbuf->status == 'A' && !isautf(filbuf->name)) {
               enckdt(buff,filbuf->date,filbuf->time);
               kwddel(buff,0);
          }
          getfil(filbpr);
          filbuf->size=fb.size;
          filbuf->date=today();
          filbuf->time=now();
          updfil(NULL);
          if (filbuf->status == 'A' && !isautf(filbuf->name)) {
               enckdt(buff,filbuf->date,filbuf->time);
               kwdins(buff,0);
          }
          updcnt(sigbpr,filbuf->status,0L,dsize,0,filbuf->status == 'A');
     }
     return(1);
}

STATIC void
cskfil(                              /* create skeleton of a Major BBS file */
long sigbpr,                                                 /* LIB pointer */
char *fname,                                                   /* file name */
char stat)                                                    /* A(pproved) */
                                                            /* U(napproved) */
              /* ends with data in filbuf record, prepared for insbtv(NULL) */
{
     getsig(sigbpr);
     setmem(filbuf,FILSIZ,0);
     filbuf->status=stat;
     strcpy(filbuf->sig,sigbuf->name);
     strcpy(filbuf->name,fname);
     filbuf->date=today();
     filbuf->time=now();
     setbtv(filbb);
}

void
enckdt(               /* Encode kwd date&time in format:  " CCCCC HH:MM:SS" */
char *cp,                 /* where CCCCC is the number of days since 1/1/80 */
unsigned dat,
unsigned tim)
{
     sprintf(cp," %5u %s",cofdat(dat),nctime(tim));
}

int
deckdt(                                              /* Decode keyword date */
char *cp)
{
     return(datofc(atoi(cp+1)));
}

void
fmtkdt(void)          /* Create the keyword that has the file's date & time */
{                                             /* (filbuf is implicit input) */
     strcpy(kwdbuf->sig,filbuf->sig);
     strcpy(kwdbuf->file,filbuf->name);
     setmem(kwdbuf->keywrd,KWDLEN+1,0);
     enckdt(kwdbuf->keywrd,filbuf->date,filbuf->time);
}

int
kwdins(                          /* insert a keyword, check for duplication */
char *kwd,                                          /* returns 1 if no dups */
int explain)                              /* 1=if problem, tell us about it */
{                                               /* filbuf is implicit input */
     int good;

     fmtkwd(kwd);
     setbtv(kwdbb);
     if ((good=!qeqbtv(kwdbuf,KKLIBW)) != 0) {
          fmtkwd(kwd);
          insbtv(NULL);
     }
     else if (explain) {
          prfmsg(KINSBAD,kwdbuf->keywrd);
     }
     return(good);
}

int
kwddel(          /* delete a keyword, with checking to make sure it's there */
char *kwd,                                             /* returns 1=deleted */
int explain)                              /* 1=if problem, tell us about it */
{                                               /* filbuf is implicit input */
     int good;

     fmtkwd(kwd);
     setbtv(kwdbb);
     if ((good=qeqbtv(kwdbuf,KKLIBW)) != 0) {
          gcrbtv(NULL,KKLIBW);
          delbtv();
     }
     else if (explain) {
          prfmsg(KDELBAD,kkwkbf->keywrd);
     }
     return(good);
}

int
kwdupd(                              /* PREPARE keyword record for updating */
char *kwd,      /* returns 1=present, needs update  0=missing, needs insert */
int explain)                              /* 1=if problem, tell us about it */
{                                               /* filbuf is implicit input */
     int good;

     fmtkwd(kwd);
     setbtv(kwdbb);
     if ((good=qeqbtv(kwdbuf,KKLIBW)) != 0) {
          gcrbtv(NULL,KKLIBW);
          /* caller should modify kwdbuf fields and updbtv() */
     }
     else {
          if (explain) {
               prfmsg(KUPDBAD,kkwkbf->keywrd);
          }
          fmtkwd(kwd);
          /* caller should modify kwdbuf fields and insbtv() */
     }
     return(good);
}

char *
nxtkwd(                          /* extract next keyword from answer string */
struct fildat *filptr)         /* pointer to file & answer string structure */
                                      /* libptr->ind is keyword number 0..9 */
{
     return(fsdxan(filans(filptr),spr("K%d",libptr->ind)));
}

void
crfsgl(void)                       /* Create the LIB list file "MAIN\LIBS." */
{
     crsfil(mainsig,"LIBS.",FDLANS,'A');
}

void
crfflm(void)                /* Create the main File directory "MAIN\FILES." */
{
     crsfil(mainsig,"FILES.",FDMFANS,'A');
}

STATIC void
fmtans(ansbuf,msg,p1,p2,p3)  /* format an initial LIB or File answer string */
char *ansbuf;
int msg;
long p1,p2,p3;
{
     char c;

     sprintf(ansbuf,getmsg(msg),p1,p2,p3);
     while ((c=*ansbuf) != '\0') {
          if (c == '\r' || c == '\n') {
               *ansbuf='\0';
          }
          ansbuf++;
     }
}

void
crffli(                               /* Create the File directory "FILES." */
long sigbpr)                                                   /* what LIB? */
{
     cskfil(sigbpr,"FILES.",'A');
     fmtans(filans(filbuf),FDFANS,sigbuf->name,sigbuf->name);
     insfil(NULL);
}

void
crftfl(                                      /* Create the "TOPFILES." file */
long sigbpr)
{
     crsfil(sigbpr,"TOPFILES.",sigbpr == mainsig ? FDMTANS : FDTANS,'A');
}

STATIC void
crsfil(                                               /* Create system file */
long sigbpr,                                                         /* LIB */
char *fname,                                                   /* File name */
int msg,                             /* Message id of description paragraph */
char status)                                  /* A(pproved) or U(napproved) */
{
     cskfil(sigbpr,fname,status);
     fmtans(filans(filbuf),msg,sigbuf->name,sigbuf->name);
     insfil(NULL);
     fmtkwd(filbuf->name);                      /* create file name keyword */
     setbtv(kwdbb);
     dinsbtv(NULL);
     updcnt(sigbpr,status,1L,0L,0,1); /* update file counts in LIB database */
}

void
cmnsig(void)                                         /* Create the MAIN LIB */
{
     setmem(sigbuf,LIBSIZ,0);
     strcpy(sigbuf->name,"MAIN");
     stzcpy(sigbuf->libop,"Sysop",UIDSIZ);
     sigbuf->maxbyt=1000000L;
     sigbuf->maxbup=200000L;
     sigbuf->maxfil=1000L;
     sigbuf->flags=NEWIDX+NOIDX;
     sigbuf->credat=today();
     sigbuf->cretim=now();
     fmtans(libans(sigbuf),SDMANS);
     setbtv(sigbb);
     inslib(NULL);
}

void
updcnt(                                          /* Update file/byte counts */
long sigbpr,                            /* LIB pointer                      */
char stat,      /* 'A' means add deltas to approved counters                */
                /* 'U' means add deltas to unapproved counters              */
                /* 'a' means transfer deltas from unapproved to approved    */
                /* 'u' means transfer deltas from approved to unapproved    */
long dfiles,                            /* change in number of files        */
long dsize,                             /* change in number of bytes        */
int dupl,                               /* change in number of uploads today*/
int didx)                               /* will index change?               */
{
     long dtota=0L,dtotu=0L;

     getsig(sigbpr);
     switch (stat) {

     case 'a':
          sigbuf->uapfil-=dfiles;
          sigbuf->uapbyt-=dsize;
          dtotu=-dfiles;
     case 'A':
          sigbuf->appfil+=dfiles;
          sigbuf->appbyt+=dsize;
          dtota=dfiles;
          break;

     case 'u':
          sigbuf->appfil-=dfiles;
          sigbuf->appbyt-=dsize;
          dtota=-dfiles;
     case 'U':
          sigbuf->uapfil+=dfiles;
          sigbuf->uapbyt+=dsize;
          dtotu=dfiles;
          break;
     }
     sigbuf->upday[0]=min(sigbuf->upday[0]+dupl,255);

     if (dtota || dtotu || dupl || didx) {
          if (sigbpr != mainsig) {
               if (didx) {
                    sigbuf->flags|=NEWIDX;
               }
               updlib(NULL);
               gmnsig();
               sigbuf->upday[0]=min(sigbuf->upday[0]+dupl,255);
          }
          sigbuf->apptot+=dtota;
          sigbuf->uaptot+=dtotu;
          if (didx) {
               sigbuf->flags|=NEWIDX;
          }
     }
     updlib(NULL);
}

int
updsgl(            /* Update LIB data in LIB list text file, incl LIB name, */
                   /* number of approved files, description, and total.     */
long sigbpr)       /* pointer to LIB whose file count or descr has changed. */
{                  /* Does nothing (returns 0) iff "LIBS." file dont exist. */
     FILE *fp;
     long filbpr;

     getsig(sigbpr);
     if ((sigbuf->flags&OMTMAI)
      || !filnam(mainsig,"LIBS.")
      || (!isfil('A') && !isfil('U'))) {
          return(0);
     }
     filbpr=absbtv();
     if ((fp=fopen(path(mainsig,"LIBS."),FOPRWB)) == NULL) {
          catastro("UNABLE TO OPEN FOR UPDATE MAIN\\LIBS.");
     }
     getsig(sigbpr);
     if (fseek(fp,sigbuf->sglptr,0) != 0) {
          catastro("UNABLE TO SEEK LINE OF MAIN\\LIBS AT OFFSET %s",
                   l2as(sigbuf->sglptr));
     }
     fprintf(fp,"     %-9.9s%11.11s   %-40.40s",sigbuf->name,
             l2as(sigbuf->appfil),liblin());
     gmnsig();
     if (fseek(fp,sigbuf->sltptr+14L,0) != 0) {
          catastro("UNABLE TO SEEK FILE TOTAL IN MAIN\\LIBS AT OFFSET %s",
                   l2as(sigbuf->sltptr+14L));
     }
     fprintf(fp,"%11.11s",l2as(sigbuf->apptot));
     fclose(fp);
     getfil(filbpr);
     filbuf->date=today();
     filbuf->time=now();
     updfil(NULL);
     return(1);
}

int
sft1st(                                 /* Get first file in the target LIB */
char status)                      /* of the A(pproved) or U(napproved) list */
{                      /* libptr->filbpr returned pointing to file (if any) */
     gtgsig();
     setmem(filkbf,FILKSZ,0);
     filkbf->status=status;
     strcpy(filkbf->sig,sigbuf->name);
     setbtv(filbb);
     if (qgebtv(NULL,0)
         && filkbf->status == status
         && sameas(filkbf->sig,sigbuf->name)) {
          libptr->filbpr=absbtv();
          return(1);
     }
     libptr->filbpr=0L;
     return(0);
}

int
sftnxt(                                  /* Get next file in the target LIB */
char status)                      /* of the A(pproved) or U(napproved) list */
{                 /* libptr->filbpr returned pointing to file (if any more) */
     if (libptr->filbpr == 0L) {
          return(0);
     }
     gtgsig();
     gtgfil();
     if (qnxbtv() && filkbf->status == status
         && sameas(filkbf->sig,sigbuf->name)) {
          libptr->filbpr=absbtv();
          return(1);
     }
     libptr->filbpr=0L;
     return(0);
}

/* Copy utilities (time split):  cpy1st, cpynxt, cpysrc, cpyfin */
/* For copying one file to one file, or concatenating many      */
/* files into one file.                                         */
/*                                                              */
/* Single file                                                  */
/* sequence:      1st nxt nxt nxt nxt fin                       */
/* return codes:   1   1   1   1   0                            */
/*                                                              */
/* Multiple file                       *                        */
/* sequence:      1st nxt nxt nxt nxt src nxt nxt nxt nxt fin   */
/* return codes:   1   1   1   1   0   1   1   1   1   0        */
/*                                                              */
/* Aborted multiple file               *                        */
/* sequence:      1st nxt nxt nxt nxt src src nxt nxt fin       */
/* return codes:   1   1   1   1   0   0   1   1   0            */
/*                                                              */
/* Aborted open                                                 */
/* sequence:      1st                                           */
/* return codes:   0                                            */

int
cpy1st(                                       /* Prepare to copy a DOS file */
char *from,
char *to,                              /* returns true if open's successful */
int binmod)                  /* 1=binary mode, 0=ASCII mode (strips '\x1A') */
{
     cpyerr=0;
     if ((lbnfp=fopen(from,FOPRB)) == NULL) {
          return(0);
     }
     if ((lbnfp2=fopen(to,FOPWB)) == NULL) {
          fclose(lbnfp);
          lbnfp=NULL;
          return(0);
     }
     bincpy=binmod;
     return(1);
}

int
cpynxt(                                    /* Copy the next block of a file */
int nbytes)                                 /* returns true if more to copy */
{
     int n,c;

     if ((nbytes=min(nbytes,cpyblk)) > 0) {
          for (n=0 ; n < nbytes && (c=fgetc(lbnfp)) != EOF ; n++) {
               if ((bincpy || c != '\x1A') && fputc(c,lbnfp2) == EOF) {
                    cpyerr=1;
                    break;
               }
          }
          if (n == nbytes) {
               return(1);
          }
     }

     fclose(lbnfp);
     lbnfp=NULL;
     return(0);
}

int
cpysrc(                   /* Change to new source file in concatenated copy */
char *from)                              /* returns true if open successful */
{
     if ((lbnfp=fopen(from,FOPRB)) == NULL) {
          return(0);
     }
     return(1);
}

int
cpyfin(void)                                      /* Wind up copy operation */
{
     fclose(lbnfp2);
     lbnfp2=NULL;
     return(!cpyerr);
}

