/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *   _____________                                                         *
 *  |             |  This is The Major BBS Library service, with Library   *
 *  |  LIBRARY.C  |  Info Banks (LIB's), and file uploads and downloads.   *
 *  |_____________|                                                        *
 *                                                                         *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.  All Rights Reserved        *
 *                                                                         *
 *                                                     RNStein  May 1991   *
 *                                                                         *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"
#include "gallibr.h"
#include "libdat.h"
#include "libutil.h"
#include "fsd.h"
#include "gallibn.h"
#include "galfiln.h"
#include "message.h"

STATIC int                                               /* Command Handler */
hdlcmd(void);                    /* returns number of chars handled (0=all) */
                                   /* cmdptr points to characters to handle */
STATIC int
sigcmd(void);                                      /* libop command Handler */

STATIC int
syscmd(void);                                      /* SYSOP command Handler */

STATIC int
bkgsvc2(void);                     /* second half of bkgsvc() routine      */

STATIC void
bkgcpy(void);                      /* background COPIED substt handling    */

STATIC void
bkgdlib(void);                     /* bkgsvc DLIB substt handler           */

STATIC void
bkgkwb(void);                 /* move backward preparing for keyword search */

/*  The Major BBS Module structure  */
/*----------------------------------*/

int libstate;                                 /* Library usrptr->state code */

int liblon(void),libinp(void);
void libstn(void),libhup(void),libmcu(void),libcls(void);

struct module library={            /* module interface block               */
     "",                           /*    name used to refer to this module */
     liblon,                       /*    user logon supplemental routine   */
     libinp,                       /*    input routine if selected         */
     libstn,                       /*    status-input routine if selected  */
     NULL,                         /*    "injoth" routine for this module  */
     NULL,                         /*    user logoff supplemental routine  */
     libhup,                       /*    hangup (lost carrier) routine     */
     libmcu,                       /*    midnight cleanup routine          */
     NULL,                         /*    delete-account routine            */
     libcls                        /*    finish-up (sys shutdown) routine  */
};

#define CONSIDFORUMS 0     /* don't remove dir that a Forum might be using? */

/*  Databases  */
/*-------------*/

BTVFILE *sigbb;               /* LIB database file handle                   */
BTVFILE *filbb;               /* File database file handle                  */
BTVFILE *kwdbb;               /* Keyword database file handle               */

struct libdat *sigbuf;
struct fildat *filbuf;
struct kwddat *kwdbuf;
struct libdat *sigkbf;        /* LIB Name                */
struct fildat *filkbf;        /* Status/LIB/File Name    */
struct kwddat *kkwkbf;        /* Keyword/LIB/File Name   */
struct kkilib *kkikbf;        /* LIB/Keyword/File Name   */



/*  Local Variables  */
/*-------------------*/
struct libusr *libusr;        /* Library data array (dynamically allocated) */
struct libusr *libptr;        /* Library data for current user (pointer to) */
FILE *libmb;                  /* library message file block pointer         */
long mainsig;                 /* Btrieve pointer to the Main LIB            */
long siggvn;                  /* Global variable for filnam() and isfil()   */
char *cmdptr;                 /* pointer to commands                        */
int libstt;                   /* new substate for this state                */
int namres;                   /* Global var for filnam() (reserved name)    */
int margi;                    /* margv[] argument being scanned             */
char ntrstt;                  /* substt when entering Library               */


/*--- OPTIONS FROM GALLIBR.MSG ---*/

int
    maxres,                   /* Maximum number of user files open at once */
    cpyblk,                   /* Maximum suggested copy size at a time     */
    topfil,                   /* list how many often-downloads in TOPFILES */
    umlimit;                  /* limit on multi-file uploads               */
char
    comeff,                   /* Communications efficiency (in %)          */
    kwscan,                   /* keyword scan, number at a time            */
    dofiles,                  /* 1=Look for FILES in DOS-Only LIBs 0=no    */
    chgabt,                   /* Charge users for aborted downloads?       */
    chgsys,                   /* Charge for TOPFILES, INDEX, FILES, LIBS?  */
    poschk,                   /* check absolute file positions & report err*/
    libcln,                   /* 1=auto-cleanup 0=no auto-cleanup for libs */
    zuresume;                 /* allow partial zmodem upload & later resume*/
char *fsyslock;               /* lock on Sysop features of the File Library*/

long (*tftabl)[2];            /* Dynamic 2D array for "TOPFILES" generation*/
                              /*      containing [0]=absptr [1]=numdld     */
                              /*      1st entries are most popular entries */
long (*mtftab)[2];            /* 2D array for "MAIN\TOPFILES" regeneration */


STATIC void
libzer(void)                                    /* Zero library's user data */
{                                               /* libptr is implicit parm  */
     setmem(libptr,sizeof(struct libusr),0);
     libptr->selsig=mainsig;
}

void EXPORT
init__library(void)                     /* Library-specific initialization */
{
     int i;
     struct fndblk fb;

     stzcpy(library.descrp,gmdnam("GALLIB.MDF"),MNMSIZ);
     libstate=register_module(&library);
     libmb=opnmsg("gallibr.mcv");
     topfil=numopt(TOPFIL,0,1000);
     tftabl=(topfil > 0) ? (long (*)[2])alcmem(sizeof(*tftabl)*topfil) : NULL;
     mtftab=(topfil > 0) ? (long (*)[2])alcmem(sizeof(*mtftab)*topfil) : NULL;
     kwscan=(char)numopt(KWSCAN,2,20);
     comeff=(char)numopt(COMEFF,1,100);
     cpyblk=numopt(CPYBLK,1,32767);
     maxres=numopt(MAXRES,1,256);
     chgabt=(char)ynopt(CHGABT);
     chgsys=(char)ynopt(CHGSYS);
     umlimit=numopt(UMLIMIT,0,32767);
     libcln=(char)ynopt(LIBCLN);
     dofiles=(char)ynopt(DOFILES);
     zuresume=(char)ynopt(ZURESUME);
     poschk=(char)ynopt(POSCHK);
     fsyslock=strupr(stgopt(FSYSLOCK));
     sigbb=opnbtv("GALLIBS.DAT",LIBSIZ+LIBMXA);
     filbb=opnbtv("GALFILES.DAT",FILSIZ+FILMXA);
     kwdbb=opnbtv("GALKEYWD.DAT",KWDSIZ);
     sigbuf=((struct libdat *)sigbb->data);
     filbuf=((struct fildat *)filbb->data);
     kwdbuf=((struct kwddat *)kwdbb->data);
     sigkbf=((struct libdat *)sigbb->key);
     filkbf=((struct fildat *)filbb->key);
     kkwkbf=((struct kwddat *)kwdbb->key);
     kkikbf=((struct kkilib *)kwdbb->key);
     libptr=libusr=(struct libusr *)alcmem(nterms*sizeof(struct libusr));
     usrnum=-1;
     signam("MAIN");
     if (issig()) {
          mainsig=absbtv();
          if (!fnd1st(&fb,"MAIN",FAMDIR)) {

                             /* In this case, the LIBXXX.DAT files say that */
                             /* the MAIN LIB already exists, but there is   */
                             /* no MAIN subdirectory.                       */

               if (mkdir("MAIN") != 0) {
                    catastro("ERROR RE-CREATING \"MAIN\" SUB-DIRECTORY");
               }
               shocst("LIBRARY INSTALLATION ERROR","The \"MAIN\" sub"
                      "directory was missing!  (It's now been recreated.)");
               for (sgl1st() ; sglnxt() ;) {           /* Generate LIB List */
               }
               sglfin();
               if (!fld1st(mainsig)) {
                    catastro("ERROR CREATING \"MAIN\\FILES\"");
               }
               while (fldnxt()) {                      /* Generate File Dir */
               }
               fldfin();
          }
     } else {
          if (fnd1st(&fb,"MAIN",FAMDIR) && (fb.attr&FAMDIR)) {

                           /* In this case, the LIBXXX.DAT files say there  */
                           /* is no MAIN LIB yet, but the MAIN subdirectory */
                           /* exists already.                               */

               shocst("LIBRARY INSTALLATION ERROR","The \"MAIN\" sub"
                      "directory already existed!  (It will be used.)");
          }
          else if (mkdir("MAIN") != 0) {
               catastro("ERROR CREATING \"MAIN\" SUB-DIRECTORY");
          }
          cmnsig();                                  /* Create the Main LIB */
          mainsig=absbtv();
          crfsgl();                             /* Create the LIB List file */
          crfflm();                  /* Create the main File directory file */
          for (sgl1st() ; sglnxt() ;) {                /* Generate LIB List */
          }
          sglfin();
          if (!fld1st(mainsig)) {
               catastro("ERROR CREATING \"MAIN\\FILES\"");
          }
          while (fldnxt()) {                           /* Generate File Dir */
          }
          fldfin();
          shocst("LIB CREATED:  MAIN","The \"MAIN\" LIB was created and the"
                                      " File Library was installed.");
     }
     for (i=0,libptr=libusr ; i < nterms ; i++,libptr++) {
          libzer();
     }
     dclvda(FKTSIZ+(kwscan+2)*sizeof(struct filmnu));  /* for dnld kwd srch */
     dclvda(FKTSIZ+CPYSIZ);                            /* for copying files */
     dclvda(FKTSIZ+RNDSIZ);                           /* for renaming files */
     dclvda(LIBASIZ);                   /* for temporarily storing LIB info */
     dclvdalib();                                         /* (in GALLIBN.C) */

     /* None of the following dclvda()'s could possibly compete with those  */
     /* shown above.  They are shown below for reference only, and should   */
     /* include all other uses of the volatile data area by the Library.    */
     /* They are shown, roughly, in largest to smallest order.              */
     /*                                                                     */
     /* dclvda(LIBNAM+1); */                /* remember name of deleted LIB */
     /* dclvda(DOSPTH+1); */           /* remember name of deleted DOS file */
     initgalfiln();
     initgallibn();
}

void
setlib(void)                         /* set up globals for the File Library */
{
     setmbk(libmb);
     libstt=usrptr->substt;
     libptr=&libusr[usrnum];
}

STATIC int
liblon(void)                                 /* Library-specific user-logon */
{
     char lopsom;

     setlib();
     if (libsys()) {
          gmnsig();
          if (sigbuf->uaptot == 1L) {
               prfmsg(OPALERT1);
          }
          else if (sigbuf->uaptot > 1L) {
               prfmsg(OPALERTN,l2as(sigbuf->uaptot));
          }
     }
     else {
          setbtv(sigbb);
          if (qeqbtv(usaptr->userid,1)) {
               lopsom=0;
               do {
                    gcrbtv(NULL,1);
                    astlib();
                    if (!sameas(usaptr->userid,sigbuf->libop)) {
                         break;
                    }
                    if (sigbuf->uapfil > 0L) {
                         prfmsg(LOPLONS,l2as(sigbuf->uapfil),sigbuf->name);
                         lopsom=1;
                    }
               } while (qnxbtv());
               if (lopsom) {
                    prfmsg(LOPLONG1);
               }
          }
     }
     libzer();
     outprf(usrnum);
     return(0);
}

STATIC int
libinp(void)                               /* Library-specific user handler */
{
     int nchar=0;

     setlib();
     ntrstt=libstt;
     if (usrptr->pfnacc > MAXPFN) {
          btuinj(usrnum,RING);
          return(1);
     }
     if (pfnlvl >= 2) {
          prfmsg(pfnlvl > 2 ? VBADWRD : BADWRD);
          libpmt();
          return(1);
     }
     cmdptr=margv[0];
     for (margi=0 ; margi < margc ; margi++) {
          for (cmdptr=margv[margi] ; *cmdptr != '\0' ; cmdptr+=nchar) {
               if ((nchar=hdlcmd()) <= 0) {
                    break;
               }
               if (libstt == LMEXIT) {
                    prf("");
                    clrufl(INLIB);
                    outprf(usrnum);
                    return(0);
               }
          }
          if (nchar <= 0) {
               break;
          }
     }
     libpmt();
     return(1);
}

void
lmreturn(void)                           /* Implicit return to Library menu */
{                     /* getting user out of whatever mess he's gotten into */
     if (tstufl(DELLIB)) {                     /* Any LIB's almost deleted? */
          gtgsig();
          sigbuf->flags&=~DYING;
          updlib(NULL);
     }
     libptr->flags&=~(DELLIB+                 /* (erase flags tested above) */
                      FILRES+                     /* no more reserving file */
                      FNMRES+                /* no more reserving file name */
                      FWTRES+       /* no more write-reserving Library file */
                      FRDRES+        /* no more read-reserving Library file */
                      BAKGND+              /* no more background processing */
                      BKSLNT+         /* next background will not be silent */
                      LOPRES+                   /* Lib-op reserved function */
                      CPYMOV+                      /* destructive copy form */
                      FCOMMD);               /* F command / ZMODEM fragment */
                                                  /* Does not clear SUBBRK! */
     usrptr->crdrat=mmucrr;              /* restore credit consumption rate */
     usrptr->flags&=~(NOZAP+        /* restore freeloader zap (auto logoff) */
                      NOINJO+               /* restore paging messages etc. */
                      NOGLOB);            /* restore global command handler */
     libptr->sigbpr=0L;                 /* no longer using an alternate LIB */
     libptr->filbpr=0L;                        /* no longer using any files */
     libstt=LMSHORT;
}

void
libexit(void)                              /* Explicit exit to Library menu */
{                               /* (or exit from Library menu to main menu) */
     switch (libstt) {
     case LMSHORT:
     case LMPROMPT:
     case 0:
     case LMENTER:
     case LIBDESC:
          lmreturn();
          libstt=LMEXIT;
          break;
     default:
          lmreturn();
          break;
     }
}

STATIC int                                               /* Command Handler */
hdlcmd(void)                     /* returns number of chars handled (0=all) */
{                                  /* cmdptr points to characters to handle */
     int rc;

     if (margc == 1 && sameas(input,"X")) {
          libexit();
          return(1);
     }
     switch (libstt) {
     case 0:
          usrptr->flags&=~X2MAIN;
          setufl(INLIB);
          hdllmu();
          return(1);
     case LMENTER:
     case LMSHORT:
     case LMPROMPT:
     case LIBDESC:
          return(hdlmnu());
     case SELLIB1:
          return(hdlssl());
     case KWSRSP:
          if ((rc=hdlkws()) >= 0) {
               return(rc);
          }
     case DKEYWRD1:
          return(hdldkw());
     case UNAME1:
          return(hdlunm());
     case USHORT:
          hdlufs();
          break;
     case MNAME:
          return(hdlmnm());
     case OWCHECK:
          hdlowc();
          break;
     default:
          if (libop()) {
               return(sigcmd());
          }
          break;
     }
     return(0);
}

STATIC int
wordcmd(                                          /* check for word-command */
char *cshort,                                /* abbreviated form of command */
char *clong)                                                /* full command */
{
     return(sameto(cshort,cmdptr) && sameto(cmdptr,clong));
}

int
sigmnu(void)                                  /* libop Library menu options */
{                                               /* implicit output:  libstt */
                   /* return value:  N=handled N chars, 0=unknown, -1=error */
     long totuap;
     int msg;

     libptr->sigbpr=libptr->selsig;
     if (wordcmd("APP","APPROVE")) {
          if (lopres(0)) {
               if (doncant("all files are already approved")) {
                    return(-1);
               }
               gslsig();
               if (libptr->selsig == mainsig) {
                    totuap=sigbuf->uaptot;
                    msg=APNONE;
               }
               else {
                    totuap=sigbuf->uapfil;
                    msg=APNLIB;
               }
               if (totuap == 0L) {
                    prfmsg(msg,sigbuf->name);
                    return(-1);
               }
               libstt=APPFIL;
               return(strlen(cmdptr));
          }
     }
     else if (wordcmd("UNA","UNAPPROVE")) {
          if (lopres(0)) {
               if (doncant("you cannot un-approve files")) {
                    return(-1);
               }
               libstt=UAPFIL;
               return(strlen(cmdptr));
          }
     }
     else if (wordcmd("COP","COPY")) {
          clrufl(CPYMOV);
          libstt=CFNAME1;
     }
     else if (wordcmd("MOV","MOVE")) {
          setufl(CPYMOV);
          libstt=MFNAME1;
     }
     else if (wordcmd("LOG","LOGIN")) {
          if (doncant("you don't have to log in files")) {
               return(-1);
          }
          libstt=LFNAME;
     }
     else if (wordcmd("REN","RENAME")) {
          libstt=RFNAME;
     }
     else if (wordcmd("DEL","DELETE")) {
          libstt=DFNAME;
     }
     else if (wordcmd("UNL","UNLOG")) {
          if (doncant("you cannot unlog files")) {
               return(-1);
          }
          libstt=ULFNAME;
     }
     else if (wordcmd("DIR","DIR")) {
          if (libsys()) {
               libstt=DOSDIR;
          }
          else if (margc-margi <= 1) {
               ddr1st(path(libptr->selsig,NULL),0);
               libstt=DDMOREL;
          }
          else {
               gslsig();
               prfmsg(LOPDIR,sigbuf->name,path(libptr->selsig,"*.*"));
               return(-1);
          }
     }
     else {
          return(0);
     }
     if (!lopres(1)) {
          lmreturn();
          return(-1);
     }
     return(strlen(cmdptr));
}

int
sysmnu(void)                                  /* Sysop Library menu options */
{                                               /* implicit output:  libstt */
                   /* return value:  N=handled N chars, 0=unknown, -1=error */
     if (wordcmd("CRE","CREATE")) {
          libstt=NAMCRE;
     }
     else if (wordcmd("REM","REMOVE")) {
          libstt=NAMDEL;
     }
     else if (wordcmd("EDI","EDIT")) {
          if (margi != margc-1) {
               gslsig();
               prfmsg(EDITZP,sigbuf->name);
               return(-1);
          }
          if (lopres(0)) {
               libptr->sigbpr=libptr->selsig;
               gtgsig();
               libedit();
               rstrin();
               return(strlen(cmdptr));
          }
     }
     else {
          return(0);
     }
     if (!lopres(1)) {
          lmreturn();
          return(-1);
     }
     return(strlen(cmdptr));
}

STATIC int
sigcmd(void)                                       /* libop command Handler */
{                             /* returns number of chars handled (or 0=all) */
     int rc=0;

     switch (libstt) {
     case APPFIL:
          hdlapf();
          break;
     case AFEXP1:
          hdlap1();
          break;
     case AFEXP:
          hdlapn();
          break;
     case UAPFIL:
          hdlupf();
          break;
     case UAFEXP:
          hdlup1();
          break;
     case DFNAME:
     case ULFNAME:
          hdldfn();
          break;
     case DFDCONF:
          hdldds();
          break;
     case RFNAME:
          rc=hdlrfn();
          break;
     case RFNEWN:
          hdlrnn();
          break;
     case MFNAME1:
     case CFNAME1:
          rc=hdlcfn();
          break;
     case CFDOS:
          hdlcdn();
          break;
     case CFLIB:
          hdlcln();
          break;
     case CFDTOE1:
     case CFLTOE1:
          hdlcfe();
          break;
     case CFLOG:
          hdlclg();
          break;
     case LFNAME:
          hdllfn();
          break;
     case LFLIN:
          hdllfs();
          break;
     case LFAPP:
          hdllfa();
          break;
     default:
          if (libsys()) {
               return(syscmd());
          }
          break;

     }
     return(rc);
}

STATIC int
syscmd(void)                                       /* SYSOP command Handler */
{                             /* returns number of chars handled (or 0=all) */
     int rc=0;

     switch (libstt) {
     case NAMCRE:
          hdlsgc();
          break;
     case LIBNASK:
          hdlchq(LIBNHLP2);
          break;
     case NAMDEL:
          hdlsdn();
          break;
     case DELCONF:
          hdlsdc();
          break;
     case DOSDIR:
          hdlddr();
          break;
     }
     return(rc);
}

void
rollcall(void)                               /* Prepare to scan other users */
{
     othusn=-1;
     othusp=user-1;
}

char *
rcsig(                                          /* Next user using this LIB */
long sigbpr)
{
     while (othusn < nterms-1) {
          othusn++;
          othusp++;
          othuap=uacoff(othusn);                       /* Search for users: */
          if ((libusr[othusn].flags&INLIB)                    /* in Library */
           && othusn != usrnum                             /* not this user */
           && (libusr[othusn].selsig == sigbpr         /* selected this LIB */
            || libusr[othusn].sigbpr == sigbpr)) {      /* reading from LIB */
               return(othuap->userid);
          }
     }
     return(NULL);
}

int
rclop(void)                                              /* Another LIB-Op? */
{
     while (othusn < nterms-1) {
          othusn++;
          othusp++;
          othuap=uacoff(othusn);                       /* Search for users: */
          if ((libusr[othusn].flags&INLIB)                /* in the Library */
           && (libusr[othusn].flags&LOPRES)) {         /* LIB-Op-ing around */
               return(1);
          }
     }
     return(0);
}

int
rcbsig(                                    /* Next user (backgnd) using LIB */
long sigbpr)
{
     while (othusn < nterms-1) {
          othusn++;
          othusp++;
          othuap=uacoff(othusn);                       /* Search for users: */
          if (othusp->class >= SUPLOF      /* user is something like online */
           && othusn != usrnum                             /* not this user */
           && (libusr[othusn].selsig == sigbpr)) {     /* selected this LIB */
               return(1);
          }
     }
     return(0);
}

int
reschk(                               /* Find next user reserving this file */
long sigbpr,                                                         /* LIB */
char *fname,                                                   /* file name */
int resmsk)                       /* reserve mask:  FRDRES FWTRES or FNMRES */
{
     int got;

     rollcall();
     while (othusn < nterms-1) {
          othusn++;
          othusp++;
          othuap=uacoff(othusn);
          if (othusp->class >= SUPLOF      /* user is something like online */
           && othusn != usrnum                           /* and not himself */
           && (got=(libusr[othusn].flags&resmsk)) != 0) {    /* & reserving */
               if (got&(FRDRES+FWTRES)) {
                    if (sigbpr == libusr[othusn].sigres
                     && sameas(fname,libusr[othusn].filres)) {
                         return(1);
                    }
               }
               if (got&FNMRES) {
                    if (sigbpr == libusr[othusn].sigre2
                     && sameas(fname,libusr[othusn].filre2)) {
                         return(1);
                    }
               }
          }
     }
     return(0);
}

int
frexcd(void)                     /* Number of reserved files exceeds limit? */
{
     int nfuse=0;

     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (libusr[othusn].flags&FILRES) {
               nfuse++;
          }
     }
     if (nfuse >= maxres) {
          prfmsg(NOFILES,maxres,maxres+1);
          return(1);
     }
     setufl(FILRES);
     return(0);
}

STATIC void
forcoes(void)                         /* make sure we get an OES (5) status */
{
     btuoes(usrnum,1);
     if (btuoba(usrnum) == outbsz-1) {
          btuinj(usrnum,OUTMT);
     }
}

/*--- Background processing routines ---*/

void
bkgbeg(                                           /* Begin background tasks */
int lockout)           /* 1=lockout input while in background 0=allow input */
{
     if (!tstufl(BAKGND)) {
          setufl(BAKGND);
          btuinj(usrnum,CYCLE);
          libptr->dribbl=5;
          btulok(usrnum,lockout);
     }
}

STATIC int
bkgmso(void)                              /* background multi-screen output */
{
     char room;

     room=btuoba(usrnum) >= 1920;
     switch(libstt) {
     case DDMORE:
          if (room) {
               if (!ddrnxt()) {
                    libstt=LMSHORT;
               }
               outprf(usrnum);
          }
          break;
     case UALXNS:
          if (room) {
               if (!ualnxt()) {
                    libstt=LMSHORT;
               }
               outprf(usrnum);
               libptr->dribbl=5;
          }
          break;
     default:
          return(0);
     }
     return(1);
}

STATIC int
bkgsvc(void)                           /* Background Library user servicing */
{
     char *cp;
     char buff[KWDLEN+1];
     long ln;
     int rc;
     struct fndblk fb;

     if (!tstufl(BAKGND)) {
          return(0);
     }
     switch(libstt=usrptr->substt) {
     case SHHEAD:            /* allow preceding messages to go out as ASCII */
          if (btuoba(usrnum) == outbsz-1) {
               prf("\r\n");
               sluhdr();
               slu1st();
               outprf(usrnum);
               libstt=SHSEL;
          }
          break;
     case SHSEL:
          if (btuoba(usrnum) > 500) {
               if (!slunxt(libptr->sigbpr == 0L || keypass("VISIBL",NULL))) {
                    slufin();
                    libstt=SHSEL2;
               }
               prf("");
               outprf(usrnum);
          }
          break;
     case SHSEL2:
          libstt=libptr->linkst;
          forcoes();
          clrufl(BAKGND);
          break;
     case CTMFIL:
          filtmp->date=today();
          filtmp->time=now();
          insfil(filtmp);
          libptr->filbpr=absbtv();
          libstt=filtmp->status == 'A' ? CTMFIL2 : CTMFIL3;
          libptr->dribbl=10;
          break;
     case CTMFIL2:
          gtgfil();
          kwdins(filbuf->name,!tstufl(BKSLNT));
          libstt=isautf(filbuf->name) ? CTMFIL3 : CTMFIL25;
          break;
     case CTMFIL25:
          gtgfil();
          enckdt(buff,filbuf->date,filbuf->time);
          kwdins(buff,!tstufl(BKSLNT));
          libstt=CTMFIL3;
          break;
     case CTMFIL3:
          updcnt(libptr->sigbpr,filtmp->status,1L,0L,filtmp->status == 'A',
                                                     filtmp->status == 'A');
          libstt=CFLUPD;              /* update file counts in LIB database */
          break;
     case CFLUPD:
          updfdt(libptr->sigbpr,filtmp->name,0);
          libstt=filtmp->status == 'A' ? REINKWD : REINKED;
          libptr->dribbl=10;
          break;
     case REDOKWD:
          libptr->ind=0;
          libstt=REDOQING;
          break;
     case REDOKING:
     case REDOQING:
          gtgfil();
          libstt=REDOQING;
          if (*(cp=nxtkwd(filbuf)) != '\0') {
               if (kwddel(cp,!tstufl(BKSLNT))) {
                    libstt=REDOKING;
               }
               libptr->dribbl=5;
          }
          if (++libptr->ind >= KWDNUM) {
               libstt=UTMFIL;
          }
          break;
     case UTMFIL:
          gtgfil();
          updfil(filtmp);
          libstt=UFLUPD;
          libptr->dribbl=10;
          break;
     case UFLUPD:
          updfdt(libptr->sigbpr,filtmp->name,-1);
          libstt=filtmp->status == 'A' ? REINKWD : REINKED;
          libptr->dribbl=10;
          break;
     case REINKWD:
          libptr->ind=0;
          libstt=REINQING;
          break;
     case REINQING:
     case REINKING:
          gtgfil();
          libstt=REINQING;
          if (*(cp=nxtkwd(filtmp)) != '\0') {
               if (kwdins(cp,!tstufl(BKSLNT))) {
                    libstt=REINKING;
               }
               libptr->dribbl=5;
          }
          if (++libptr->ind >= KWDNUM) {
               libstt=REINKED;
          }
          break;
     case REINKED:
          libstt=libptr->linkst;
          break;
     case FUPLOG:
          if (filtmp->status == 'A') {
               updfld(libptr->sigbpr,libptr->filbpr,1);
               libptr->dribbl=10;
          }
          libstt=FUPLOG2;
          break;
     case FUPLOG2:
          clrufl(BAKGND+FNMRES+FWTRES);
          break;
     case FILMOD:
          if (filtmp->status == 'A') {
               updfld(libptr->sigbpr,libptr->filbpr,1);
          }
          libstt=LMSHORT;
          break;
     case LFFIN:
          prfmsg(LFINFM,filtmp->name,filtmp->sig);
          prfmsg(filtmp->status == 'A' ? LFAYES : LFANO);
          if (filtmp->status == 'A') {
               updfld(libptr->sigbpr,libptr->filbpr,1);
          }
          libstt=LMSHORT;
          break;
     case CLLCPY:
          libptr->linkst=CFLFIN;
          libstt=CPYFIL;
          break;
     case CPYFIL:
          libstt=COPYING;
          break;
     case COPYING:
          if (!cpynxt(cpyblk)) {
               libstt=COPIED;
          }
          break;
     case COPIED:
          bkgcpy();
          break;
     case CFLFIN:                                    /* Copy LIB -> LIB/DOS */
          if (cpytmp->tosig != 0L) {      /* -> LIB: update size & file dir */
               getsig(libptr->sigbpr=cpytmp->tosig);
               if (!(sigbuf->flags&DOSONL)) {
                    updfdt(libptr->sigbpr,filtmp->name,0);
                    if (filtmp->status == 'A') {
                         updfld(libptr->sigbpr,libptr->filbpr,1);
                    }
               }
          }                                                /* check if move */
          if (tstufl(CPYMOV)) {
               getsig(libptr->sigbpr=cpytmp->fmsig);
               if (filnam(cpytmp->fmsig,cpytmp->fmfile) && ucansee(0)) {
                    prfmsg(MOVRPT,cpytmp->fmpath);
                    libstt=DFDING;
                    libptr->linkst=0;
                    break;
               }
          }
          libstt=LMSHORT;
          break;
     case AF1ING:
          gtgfil();
          filbuf->status='A';
          filbuf->date=today();
          filbuf->time=now();
          updfil(NULL);
          libstt=AF1KWD;
          libptr->dribbl=10;
          break;
     case AF1KWD:
          libptr->ind=0;
          libstt=AF1KING;
          libptr->dribbl=10;
          break;
     case AF1KING:
          gtgfil();
          if (*(cp=nxtkwd(filbuf)) != '\0') {
               kwdins(cp,!tstufl(BKSLNT));
               libptr->dribbl=5;
          }
          if (++libptr->ind >= KWDNUM) {
               libstt=AF1KFN;
          }
          break;
     case AF1KFN:
          gtgfil();
          kwdins(filbuf->name,!tstufl(BKSLNT));
          libptr->dribbl=5;
          libstt=isautf(filbuf->name) ? AF1KED : AF1KDT;
          break;
     case AF1KDT:
          gtgfil();
          enckdt(buff,filbuf->date,filbuf->time);
          kwdins(buff,!tstufl(BKSLNT));
          libptr->dribbl=5;
          libstt=AF1KED;
          break;
     case AF1KED:
          updcnt(libptr->sigbpr,'a',1L,filbuf->size,1,1);
          gtgfil();
          prfmsg(AF1INFM,filbuf->name,filbuf->sig);
          updfld(libptr->sigbpr,libptr->filbpr,1);
          libstt=LMSHORT;
          break;
     case AFING:
          gtgfil();
          updcnt(libptr->sigbpr,'a',1L,filbuf->size,1,1); /* Transfer counts */
          libstt=AFKWD;
          break;
     case AFKWD:
          libptr->ind=0;
          libstt=AFKING;
          libptr->dribbl=10;
          break;
     case AFKING:
          gtgfil();
          if (*(cp=nxtkwd(filbuf)) != '\0') {
               kwdins(cp,!tstufl(BKSLNT));
               libptr->dribbl=5;
          }
          if (++libptr->ind >= KWDNUM) {
               libstt=AFKFN;
          }
          break;
     case AFKFN:
          gtgfil();
          kwdins(filbuf->name,!tstufl(BKSLNT));
          libptr->dribbl=5;
          libstt=isautf(filbuf->name) ? AFKED : AFKDT;
          break;
     case AFKDT:
          gtgfil();
          enckdt(buff,filbuf->date,filbuf->time);
          kwdins(buff,!tstufl(BKSLNT));
          libptr->dribbl=5;
          libstt=AFKED;
          break;
     case AFKED:
          libptr->lnum++;
          updfld(libptr->sigbpr,libptr->filbpr,1);
          getfil(ln=libptr->filbpr);
          sftnxt('U');
          getfil(ln);
          filbuf->status='A';
          updfil(NULL);
          libstt=AFLOOP;
          libptr->dribbl=10;
          break;
     case AFLOOP:
          if (libptr->filbpr != 0L) {
               clrufl(BAKGND+FWTRES);
               gtgfil();
               shofil();
               libstt=AFEXP;
               break;                   /* more files to offer for approval */
          }
          gtgsig();
          prfmsg(AFINFM,l2as(libptr->lnum),sigbuf->name);
          libstt=LMSHORT;
          break;
     case UAFING:
          gtgfil();
          filbuf->status='U';
          updfil(NULL);
          libstt=UAFKWD;
          libptr->dribbl=10;
          break;
     case UAFKWD:
          libptr->ind=0;
          libstt=UAFKING;
          libptr->dribbl=10;
          break;
     case UAFKING:
          gtgfil();
          if (*(cp=nxtkwd(filbuf)) != '\0') {
               kwddel(cp,!tstufl(BKSLNT));
               libptr->dribbl=5;
          }
          if (++libptr->ind >= KWDNUM) {
               libstt=UAFKFN;
          }
          break;
     case UAFKFN:
          gtgfil();
          kwddel(filbuf->name,!tstufl(BKSLNT));
          libptr->dribbl=5;
          libstt=isautf(filbuf->name) ? UAFKED : UAFKDT;
          break;
     case UAFKDT:
          gtgfil();
          enckdt(buff,filbuf->date,filbuf->time);
          kwddel(buff,!tstufl(BKSLNT));
          libptr->dribbl=5;
          libstt=UAFKED;
          break;
     case UAFKED:
          updcnt(libptr->sigbpr,'u',1L,filbuf->size,0,1);
          gtgfil();
          prfmsg(UAFINFM,filbuf->name,filbuf->sig);
          updfld(libptr->sigbpr,libptr->filbpr,0);
          libstt=LMSHORT;
          break;
     case RFKWD:
          libptr->ind=0;
          libstt=RFKING;
          libptr->dribbl=10;
          break;
     case RFKING:
          gtgfil();
          if (*(cp=nxtkwd(filbuf)) != '\0') {
               rc=kwdupd(cp,!tstufl(BKSLNT));
               strcpy(kwdbuf->file,rndtmp->file2);
               rc ? updbtv(NULL) : insbtv(NULL);
               libptr->dribbl=5;
          }
          if (++libptr->ind >= KWDNUM) {
               libstt=filbuf->status == 'A' ? RFKFN : RFDOS;
          }
          break;
     case RFKFN:
          gtgfil();
          rc=kwdupd(filbuf->name,!tstufl(BKSLNT));
          strcpy(kwdbuf->file,rndtmp->file2);
          strcpy(kwdbuf->keywrd,rndtmp->file2);
          strlwr(kwdbuf->keywrd);           /* Update special file name kwd */
          rc ? updbtv(NULL) : insbtv(NULL);
          libptr->dribbl=5;
          libstt=RFKDT;
          break;
     case RFKDT:
          gtgfil();
          if (!isautf(filbuf->name)) {
               enckdt(buff,filbuf->date,filbuf->time);
               kwddel(buff,!tstufl(BKSLNT));
          }
          libptr->dribbl=5;
          libstt=RFKDT2;
          break;
     case RFKDT2:
          gtgfil();
          if (!isautf(rndtmp->file2)) {
               enckdt(buff,filbuf->date,filbuf->time);
               strcpy(filbuf->name,rndtmp->file2);
               kwdins(buff,!tstufl(BKSLNT));
          }
          libptr->dribbl=5;
          libstt=RFDOS;
          break;
     case RFDOS:
          rename(rndtmp->path1,rndtmp->path2);           /* rename DOS file */
          libstt=RFNAM;
          libptr->dribbl=5;
          break;
     case RFNAM:
          if (libptr->filbpr != 0L) {
               gtgfil();
               strcpy(filbuf->name,rndtmp->file2);
               updfil(NULL);
               libptr->filbpr=absbtv();                             /* nec? */
          }                            /* Update file name in file database */
          libstt=RFNOTF;
          libptr->dribbl=10;
          break;
     case RFNOTF:
          prfmsg(RFINFM,rndtmp->file1,rndtmp->file2);
          libstt=RFUPCT;
          break;
     case RFUPCT:
          gtgfil();
          if (filbuf->status == 'A') {
               updcnt(libptr->sigbpr,'A',0L,0L,0,1);
          }
          libptr->dribbl=10;
          libstt=RFUPFD;
          break;
     case RFUPFD:
          gtgfil();
          if (filbuf->status == 'A' && libptr->filbpr != 0L) {
               updfld(libptr->sigbpr,libptr->filbpr,1);
          }
          libstt=LMSHORT;
          break;
     case DFDING:
          if (unlink(cp=path(libptr->sigbpr,filtmp->name)) != 0) {
               prfmsg(fnd1st(&fb,cp,0) ? DFDUNS : DFDUNN);
          }
          gtgsig();
          if (sigbuf->flags&DOSONL) {                  /* if a DOS-only LIB */
               updcnt(libptr->sigbpr,'A',-1L,0L,0,0);
               libstt=DFDONE;            /* only need to update LIB's stats */
          }
          else {                                 /* but if not DOS-only LIB */
               libstt=DFKWD;             /* go on and delete keywords, etc. */
          }
          break;
     case DFKWD:
          libstt=filbuf->status == 'A' ? DFKING : DFILE;
          libptr->ind=0;
          break;
     case DFKING:
          gtgfil();
          if (*(cp=nxtkwd(filbuf)) != '\0') {
               kwddel(cp,!tstufl(BKSLNT));
               libptr->dribbl=5;
          }
          if (++libptr->ind >= KWDNUM) {
               libstt=DFKFN;
          }
          break;
     case DFKFN:
          gtgfil();
          kwddel(filbuf->name,!tstufl(BKSLNT));
          libptr->dribbl=5;
          libstt=isautf(filbuf->name) ? DFDIR : DFKDT;
          break;
     case DFKDT:
          gtgfil();
          enckdt(buff,filbuf->date,filbuf->time);
          kwddel(buff,!tstufl(BKSLNT));
          libptr->dribbl=5;
          libstt=DFDIR;
          break;
     case DFDIR:
          if (filtmp->status == 'A') {
               updfld(libptr->sigbpr,libptr->filbpr,0);
          }
          libstt=DFILE;
          break;
     case DFILE:
          gtgfil();
          delbtv();
          libstt=DFDCNT;
          break;
     case DFDCNT:
          updcnt(libptr->sigbpr,filtmp->status,-1L,-filtmp->size,0,
                 filtmp->status == 'A');
          libstt=DFDONE;
          break;
     case DFDONE:
          prfmsg(DFINFM,filtmp->name,filtmp->sig);
          if (libptr->linkst > 0) {
               prfmsg(libptr->linkst,path(libptr->sigbpr,NULL));
          }
          libstt=LMSHORT;
          break;
     case DSAFILES:
          libstt=sft1st('A') ? DSAUPD : DSUFILES;
          libptr->dribbl=10;
          break;
     case DSAUPD:
          gtgfil();
          updcnt(libptr->sigbpr,filbuf->status,-1L,-filbuf->size,0,1);
          libstt=DSAFILE;
          break;
     case DSAFILE:
          gtgfil();
          unlink(path(libptr->sigbpr,filbuf->name));
          updfld(libptr->sigbpr,libptr->filbpr,0);
          gtgfil();
          delbtv();
          libstt=DSAFILES;
          break;

     case DSUFILES:
          libstt=sft1st('U') ? DSUUPD : DSKWD;
          libptr->dribbl=10;
          break;
     case DSUUPD:
          gtgfil();
          updcnt(libptr->sigbpr,filbuf->status,-1L,-filbuf->size,0,1);
          libstt=DSUFILE;
          break;
     case DSUFILE:
          gtgfil();
          delbtv();
          unlink(path(libptr->sigbpr,filbuf->name));
          libstt=DSUFILES;
          break;
     case DSKWD:
          gtgsig();
          setbtv(kwdbb);
          setmem(kkikbf,KKISIZ,0);
          strcpy(kkikbf->sig,sigbuf->name);
          if (qgebtv(NULL,KKILIB) && sameas(kkikbf->sig,sigbuf->name)) {
               libptr->lnum=absbtv();
               libstt=DSKING;
               break;
          }
          else {
               libstt=(*fsdxan(libans(sigbuf),"PREFIX") == '\0'
                       || sigbuf->flags&RDONLY) ? DSDIR : DLIB;
          }
          libptr->dribbl=10;
          break;
     case DSKING:
          setbtv(kwdbb);
          gabbtv(NULL,libptr->lnum,KKILIB);
          delbtv();
          libstt=DSKWD;
          libptr->dribbl=10;
          break;
     case DSDIR:
          gtgsig();
          libstt=DLIB;
          #if CONSIDFORUMS
          if ((rc=findsigu(spr("%c%s",SIGIDC,sigbuf->name),0)) != NOSIG) {
               prf("\rThe \"%s\" directory will be left behind for the \"%s\""
                   " Forum.",sigbuf->name,sigoff(rc)->signam);
               break;
          }
          #endif
          if (rmdir(sigbuf->name) != 0) {               /* Remove directory */
               prf("\rUnable to remove directory \"%s\"",sigbuf->name);
          }
          break;
     case DLIB:
          bkgdlib();
          break;
     case LIBDIR:
          gtgsig();
          if ((*fsdxan(libans(sigbuf),"PREFIX") == '\0' || sigbuf->flags&RDONLY)
           && mkdir(sigbuf->name) != 0) {
               prfmsg(MDWARN,sigbuf->name);
          }
          libstt=(sigbuf->flags&DOSONL) ? LIBRPT : NEWFDIR;
          break;
     case NEWFDIR:
          crffli(libptr->sigbpr);
          libptr->filbpr=absbtv();
          updfld(libptr->sigbpr,libptr->filbpr,1);
          gtgfil();
          libptr->lnum=filbuf->mfdptr;
          libstt=NEWFDIR2;
          libptr->dribbl=10;
          break;
     case NEWFDIR2:
          gtgfil();
          kwdins(filbuf->name,!tstufl(BKSLNT));
          libstt=NEWFDIR3;
          libptr->dribbl=10;
          break;
     case NEWFDIR3:
          updcnt(libptr->sigbpr,'A',1L,0L,0,1);
          libstt=NEWFDIR4;
          break;
     case NEWFDIR4:
          rdtmpf();
          if (fld1st(libptr->sigbpr)) {
               libstt=NEWFDING;
               libptr->dribbl=10;
          }
          else {
               prfmsg(BADCFD,path(libptr->sigbpr,"FILES.{T}"));
               libstt=LIBRPT;
          }
          break;
     case NEWFDING:
          if (!fldnxt()) {
               libstt=LIBED;
          }
          break;
     case LIBED:
          if (fldfin()) {
               gtgfil();
               filbuf->mfdptr=libptr->lnum;
               updfil(NULL);
               libstt=LIBRPT;
          }
          break;
     case LIBRPT:
          gtgsig();
          prfmsg(CREINFM,sigbuf->name);
          shocst(spr("LIB CREATED:  %s",sigbuf->name),
               "The \"%s\" LIB was created in the File Library.",sigbuf->name);
          libstt=SGLGEN;
          break;
     case SGLGEN:
          sgl1st();
          libstt=SGLING;
          libptr->dribbl=5;
          break;
     case SGLING:
          if (!sglnxt()) {
               libstt=SGLED;
          }
          break;
     case SGLED:
     case SGLBUSY:
     case SGLWAIT:
          libstt=sglfin() ? LMSHORT : (libstt == SGLED ? SGLBUSY : SGLWAIT);
          break;
     case KWSBAK:             /* move backward preparing for keyword search */
          bkgkwb();
          break;
     case KWSBKW:              /* check candidate in reverse keyword search */
          if (!getkwd(1)) {
               libstt=LMSHORT;
               break;
          }
          libstt=KWSBAK;
          if (tstufl(KWSILB) || signam(kwdbuf->sig)
                             && issig()
                             && libkey(absbtv(),"VISIBL",0)) {
               kwsfil();
               if (libptr->ind == 0) {
                    prfmsg(KWSHED+tstufl(KWSDNT+KWSILB));
                    outprf(usrnum);
                    libptr->ind++;
                    libstt=KWSFOR;
               }
               else {
                    libptr->ind--;
               }
          }
          libptr->dribbl=5;
          break;
     case KWSFOR:                         /* move forward in keyword search */
          if ((ln=mnutmp[libptr->ind].kwdbpr) != 0L) {
               libptr->lnum=ln;
               libstt=KWSSHO;
               libptr->dribbl=5;
               break;
          }
          if (!getkwd(1)) {
               libstt=LMSHORT;
               break;
          }
          signam(kwdbuf->sig);
          if (kwdnxt()
           && (!tstufl(KWSILB) || sameas(kwdbuf->sig,sigkbf->name))
           && (!tstufl(KWSDNT) || kwdbuf->keywrd[0] == ' ')) {
               libptr->lnum=absbtv();
               libstt=KWSFWD;
               break;
          }
          else if (libptr->num == 0 && (ln=mnutmp[0].kwdbpr) != 0L) {
               movmem(&mnutmp[0],&mnutmp[kwscan],sizeof(mnutmp[0]));
               setmem(&mnutmp[0],sizeof(mnutmp[0])*kwscan,0);
               libptr->ind=kwscan-1;
               libptr->lnum=ln;
               libstt=KWSBAK;
          }
          else {
               prfmsg(KWSBOT);
               outprf(usrnum);
               libstt=KWSPMT;
          }
          break;
     case KWSFWD:              /* check candidate in forward keyword search */
          if (!getkwd(1)) {
               libstt=LMSHORT;
               break;
          }
          if (tstufl(KWSILB) || signam(kwdbuf->sig)
                             && issig()
                             && libkey(absbtv(),"VISIBL",0)) {
               kwsfil();
               libstt=KWSSHO;
          }
          else {
               libstt=KWSFOR;
          }
          libptr->dribbl=10;
          break;
     case KWSSHO:                            /* show line in keyword search */
          if (btuoba(usrnum) > 90) {
               if (!getkwd(1)) {
                    libstt=LMSHORT;
                    break;
               }
               if (libptr->ind <= kwscan) {
                    kxfref();
                    prfmsg(KWSSHO+tstufl(KWSDNT+KWSILB),++libptr->num);
                    outprf(usrnum);
                    libptr->ind++;
                    libstt=KWSFOR;
                    libptr->dribbl=10;
               }
               else {
                    libstt=KWSPMT;
               }
          }
          break;
     case KWSPMT:                   /* show prompt at end of keyword search */
          if (libptr->num == 0) {
               prfmsg(NOKEYS);
               libstt=LMSHORT;
          }
          else {
               clrufl(BAKGND+BKSLNT);
               libstt=KWSRSP;
          }
          break;
     default:
          if (!bkgmso()) {
               prf("\rUndefined background state %d.\r",libstt);
               libstt=LMSHORT;
          }
          break;
     }
     return(bkgsvc2());
}

STATIC int
bkgsvc2(void)                      /* second half of bkgsvc() routine      */
{
     switch(usrptr->substt=libstt) {
     case FUPLOG2:
          if (!tstufl(BAKGND)) {
               usrptr->state=libptr->savstt;    /* (sneakily un-glom CYCLEs */
               usrptr->substt=libptr->savsbs;          /* back to FILEXFER) */
               btulok(usrnum,0);
          }
          return(1);
     case REUPLOAD:
          clrufl(BAKGND);
          btulok(usrnum,0);
          if (filtmp->status == 'A') {
               updfld(libptr->sigbpr,libptr->filbpr,1);
          }
          reupload();
          outprf(usrnum);
          return(0);
     default:
          if (tstufl(BAKGND)) {
               if (libstt >= 0 && !tstufl(BKSLNT)) {
                    prfmsg(libstt);
                    outprf(usrnum);
               }
               return(1);
          }                           /* fall through if BAKGND flag is off */
     case LMSHORT:                                  /* terminate background */
          btucli(usrnum);
          btulok(usrnum,0);
          libpmt();
     case SHSELC:                        /* background -> wait for status 5 */
          return(0);
     }
}

STATIC void
bkgcpy(void)                       /* background COPIED substt handling    */
{
     prfmsg(cpyfin() ? CFOK : CFNOK);
     settnd(cpytmp->topath,cpytmp->mtime);
     switch (libstt=libptr->linkst) {
     case CFLOG:       /*  Copy DOS -> LIB:  handle move, offer to log */
     case CFDFIN:                     /* Copy DOS -> DOS:  handle move */
          if (tstufl(CPYMOV)) {
               if (cpytmp->fmsig != 0L) {
                    updcnt(cpytmp->fmsig,'A',-1L,0L,0,0);
               }               /* count file moves from a dos-only lib */
               unlink(cpytmp->fmpath);
               prfmsg(MOVRPT,cpytmp->fmpath);
               prf("\r");
          }
          if (libstt == CFLOG) {
               clrufl(BAKGND);         /* (keep create lock for login) */
          }
          else {
               libstt=LMSHORT;   /* done fooling with DOS->DOS mov/cpy */
          }
          break;
     case CFLFIN:         /* Copy LIB -> LIB or LIB -> DOS (see below) */
          break;
     }
}

STATIC void
bkgdlib(void)                      /* bkgsvc DLIB substt handler           */
{
     rollcall();
     while (rcbsig(libptr->sigbpr)) {             /* Deselect users    */
          libusr[othusn].selsig=mainsig;          /* absent fm Library */
          prfmsg(DSELING,othuap->userid);
     }
     if (libptr->selsig == libptr->sigbpr) {
          libptr->selsig=mainsig;                 /* Deselect yourself */
          prfmsg(DSELING,usaptr->userid);
     }
     gtgsig();
     prfmsg(DELING,sigbuf->name);
     strcpy((char *)vdaptr,sigbuf->name);     /* (remember doomed LIB) */
     delbtv();                                           /* DELETE LIB */
     prfmsg(DELINFM,(char *)vdaptr);
     shocst(spr("LIB DELETED:  %s",(char *)vdaptr),
         "The \"%s\" LIB was deleted from the File Library.",sigbuf->name);
     libstt=SGLGEN;
}

STATIC void
bkgkwb(void)                  /* move backward preparing for keyword search */
{
     if (!getkwd(1)) {
          libstt=LMSHORT;
          return;
     }
     signam(kwdbuf->sig);
     if (kwdprv()
      && (!tstufl(KWSILB) || sameas(kwdbuf->sig,sigkbf->name))
      && ( tstufl(KWSDNT) || kwdbuf->keywrd[0] > ' ')) {
          libptr->lnum=absbtv();
          libstt=KWSBKW;
     }
     else {
          prfmsg(KWSHED+tstufl(KWSDNT+KWSILB));
          prfmsg(KWSTOP);
          outprf(usrnum);
          libptr->ind++;
          libstt=KWSFWD;
     }
}

STATIC void
libstn(void)                             /* Library-specific status handler */
{
     setlib();
     switch (status) {

     case CYCLE:
          if (libptr->dribbl > 0) {               /* dribbl delays bkgsvc() */
               libptr->dribbl--;                        /* for a few cycles */
          }
          else if (!bkgsvc()) {
               break;
          }
          btuinj(usrnum,CYCLE);
          break;

     case OUTMT:
          switch (libstt=usrptr->substt) {
          case SHSELC:
               libpmt();
               break;
          case LIBNHLP2:
               libnedit();
               btuoes(usrnum,0);
               outprf(usrnum);
               break;
          case FILNHLP2:
               filnedit();
               btuoes(usrnum,0);
               outprf(usrnum);
               break;
          }
          break;

     default:
          dfsthn();
          break;
     }
}

STATIC void
libmcu(void)                /* prepare for auto-cleanup in the file library */
{
     libptr=libusr;                /* (for temporary use by sgl1st,nxt,fin) */
     vdaptr=vdaoff(0);             /* (for temporary use by sgl1st,nxt,fin) */
     libcup();
}

STATIC void
libhup(void)                                /* Library-specific user hangup */
{
     extern int errcod;                         /* exit code, in MAJORBBS.C */
     int i;

     setlib();
     clrufl(INLIB+FILRES+FNMRES+FRDRES+FWTRES);
     if (usrptr->state == libstate) {
          switch(libstt) {
          case SGLWAIT:   /* don't wait forever for LIB-list file to finish */
          case SHSEL:         /* don't complete a LIB-list to user's screen */
               break;
          default:
               if (errcod <= 1) {                   /* if not catastro, etc */
                    for (i=0 ; i < 1000 ; i++) {
                         if (!bkgsvc()) {  /* panic completion of bkg tasks */
                              break;
                         }
                    }
               }
               break;
          }
          lmreturn(); /* (may save ZMODEM file fragment for later recovery) */
          libzer();
     }
}

STATIC void
libcls(void)                                /* Library-specific system-down */
{
     free(libusr);
     clsbtv(kwdbb);
     clsbtv(filbb);
     clsbtv(sigbb);
     clsmsg(libmb);
}
