/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *   _____________                                                         *
 *  |             |  Here are some user-interactive utilities, like        *
 *  |  LIBDISP.C  |  long lists & menus.  Also includes command parsing,   *
 *  |_____________|  access checking, file transfer interface routines.    *
 *                                                                         *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.  All Rights Reserved        *
 *                                                                         *
 *                                                     RNStein  Apr 1992   *
 *                                                                         *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"
#include "gallibr.h"
#include "libdat.h"
#include "libutil.h"
#include "fsd.h"

/*  Local Variables  */
/*-------------------*/
static int tfslnt=0;                 /* global to tcflib (supress libpmt()) */
long byteroom;                                 /* return value of sigroom() */

void
kxfref(void)                         /* Cross-ref keyword data to File data */
{
     filkbf->status='A';
     stzcpy(filkbf->sig,mnutmp[libptr->ind].sig,LIBNAM+1);
     stzcpy(filkbf->name,mnutmp[libptr->ind].file,FILNAM+1);
     setbtv(filbb);
     if (!qeqbtv(NULL,0)) {
          setmem(filbuf,FKTSIZ,0);
          strcpy(filbuf->name,filkbf->name);  /* (show missing file's name) */
     }
     else {
          getfil(absbtv());
     }
}

void
kwsfil(void)          /* Record keyword info into temoporary menu structure */
{
     mnutmp[libptr->ind].kwdbpr=libptr->lnum;
     strcpy(mnutmp[libptr->ind].sig,kwdbuf->sig);
     strcpy(mnutmp[libptr->ind].file,kwdbuf->file);
     if (strchr(kwdbuf->keywrd,'.') != NULL) {
          strupr(kwdbuf->keywrd);
     }
     strcpy(mnutmp[libptr->ind].keywrd,kwdbuf->keywrd);
}

int
getkwd(                /* get back your place in a keyword scan, if you can */
int explain)                         /* 1=if you can't, let's hear about it */
{
     setbtv(kwdbb);
     if (aabbtv(NULL,libptr->lnum,tstufl(KWSILB))) {
          return(1);
     }
     if (explain) {
          prfmsg(KWSBOOM);
     }
     return(0);
}

int
kwdprv(void)                        /* is there a keyword looking backward? */
{
     setbtv(kwdbb);
     if (qprbtv()) {
          gcrbtv(NULL,tstufl(KWSILB));
          return(1);
     }
     return(0);
}

int
kwdnxt(void)                         /* is there a keyword looking forward? */
{
     setbtv(kwdbb);
     if (qnxbtv()) {
          gcrbtv(NULL,tstufl(KWSILB));
          return(1);
     }
     return(0);
}

void
rdtmpf(void)         /* Read target file and keywords into temporary buffer */
{
     gtgfil();
     movmem(filbuf,filtmp,FKTSIZ);
}

void
mknewf(                              /* create a brand new file data record */
struct fildat *filbpr)                          /* where to make the record */
                    /* assumes file name is in filkbf->name (from filnam()) */
                                    /* assumes libptr->sigbpr points to LIB */
{
     setmem(filbpr,FKTSIZ,0);
     filbpr->status='A';
     gtgsig();
     strcpy(filbpr->sig,sigbuf->name);
     strcpy(filbpr->name,filkbf->name);
     sprintf(filans(filbpr),"WHO=%s%c",usaptr->userid,'\0');
}

STATIC void
shokwds(void)
{
     int n,nans;
     char *ans,*cp;

     n=-1;
     for (ans=filans(filbuf) ; (nans=strlen(ans)) != 0 ; ans+=nans+1) {
          if (ans[0] == 'K'
           && isdigit(ans[1])
           && (cp=strchr(ans,'=')) != NULL) {
               if (n < 0) {
                    prfmsg(FILKPRE);
                    n=9;
               }
               if (n >= usaptr->scnwid-2-KWDLEN) {
                    prfmsg(FILKLIN);
                    n=9;
               }
               prfmsg(FILKWD,cp+1);
               n+=strlen(cp+1)+2;
          }
     }
}

void
shodesc(                             /* show long description (LIB or file) */
char *ans)                                          /* entire answer string */
{
     int nans,anyl;

     for (anyl=0 ; (nans=strlen(ans)) != 0 ; ans+=nans+1) {
          if (ans[0] == 'L' && isdigit(ans[1]) && ans[2] == '=') {
               prf("\n%s",ans+3);
               anyl=1;
          }
     }
     if (anyl) {
          prf("\r");
     }
}

void
shofil(void)                         /* Show information on the target file */
{                     /* (filbuf contains info, libptr->sigbpr is implicit) */
     gtgsig();
     if (sigbuf->flags&DOSONL) {
          prfmsg(FILENDOS);
     }
     else {
          prfmsg(FILEPRE);
          shokwds();
          prfmsg(FILEBTW);
          shodesc(filans(filbuf));
          prfmsg(FILEPST);
     }
}

long
filcst(                    /* Estimates total file download cost in credits */
long bytes)                                      /* number of bytes in file */
{                                        /* implicit input:  libptr->sigbpr */
     long cost;

     gtgsig();
     if (usrptr->flags&ISX25
      || grtype[grpnum[usrnum]] == GTLAN
      || sigbuf->flags&FREDNL) {
          cost=0L;
     }
     else {
          cost=(dnlsec(bytes)*usrptr->crdrat)/60;
     }
     return(cost+dnlprc(bytes));
}

long
dnlprc(                        /* price for downloading a file of this size */
long nbytes)                                     /* number of bytes in file */
{                                        /* implicit input:  libptr->sigbpr */
     int n;
     long ln;

          /* the easy formula:  (nbytes*sigbuf->dpkbyt)>>10                 */
          /* but this would overflow if the result were over 2 million      */
          /* so, to avoid overflow and preserve accuracy...                 */

     gtgsig();
     for (n=10 ; n > 0 && nbytes > (1L<<15) ; n--) {
          nbytes>>=1;
     }
     for (ln=sigbuf->dpkbyt ; n > 0 && ln > (1L<<15) ; n--) {
          ln>>=1;
     }
     ln*=nbytes;
     if (n > 0) {
          ln>>=n;
     }
     return(ln+sigbuf->dpfile);     /* result has up to 15 significant bits */
}

long
dnlsec(                                /* Estimate download time in seconds */
long bytes)                                 /* implicitly uses usrptr->baud */
{               /* Formula:  seconds = #bytes / (baud/10)*(%efficiency/100) */
     long ln;

     ln=(usrptr->baud+0L)*comeff;
     if (ln == 0L) {
          return(0L);
     }
     if (bytes < 2000000L) {
          ln=(bytes*1000+(ln>>1))/ln;
     }
     else {
          ln=ln/1000;
          ln=(bytes+(ln>>1))/ln;
     }
     return(ln);
}

void
ddr1st(                             /* Generate DOS-like directory of files */
char *path,
int mask)            /* FAMDIR to include sub-directories, 0 for just files */
{
     char buff[80];
     char *cp;

     if ((cp=strchr(path,':')) != NULL && cp > path) {
          libptr->ind=toupper(cp[-1])-'A'+1;
     }
     else {
          libptr->ind=0;
     }
     libptr->lnum=0L;
     libptr->lnum2=0L;
     stzcpy(buff,path,80-5);
     setftu();                            /* (steal FTF's struct fndblk fb) */
     switch (buff[strlen(buff)-1]) {
     case ':':
     case '\\':
          strcat(buff,"*.*");
          libptr->num=fnd1st(&ftuptr->fb,buff,mask);
          break;
     default:
          if (fnd1st(&ftuptr->fb,buff,mask)) {
               if (ftuptr->fb.attr&FAMDIR) {
                    strcat(buff,"\\*.*");
                    if(!fnd1st(&ftuptr->fb,buff,mask)) {
                         buff[strlen(buff)-4]='\0';
                         fnd1st(&ftuptr->fb,buff,mask);
                    }
               }
               libptr->num=1;
               break;
          }
          libptr->num=0;
          break;
     }
}

int
ddrnxt(void)           /* Continue generating DOS-like directories of files */
{
     if (libptr->num) {
          setftu();                  /* (steal FTF's struct fndblk fb) */
          prf(ftuptr->fb.attr&FAMDIR ? "%-13.13s <DIR>   "
                                     : "%-13.13s%9.9s",
              ftuptr->fb.name,l2as(ftuptr->fb.size));
          prf("  %s  %-5.5s\r",ncdate(ftuptr->fb.date),
                               nctime(ftuptr->fb.time));
          libptr->lnum2+=ftuptr->fb.size;
          libptr->lnum++;
          if (!fndnxt(&ftuptr->fb)) {
               libptr->num=0;
          }
          return(1);
     }
     else {
          if (libptr->lnum > 0L) {
               prf("%9s File(s)\r%9s total bytes in these files\r",
                   l2as(libptr->lnum),l2as(libptr->lnum2));
          }
          else {
               prf("      No Files\r");
          }
          if (libptr->ind >= 0) {
               prf("%9s bytes free on this disk\r",l2as(dskfre(libptr->ind)));
          }
          return(0);
     }
}

void
ual1st(void)    /* Prepare for unapproved file list (selected LIB implicit) */
{
     gslsig();
     filkbf->status='U';
     setmem(filkbf->sig,LIBNAM+1,0);
     if (libptr->selsig != mainsig) {
          strcpy(filkbf->sig,sigbuf->name);
     }
     setmem(filkbf->name,FILNAM+1,0);
     libptr->lnum=0L;
     setbtv(filbb);
     if (!qgebtv(NULL,0) || filkbf->status != 'U') {
          libptr->filbpr=0L;
          return;                                    /* no unapproved files */
     }
     if (sameas(filkbf->sig,sigbuf->name)) {
          libptr->filbpr=absbtv();
          libptr->sigbpr=libptr->selsig;
          prfmsg(UAL1ST,sigbuf->name,liblin());
          return;                                  /* first unapproved file */
     }
     if (libptr->selsig == mainsig) {
          libptr->filbpr=absbtv();
          setbtv(sigbb);
          geqbtv(NULL,filkbf->sig,0);
          astlib();
          libptr->sigbpr=absbtv();
          prfmsg(UAL1ST,sigbuf->name,liblin());
          return;                   /* first unapproved file in master list */
     }
     libptr->filbpr=0L;
     return;                                 /* no unapproved files to list */
}

int
ualnxt(void)                                   /* Show next unnaproved file */
{     /* returns number of lines that will be output by NEXT call to ualnxt */
     if (libptr->filbpr != 0L) {
          gtgsig();
          gtgfil();
          if (!sameas(sigbuf->name,filbuf->sig)) {
               prfmsg(UALFIN,l2as(libptr->lnum));
               libptr->lnum=0L;
               setbtv(sigbb);
               geqbtv(NULL,filbuf->sig,0);
               astlib();
               libptr->sigbpr=absbtv();
               prfmsg(UAL1ST,sigbuf->name,liblin());
          }
          prfmsg(UALNXT,filbuf->name,l2as(filbuf->size),
                        fsdxan(filans(filbuf),"WHO"),fillin());
          libptr->lnum++;
          setbtv(filbb);
          if (!qnxbtv() || filkbf->status != 'U') {
               libptr->filbpr=0L;
               return(2);              /* no more unapproved files (footer) */
          }
          if (sameas(filkbf->sig,sigbuf->name)) {
               libptr->filbpr=absbtv();
               return(1);               /* next unapp file, same sig (line) */
          }
          if (libptr->selsig == mainsig) {
               libptr->filbpr=absbtv();
               return(8); /* next unapp file, next sig (footer+header+line) */
          }
          libptr->filbpr=0L;
          return(2);           /* no more unapproved files to list (footer) */
     }
     else {
          prfmsg(UALFIN,l2as(libptr->lnum));
          return(0);
     }
}

/*--- PARSING AND COMMAND CHECKING ---*/

int
wildcmd(void)                  /* Are there wildcard characters in command? */
{
     int rc=0;

     if (strchr(cmdptr,'*') || strchr(cmdptr,'?')) {
          prfmsg(FDWILD);
          rc=1;
     }
     return(rc);
}

int
fnresv(void)                           /* Rebuke user if file name reserved */
{
     if (namres) {
          prfmsg(FNRESERV,cmdptr);
          return(1);
     }
     return(0);
}

int
snresv(void)                            /* Rebuke user if LIB name reserved */
{
     if (namres) {
          prfmsg(RESLIB,sigkbf->name);
          return(1);
     }
     return(0);
}

int
fnwbad(void)                          /* Is new sig\file specification bad? */
{
     if (!filnam(libptr->selsig,cmdptr)) {
          if (siggvn == 0L && filkbf->name[0] == '\0') {
               prfmsg(NOSUCH1,sigkbf->name);
          }
          else {
               prfmsg(namres ? FNRESERV : FNBAD,cmdptr);
          }
          return(1);
     }
     return(0);
}

int
fsnbad(                                 /* Is a sig\file specification bad? */
int bfmsg)                                         /* message to give if so */
{
     if (!filnam(libptr->selsig,cmdptr)) {
          if (bfmsg == 0) {
          }
          else if (siggvn == 0L && filkbf->name[0] == '\0') {
               prfmsg(NOSUCH1,sigkbf->name);
          }
          else {
               getsig(siggvn);
               prfmsg(bfmsg,cmdptr,sigbuf->name);
          }
          return(1);
     }
     return(0);
}

int
fdosalr(                  /* Rebuke user if file name already exists in DOS */
int msg,
char *fname)
{
     struct fndblk fb;

     if (fnd1st(&fb,fname,FAMDIR)) {
          prfmsg(msg,fname);
          return(1);
     }
     return(0);
}

int
lbncant(            /* Detects modification of approved file on another LIB */
int msg)                                        /* message to provide if so */
{
     getsig(siggvn);
     if (siggvn != libptr->selsig        /* if file not in the current LIB, */
      && !(sigbuf->flags&DOSONL)              /* and not in a DOS-only LIB, */
      && filtmp->status == 'A') {     /* and file is approved for download, */
          prfmsg(msg);                   /* then, sorry, we cant modify it. */
          lmreturn();
          return(1);
     }
     return(0);
}

int
helpusr(msg,p1,p2,p3,p4)                     /* Help user if he asks for it */
int msg;
long p1,p2,p3,p4;
{
     if (sameas(cmdptr,"?")) {
          prfmsg(msg,p1,p2,p3,p4);
          return(1);
     }
     return(0);
}

int
nodosf(path,msg,p1,p2,p3)              /* Rebuke user if no DOS file exists */
char *path;
int msg;
long p1,p2,p3;
{
     struct fndblk fb;

     if (!fnd1st(&fb,path,0)) {
          prfmsg(msg,p1,p2,p3);
          return(1);
     }
     return(0);
}

int
fexist(                                       /* Rebuke user if file exists */
int msg)
{
     if (isfil('A') || isfil('U')) {
          getfil(absbtv());
          if (msg != 0) {
               prfmsg(msg,filkbf->name,sigkbf->name,fillin());
          }
          return(1);
     }
     return(0);
}

int
snoexs(                                /* Rebuke user if LIB does not exist */
int explain)         /* 1=rebuke with message 0=don't rebuke, just return 1 */
                                     /* side effect:  libptr->sigbpr is set */
                               /* must call right after filnam() or isfil() */
{
     if (!chksig()) {
          if (explain) {
               prfmsg(NOSUCH1,sigkbf->name);
          }
          return(1);
     }
     return(0);
}

int
signow(                        /* Rebuke if cannot write to LIB (read-only) */
char *doing)                            /* whats he trying to do to the LIB */
                                     /* NULL if we don't want to rebuke him */
{
     gtgsig();
     if (sigbuf->flags&RDONLY) {
          if (doing != NULL) {
               prfmsg(LIBNOW,doing,sigbuf->name);
          }
          return(1);
     }
     return(0);
}

int
snosel(                /* Rebuke user if specified LIB not the selected LIB */
int msg)
{
     if (siggvn != libptr->selsig) {
          prfmsg(msg,sigkbf->name);
          return(1);
     }
     return(0);
}

int
chksig(void)                       /* makes sure explicit LIB really exists */
                  /* 1=exists or implicit lib, 0=explicit lib doesn't exist */
                                     /* side effect:  libptr->sigbpr is set */
                              /* must call right after filnam() or signam() */
{
     if (siggvn == 0L) {
          if (!issig()) {
               return(0);
          }
          siggvn=absbtv();
     }
     getsig(libptr->sigbpr=siggvn);
     if (!keypass("VISIBL",NULL)) {
          siggvn=0L;
          return(0);
     }
     return(1);
}

int
uploader(void)                        /* is this the uploader of this file? */
                                  /* expects isfil() has just returned true */
{
     setbtv(filbb);
     getfil(absbtv());
     return(sameas(fsdxan(filans(filbuf),"WHO"),usaptr->userid));
}

STATIC int
ucanseef(void)                     /* Is there a file for this user to see? */
                  /* allows libop, sysop & uploader to see unapproved files */
                               /* sees if DOS file exists in a DOS-only LIB */
          /* call immediately after filnam() call (or fsnbad() or fnwbad()) */

  /*                                  libptr->                              */
  /*   Cases:       ret val  siggvn    filbpr    sigkbf->name  filbuf->name */
  /*   No such LIB     0       0L        ---      something        ---      */
  /*   No such file    0     LIB ptr     ---       LIB name        ---      */
  /*   LIB file exists 1     LIB ptr   file ptr    LIB name     file name   */
  /*   DOS-only file   1     LIB ptr      0L       LIB name     file name   */

           /* When returning 1, also fills up filbuf buffer with file info. */
                                   /* and points libptr->sigbpr to LIB info */
{
     struct fndblk fb;

     if (chksig()) {                 /* side effect:  libptr->sigbpr is set */
          if (sigbuf->flags&DOSONL) {
               if (fnd1st(&fb,path(libptr->sigbpr,filkbf->name),0)) {
                    mknewf(filbuf);
                    filbuf->size=fb.size;
                    filbuf->date=fb.date;
                    filbuf->time=fb.time;
                    libptr->filbpr=0L;
                    return(1);
               }
          }
          else if (isfil('A')
                || isfil('U') && (libops(libptr->sigbpr) || uploader())) {
               setbtv(filbb);
               libptr->filbpr=absbtv();
               gtgfil();
               return(1);
          }
     }
     return(0);
}

int
ucansee(                           /* Is there a file for this user to see? */
int msg)                                 /* error message, or 0 to be quiet */
             /* if true, leaves file data in both filbuf and filtmp buffers */
                                   /* and points libptr->sigbpr to LIB info */
{
     if (ucanseef()) {
          movmem(filbuf,filtmp,FKTSIZ);
          return(1);
     }
     else {
          if (msg != 0) {
               prfmsg(msg,filkbf->name,sigkbf->name);
          }
          return(0);
     }
}

int
tfstat(                    /* Rebuke user if status of target file is wrong */
char stat,
int msg)
{
     gtgfil();
     if (filbuf->status == stat) {
          prfmsg(msg,filkbf->name);
          return(1);
     }
     return(0);
}

int
ckroom(                                    /* Check on room in LIB for file */
int tough)                   /* Give a warning if LIB size limit constrains */
{
     int rc=1;

     if (sigroom(libptr->sigbpr) < 1L && !libsys()) {
          prfmsg(UFULL);
          rc=0;
     }
     else if (byteroom < sigbuf->maxbup && !libsys()) {
          if (byteroom <= 3L) {
               prfmsg(USFULL);
               rc=0;
          }
          else if (tough) {
               prfmsg(USWARN1,l2as(byteroom));
          }
     }
     return(rc);
}

int
fwtres(                                             /* Write-reserve a file */
char *usage)            /* what you're doing with it, or NULL to keep quiet */
                            /* implicit input: libptr->sigbpr, filtmp->name */
{
     if (reschk(libptr->sigbpr,filtmp->name,FRDRES+FWTRES+FNMRES)) {
          if (usage != NULL) {
               gtgsig();
               prfmsg(libops(libptr->sigbpr) ? FUSESYS : FUSING,
                      filtmp->name,sigbuf->name,usage,othuap->userid);
          }
          return(0);
     }
     strcpy(libptr->filres,filtmp->name);
     libptr->sigres=libptr->sigbpr;
     setufl(FWTRES);
     return(1);
}

int
frdres(                                      /* Read-reserve a Library file */
char *fname,                                                   /* file name */
int explain)                       /* 1=explain why 0=just return yes or no */
                                          /* implicit input: libptr->sigbpr */
{
     if (reschk(libptr->sigbpr,fname,FWTRES+FNMRES)) {
          if (explain) {
               gtgsig();
               prfmsg(libops(libptr->sigbpr) ? FREPSYS : FREPAIR,
                      fname,sigbuf->name,othuap->userid);
          }
          return(0);
     }
     strcpy(libptr->filres,fname);
     libptr->sigres=libptr->sigbpr;
     setufl(FRDRES);
     return(1);
}

int
fnmres(                    /* Make sure no one else is using this file name */
int explain)                /* 1=tell who if they are, 0=just say yes or no */
                            /* implicit input: libptr->sigbpr, filtmp->name */
{
     if (reschk(libptr->sigbpr,filtmp->name,FNMRES)) {
          if (explain) {
               gtgsig();
               prfmsg(libops(libptr->sigbpr) ? FNAMRES : UFNAMRES,
                      filtmp->name,sigbuf->name,othuap->userid);
          }
          return(0);
     }
     strcpy(libptr->filre2,filtmp->name);
     libptr->sigre2=libptr->sigbpr;
     setufl(FNMRES);
     return(1);
}

int
doncant(                        /* rebuff if trying to do in a DOS-only LIB */
char *doing)                                           /* what trying to do */
{
     gtgsig();
     if (sigbuf->flags&DOSONL) {
          prfmsg(DOCANT,sigbuf->name,doing);
          return(1);
     }
     return(0);
}

int
lopres(                                          /* reserve LIB-Op function */
int explain)
{
     rollcall();
     if (rclop()) {
          if (explain) {
               prfmsg(LOPOUT);
          }
          return(0);
     }
     setufl(LOPRES);
     return(1);
}

int
sigdie(                                            /* Is LIB being deleted? */
long sigbpr,
int explain)                       /* 1=explain why 0=just return yes or no */
{
     getsig(sigbpr);
     if (sigbuf->flags&DYING) {
          if (explain) {
               prfmsg(LIBDIE,sigbuf->name);
          }
          return(1);
     }
     libptr->sigbpr=sigbpr;       /* VERY IMPORTANT SIDE EFFECT of sigdie() */
     return(0);
}

void
uprept(                    /* Report number of uploads today, and this week */
int spacit)                          /* 1=prepend CRLF if any report at all */
{                                                  /* sigbuf implicit input */
     int totday,totwk,i,wksat,daymsg;

     for (i=6,totwk=0,wksat=0 ; i >= 0 ; i--) {
          totwk+=(totday=sigbuf->upday[i]);
          wksat=wksat || totday == 255;
     }
     if (totwk == 0) {
          return;
     }
     if (spacit) {
          prf("\r");
     }
     switch (totday) {
     case 0:
          daymsg=UPDAY0;
          break;
     case 1:
          daymsg=UPDAY1;
          break;
     default:
          daymsg=UPDAYN;
          break;
     case 255:
          daymsg=UPDAYM;
          break;
     }
     prfmsg(daymsg,totday);
     if (totwk > totday) {
          prfmsg(wksat ? UPWEEKM : UPWEEK,totwk,totwk == 1 ? "" : "s");
     }
}


/*--- General purpose protocol routines ---*/

int
daford(                           /* can user afford to download this file? */
int explain)                                       /* 1=if not, tell him so */
{                                /* expects filbuf->size to be size of file */
     if (!tstcrd(dnlprc(filbuf->size))) {
          if (explain) {
               prfmsg(DPBUST);
          }
          return(0);
     }
     return(1);
}

STATIC void
dncfin(                                        /* finalize download charges */
int nmltrm,                                         /* 1=finished 0=aborted */
long nbytes)
{           /* libptr->sigbpr must point to sig of file that was downloaded */
                                            /* filbuf->name is name of file */
     if ((nmltrm || chgabt == 1)
      && (!isautf(filbuf->name) || chgsys)) {
          dlcharge(dnlprc(nbytes));
     }
}

void
dlcharge(               /* charge user for download (w/royalty to uploader) */
long amount)                                           /* amount of credits */
{             /* assumes sigbuf contains LIB data, usaptr pts to downloader */
     char *who;

     dedcrd(amount,1);
     if (libptr->filbpr != 0L) {
          gtgfil();
          if (!sameas(who=fsdxan(filans(filbuf),"WHO"),"Sysop")) {
               amount=(amount*sigbuf->uplroy)/100L;
               if (amount > 0L) {
                    crdusr(who,l2as(amount),0,0);
               }
          }
     }
}

long
sigroom(                        /* How much room in this LIB for an upload? */
long sigbpr)                           /* pointer to LIB data in LIBSIG.DAT */
{                    /* returns room in #files, sets byteroom=room in bytes */
     getsig(sigbpr);
     if (sigbuf->flags&DOSONL) {
          cntdir(path(sigbpr,"*.*"));
     }
     else {
          numfils=sigbuf->appfil+sigbuf->uapfil;
          numbyts=sigbuf->appbyt+sigbuf->uapbyt;
     }
     byteroom=min(sigbuf->maxbup,sigbuf->maxbyt-numbyts);
     return(sigbuf->maxfil-numfils);
}

/*--- Downloading Interface to FTG.H and FILEXFER.C for the File Library ---*/

STATIC void
sngmsg(void)                    /* make a single-file sub-tagspec in tshmsg */

{
     movmem(ltgptr,tshmsg,sizeof(*ltgptr));
     movmem(ftuptr->fb.name,((struct ftglib *)&tshmsg)->filspc,FILNAM+1);
}

STATIC void
auddn(                                    /* record download in audit trail */
int good)                                         /* 1=completed, 0=aborted */
{                          /* libptr->sigbpr and filbuf are implicit inputs */
     gtgsig();
     if (sigbuf->flags&DNLAUD && !tstufl(FCOMMD)) {
          shocst(good ? "LIBRARY FILE DOWNLOAD"
                      : "LIBRARY FILE DOWNLOAD ABORTED",
                 good ? "User %s download %s\\%s"
                      : "User %s aborted dnld of %s\\%s",usaptr->userid,
                                                  filbuf->sig,filbuf->name);
     }
}

STATIC void
zapcrd(int yes)                         /* stop charging credits 1=yes 0=no */
{
     libptr->num=usrptr->crdrat;
     libptr->ind=(int)(usrptr->flags&NOZAP);
     if (yes) {
          usrptr->crdrat=0;
          usrptr->flags|=NOZAP;
     }
}

STATIC void
rstcrd(void)                                         /* restore from zapcrd */
{
     usrptr->crdrat=libptr->num;
     usrptr->flags&=~(libptr->ind^NOZAP);
}

STATIC int
tshlib(int tshcod)                  /* Handle tagspecs for the File Library */
{                           /* implicit inputs: ftgptr,usrnum,usrptr,usaptr */
                             /* for TSHFIN and TSHHUP, vdaptr is also valid */
                                  /* return value meaning depends on tshcod */
                             /* implicit input/output in many cases: tshmsg */
                                     /* expect caller to do outprf() if any */
     int rc=0;
     FILE *fp;

     setlib();
     switch(tshcod) {
     case TSHDSC:                            /* Describe tagspec in English */
          getsig(ltgptr->sigbpr);
          sprintf(tshmsg,"file%s \"%s\" in the %s LIB",
                  ftgptr->flags&FTGWLD ? "s" : "",
                  ltgptr->filspc,sigbuf->name);
          break;
     case TSHVIS:                                  /* Visible to this user? */
          if (filnam(ltgptr->sigbpr,ltgptr->filspc) && ucanseef()) {
               if ((fp=fopen(path(ltgptr->sigbpr,
                                  ltgptr->filspc),FOPRB)) != NULL) {
                    fread(tshmsg,1,TSHLEN,fp);
                    fclose(fp);
               }
               rc=1;
          }
          break;
     case TSHSCN:             /* Scan of multi-file wildcard tagspec begins */
          if (fnd1st(&ftuptr->fb,path(ltgptr->sigbpr,ltgptr->filspc),0)) {
               sngmsg();
               rc=1;
          }
          break;
     case TSHNXT:                             /* Next file in wildcard scan */
          if (fndnxt(&ftuptr->fb)) {
               sngmsg();
               rc=1;
          }
          break;
     case TSHBEG:              /* Begin download, check permission, reserve */
          libptr->sigbpr=ltgptr->sigbpr;
          gtgsig();
          if (!filnam(ltgptr->sigbpr,ltgptr->filspc)
           || siggvn != ltgptr->sigbpr
           || !ucanseef()) {
               sprintf(tshmsg,"There is no file \"%s\" in the %s LIB available"
                              " to you.",ltgptr->filspc,sigbuf->name);
          }
          else if (!keypass("DOWNLD",NULL) && !tstufl(FCOMMD)) {
               sprintf(tshmsg,"You don't have download access to the %s LIB.",
                              sigbuf->name);
          }
          else if (!smlchk(0)) {
               sprintf(tshmsg,"You don't have access to the MAIN\\%s file",
                              filbuf->name);
          }
          else if (sigdie(siggvn,0)) {
               sprintf(tshmsg,"LIB %s is being deleted.",sigbuf->name);
          }
          else if (!daford(0) && !tstufl(FCOMMD) && !sameas(ftfpsp->code,"V")) {
               sprintf(tshmsg,"You don't have enough credits to download"
                              " \"%s\\%s\".",sigbuf->name,ltgptr->filspc);
          }
          else if (!frdres(filbuf->name,0)) {
               sprintf(tshmsg,"File \"%s\\%s\" is temporarily closed for"
                              " updating.",sigbuf->name,ltgptr->filspc);
          }
          else {
               zapcrd(sigbuf->flags&FREDNL);
               strcpy(ftfscb->fname,ltgptr->filspc);
               strcpy(tshmsg,path(ltgptr->sigbpr,ltgptr->filspc));
               rc=1;
          }
          break;
     case TSHEND:             /* End complete download of a file, unreserve */
          clrufl(FRDRES);
          if (!tstufl(FCOMMD) && !sameas(ftfpsp->code,"V")) {
               if (filnam(ltgptr->sigbpr,ltgptr->filspc) && ucanseef()) {
                    auddn(1);
                    dncfin(1,ftfscb->actbyt);
               }
               sv.dwnlds++;
               if (libptr->filbpr != 0L) {
                    gtgfil();
                    filbuf->numdld++;
                    updfil(NULL);
               }
          }
          rstcrd();
          break;
     case TSHSKP:                     /* Skip incomplete download of a file */
          clrufl(FRDRES);
          if (filnam(ltgptr->sigbpr,ltgptr->filspc) && ucanseef()) {
               auddn(0);
               dncfin(0,ftfscb->actbyt);
          }
          rstcrd();
          break;
     case TSHFIN:                           /* Finish file transfer session */
          usrptr->state=libstate;
          usrptr->substt=LMSHORT;
          setlib();
          libpmt();
          prf("");
          rc=1;
          break;
     case TSHHUP:                /* Finish session because user logging off */
          break;
     }
     return(rc);
}

void
prptsp(                          /* prepare tagspec for download submission */
int wild)                      /* 1=wild, multi-file download 0=single file */
                                    /* inputs: filkbf->name, libptr->sigbpr */
{                    /* this is what's needed between ftgnew() and ftgsbm() */
     ltgptr->sigbpr=libptr->sigbpr;
     movmem(filkbf->name,ltgptr->filspc,FILNAM+1);
     ftgptr->flags=(wild             ? FTGWLD : 0)
                  +(hasmkey(TAGLOCK) ? FTGABL : 0);
     ftgptr->tshndl=tshlib;
}

STATIC void
tcflib(void)       /* return to File Library after downloading tagged files */
{
     usrptr->state=libstate;
     usrptr->substt=LMSHORT;
     setlib();
     if (!tfslnt) {
          libpmt();
          prf("");
     }
}

void
tagmnu(                                             /* display tagging menu */
char *cmd,                                /* initial command, or "" if none */
int silent)                            /* 1=silent 0=display Library prompt */
{
     tfslnt=silent;
     ftgdnl(cmd,tcflib);
     tfslnt=0;
}

/*--- Uploading Interface to FUP.H and FILEXFER.C for the File Library ---*/

STATIC void
audup(                                      /* record upload in audit trail */
int good)                             /* "->" if completed, "-)" if aborted */
{                  /* libptr->sigbpr and libptr->filbpr are implicit inputs */
     gtgsig();
     if (sigbuf->flags&UPLAUD) {
          shocst(good ? "LIBRARY FILE UPLOAD"
                      : "LIBRARY FILE UPLOAD ABORTED",
                 good ? "User %s uploaded %s\\%s"
                      : "User %s aborted upld of %s\\%s",usaptr->userid,
                                                  filtmp->sig,filtmp->name);
     }
}

STATIC void
logprp(void)                               /* prepare file to get logged in */
{
     if (sigbuf->flags&DOSONL) {
          updcnt(libptr->sigbpr,'A',1L+libptr->filbpr,0L,0,0);
                                           /* if new file, updcnt(,,1L,,,), */
                                    /* but if reuploading, updcnt(,,0L,,,)  */
          clrufl(FNMRES+FWTRES);
     }
     else {
          fsdpan(filans(filtmp),"WHO",usaptr->userid);
          libptr->savstt=usrptr->state;
          libptr->savsbs=usrptr->substt;
          usrptr->state=libstate;
          usrptr->substt=(libptr->filbpr == 0L ? CTMFIL :
                          (filtmp->status == 'A' ? REDOKWD : UTMFIL));
          libptr->linkst=FUPLOG;               /* (sneakily glom onto FILE- */
          setufl(BKSLNT+BAKGND);              /* XFER's CYCLEs for a while) */
     }
}

STATIC int
fuplib(int fupcod)                   /* Handle uploads for the File Library */
{                          /* implicit inputs:  usrnum,usrptr,usaptr,vdaptr */
                                  /* return value meaning depends on fupcod */
                             /* implicit input/output in many cases: fupmsg */
                                     /* expect caller to do outprf() if any */
     int rc=0;
     int msg;

     setlib();
     switch(fupcod) {
     case FUPPTH:                  /* Find out what path the file would use */
          sprintf(ftfbuf,path(libptr->sigbpr,tstufl(MULTUP) ? ftfscb->fname
                                                            : filtmp->name));
          gtgsig();
          if (sigbuf->flags&DOSONL) {
               rc=2;
          }
          else {
               rc=1;
               if (tstufl(MULTUP)) {
                    if (filnam(libptr->sigbpr,ftfscb->fname)
                     && (isfil('A') || isfil('U'))
                     && uploader()) {
                         getfil(absbtv());
                         if (sameas(fillin(),getmsg(ZPDESC))) {
                              rc=2;
                         }
                    }
               }
               else {
                    if (sameas(fsdxan(filans(filtmp),"S"),getmsg(ZPDESC))
                     && sameas(fsdxan(filans(filtmp),"WHO"),usaptr->userid)) {
                         rc=2;
                    }
               }
          }
          break;
     case FUPBEG:                /* Begin upload, check permission, reserve */
          if (sigroom(libptr->sigbpr) <= 0L && !libsys()) {
               strcpy(ftfbuf,"Too many files already in this LIB.");
               break;
          }
          if (!libsys()) {
               ftfscb->maxbyt=byteroom;
          }
          if (!tstufl(MULTUP)) {
               if (ftfscb->actfil >= 1) {
                    strcpy(ftfbuf,"You can't upload more than 1 file this way."
                                  "\rType \"U *\" to upload multiple files.");
               }
               else {
                    sprintf(ftfbuf,path(libptr->sigbpr,filtmp->name));
                    rc=1;              /* (overrides protocol name, if any) */
               }
          }
          else {
               if (ftfscb->fname[0] == '\0') {
                    strcpy(ftfbuf,"No file name from the sender,"
                                  " multi-file uploads not allowed.");
               }
               else if (!filnam(libptr->sigbpr,ftfscb->fname)
                     || siggvn != libptr->sigbpr) {
                    sprintf(ftfbuf,namres ? "Reserved file name: \"%s\"."
                                          : "Not a valid file name: \"%s\".",
                                             ftfscb->fname);
               }
               else if (umlimit > 0 && ftfscb->actfil >= umlimit && !libop()) {
                    sprintf(ftfbuf,
                            "Too many files uploaded at once, stopping at %d.",
                                                                       umlimit);
               }
               else if (!okrupl(0) && !okupl(0)) {
                    strcpy(ftfbuf,"Not allowed to upload this file.");
               }
               else {
                    sprintf(ftfbuf,path(libptr->sigbpr,filtmp->name));
                    rc=1;
               }
          }
          break;
     case FUPEND:               /* End complete upload of a file, unreserve */
          audup(1);
          sv.uplds++;
          gtgsig();
          logprp();
          if (!(sigbuf->flags&DOSONL)
           && sameas(fsdxan(filans(filtmp),"S"),getmsg(ZPDESC))) {
               fsdpan(filans(filtmp),"S","");
          }
          sprintf(ftfbuf,path(libptr->sigbpr,filtmp->name));
          clrufl(ZFRAGM);
          break;
     case FUPSKP:                       /* Skip incomplete upload of a file */
          audup(0);
          if (sameas(ftfpsp->code,"Z") && zuresume) {
               gtgsig();
               logprp();
               if (!(sigbuf->flags&DOSONL)) {
                    fsdpan(filans(filtmp),"S",getmsg(ZPDESC));
               }
               setufl(ZFRAGM);
          }
          else {
               unlink(path(libptr->sigbpr,filtmp->name));
               clrufl(ZFRAGM);
          }
          break;
     case FUPFIN:                             /* Finish file upload session */
          btulok(usrnum,0);
          rstcrd();
          usrptr->state=libstate;
          usrptr->substt=LMSHORT;
          setlib();
          if (tstufl(ZFRAGM)) {
               gtgsig();
               if (sigbuf->flags&DOSONL) {
                    prfmsg(UZFRAGD,l2as(ftfscb->actbyt),filtmp->name,
                                                        filtmp->name,
                                                        sigbuf->name);
               }
               else {
                    prfmsg(UZFRAG,l2as(ftfscb->actbyt),filtmp->name,
                                  fsdxan(filans(filtmp),"S"),filtmp->name,
                                                             sigbuf->name);
               }
          }
          else if (ftfscb->actfil == 1 && ftfscb->tryfil == 1) {
               gtgsig();
               if (sigbuf->flags&DOSONL) {
                    msg=UEXITD;
               }
               else if (*fsdxan(filans(filtmp),"L0") != '\0'
                     || *fsdxan(filans(filtmp),"K0") != '\0') {
                    msg=UEXITRE;
               }
               else if (keypass("PREAPP",NULL)) {
                    msg=UEXITA;
               }
               else {
                    msg=UEXIT;
               }
               prfmsg(msg,filtmp->sig,filtmp->name);
          }
          else if (ftfscb->actfil >= 1) {
               prfmsg(sigbuf->flags&DOSONL ? UEXITDN :
                   (keypass("PREAPP",NULL) ? UEXITAN : UEXITN),
                         l2as(ftfscb->actfil));
          }
          sigroom(libptr->sigbpr);
          if (byteroom < 0L) {
               prfmsg(USSOP,l2as(numbyts),l2as(-byteroom));
          }
          libpmt();
          prf("");
          rc=1;
          break;
     case FUPHUP:                /* Finish session because user logging off */
          btulok(usrnum,0);
          rstcrd();
          break;
     }
     return(rc);
}

void
prpup(     /* prepare for upload (like goupld(), but protocol is parameter) */
char *protocol)
{
     gtgsig();
     zapcrd(sigbuf->flags&FREUPL);
     filtmp->name[0] == '\0' ? setufl(MULTUP) : clrufl(MULTUP);
     clrufl(LOGPND+ZFRAGM);
     fileup(filtmp->name,protocol,fuplib);
}

void
goupld(                                                  /* initiate upload */
int expprt)                                        /* is protocol explicit? */
{                /* filtmp->name is nominal file name, or "" for multi-file */
                                       /* libptr->sigbpr is LIB to put into */
     prpup((expprt && margi < margc-1) ? margv[margi+1] : "?");
}

/*--- Locks & Keys & other restrictions ---*/

int
libkey(                              /* does user have the appropriate key? */
long sigbpr,                                            /* for explicit LIB */
char *keyname,                                /* name of key (see LIBDAT.H) */
int picky)         /* 1=reject if no lock 0=no lock means anyone can access */
{                     /* (note, keypass() is used more often than libkey()) */
     char *cp;

     getsig(sigbpr);
     cp=fsdxan(libans(sigbuf),keyname);
     if (*cp == '\0') {
          return(!picky);
     }
     return(haskey(cp));
}

int
keypass(                               /* does this guy have the right key? */
char *kname,                                  /* name of key (see LIBDAT.H) */
char *doing)                        /* type of access, or NULL to be silent */
{                                                /* libptr->sigbpr implicit */
     if (!libkey(libptr->sigbpr,kname,0)
      && !libops(libptr->sigbpr)) {
          if (doing != NULL) {
               gtgsig();
               prfmsg(SNOKEY,doing,sigbuf->name);
          }
          return(0);
     }
     return(1);
}

int
libop(void)                       /* is user the libop of the selected LIB? */
{
     return(libops(libptr->selsig));
}

int
libops(                             /* is user the libop of a specific LIB? */
long sigbpr)
{
     getsig(sigbpr);
     return(libkey(sigbpr,"LIBLOK",1)
         || sameas(sigbuf->libop,usaptr->userid)
         || libsys());
}

int
libsys(void)                     /* is user the Sysop for the File Library? */
{
     return(haskey(fsyslock));
}

int
smlchk(                 /* check against access to system files in MAIN LIB */
int explain)                                  /* 1=if not, tell us about it */
{                                /* libptr->sigbpr, filbuf->name are inputs */
     if (libptr->sigbpr == mainsig
      && isautf(filbuf->name)
      && !hasmkey(SMLOCK)
      && !libops(mainsig)) {
          if (explain) {
               prfmsg(SMNOKEY,filbuf->name);
          }
          return(0);
     }
     return(1);
}

int
smwchk(                          /* check against overwriting a system file */
int explain)                                           /* 1=if not, tell us */
{                                /* libptr->sigbpr, filtmp->name are inputs */
     gtgsig();
     if (!(sigbuf->flags&DOSONL)
      && isautf(filtmp->name)
      && !libop()) {
          if (explain) {
               prfmsg(SMWNOT,filtmp->name,sigbuf->name);
          }
          return(0);
     }
     return(1);
}

int
socheck(void)    /* check that the Sysop is the only one doing these things */
{
     if (libsys()) {
          return(1);
     }
     prfmsg(SNOSYS);
     return(0);
}

int
locheck(void)         /* check that LIB-Op has LIB-Op key to the TARGET LIB */
                                        /* libptr->sigbpr is implicit input */
{
     if (libops(libptr->sigbpr)) {
          return(1);
     }
     gtgsig();
     prfmsg(SNOKEY,"LIB-Operator",sigbuf->name);
     return(0);
}
